/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.javacommons.contract;

import io.github.torand.javacommons.collection.ArrayHelper;
import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.contract.Requirement;
import io.github.torand.javacommons.lang.StringHelper;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public final class Requires {
    private Requires() {
    }

    public static int[] requireNonEmpty(int[] array, String msg, Object ... args) {
        Objects.requireNonNull(array, String.format(msg, args));
        Requires.require(() -> ArrayHelper.nonEmpty(array), msg, args);
        return array;
    }

    public static long[] requireNonEmpty(long[] array, String msg, Object ... args) {
        Objects.requireNonNull(array, String.format(msg, args));
        Requires.require(() -> ArrayHelper.nonEmpty(array), msg, args);
        return array;
    }

    public static <T> T[] requireNonEmpty(T[] array, String msg, Object ... args) {
        Objects.requireNonNull(array, String.format(msg, args));
        Requires.require(() -> ArrayHelper.nonEmpty(array), msg, args);
        return array;
    }

    public static <T extends Collection<?>> T requireNonEmpty(T collection, String msg, Object ... args) {
        Objects.requireNonNull(collection, String.format(msg, args));
        Requires.require(() -> CollectionHelper.nonEmpty(collection), msg, args);
        return collection;
    }

    public static String requireNonBlank(String string, String msg, Object ... args) {
        Objects.requireNonNull(string, String.format(msg, args));
        Requires.require(() -> StringHelper.nonBlank(string), msg, args);
        return string;
    }

    public static <T> Optional<T> requireNonEmpty(Optional<T> optional, String msg, Object ... args) {
        Requires.require(() -> Objects.nonNull(optional) && optional.isPresent(), msg, args);
        return optional;
    }

    public static void require(Requirement requirement, String msg, Object ... args) {
        if (!requirement.test()) {
            throw new IllegalArgumentException(String.format(msg, args));
        }
    }

    public static void precondition(Requirement requirement, String msg, Object ... args) {
        if (!requirement.test()) {
            throw new IllegalStateException(String.format(msg, args));
        }
    }
}

