/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.javacommons.stream;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamHelper {
    private StreamHelper() {
    }

    public static <T> Stream<T> streamSafely(Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> streamSafely(Iterator<T> iterator) {
        if (Objects.isNull(iterator)) {
            return Stream.empty();
        }
        return StreamHelper.streamSafely(() -> iterator);
    }

    @SafeVarargs
    public static <T> Stream<T> streamSafely(T ... items) {
        if (Objects.isNull(items)) {
            return Stream.empty();
        }
        return Stream.of(items);
    }

    public static <T> Stream<T> concatAndStream(Iterable<T> first, Iterable<T> second) {
        return Stream.concat(StreamHelper.streamSafely(first), StreamHelper.streamSafely(second));
    }

    public static <T> Stream<T> concatStreams(Stream<T> ... streams) {
        return Stream.of(streams).flatMap(Function.identity());
    }

    public static <T> Collector<T, ?, List<T>> toReversedList() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            Collections.reverse(list);
            return list;
        });
    }
}

