/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.utils.StringHelper;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Extensions {
    public static final String EXT_RESTCLIENT_CONFIGKEY = "x-restclient-configkey";
    public static final String EXT_JSON_SERIALIZER = "x-json-serializer";
    public static final String EXT_VALIDATION_CONSTRAINT = "x-validation-constraint";
    public static final String EXT_NULLABLE = "x-nullable";
    public static final String EXT_MODEL_SUBDIR = "x-model-subdir";
    public static final String EXT_DEPRECATION_MESSAGE = "x-deprecation-message";
    private final Map<String, Object> extensions;

    public static Extensions extensions(Map<String, Object> extensions) {
        return new Extensions(extensions);
    }

    public Extensions(Map<String, Object> extensions) {
        this.extensions = Objects.nonNull(extensions) ? extensions : Collections.emptyMap();
    }

    public Optional<String> getString(String name) {
        Object value = this.extensions.get(name);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        if (!(value instanceof String)) {
            throw new RuntimeException("Value of extension %s is not a String".formatted(name));
        }
        if (StringHelper.nonBlank((String)value)) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public Optional<Boolean> getBoolean(String name) {
        Object value = this.extensions.get(name);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw new RuntimeException("Value of extension %s is not a Boolean".formatted(name));
        }
        return Optional.of((Boolean)value);
    }
}

