/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.model.OpenApiDefInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.StringHelper;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class OpenApiDefInfoCollector
extends BaseCollector {
    private final ComponentResolver componentResolver;

    public OpenApiDefInfoCollector(ComponentResolver componentResolver, Options opts) {
        super(opts);
        this.componentResolver = componentResolver;
    }

    public OpenApiDefInfo getOpenApiDefInfo(String name, List<SecurityRequirement> securityRequirements) {
        OpenApiDefInfo openApiDefInfo = new OpenApiDefInfo();
        openApiDefInfo.name = name;
        openApiDefInfo.imports.add("jakarta.ws.rs.core.Application");
        if (CollectionHelper.nonEmpty(securityRequirements)) {
            openApiDefInfo.annotations.add(this.getSecuritySchemesAnnotation(securityRequirements, openApiDefInfo.imports));
        }
        return openApiDefInfo;
    }

    private String getSecuritySchemesAnnotation(List<SecurityRequirement> securityRequirements, Set<String> imports) {
        imports.add("org.eclipse.microprofile.openapi.annotations.security.SecuritySchemes");
        ArrayList<String> securitySchemeAnnotations = new ArrayList<String>();
        securityRequirements.forEach(sr -> sr.keySet().forEach(schemeName -> securitySchemeAnnotations.add(this.getSecuritySchemeAnnotation((String)schemeName, imports))));
        return "@SecuritySchemes(%s)".formatted(this.formatAnnotationDefaultParam(securitySchemeAnnotations));
    }

    private String getSecuritySchemeAnnotation(String name, Set<String> imports) {
        SecurityScheme securityScheme = this.componentResolver.securitySchemes().getOrThrow(name);
        ArrayList<String> params = new ArrayList<String>();
        params.add("securitySchemeName = \"%s\"".formatted(name));
        if (StringHelper.nonBlank(securityScheme.getDescription())) {
            params.add("description = \"%s\"".formatted(this.normalizeDescription(securityScheme.getDescription())));
        }
        imports.add("org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType");
        params.add("type = SecuritySchemeType.%s".formatted(securityScheme.getType().name()));
        switch (securityScheme.getType()) {
            case APIKEY: {
                params.add("name = \"%s\"".formatted(securityScheme.getName()));
                break;
            }
            case HTTP: {
                params.add("scheme = \"%s\"".formatted(securityScheme.getScheme()));
                if (!Objects.nonNull(securityScheme.getBearerFormat())) break;
                params.add("bearerFormat = \"%s\"".formatted(securityScheme.getBearerFormat()));
                break;
            }
            case OAUTH2: {
                if (!Objects.nonNull(securityScheme.getFlows())) break;
                params.add("flows = %s".formatted(this.getOAuthFlowsAnnotation(securityScheme.getFlows(), imports)));
                break;
            }
            case OPENIDCONNECT: {
                params.add("openIdConnectUrl = \"%s\"".formatted(securityScheme.getOpenIdConnectUrl()));
                break;
            }
            case MUTUALTLS: {
                throw new IllegalStateException("Security scheme MUTUALTLS not supported");
            }
        }
        imports.add("org.eclipse.microprofile.openapi.annotations.security.SecurityScheme");
        return (this.opts.useKotlinSyntax ? "" : "@") + "SecurityScheme(%s)".formatted(StringHelper.joinCsv(params));
    }

    private String getOAuthFlowsAnnotation(OAuthFlows flows, Set<String> imports) {
        ArrayList<String> params = new ArrayList<String>();
        if (Objects.nonNull(flows.getAuthorizationCode())) {
            params.add("authorizationCode = %s".formatted(this.getOAuthFlowAnnotation(flows.getAuthorizationCode(), imports)));
        }
        if (Objects.nonNull(flows.getImplicit())) {
            params.add("implicit = %s".formatted(this.getOAuthFlowAnnotation(flows.getImplicit(), imports)));
        }
        if (Objects.nonNull(flows.getClientCredentials())) {
            params.add("clientCredentials = %s".formatted(this.getOAuthFlowAnnotation(flows.getClientCredentials(), imports)));
        }
        if (Objects.nonNull(flows.getPassword())) {
            params.add("password = %s".formatted(this.getOAuthFlowAnnotation(flows.getPassword(), imports)));
        }
        imports.add("org.eclipse.microprofile.openapi.annotations.security.OAuthFlows");
        return (this.opts.useKotlinSyntax ? "" : "@") + "OAuthFlows(%s)".formatted(StringHelper.joinCsv(params));
    }

    private String getOAuthFlowAnnotation(OAuthFlow flow, Set<String> imports) {
        ArrayList<String> params = new ArrayList<String>();
        if (StringHelper.nonBlank(flow.getAuthorizationUrl())) {
            params.add("authorizationUrl = \"%s\"".formatted(flow.getAuthorizationUrl()));
        }
        if (StringHelper.nonBlank(flow.getTokenUrl())) {
            params.add("tokenUrl = \"%s\"".formatted(flow.getTokenUrl()));
        }
        if (StringHelper.nonBlank(flow.getRefreshUrl())) {
            params.add("refreshUrl = \"%s\"".formatted(flow.getRefreshUrl()));
        }
        if (CollectionHelper.nonEmpty(flow.getScopes())) {
            params.add("scopes = %s".formatted(this.getScopesAnnotation(flow.getScopes(), imports)));
        }
        imports.add("org.eclipse.microprofile.openapi.annotations.security.OAuthFlow");
        return (this.opts.useKotlinSyntax ? "" : "@") + "OAuthFlow(%s)".formatted(StringHelper.joinCsv(params));
    }

    private String getScopesAnnotation(Scopes scopes, Set<String> imports) {
        List<String> scopeAnnotations = scopes.keySet().stream().map(name -> this.getScopeAnnotation((String)name, (String)scopes.get(name), imports)).toList();
        return this.formatAnnotationNamedParam(scopeAnnotations);
    }

    private String getScopeAnnotation(String name, String description, Set<String> imports) {
        imports.add("org.eclipse.microprofile.openapi.annotations.security.OAuthScope");
        return (this.opts.useKotlinSyntax ? "" : "@") + "OAuthScope(name = \"%s\", description = \"%s\")".formatted(name, this.normalizeDescription(description));
    }
}

