/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.utils.KotlinTypeMapper;
import io.github.torand.openapi2java.utils.StringHelper;
import java.util.List;
import java.util.Map;

public abstract class BaseCollector {
    protected final Options opts;

    protected BaseCollector(Options opts) {
        this.opts = opts;
    }

    protected String normalizeDescription(String description) {
        return StringHelper.nonBlank(description) ? description.replaceAll("%", "%%") : "TBD";
    }

    protected String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = StringHelper.stripHead(path, 1);
        }
        if (path.endsWith("/")) {
            path = StringHelper.stripTail(path, 1);
        }
        return path;
    }

    protected String dirPath2PackagePath(String dirPath) {
        return dirPath.replaceAll("\\/", ".");
    }

    protected String modelName2SchemaName(String modelName) {
        return modelName.replaceFirst(this.opts.pojoNameSuffix + "$", "");
    }

    protected String formatClassRef(String className) {
        return this.opts.useKotlinSyntax ? "%s::class".formatted(KotlinTypeMapper.toKotlinNative(className)) : "%s.class".formatted(className);
    }

    protected String formatInnerAnnotation(String annotation, Object ... args) {
        return (this.opts.useKotlinSyntax ? "" : "@") + annotation.formatted(args);
    }

    protected String formatAnnotationDefaultParam(List<String> value) {
        if (value.size() == 1) {
            return value.get(0);
        }
        if (this.opts.useKotlinSyntax) {
            return StringHelper.joinCsv(value);
        }
        return "{" + StringHelper.joinCsv(value) + "}";
    }

    protected String formatAnnotationNamedParam(List<String> value) {
        if (this.opts.useKotlinSyntax) {
            return "[ " + StringHelper.joinCsv(value) + " ]";
        }
        return value.size() == 1 ? value.get(0) : "{ " + StringHelper.joinCsv(value) + " }";
    }

    protected String formatDeprecationMessage(Map<String, Object> extensions) {
        return new Extensions(extensions).getString("x-deprecation-message").orElse("Deprecated");
    }
}

