/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers;

import io.github.torand.openapi2java.Options;
import java.io.IOException;
import java.io.Writer;

public abstract class BaseWriter
implements AutoCloseable {
    private final Writer writer;
    protected final Options opts;

    public BaseWriter(Writer writer, Options opts) {
        this.writer = writer;
        this.opts = opts;
    }

    protected void write(String format, Object ... args) {
        try {
            this.writer.append(format.formatted(args));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append to writer", e);
        }
    }

    protected void writeLine(String format, Object ... args) {
        try {
            this.writer.append(format.formatted(args)).append("\n");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append to writer", e);
        }
    }

    protected void writeNewLine() {
        try {
            this.writer.append("\n");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append to writer", e);
        }
    }

    protected void writeIndent(int levels) {
        String indent = "\t";
        if (!this.opts.indentWithTab) {
            indent = " ".repeat(this.opts.indentSize);
        }
        for (int level = 0; level < levels; ++level) {
            try {
                this.writer.append(indent);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to append to writer", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

