/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.kotlin;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.model.MethodParamInfo;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.KotlinTypeMapper;
import io.github.torand.openapi2java.utils.StringHelper;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.ResourceWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.TreeSet;

public class KotlinResourceWriter
extends BaseWriter
implements ResourceWriter {
    public KotlinResourceWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(ResourceInfo resourceInfo) {
        this.writeLine("package %s", this.opts.rootPackage);
        this.writeNewLine();
        TreeSet<String> imports = new TreeSet<String>();
        imports.addAll(resourceInfo.imports);
        imports.addAll(resourceInfo.staticImports);
        resourceInfo.methods.forEach(m -> {
            imports.addAll(m.imports);
            imports.addAll(m.staticImports);
            m.parameters.forEach(p -> {
                imports.addAll(p.imports);
                imports.addAll(p.staticImports);
                imports.addAll(p.type.typeImports);
                if (Objects.nonNull(p.type.keyType)) {
                    imports.addAll(p.type.keyType.typeImports);
                }
                if (Objects.nonNull(p.type.itemType)) {
                    imports.addAll(p.type.itemType.typeImports);
                }
            });
        });
        imports.removeIf(i -> i.equals("java.util.List") || i.contains("ROOT_PATH"));
        imports.add("%s.%s.Companion.ROOT_PATH".formatted(this.opts.rootPackage, resourceInfo.name));
        imports.forEach(i -> this.writeLine("import %s".formatted(i), new Object[0]));
        this.writeNewLine();
        resourceInfo.annotations.forEach(a -> this.writeLine((String)a, new Object[0]));
        this.writeLine("interface %s {".formatted(resourceInfo.name), new Object[0]);
        resourceInfo.methods.forEach(m -> {
            this.writeNewLine();
            if (m.isDeprecated()) {
                this.writeIndent(1);
                this.writeLine("@Deprecated(\"%s\")".formatted(m.deprecationMessage), new Object[0]);
            }
            m.annotations.forEach(a -> {
                this.writeIndent(1);
                this.writeLine((String)a, new Object[0]);
            });
            this.writeIndent(1);
            this.writeLine("fun %s(".formatted(m.name), new Object[0]);
            for (int i = 0; i < m.parameters.size(); ++i) {
                MethodParamInfo paramInfo = m.parameters.get(i);
                this.writeIndent(2);
                if (CollectionHelper.nonEmpty(paramInfo.annotations)) {
                    this.write(String.join((CharSequence)" ", paramInfo.annotations) + " ", new Object[0]);
                }
                this.write(paramInfo.name + ": ", new Object[0]);
                this.write(KotlinTypeMapper.toKotlinNative(paramInfo.type.getFullName()), new Object[0]);
                if (paramInfo.nullable) {
                    this.write("? = null", new Object[0]);
                }
                if (i < m.parameters.size() - 1) {
                    this.write(",", new Object[0]);
                }
                if (StringHelper.nonBlank(paramInfo.comment)) {
                    this.write(" // %s", paramInfo.comment);
                }
                this.writeNewLine();
            }
            this.writeIndent(1);
            if (this.opts.useResteasyResponse) {
                this.writeLine("): RestResponse<%s>".formatted(Objects.nonNull(m.returnType) ? m.returnType : "Unit"), new Object[0]);
            } else {
                this.writeLine("): Response", new Object[0]);
            }
        });
        this.writeNewLine();
        this.writeIndent(1);
        this.writeLine("companion object {", new Object[0]);
        this.writeIndent(2);
        this.writeLine("const val ROOT_PATH: String = \"%s\"", this.opts.rootUrlPath);
        if (Objects.nonNull(resourceInfo.authMethod)) {
            resourceInfo.authMethod.annotations.forEach(a -> {
                this.writeIndent(2);
                this.writeLine((String)a, new Object[0]);
            });
            this.writeIndent(2);
            this.writeLine("fun %s() = \"TODO\"".formatted(resourceInfo.authMethod.name), new Object[0]);
        }
        this.writeIndent(1);
        this.writeLine("}", new Object[0]);
        this.writeLine("}", new Object[0]);
    }
}

