/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.SecurityRequirementInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.StringHelper;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;

public class SecurityRequirementCollector
extends BaseCollector {
    public SecurityRequirementCollector(Options opts) {
        super(opts);
    }

    public SecurityRequirementInfo getSequrityRequirementInfo(List<SecurityRequirement> securityRequirements) {
        SecurityRequirementInfo secReqInfo = new SecurityRequirementInfo();
        if (securityRequirements.size() > 1) {
            throw new IllegalStateException("Multiple alternative security requirements not supported");
        }
        SecurityRequirement securityRequirement = securityRequirements.get(0);
        if (securityRequirement.size() > 1) {
            throw new IllegalStateException("Multiple mandatory security scheme names not supported");
        }
        ArrayList<String> params = new ArrayList<String>();
        secReqInfo.scheme = (String)securityRequirement.keySet().iterator().next();
        params.add("name = \"%s\"".formatted(secReqInfo.scheme));
        secReqInfo.scopes = (List)securityRequirement.get((Object)secReqInfo.scheme);
        if (CollectionHelper.nonEmpty(secReqInfo.scopes)) {
            params.add("scopes = %s".formatted(this.formatAnnotationNamedParam(StringHelper.quote(secReqInfo.scopes))));
        }
        if (this.opts.addMpOpenApiAnnotations) {
            secReqInfo.imports.add("org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement");
            secReqInfo.annotations.add("@SecurityRequirement(%s)".formatted(StringHelper.joinCsv(params)));
        }
        return secReqInfo;
    }
}

