/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.generators;

import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.OpenApiDefInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.OpenApiDefInfo;
import io.github.torand.openapi2java.writers.OpenApiDefWriter;
import io.github.torand.openapi2java.writers.WriterFactory;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiDefGenerator {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiDefGenerator.class);
    private final Options opts;

    public OpenApiDefGenerator(Options opts) {
        this.opts = opts;
    }

    public void generate(OpenAPI openApiDoc) {
        ComponentResolver componentResolver = new ComponentResolver(openApiDoc);
        OpenApiDefInfoCollector openApiDefInfoCollector = new OpenApiDefInfoCollector(componentResolver, this.opts);
        String openApiDefClassName = "OpenApiDefinition";
        if (this.opts.verbose) {
            logger.info("Generating Open-API definition class: {}", (Object)openApiDefClassName);
        }
        OpenApiDefInfo openApiDefInfo = openApiDefInfoCollector.getOpenApiDefInfo(openApiDefClassName, openApiDoc.getSecurity());
        String openApiDefFilename = openApiDefClassName + this.opts.getFileExtension();
        try (OpenApiDefWriter openApiDefWriter = WriterFactory.createOpenApiDefWriter(openApiDefFilename, this.opts);){
            openApiDefWriter.write(openApiDefInfo);
        }
        catch (IOException e) {
            logger.error("Failed to write file {}", (Object)openApiDefFilename, (Object)e);
        }
        logger.info("Generated Open-API definition class in directory {}", (Object)this.opts.outputDir);
    }
}

