/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.java;

import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.PojoInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.PojoWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JavaPojoWriter
extends BaseWriter
implements PojoWriter {
    public JavaPojoWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(PojoInfo pojoInfo) {
        this.writeLine("package %s;", this.opts.getModelPackage(pojoInfo.modelSubpackage));
        this.writeNewLine();
        TreeSet nonJavaImports = new TreeSet();
        TreeSet javaImports = new TreeSet();
        Consumer<String> collectImport = qt -> {
            if (this.isJavaPackage((String)qt)) {
                javaImports.add(qt);
            } else {
                nonJavaImports.add(qt);
            }
        };
        Predicate<String> isModelType = qt -> this.isModelPackage((String)qt, pojoInfo.modelSubpackage);
        pojoInfo.imports.forEach(collectImport);
        pojoInfo.properties.stream().flatMap(p -> p.imports.stream()).forEach(collectImport);
        pojoInfo.properties.stream().flatMap(p -> p.type.typeImports()).filter(Predicate.not(isModelType)).forEach(collectImport);
        pojoInfo.properties.stream().flatMap(p -> p.type.annotationImports()).filter(Predicate.not(isModelType)).forEach(collectImport);
        if (CollectionHelper.nonEmpty(nonJavaImports)) {
            nonJavaImports.forEach(ti -> this.writeLine("import %s;".formatted(ti), new Object[0]));
            this.writeNewLine();
        }
        if (CollectionHelper.nonEmpty(javaImports)) {
            javaImports.forEach(ti -> this.writeLine("import %s;".formatted(ti), new Object[0]));
            this.writeNewLine();
        }
        if (pojoInfo.isDeprecated()) {
            this.writeLine("/// @deprecated %s".formatted(pojoInfo.deprecationMessage), new Object[0]);
            this.writeLine("@Deprecated", new Object[0]);
        }
        pojoInfo.annotations.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
        if (this.opts.pojosAsRecords) {
            this.writeLine("public record %s (".formatted(pojoInfo.name), new Object[0]);
        } else {
            this.writeLine("public class %s {".formatted(pojoInfo.name), new Object[0]);
        }
        AtomicInteger propNo = new AtomicInteger(1);
        pojoInfo.properties.forEach(propInfo -> {
            this.writeNewLine();
            this.writePropertyAnnotationLines((PropertyInfo)propInfo);
            this.writeIndent(1);
            if (Objects.nonNull(propInfo.type.itemType)) {
                String itemTypeWithAnnotations = CollectionHelper.streamConcat(propInfo.type.itemType.annotations, List.of(propInfo.type.itemType.name)).collect(Collectors.joining(" "));
                if (!this.opts.pojosAsRecords) {
                    this.write("public ", new Object[0]);
                }
                if (Objects.nonNull(propInfo.type.keyType)) {
                    String keyTypeWithAnnotations = CollectionHelper.streamConcat(propInfo.type.keyType.annotations, List.of(propInfo.type.keyType.name)).collect(Collectors.joining(" "));
                    this.write("%s<%s, %s> %s".formatted(propInfo.type.name, keyTypeWithAnnotations, itemTypeWithAnnotations, propInfo.name), new Object[0]);
                } else {
                    this.write("%s<%s> %s".formatted(propInfo.type.name, itemTypeWithAnnotations, propInfo.name), new Object[0]);
                }
            } else if (this.opts.pojosAsRecords) {
                this.write("%s %s".formatted(propInfo.type.name, propInfo.name), new Object[0]);
            } else {
                this.write("public %s %s".formatted(propInfo.type.name, propInfo.name), new Object[0]);
            }
            if (this.opts.pojosAsRecords) {
                if (propNo.getAndIncrement() < pojoInfo.properties.size()) {
                    this.writeLine(",", new Object[0]);
                } else {
                    this.writeNewLine();
                }
            } else {
                this.writeLine(";", new Object[0]);
            }
        });
        if (this.opts.pojosAsRecords) {
            this.writeLine(") {", new Object[0]);
            this.writeNewLine();
            this.writeLine("}", new Object[0]);
        } else {
            this.writeNewLine();
            this.writeNoArgConstructor(pojoInfo.name);
            this.writeNewLine();
            this.writeParameterizedConstructor(pojoInfo.name, pojoInfo.properties);
            this.writeLine("}", new Object[0]);
        }
    }

    private void writeNoArgConstructor(String name) {
        this.writeIndent(1);
        this.writeLine("public %s() {", name);
        this.writeIndent(1);
        this.writeLine("}", new Object[0]);
    }

    private void writeParameterizedConstructor(String name, List<PropertyInfo> props) {
        this.writeIndent(1);
        this.writeLine("public %s(%s) {", name, props.stream().map(p -> p.type.getFullName() + " " + p.name).collect(Collectors.joining(", ")));
        props.forEach(p -> {
            this.writeIndent(2);
            this.writeLine("this.%s = %s;", p.name, p.name);
        });
        this.writeIndent(1);
        this.writeLine("}", new Object[0]);
    }

    private void writePropertyAnnotationLines(PropertyInfo propInfo) {
        if (propInfo.isDeprecated()) {
            this.writeIndent(1);
            this.writeLine("/// @deprecated %s".formatted(propInfo.deprecationMessage), new Object[0]);
            this.writeIndent(1);
            this.writeLine("@Deprecated", new Object[0]);
        }
        propInfo.annotations.forEach(a -> {
            this.writeIndent(1);
            this.writeLine((String)a, new Object[0]);
        });
        propInfo.type.annotations.forEach(a -> {
            this.writeIndent(1);
            this.writeLine((String)a, new Object[0]);
        });
    }

    private boolean isModelPackage(String qualifiedType, String pojoModelSubpackage) {
        int lastDotIdx = qualifiedType.lastIndexOf(".");
        String typePackage = qualifiedType.substring(0, lastDotIdx);
        return this.opts.getModelPackage(pojoModelSubpackage).equals(typePackage);
    }

    private boolean isJavaPackage(String qualifiedType) {
        return qualifiedType.startsWith("java.");
    }
}

