/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.Exceptions;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SchemaResolver {
    private final Map<String, Schema> schemas;

    SchemaResolver(Map<String, Schema> schemas) {
        this.schemas = schemas;
    }

    public String getTypeName(String $ref) {
        return $ref.replace("#/components/schemas/", "");
    }

    public Optional<String> getModelSubpackage(String $ref) {
        Schema schema = this.getOrThrow($ref);
        return Extensions.extensions(schema.getExtensions()).getString("x-model-subdir").map(subdir -> subdir.replaceAll("\\/", "."));
    }

    public Optional<Schema> get(String $ref) {
        return Optional.ofNullable(this.schemas.get(this.getTypeName($ref)));
    }

    public Schema getOrThrow(String $ref) {
        return this.get($ref).orElseThrow(Exceptions.illegalStateException("Schema %s not found", $ref));
    }

    public boolean isEnumType(String $ref) {
        return this.get($ref).map(SchemaResolver::isEnumType).orElse(false);
    }

    public boolean isObjectType(String $ref) {
        return this.get($ref).map(SchemaResolver::isObjectType).orElse(false);
    }

    public boolean isArrayType(String $ref) {
        return this.get($ref).map(SchemaResolver::isArrayType).orElse(false);
    }

    public boolean isCompoundType(String $ref) {
        return this.get($ref).map(SchemaResolver::isCompoundType).orElse(false);
    }

    public boolean isPrimitiveType(String $ref) {
        return this.get($ref).map(SchemaResolver::isPrimitiveType).orElse(false);
    }

    public static boolean isEnumType(Schema<?> schema) {
        return Objects.nonNull(schema.getEnum());
    }

    public static boolean isObjectType(Schema<?> schema) {
        return CollectionHelper.nonEmpty(schema.getTypes()) && schema.getTypes().contains("object");
    }

    public static boolean isArrayType(Schema<?> schema) {
        return CollectionHelper.nonEmpty(schema.getTypes()) && schema.getTypes().contains("array");
    }

    public static boolean isCompoundType(Schema<?> schema) {
        return CollectionHelper.nonEmpty(schema.getAllOf());
    }

    public static boolean isPrimitiveType(Schema<?> schema) {
        return !SchemaResolver.isEnumType(schema) && !SchemaResolver.isObjectType(schema) && !SchemaResolver.isArrayType(schema) && !SchemaResolver.isCompoundType(schema);
    }
}

