/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.lang.Exceptions;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Map;
import java.util.Optional;

public class ParameterResolver {
    private final Map<String, Parameter> parameters;

    ParameterResolver(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public String getParameterName(String $ref) {
        return $ref.replace("#/components/parameters/", "");
    }

    public Optional<Parameter> get(String $ref) {
        return Optional.ofNullable(this.parameters.get(this.getParameterName($ref)));
    }

    public Parameter getOrThrow(String $ref) {
        return this.get($ref).orElseThrow(Exceptions.illegalStateException((String)"Parameter %s not found", (Object[])new Object[]{$ref}));
    }

    public boolean isHeaderParameter(String $ref) {
        return this.get($ref).map(p -> "header".equals(p.getIn())).orElse(false);
    }

    public boolean isPathParameter(String $ref) {
        return this.get($ref).map(p -> "path".equals(p.getIn())).orElse(false);
    }

    public boolean isQueryParameter(String $ref) {
        return this.get($ref).map(p -> "query".equals(p.getIn())).orElse(false);
    }
}

