/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.collectors.TypeInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.model.TypeInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class PropertyInfoCollector
extends BaseCollector {
    private final TypeInfoCollector typeInfoCollector;

    public PropertyInfoCollector(SchemaResolver schemaResolver, Options opts) {
        super(opts);
        this.typeInfoCollector = new TypeInfoCollector(schemaResolver, opts);
    }

    public PropertyInfo getPropertyInfo(String name, Schema<?> property, boolean required) {
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.name = name;
        propInfo.required = required;
        TypeInfoCollector.NullabilityResolution nullabilityResolution = required ? TypeInfoCollector.NullabilityResolution.FROM_SCHEMA : TypeInfoCollector.NullabilityResolution.FORCE_NULLABLE;
        propInfo.type = this.typeInfoCollector.getTypeInfo(property, nullabilityResolution);
        if (this.opts.addMpOpenApiAnnotations) {
            String schemaAnnotation = this.getSchemaAnnotation(property, propInfo.type, propInfo.imports);
            propInfo.annotations.add(schemaAnnotation);
        }
        if (this.opts.addJsonPropertyAnnotations) {
            String jsonPropAnnotation = this.getJsonPropertyAnnotation(name, propInfo.imports);
            propInfo.annotations.add(jsonPropAnnotation);
        }
        if (Boolean.TRUE.equals(property.getDeprecated())) {
            propInfo.deprecationMessage = this.formatDeprecationMessage(property.getExtensions());
        }
        return propInfo;
    }

    private String getSchemaAnnotation(Schema<?> property, TypeInfo typeInfo, Set<String> imports) {
        String description = property.getDescription();
        boolean required = !this.typeInfoCollector.isNullable(property) && !typeInfo.nullable;
        imports.add("org.eclipse.microprofile.openapi.annotations.media.Schema");
        ArrayList<String> schemaParams = new ArrayList<String>();
        schemaParams.add("description = \"%s\"".formatted(this.normalizeDescription(description)));
        if (required) {
            schemaParams.add("required = true");
        }
        if (Objects.nonNull(property.getDefault())) {
            schemaParams.add("defaultValue = \"%s\"".formatted(property.getDefault().toString()));
        }
        if (Objects.nonNull(typeInfo.schemaFormat)) {
            schemaParams.add("format = \"%s\"".formatted(typeInfo.schemaFormat));
        }
        if (Objects.nonNull(typeInfo.schemaPattern)) {
            schemaParams.add("pattern = \"%s\"".formatted(typeInfo.schemaPattern));
        }
        if (Boolean.TRUE.equals(property.getDeprecated())) {
            schemaParams.add("deprecated = true");
        }
        return "@Schema(%s)".formatted(StringUtils.joinCsv(schemaParams));
    }

    private String getJsonPropertyAnnotation(String name, Set<String> imports) {
        imports.add("com.fasterxml.jackson.annotation.JsonProperty");
        return "@JsonProperty(\"%s\")".formatted(name);
    }
}

