/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.javacommons.collection.CollectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class TypeInfo {
    public String name;
    public String description;
    public boolean nullable;
    public TypeInfo keyType;
    public boolean primitive;
    public TypeInfo itemType;
    public String schemaFormat;
    public String schemaPattern;
    public List<String> annotations = new ArrayList<String>();
    public List<String> annotationImports = new ArrayList<String>();
    public List<String> typeImports = new ArrayList<String>();

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return Objects.nonNull(this.itemType);
    }

    public String getFullName() {
        if (Objects.nonNull(this.keyType) && Objects.nonNull(this.itemType)) {
            return "%s<%s,%s>".formatted(this.name, this.keyType.getFullName(), this.itemType.getFullName());
        }
        if (Objects.nonNull(this.itemType)) {
            return "%s<%s>".formatted(this.name, this.itemType.getFullName());
        }
        return this.name;
    }

    public Stream<String> typeImports() {
        return Objects.isNull(this.itemType) ? this.typeImports.stream() : CollectionHelper.concatStream(this.typeImports, this.itemType.typeImports);
    }

    public Stream<String> annotationImports() {
        return Objects.isNull(this.itemType) ? this.annotationImports.stream() : CollectionHelper.concatStream(this.annotationImports, this.itemType.annotationImports);
    }
}

