/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.java;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.MethodParamInfo;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.ResourceWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;

public class JavaResourceWriter
extends BaseWriter
implements ResourceWriter {
    public JavaResourceWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(ResourceInfo resourceInfo) {
        this.writeLine("package %s;", this.opts.rootPackage);
        this.writeNewLine();
        TreeSet nonJavaImports = new TreeSet();
        TreeSet javaImports = new TreeSet();
        Consumer<String> importConsumer = qt -> {
            if (this.isJavaPackage((String)qt)) {
                javaImports.add(qt);
            } else {
                nonJavaImports.add(qt);
            }
        };
        resourceInfo.imports.forEach(importConsumer);
        resourceInfo.methods.forEach(m -> {
            m.imports.forEach(importConsumer);
            m.parameters.forEach(p -> {
                p.imports.forEach(importConsumer);
                p.type.typeImports.forEach(importConsumer);
                if (Objects.nonNull(p.type.keyType)) {
                    p.type.keyType.typeImports.forEach(importConsumer);
                }
                if (Objects.nonNull(p.type.itemType)) {
                    p.type.itemType.typeImports.forEach(importConsumer);
                }
            });
        });
        if (CollectionHelper.nonEmpty(nonJavaImports)) {
            nonJavaImports.forEach(ti -> this.writeLine("import %s;".formatted(ti), new Object[0]));
            this.writeNewLine();
        }
        if (CollectionHelper.nonEmpty(javaImports)) {
            javaImports.forEach(ti -> this.writeLine("import %s;".formatted(ti), new Object[0]));
            this.writeNewLine();
        }
        TreeSet<String> staticImports = new TreeSet<String>();
        staticImports.addAll(resourceInfo.staticImports);
        resourceInfo.methods.forEach(m -> {
            staticImports.addAll(m.staticImports);
            m.parameters.forEach(p -> staticImports.addAll(p.staticImports));
        });
        staticImports.forEach(si -> this.writeLine("import static %s;".formatted(si), new Object[0]));
        this.writeNewLine();
        resourceInfo.annotations.forEach(a -> this.writeLine((String)a, new Object[0]));
        this.writeLine("public interface %s {".formatted(resourceInfo.name), new Object[0]);
        this.writeNewLine();
        this.writeIndent(1);
        this.writeLine("String ROOT_PATH = \"%s\";", this.opts.rootUrlPath);
        resourceInfo.methods.forEach(m -> {
            this.writeNewLine();
            if (m.isDeprecated()) {
                this.writeIndent(1);
                this.writeLine("/// @deprecated %s".formatted(m.deprecationMessage), new Object[0]);
                this.writeIndent(1);
                this.writeLine("@Deprecated", new Object[0]);
            }
            m.annotations.forEach(a -> {
                this.writeIndent(1);
                this.writeLine((String)a, new Object[0]);
            });
            this.writeIndent(1);
            if (this.opts.useResteasyResponse) {
                this.writeLine("RestResponse<%s> %s(".formatted(Objects.nonNull(m.returnType) ? m.returnType : "Void", m.name), new Object[0]);
            } else {
                this.writeLine("Response %s(".formatted(m.name), new Object[0]);
            }
            for (int i = 0; i < m.parameters.size(); ++i) {
                MethodParamInfo paramInfo = m.parameters.get(i);
                this.writeIndent(2);
                if (paramInfo.isDeprecated()) {
                    this.write("@Deprecated ", new Object[0]);
                }
                if (CollectionHelper.nonEmpty(paramInfo.annotations)) {
                    this.write(String.join((CharSequence)" ", paramInfo.annotations) + " ", new Object[0]);
                }
                this.write(paramInfo.type.getFullName() + " ", new Object[0]);
                this.write(paramInfo.name, new Object[0]);
                if (i < m.parameters.size() - 1) {
                    this.write(",", new Object[0]);
                }
                if (StringHelper.nonBlank((String)paramInfo.comment)) {
                    this.write(" // %s", paramInfo.comment);
                }
                this.writeNewLine();
            }
            this.writeIndent(1);
            this.writeLine(");", new Object[0]);
        });
        if (Objects.nonNull(resourceInfo.authMethod)) {
            this.writeNewLine();
            resourceInfo.authMethod.annotations.forEach(a -> {
                this.writeIndent(1);
                this.writeLine((String)a, new Object[0]);
            });
            this.writeIndent(1);
            this.writeLine("default String %s() {".formatted(resourceInfo.authMethod.name), new Object[0]);
            this.writeIndent(2);
            this.writeLine("return \"TODO\";", new Object[0]);
            this.writeIndent(1);
            this.writeLine("}", new Object[0]);
        }
        this.writeLine("}", new Object[0]);
    }

    private boolean isJavaPackage(String qualifiedType) {
        return qualifiedType.startsWith("java.");
    }
}

