/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.collectors.PropertyInfoCollector;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.PojoInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class PojoInfoCollector
extends BaseCollector {
    private final PropertyInfoCollector propertyInfoCollector;
    private final SchemaResolver schemaResolver;

    public PojoInfoCollector(SchemaResolver schemaResolver, Options opts) {
        super(opts);
        this.propertyInfoCollector = new PropertyInfoCollector(schemaResolver, opts);
        this.schemaResolver = schemaResolver;
    }

    public PojoInfo getPojoInfo(String name, Schema<?> schema) {
        PojoInfo pojoInfo = new PojoInfo(name);
        Optional<String> maybeModelSubdir = Extensions.extensions(schema.getExtensions()).getString("x-model-subdir");
        pojoInfo = pojoInfo.withModelSubdir(maybeModelSubdir.orElse(null)).withModelSubpackage(maybeModelSubdir.map(this::dirPath2PackagePath).orElse(null));
        if (this.opts.addMpOpenApiAnnotations()) {
            pojoInfo = pojoInfo.withAddedAnnotation(this.getSchemaAnnotation(name, schema));
        }
        if (Boolean.TRUE.equals(schema.getDeprecated())) {
            pojoInfo = pojoInfo.withDeprecationMessage(this.formatDeprecationMessage(schema.getExtensions()));
        }
        pojoInfo = pojoInfo.withAddedProperties(this.getSchemaProperties(schema));
        return pojoInfo;
    }

    private AnnotationInfo getSchemaAnnotation(String name, Schema<?> pojo) {
        ArrayList<String> schemaParams = new ArrayList<String>();
        schemaParams.add("name = \"%s\"".formatted(this.modelName2SchemaName(name)));
        schemaParams.add("description = \"%s\"".formatted(this.normalizeDescription(pojo.getDescription())));
        if (Boolean.TRUE.equals(pojo.getDeprecated())) {
            schemaParams.add("deprecated = true");
        }
        return new AnnotationInfo("@Schema(%s)".formatted(StringUtils.joinCsv(schemaParams)), "org.eclipse.microprofile.openapi.annotations.media.Schema");
    }

    private List<PropertyInfo> getSchemaProperties(Schema<?> schema) {
        ArrayList<PropertyInfo> props = new ArrayList<PropertyInfo>();
        if (CollectionHelper.nonEmpty((Collection)schema.getAllOf())) {
            schema.getAllOf().forEach(subSchema -> props.addAll(this.getSchemaProperties((Schema<?>)subSchema)));
        } else {
            if (StringHelper.nonBlank((String)schema.get$ref())) {
                Schema<?> refSchema = this.schemaResolver.getOrThrow(schema.get$ref());
                return this.getSchemaProperties(refSchema);
            }
            schema.getProperties().forEach((propName, propSchema) -> props.add(this.propertyInfoCollector.getPropertyInfo((String)propName, (Schema<?>)propSchema, this.isRequired(schema, (String)propName))));
        }
        return props;
    }

    private boolean isRequired(Schema<?> schema, String propName) {
        return CollectionHelper.nonEmpty((Collection)schema.getRequired()) && schema.getRequired().contains(propName);
    }
}

