/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.collectors.TypeInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.model.TypeInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Objects;

public class PropertyInfoCollector
extends BaseCollector {
    private final TypeInfoCollector typeInfoCollector;

    public PropertyInfoCollector(SchemaResolver schemaResolver, Options opts) {
        super(opts);
        this.typeInfoCollector = new TypeInfoCollector(schemaResolver, opts);
    }

    public PropertyInfo getPropertyInfo(String name, Schema<?> property, boolean required) {
        PropertyInfo propInfo = new PropertyInfo(name).withRequired(required);
        TypeInfoCollector.NullabilityResolution nullabilityResolution = required ? TypeInfoCollector.NullabilityResolution.FROM_SCHEMA : TypeInfoCollector.NullabilityResolution.FORCE_NULLABLE;
        propInfo = propInfo.withType(this.typeInfoCollector.getTypeInfo(property, nullabilityResolution));
        if (this.opts.addMpOpenApiAnnotations()) {
            AnnotationInfo schemaAnnotation = this.getSchemaAnnotation(property, propInfo.type());
            propInfo = propInfo.withAddedAnnotation(schemaAnnotation);
        }
        if (this.opts.addJsonPropertyAnnotations()) {
            AnnotationInfo jsonPropAnnotation = this.getJsonPropertyAnnotation(name);
            propInfo = propInfo.withAddedAnnotation(jsonPropAnnotation);
        }
        if (Boolean.TRUE.equals(property.getDeprecated())) {
            propInfo = propInfo.withDeprecationMessage(this.formatDeprecationMessage(property.getExtensions()));
        }
        return propInfo;
    }

    private AnnotationInfo getSchemaAnnotation(Schema<?> property, TypeInfo typeInfo) {
        boolean required = !this.typeInfoCollector.isNullable(property) && !typeInfo.nullable();
        ArrayList<String> schemaParams = new ArrayList<String>();
        schemaParams.add("description = \"%s\"".formatted(this.normalizeDescription(property.getDescription())));
        if (required) {
            schemaParams.add("required = true");
        }
        if (Objects.nonNull(property.getDefault())) {
            schemaParams.add("defaultValue = \"%s\"".formatted(property.getDefault().toString()));
        }
        if (Objects.nonNull(typeInfo.schemaFormat())) {
            schemaParams.add("format = \"%s\"".formatted(typeInfo.schemaFormat()));
        }
        if (Objects.nonNull(typeInfo.schemaPattern())) {
            schemaParams.add("pattern = \"%s\"".formatted(typeInfo.schemaPattern()));
        }
        if (Boolean.TRUE.equals(property.getDeprecated())) {
            schemaParams.add("deprecated = true");
        }
        return new AnnotationInfo("@Schema(%s)".formatted(StringUtils.joinCsv(schemaParams)), "org.eclipse.microprofile.openapi.annotations.media.Schema");
    }

    private AnnotationInfo getJsonPropertyAnnotation(String name) {
        return new AnnotationInfo("@JsonProperty(\"%s\")".formatted(name), "com.fasterxml.jackson.annotation.JsonProperty");
    }
}

