/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.javacommons.collection.CollectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;

public class AnnotatedTypeName {
    private final List<String> annotatedTypeNameItems;

    public AnnotatedTypeName(List<String> annotatedTypeNameItems) {
        ObjectUtils.requireNonEmpty(annotatedTypeNameItems);
        this.annotatedTypeNameItems = new ArrayList<String>(annotatedTypeNameItems);
    }

    public boolean hasAnnotations() {
        return this.annotatedTypeNameItems.size() >= 2;
    }

    public Stream<String> annotations() {
        if (!this.hasAnnotations()) {
            return Stream.empty();
        }
        return this.annotatedTypeNameItems.stream().limit((long)this.annotatedTypeNameItems.size() - 1L);
    }

    public String annotationsAsString() {
        return this.annotations().collect(Collectors.joining(" "));
    }

    public String typeName() {
        return (String)CollectionHelper.tailOf(this.annotatedTypeNameItems);
    }

    public String asString() {
        return String.join((CharSequence)" ", this.annotatedTypeNameItems);
    }

    public Stream<String> items() {
        return this.annotatedTypeNameItems.stream();
    }
}

