/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.javacommons.stream.StreamHelper;
import io.github.torand.openapi2java.model.ImportsSupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public record ImportInfo(Set<String> normalImports, Set<String> staticImports) implements ImportsSupplier
{
    private ImportInfo() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public static ImportInfo empty() {
        return new ImportInfo();
    }

    @Override
    public ImportInfo imports() {
        return this;
    }

    public ImportInfo withAddedNormalImport(String normalImport) {
        TreeSet<String> newNormalImports = new TreeSet<String>(this.normalImports);
        newNormalImports.add(normalImport);
        return new ImportInfo(newNormalImports, this.staticImports);
    }

    public ImportInfo withAddedStaticImport(String staticImport) {
        TreeSet<String> newStaticImports = new TreeSet<String>(this.staticImports);
        newStaticImports.add(staticImport);
        return new ImportInfo(this.normalImports, newStaticImports);
    }

    public ImportInfo withAddedImports(ImportsSupplier importSupplier) {
        TreeSet<String> newNormalImports = new TreeSet<String>(this.normalImports);
        newNormalImports.addAll(importSupplier.imports().normalImports());
        TreeSet<String> newStaticImports = new TreeSet<String>(this.staticImports);
        newStaticImports.addAll(importSupplier.imports().staticImports());
        return new ImportInfo(newNormalImports, newStaticImports);
    }

    public ImportInfo withAddedImports(Collection<? extends ImportsSupplier> importSuppliers) {
        TreeSet<String> newNormalImports = new TreeSet<String>(this.normalImports);
        StreamHelper.streamSafely(importSuppliers).map(ImportsSupplier::imports).map(ImportInfo::normalImports).forEach(newNormalImports::addAll);
        TreeSet<String> newStaticImports = new TreeSet<String>(this.staticImports);
        StreamHelper.streamSafely(importSuppliers).map(ImportsSupplier::imports).map(ImportInfo::staticImports).forEach(newStaticImports::addAll);
        return new ImportInfo(newNormalImports, newStaticImports);
    }
}

