/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.EntityInfo;
import io.github.torand.openapi2java.model.MethodParamInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public record MethodInfo(String name, List<MethodParamInfo> parameters, String returnType, String deprecationMessage, List<AnnotationInfo> annotations) implements EntityInfo
{
    public MethodInfo(String name) {
        this(name, Collections.emptyList(), null, null, Collections.emptyList());
    }

    public MethodInfo withAddedParameters(Collection<MethodParamInfo> params) {
        LinkedList<MethodParamInfo> newParameters = new LinkedList<MethodParamInfo>(this.parameters);
        newParameters.addAll(params);
        return new MethodInfo(this.name, newParameters, this.returnType, this.deprecationMessage, this.annotations);
    }

    public MethodInfo withReturnType(String returnType) {
        return new MethodInfo(this.name, this.parameters, returnType, this.deprecationMessage, this.annotations);
    }

    public MethodInfo withDeprecationMessage(String deprecationMessage) {
        return new MethodInfo(this.name, this.parameters, this.returnType, deprecationMessage, this.annotations);
    }

    public MethodInfo withAddedAnnotation(AnnotationInfo annotation) {
        LinkedList<AnnotationInfo> newAnnotations = new LinkedList<AnnotationInfo>(this.annotations);
        newAnnotations.add(annotation);
        return new MethodInfo(this.name, this.parameters, this.returnType, this.deprecationMessage, newAnnotations);
    }

    public MethodInfo withAddedAnnotations(Collection<AnnotationInfo> annotations) {
        MethodInfo merged = this;
        for (AnnotationInfo annotation : annotations) {
            merged = merged.withAddedAnnotation(annotation);
        }
        return merged;
    }

    public boolean isDeprecated() {
        return Objects.nonNull(this.deprecationMessage);
    }

    @Override
    public Set<String> aggregatedNormalImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        this.parameters.stream().map(p -> p.aggregatedNormalImports()).forEach(aggregated::addAll);
        this.annotations.stream().map(a -> a.imports().normalImports()).forEach(aggregated::addAll);
        return aggregated;
    }

    @Override
    public Set<String> aggregatedStaticImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        this.parameters.stream().map(p -> p.aggregatedStaticImports()).forEach(aggregated::addAll);
        this.annotations.stream().map(a -> a.imports().staticImports()).forEach(aggregated::addAll);
        return aggregated;
    }
}

