/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.javacommons.stream.StreamHelper;
import io.github.torand.openapi2java.model.AnnotatedTypeName;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.EntityInfo;
import io.github.torand.openapi2java.model.ImportInfo;
import io.github.torand.openapi2java.model.ImportsSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public record TypeInfo(String name, String description, boolean nullable, TypeInfo keyType, boolean primitive, TypeInfo itemType, String schemaFormat, String schemaPattern, List<AnnotationInfo> annotations, ImportInfo imports) implements EntityInfo,
ImportsSupplier
{
    public TypeInfo() {
        this(null, null, false, null, false, null, null, null, Collections.emptyList(), ImportInfo.empty());
    }

    public TypeInfo withName(String name) {
        return new TypeInfo(name, this.description, this.nullable, this.keyType, this.primitive, this.itemType, this.schemaFormat, this.schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withDescription(String description) {
        return new TypeInfo(this.name, description, this.nullable, this.keyType, this.primitive, this.itemType, this.schemaFormat, this.schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withNullable(boolean nullable) {
        return new TypeInfo(this.name, this.description, nullable, this.keyType, this.primitive, this.itemType, this.schemaFormat, this.schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withKeyType(TypeInfo keyType) {
        return new TypeInfo(this.name, this.description, this.nullable, keyType, this.primitive, this.itemType, this.schemaFormat, this.schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withPrimitive(boolean primitive) {
        return new TypeInfo(this.name, this.description, this.nullable, this.keyType, primitive, this.itemType, this.schemaFormat, this.schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withItemType(TypeInfo itemType) {
        return new TypeInfo(this.name, this.description, this.nullable, this.keyType, this.primitive, itemType, this.schemaFormat, this.schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withSchemaFormat(String schemaFormat) {
        return new TypeInfo(this.name, this.description, this.nullable, this.keyType, this.primitive, this.itemType, schemaFormat, this.schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withSchemaPattern(String schemaPattern) {
        return new TypeInfo(this.name, this.description, this.nullable, this.keyType, this.primitive, this.itemType, this.schemaFormat, schemaPattern, this.annotations, this.imports);
    }

    public TypeInfo withAddedAnnotation(AnnotationInfo annotation) {
        LinkedList<AnnotationInfo> newAnnotations = new LinkedList<AnnotationInfo>(this.annotations);
        newAnnotations.add(annotation);
        return new TypeInfo(this.name, this.description, this.nullable, this.keyType, this.primitive, this.itemType, this.schemaFormat, this.schemaPattern, newAnnotations, this.imports);
    }

    public TypeInfo withNoAnnotations() {
        return new TypeInfo(this.name, this.description, this.nullable, this.keyType, this.primitive, this.itemType, this.schemaFormat, this.schemaPattern, Collections.emptyList(), this.imports);
    }

    public TypeInfo withAddedNormalImport(String normalImport) {
        return new TypeInfo(this.name, this.description, this.nullable, this.keyType, this.primitive, this.itemType, this.schemaFormat, this.schemaPattern, this.annotations, this.imports.withAddedNormalImport(normalImport));
    }

    public boolean isArray() {
        return Objects.isNull(this.keyType) && Objects.nonNull(this.itemType);
    }

    public String getFullName() {
        if (Objects.nonNull(this.keyType) && Objects.nonNull(this.itemType)) {
            return "%s<%s,%s>".formatted(this.name, this.keyType.getFullName(), this.itemType.getFullName());
        }
        if (Objects.nonNull(this.itemType)) {
            return "%s<%s>".formatted(this.name, this.itemType.getFullName());
        }
        return this.name;
    }

    public AnnotatedTypeName getAnnotatedFullName() {
        ArrayList<String> annotatedFullName = new ArrayList<String>();
        StreamHelper.streamSafely(this.annotations).map(AnnotationInfo::annotation).forEach(annotatedFullName::add);
        if (Objects.nonNull(this.itemType)) {
            String itemTypeWithAnnotations = this.itemType.getAnnotatedFullName().items().filter(Predicate.not("@Valid"::equals)).collect(Collectors.joining(" "));
            if (Objects.nonNull(this.keyType)) {
                String keyTypeWithAnnotations = this.keyType.getAnnotatedFullName().items().filter(Predicate.not("@Valid"::equals)).collect(Collectors.joining(" "));
                annotatedFullName.add("%s<%s, %s>".formatted(this.name, keyTypeWithAnnotations, itemTypeWithAnnotations));
            } else {
                annotatedFullName.add("%s<%s>".formatted(this.name, itemTypeWithAnnotations));
            }
        } else {
            annotatedFullName.add(this.name);
        }
        return new AnnotatedTypeName(annotatedFullName);
    }

    @Override
    public Set<String> aggregatedNormalImports() {
        ImportInfo imports = this.imports.withAddedImports(this.annotations);
        if (Objects.nonNull(this.keyType)) {
            imports = imports.withAddedImports(this.keyType);
        }
        if (Objects.nonNull(this.itemType)) {
            imports = imports.withAddedImports(this.itemType);
        }
        return imports.normalImports();
    }

    @Override
    public Set<String> aggregatedStaticImports() {
        ImportInfo imports = this.imports.withAddedImports(this.annotations);
        if (Objects.nonNull(this.keyType)) {
            imports = imports.withAddedImports(this.keyType);
        }
        if (Objects.nonNull(this.itemType)) {
            imports = imports.withAddedImports(this.itemType);
        }
        return imports.staticImports();
    }
}

