/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.java;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.OpenApiDefInfo;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.OpenApiDefWriter;
import java.io.Writer;

public class JavaOpenApiDefWriter
extends BaseWriter
implements OpenApiDefWriter {
    public JavaOpenApiDefWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(OpenApiDefInfo openApiDefInfo) {
        this.writeLine("package %s;", this.opts.rootPackage());
        this.writeNewLine();
        if (CollectionHelper.nonEmpty(openApiDefInfo.aggregatedNormalImports())) {
            openApiDefInfo.aggregatedNormalImports().forEach(i -> this.writeLine("import %s;".formatted(i), new Object[0]));
            this.writeNewLine();
        }
        if (CollectionHelper.nonEmpty(openApiDefInfo.aggregatedStaticImports())) {
            openApiDefInfo.aggregatedStaticImports().forEach(i -> this.writeLine("import static %s;".formatted(i), new Object[0]));
            this.writeNewLine();
        }
        openApiDefInfo.annotationsAsStrings().forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
        this.writeLine("public class %s extends Application {", openApiDefInfo.name());
        this.writeLine("}", new Object[0]);
    }
}

