/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.kotlin;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.stream.StreamHelper;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotatedTypeName;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.PojoInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.utils.KotlinTypeMapper;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.PojoWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class KotlinPojoWriter
extends BaseWriter
implements PojoWriter {
    private static final Set<String> RESERVED_KEYWORDS = Set.of("as", "break", "class", "continue", "do", "else", "false", "for", "fun", "if", "in", "interface", "is", "null", "object", "package", "return", "super", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "when", "while");

    public KotlinPojoWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(PojoInfo pojoInfo) {
        this.writeLine("package %s", this.opts.getModelPackage(pojoInfo.modelSubpackage()));
        this.writeNewLine();
        this.writeImports(pojoInfo);
        if (pojoInfo.isDeprecated()) {
            this.writeLine("@Deprecated(\"%s\")".formatted(pojoInfo.deprecationMessage()), new Object[0]);
        }
        pojoInfo.annotations().forEach(a -> this.writeLine(a.annotation(), new Object[0]));
        this.writeLine("@JvmRecord", new Object[0]);
        this.writeLine("data class %s (".formatted(pojoInfo.name()), new Object[0]);
        AtomicInteger propNo = new AtomicInteger(1);
        pojoInfo.properties().forEach(propInfo -> {
            this.writeNewLine();
            this.writePropertyAnnotationLines((PropertyInfo)propInfo);
            this.writePropertyTypeAndName((PropertyInfo)propInfo);
            if (propNo.getAndIncrement() < pojoInfo.properties().size()) {
                this.writeLine(",", new Object[0]);
            } else {
                this.writeNewLine();
            }
        });
        this.writeLine(")", new Object[0]);
    }

    private void writeImports(PojoInfo pojoInfo) {
        List<String> imports = pojoInfo.aggregatedNormalImports().stream().filter(ni -> !this.isInPackage((String)ni, pojoInfo.modelSubpackage())).filter(Predicate.not("java.util.List"::equals)).filter(Predicate.not("java.util.Map"::equals)).map(arg_0 -> KotlinPojoWriter.lambda$writeImports$3("import %s", arg_0)).toList();
        if (CollectionHelper.nonEmpty(imports)) {
            imports.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
            this.writeNewLine();
        }
    }

    private void writePropertyAnnotationLines(PropertyInfo propInfo) {
        if (propInfo.isDeprecated()) {
            this.writeIndent(1);
            this.writeLine("@Deprecated(\"%s\")".formatted(propInfo.deprecationMessage()), new Object[0]);
        }
        StreamHelper.streamSafely(propInfo.annotations()).map(AnnotationInfo::annotation).map(this::prefixPropertyAnnotation).forEach(a -> {
            this.writeIndent(1);
            this.writeLine((String)a, new Object[0]);
        });
    }

    private void writePropertyTypeAndName(PropertyInfo propInfo) {
        AnnotatedTypeName annotatedTypeName = propInfo.type().getAnnotatedFullName();
        annotatedTypeName.annotations().map(this::prefixPropertyAnnotation).forEach(a -> {
            this.writeIndent(1);
            this.writeLine((String)a, new Object[0]);
        });
        this.writeIndent(1);
        this.write("val %s: ", KotlinPojoWriter.escapeReservedKeywords(propInfo.name()));
        this.write(KotlinTypeMapper.toKotlinNative(annotatedTypeName.typeName()), new Object[0]);
        if (!propInfo.required() || propInfo.type().nullable()) {
            this.write("? = null", new Object[0]);
        }
    }

    private String prefixPropertyAnnotation(String annotation) {
        if (annotation.startsWith("@JsonProperty")) {
            return annotation;
        }
        return "@field:" + annotation.substring(1);
    }

    private boolean isInPackage(String qualifiedType, String pojoModelSubpackage) {
        int lastDotIdx = qualifiedType.lastIndexOf(".");
        String typePackage = qualifiedType.substring(0, lastDotIdx);
        return this.opts.getModelPackage(pojoModelSubpackage).equals(typePackage);
    }

    private static String escapeReservedKeywords(String name) {
        return RESERVED_KEYWORDS.contains(name) ? "`%s`".formatted(name) : name;
    }

    private static /* synthetic */ String lambda$writeImports$3(String rec$, Object xva$0) {
        return "import %s".formatted(xva$0);
    }
}

