/*
 * Decompiled with CFR 0.152.
 */
package io.github.unknowncoder56.javaslc;

import io.github.unknowncoder56.javaslc.Bot;
import io.github.unknowncoder56.javaslc.CommandListener;
import io.github.unknowncoder56.javaslc.ErrorListener;
import io.github.unknowncoder56.javaslc.StartListener;
import java.util.ArrayList;

public class BotBuilder {
    private String prefix = "";
    private StartListener startListener = null;
    private ErrorListener errorListener = null;
    private String token = "";
    private long botUserId = 0L;
    private final ArrayList<CommandListener> commandListeners = new ArrayList();

    private BotBuilder() {
    }

    public static BotBuilder newInstance() {
        return new BotBuilder();
    }

    public BotBuilder setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public BotBuilder setStartListener(StartListener startListener) {
        this.startListener = startListener;
        return this;
    }

    public BotBuilder setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    public BotBuilder setToken(String token) {
        this.token = token;
        return this;
    }

    public BotBuilder setBotUserId(long botUserId) {
        this.botUserId = botUserId;
        return this;
    }

    public BotBuilder addCommandListener(CommandListener commandListener) {
        this.commandListeners.add(commandListener);
        return this;
    }

    public Bot build() {
        return new Bot(this.prefix, this.startListener, this.errorListener, this.token, this.botUserId, this.commandListeners);
    }
}

