/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.cloud;

import com.google.common.io.CharStreams;
import com.google.gson.annotations.SerializedName;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.CertificateStatus;
import com.venafi.vcert.sdk.certificate.ChainOption;
import com.venafi.vcert.sdk.certificate.CsrOriginOption;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.certificate.PEMCollection;
import com.venafi.vcert.sdk.certificate.RenewalRequest;
import com.venafi.vcert.sdk.certificate.RevocationRequest;
import com.venafi.vcert.sdk.connectors.Connector;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.connectors.cloud.Cloud;
import com.venafi.vcert.sdk.connectors.cloud.CloudConnectorException;
import com.venafi.vcert.sdk.connectors.cloud.CloudConnectorUtils;
import com.venafi.vcert.sdk.connectors.cloud.domain.Application;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateDetails;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import com.venafi.vcert.sdk.connectors.cloud.domain.UserDetails;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;
import com.venafi.vcert.sdk.policy.api.domain.CloudPolicy;
import com.venafi.vcert.sdk.policy.converter.CloudPolicySpecificationConverter;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.utils.VCertUtils;
import feign.Response;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Strings;

public class CloudConnector
implements Connector {
    private Cloud cloud;
    private UserDetails user;
    private Authentication auth;
    private String zone;
    private String vendorAndProductName;

    public CloudConnector(Cloud cloud) {
        this.cloud = cloud;
    }

    @Override
    public ConnectorType getType() {
        return ConnectorType.CLOUD;
    }

    @Override
    public void setBaseUrl(String url) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setZone(String zone) {
        this.zone = zone;
    }

    @Override
    public void setVendorAndProductName(String vendorAndProductName) {
        this.vendorAndProductName = vendorAndProductName;
    }

    @Override
    public String getVendorAndProductName() {
        return this.vendorAndProductName;
    }

    @Override
    public void ping() throws VCertException {
        Response response = this.doPing();
        if (response.status() != 200) {
            throw new CloudConnectorException.UnexpectedStatusException(response.status(), response.reason());
        }
    }

    private Response doPing() {
        return this.cloud.ping(this.auth.apiKey());
    }

    @Override
    public void authenticate(Authentication auth) throws VCertException {
        VCertException.throwIfNull(auth, "Failed to authenticate: missing credentials");
        this.auth = auth;
        this.user = this.cloud.authorize(auth.apiKey());
    }

    @Override
    public ZoneConfiguration readZoneConfiguration(String zone) throws VCertException {
        String[] valies = StringUtils.split((String)zone, (String)"\\");
        String appName = valies[0];
        String citAlias = valies[1];
        CertificateIssuingTemplate cit = null;
        String zoneId = null;
        if (appName == null || appName == "" || citAlias == null || citAlias == "") {
            throw new CloudConnectorException.ZoneFormatException("The parameters: appName, citAlias or both are empty");
        }
        cit = this.cloud.certificateIssuingTemplateByAppNameAndCitAlias(appName, citAlias, this.auth.apiKey());
        Application app = this.cloud.applicationByName(appName, this.auth.apiKey());
        String appId = app.id();
        ZoneConfiguration zoneConfig = cit.toZoneConfig();
        zoneConfig.policy(cit.toPolicy());
        zoneConfig.zoneId(zoneId);
        zoneConfig.applicationId(appId);
        zoneConfig.certificateIssuingTemplateId(cit.id());
        return zoneConfig;
    }

    @Override
    public CertificateRequest generateRequest(ZoneConfiguration zoneConfig, CertificateRequest request) throws VCertException {
        switch (request.csrOrigin()) {
            case LocalGeneratedCSR: {
                if (zoneConfig == null) {
                    zoneConfig = this.readZoneConfiguration(this.zone);
                }
                zoneConfig.applyCertificateRequestDefaultSettingsIfNeeded(request);
                zoneConfig.validateCertificateRequest(request);
                request.generatePrivateKey();
                request.generateCSR();
                break;
            }
            case UserProvidedCSR: {
                if (request.csr().length != 0) break;
                throw new CloudConnectorException.CSRNotProvidedByUserException();
            }
            case ServiceGeneratedCSR: {
                request.csr(null);
                break;
            }
            default: {
                throw new CloudConnectorException.UnreconigzedCSROriginException(request.csrOrigin());
            }
        }
        return request;
    }

    @Override
    public String requestCertificate(CertificateRequest request, String zone) throws VCertException {
        return this.requestCertificate(request, new ZoneConfiguration().zoneId(zone));
    }

    @Override
    public String requestCertificate(CertificateRequest request, ZoneConfiguration zoneConfiguration) throws VCertException {
        if (StringUtils.isBlank((CharSequence)zoneConfiguration.zoneId())) {
            zoneConfiguration.zoneId(this.zone);
        }
        if (CsrOriginOption.ServiceGeneratedCSR == request.csrOrigin()) {
            throw new CloudConnectorException.UnsupportedServiceGeneratedCSRException();
        }
        if (this.user == null || this.user.company() == null) {
            throw new CloudConnectorException.UserNotAuthenticatedException("Must be authenticated to request a certificate");
        }
        CertificateRequestsPayload payload = new CertificateRequestsPayload().zoneId(zoneConfiguration.zoneId()).csr(new String(request.csr()));
        if (request.validityHours() > 0) {
            String validityHours = "PT" + request.validityHours() + "H";
            payload.validityPeriod(validityHours);
        }
        payload.applicationId(zoneConfiguration.applicationId());
        payload.certificateIssuingTemplateId(zoneConfiguration.certificateIssuingTemplateId());
        VCertUtils.addApiClientInformation(payload);
        CertificateRequestsResponse response = this.cloud.certificateRequest(this.auth.apiKey(), payload);
        String requestId = response.certificateRequests().get(0).id();
        request.pickupId(requestId);
        return requestId;
    }

    @Override
    public PEMCollection retrieveCertificate(CertificateRequest request) throws VCertException {
        CertificateStatus certificateStatus = null;
        if (request.fetchPrivateKey()) {
            throw new CloudConnectorException.UnsupportedPrivateKeyRetrieveException();
        }
        String certId = "";
        if (StringUtils.isBlank((CharSequence)request.pickupId()) && StringUtils.isNotBlank((CharSequence)request.thumbprint())) {
            String certificateRequestId = null;
            Cloud.CertificateSearchResponse certificateSearchResponse = this.searchCertificatesByFingerprint(request.thumbprint());
            if (certificateSearchResponse.certificates().size() == 0) {
                throw new CloudConnectorException.CertificateNotFoundByFingerprintException(request.thumbprint());
            }
            ArrayList<String> reqIds = new ArrayList<String>();
            boolean isOnlyOneCertificateRequestId = true;
            for (Cloud.Certificate certificate : certificateSearchResponse.certificates()) {
                reqIds.add(certificate.certificateRequestId());
                if (StringUtils.isNotBlank(certificateRequestId) && certificateRequestId.equals(certificate.certificateRequestId())) {
                    isOnlyOneCertificateRequestId = false;
                }
                if (StringUtils.isNotBlank((CharSequence)certificate.certificateRequestId())) {
                    certificateRequestId = certificate.certificateRequestId();
                    continue;
                }
                certId = certificate.id();
            }
            if (!isOnlyOneCertificateRequestId) {
                throw new CloudConnectorException.MoreThanOneCertificateRequestIdException(reqIds);
            }
            request.pickupId(certificateRequestId);
        }
        Instant startTime = Instant.now();
        while (!StringUtils.isBlank((CharSequence)request.pickupId()) && !"ISSUED".equals((certificateStatus = this.getCertificateStatus(request.pickupId())).status())) {
            if ("FAILED".equals(certificateStatus.status())) {
                throw new CloudConnectorException.CertificateStatusFailedException(certificateStatus.toString());
            }
            if (Duration.ZERO.equals(request.timeout())) {
                throw new CloudConnectorException.CertificatePendingException(request.pickupId());
            }
            if (Instant.now().isAfter(startTime.plus(request.timeout()))) {
                throw new CloudConnectorException.RetrieveCertificateTimeoutException(request.pickupId());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new CloudConnectorException.AttemptToRetryException(e);
            }
        }
        if (this.user == null || this.user.company() == null) {
            throw new CloudConnectorException.UserNotAuthenticatedException("Must be authenticated to retieve certificate");
        }
        if (certificateStatus == null) {
            throw new CloudConnectorException.FailedToRetrieveCertificateStatusException(request.pickupId());
        }
        String certificateId = certificateStatus.certificateIds().get(0);
        if (StringUtils.isNotBlank((CharSequence)certificateId)) {
            String chainOption;
            switch (request.chainOption()) {
                case ChainOptionRootFirst: {
                    chainOption = "ROOT_FIRST";
                    break;
                }
                default: {
                    chainOption = "EE_FIRST";
                }
            }
            String body = this.certificateViaCSR(certificateId, chainOption, request);
            PEMCollection pemCollection = PEMCollection.fromResponse(body, request.chainOption(), request.privateKey(), request.keyPassword());
            request.checkCertificate(pemCollection.certificate());
            return pemCollection;
        }
        String body = this.certificateAsPem(certId, request);
        return PEMCollection.fromResponse(body, ChainOption.ChainOptionIgnore, request.privateKey(), request.keyPassword());
    }

    private String certificateViaCSR(String certificateId, String chainOrder, CertificateRequest request) throws VCertException {
        Instant startTime = Instant.now();
        while (true) {
            Response response;
            if ((response = this.cloud.certificateViaCSR(certificateId, this.auth.apiKey(), chainOrder)).status() == 200) {
                try {
                    return CharStreams.toString((Readable)response.body().asReader());
                }
                catch (IOException e) {
                    throw new CloudConnectorException.UnableToReadPEMCertificateException(certificateId);
                }
            }
            if (Duration.ZERO.equals(request.timeout())) {
                throw new CloudConnectorException.CertificatePendingException(request.pickupId());
            }
            if (Instant.now().isAfter(startTime.plus(request.timeout()))) {
                throw new CloudConnectorException.RetrieveCertificateTimeoutException(request.pickupId());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new CloudConnectorException.AttemptToRetryException(e);
            }
        }
    }

    private String certificateAsPem(String certificateId, CertificateRequest request) throws VCertException {
        Instant startTime = Instant.now();
        while (true) {
            Response response;
            if ((response = this.cloud.certificateAsPem(certificateId, this.auth.apiKey())).status() == 200) {
                try {
                    return CharStreams.toString((Readable)response.body().asReader());
                }
                catch (IOException e) {
                    throw new CloudConnectorException.UnableToReadPEMCertificateException(certificateId);
                }
            }
            if (Duration.ZERO.equals(request.timeout())) {
                throw new CloudConnectorException.CertificatePendingException(request.pickupId());
            }
            if (Instant.now().isAfter(startTime.plus(request.timeout()))) {
                throw new CloudConnectorException.RetrieveCertificateTimeoutException(request.pickupId());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new CloudConnectorException.AttemptToRetryException(e);
            }
        }
    }

    public String certificateAsPem(String requestId) throws VCertException {
        Response response = this.cloud.certificateAsPem(requestId, this.auth.apiKey());
        if (response.status() != 200) {
            throw new VCertException(String.format("Invalid response fetching the certificate via CSR: %s", response.reason()));
        }
        try {
            return CharStreams.toString((Readable)response.body().asReader());
        }
        catch (IOException e) {
            throw new VCertException("Unable to read the PEM certificate");
        }
    }

    private CertificateStatus getCertificateStatus(String requestId) {
        return this.cloud.certificateStatus(requestId, this.auth.apiKey());
    }

    @Override
    public void revokeCertificate(RevocationRequest request) throws VCertException {
        throw new UnsupportedOperationException("not supported by endpoint");
    }

    @Override
    public String renewCertificate(RenewalRequest request) throws VCertException {
        String certificateRequestId = null;
        if (StringUtils.isNotBlank((CharSequence)request.thumbprint())) {
            Cloud.CertificateSearchResponse result = this.searchCertificatesByFingerprint(request.thumbprint());
            Set requestIds = result.certificates().stream().map(c -> c.certificateRequestId()).collect(Collectors.toSet());
            if (requestIds.size() > 1) {
                throw new CloudConnectorException.MoreThanOneCertificateRequestIdException(request.thumbprint());
            }
            if (requestIds.size() == 0) {
                throw new CloudConnectorException.CertificateNotFoundByFingerprintException(request.thumbprint());
            }
            certificateRequestId = (String)requestIds.iterator().next();
        } else if (StringUtils.isNotBlank((CharSequence)request.certificateDN())) {
            certificateRequestId = request.certificateDN();
        } else {
            throw new CloudConnectorException.CertificateDNOrFingerprintWasNotProvidedException();
        }
        CertificateStatus status = this.cloud.certificateStatus(certificateRequestId, this.auth.apiKey());
        String certificateId = status.certificateIds().get(0);
        CertificateDetails certDetails = this.cloud.certificateDetails(certificateId, this.auth.apiKey());
        if (!certDetails.certificateRequestId().equals(certificateRequestId)) {
            StringBuilder errorStr = new StringBuilder();
            errorStr.append("Certificate under requestId %s ");
            errorStr.append(StringUtils.isNotBlank((CharSequence)request.thumbprint()) ? String.format("with thumbprint %s ", request.thumbprint()) : "");
            errorStr.append("is not the latest under ManagedCertificateId %s. The latest request is %s. ");
            errorStr.append("This error may happen when revoked certificate is requested to be renewed.");
            throw new VCertException(String.format(errorStr.toString(), certificateRequestId, certDetails.id(), certDetails.certificateRequestId()));
        }
        CertificateRequestsPayload certificateRequest = new CertificateRequestsPayload();
        certificateRequest.existingCertificateId(certDetails.id());
        certificateRequest.applicationId(status.applicationId());
        certificateRequest.certificateIssuingTemplateId(status.certificateIssuingTemplateId());
        VCertUtils.addApiClientInformation(certificateRequest);
        certificateRequest.reuseCSR(!Objects.nonNull(request.request()) || request.request().csr().length <= 0);
        if (certificateRequest.reuseCSR) {
            throw new CloudConnectorException.CSRNotProvidedException();
        }
        certificateRequest.csr(Strings.fromByteArray((byte[])request.request().csr()));
        CertificateRequestsResponse response = this.cloud.certificateRequest(this.auth.apiKey(), certificateRequest);
        return response.certificateRequests().get(0).id();
    }

    @Override
    public ImportResponse importCertificate(ImportRequest request) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public Policy readPolicyConfiguration(String zone) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setPolicy(String policyName, PolicySpecification policySpecification) throws VCertException {
        try {
            CloudPolicy cloudPolicy = (CloudPolicy)CloudPolicySpecificationConverter.INSTANCE.convertFromPolicySpecification(policySpecification);
            CloudConnectorUtils.setCit(policyName, cloudPolicy.certificateIssuingTemplate(), cloudPolicy.caInfo(), this.auth.apiKey(), this.cloud);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    @Override
    public PolicySpecification getPolicy(String policyName) throws VCertException {
        PolicySpecification policySpecification;
        try {
            CloudPolicy cloudPolicy = CloudConnectorUtils.getCloudPolicy(policyName, this.auth.apiKey(), this.cloud);
            policySpecification = CloudPolicySpecificationConverter.INSTANCE.convertToPolicySpecification(cloudPolicy);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        return policySpecification;
    }

    private Cloud.CertificateSearchResponse searchCertificates(Cloud.SearchRequest searchRequest) {
        return this.cloud.searchCertificates(this.auth.apiKey(), searchRequest);
    }

    private Cloud.CertificateSearchResponse searchCertificatesByFingerprint(String fingerprint) {
        String cleanFingerprint = fingerprint.replaceAll(":", "").replaceAll("/.", "");
        return this.searchCertificates(Cloud.SearchRequest.findByFingerPrint(cleanFingerprint));
    }

    private String[] parseZoneIdentifiers(String zone) throws VCertException {
        try {
            UUID.fromString(zone);
            return new String[]{zone, null, null};
        }
        catch (IllegalArgumentException iae) {
            String[] zoneParsed = zone.split(Pattern.quote("\\"));
            if (zoneParsed.length != 2) {
                throw new VCertException(String.format("Invalid zone ID or path. We expect UUID or 'ProjectName\\ZoneName', but we got '%s'.", zone));
            }
            if (StringUtils.isBlank((CharSequence)zoneParsed[0])) {
                throw new VCertException(String.format("Unable to get Project Name from '%s'", zone));
            }
            if (StringUtils.isBlank((CharSequence)zoneParsed[1])) {
                throw new VCertException(String.format("Unable to get Zone Name from '%s'", zone));
            }
            return new String[]{null, zoneParsed[0], zoneParsed[1]};
        }
    }

    public UserDetails user() {
        return this.user;
    }

    public String vendorAndProductName() {
        return this.vendorAndProductName;
    }

    public static class ApiClientInformation {
        String type;
        String identifier;

        public String type() {
            return this.type;
        }

        public String identifier() {
            return this.identifier;
        }

        public ApiClientInformation type(String type) {
            this.type = type;
            return this;
        }

        public ApiClientInformation identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiClientInformation)) {
                return false;
            }
            ApiClientInformation other = (ApiClientInformation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.type();
            String other$type = other.type();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$identifier = this.identifier();
            String other$identifier = other.identifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiClientInformation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.type();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $identifier = this.identifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.ApiClientInformation(type=" + this.type() + ", identifier=" + this.identifier() + ")";
        }
    }

    static class CertificateRequestsResponseData {
        private String id;
        private String zoneId;
        private String status;
        private String subjectDN;
        private boolean generatedKey;
        private boolean defaultKeyPassword;
        private Collection<String> certificateInstanceIds;
        private OffsetDateTime creationDate;
        private String pem;
        private String der;

        public String id() {
            return this.id;
        }

        public String zoneId() {
            return this.zoneId;
        }

        public String status() {
            return this.status;
        }

        public String subjectDN() {
            return this.subjectDN;
        }

        public boolean generatedKey() {
            return this.generatedKey;
        }

        public boolean defaultKeyPassword() {
            return this.defaultKeyPassword;
        }

        public Collection<String> certificateInstanceIds() {
            return this.certificateInstanceIds;
        }

        public OffsetDateTime creationDate() {
            return this.creationDate;
        }

        public String pem() {
            return this.pem;
        }

        public String der() {
            return this.der;
        }

        public CertificateRequestsResponseData id(String id) {
            this.id = id;
            return this;
        }

        public CertificateRequestsResponseData zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public CertificateRequestsResponseData status(String status) {
            this.status = status;
            return this;
        }

        public CertificateRequestsResponseData subjectDN(String subjectDN) {
            this.subjectDN = subjectDN;
            return this;
        }

        public CertificateRequestsResponseData generatedKey(boolean generatedKey) {
            this.generatedKey = generatedKey;
            return this;
        }

        public CertificateRequestsResponseData defaultKeyPassword(boolean defaultKeyPassword) {
            this.defaultKeyPassword = defaultKeyPassword;
            return this;
        }

        public CertificateRequestsResponseData certificateInstanceIds(Collection<String> certificateInstanceIds) {
            this.certificateInstanceIds = certificateInstanceIds;
            return this;
        }

        public CertificateRequestsResponseData creationDate(OffsetDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public CertificateRequestsResponseData pem(String pem) {
            this.pem = pem;
            return this;
        }

        public CertificateRequestsResponseData der(String der) {
            this.der = der;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsResponseData)) {
                return false;
            }
            CertificateRequestsResponseData other = (CertificateRequestsResponseData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$zoneId = this.zoneId();
            String other$zoneId = other.zoneId();
            if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
                return false;
            }
            String this$status = this.status();
            String other$status = other.status();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$subjectDN = this.subjectDN();
            String other$subjectDN = other.subjectDN();
            if (this$subjectDN == null ? other$subjectDN != null : !this$subjectDN.equals(other$subjectDN)) {
                return false;
            }
            if (this.generatedKey() != other.generatedKey()) {
                return false;
            }
            if (this.defaultKeyPassword() != other.defaultKeyPassword()) {
                return false;
            }
            Collection<String> this$certificateInstanceIds = this.certificateInstanceIds();
            Collection<String> other$certificateInstanceIds = other.certificateInstanceIds();
            if (this$certificateInstanceIds == null ? other$certificateInstanceIds != null : !((Object)this$certificateInstanceIds).equals(other$certificateInstanceIds)) {
                return false;
            }
            OffsetDateTime this$creationDate = this.creationDate();
            OffsetDateTime other$creationDate = other.creationDate();
            if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
                return false;
            }
            String this$pem = this.pem();
            String other$pem = other.pem();
            if (this$pem == null ? other$pem != null : !this$pem.equals(other$pem)) {
                return false;
            }
            String this$der = this.der();
            String other$der = other.der();
            return !(this$der == null ? other$der != null : !this$der.equals(other$der));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsResponseData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $zoneId = this.zoneId();
            result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
            String $status = this.status();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $subjectDN = this.subjectDN();
            result = result * 59 + ($subjectDN == null ? 43 : $subjectDN.hashCode());
            result = result * 59 + (this.generatedKey() ? 79 : 97);
            result = result * 59 + (this.defaultKeyPassword() ? 79 : 97);
            Collection<String> $certificateInstanceIds = this.certificateInstanceIds();
            result = result * 59 + ($certificateInstanceIds == null ? 43 : ((Object)$certificateInstanceIds).hashCode());
            OffsetDateTime $creationDate = this.creationDate();
            result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
            String $pem = this.pem();
            result = result * 59 + ($pem == null ? 43 : $pem.hashCode());
            String $der = this.der();
            result = result * 59 + ($der == null ? 43 : $der.hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.CertificateRequestsResponseData(id=" + this.id() + ", zoneId=" + this.zoneId() + ", status=" + this.status() + ", subjectDN=" + this.subjectDN() + ", generatedKey=" + this.generatedKey() + ", defaultKeyPassword=" + this.defaultKeyPassword() + ", certificateInstanceIds=" + this.certificateInstanceIds() + ", creationDate=" + this.creationDate() + ", pem=" + this.pem() + ", der=" + this.der() + ")";
        }
    }

    public static class CertificateRequestsResponse {
        private List<CertificateRequestsResponseData> certificateRequests;

        public List<CertificateRequestsResponseData> certificateRequests() {
            return this.certificateRequests;
        }

        public CertificateRequestsResponse certificateRequests(List<CertificateRequestsResponseData> certificateRequests) {
            this.certificateRequests = certificateRequests;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsResponse)) {
                return false;
            }
            CertificateRequestsResponse other = (CertificateRequestsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CertificateRequestsResponseData> this$certificateRequests = this.certificateRequests();
            List<CertificateRequestsResponseData> other$certificateRequests = other.certificateRequests();
            return !(this$certificateRequests == null ? other$certificateRequests != null : !((Object)this$certificateRequests).equals(other$certificateRequests));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CertificateRequestsResponseData> $certificateRequests = this.certificateRequests();
            result = result * 59 + ($certificateRequests == null ? 43 : ((Object)$certificateRequests).hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.CertificateRequestsResponse(certificateRequests=" + this.certificateRequests() + ")";
        }
    }

    public static class CertificateRequestsPayload {
        @SerializedName(value="certificateSigningRequest")
        private String csr;
        private String zoneId;
        private String existingManagedCertificateId;
        private boolean reuseCSR;
        private String validityPeriod;
        private String applicationId;
        private String certificateIssuingTemplateId;
        private String existingCertificateId;
        private ApiClientInformation apiClientInformation;

        public String csr() {
            return this.csr;
        }

        public String zoneId() {
            return this.zoneId;
        }

        public String existingManagedCertificateId() {
            return this.existingManagedCertificateId;
        }

        public boolean reuseCSR() {
            return this.reuseCSR;
        }

        public String validityPeriod() {
            return this.validityPeriod;
        }

        public String applicationId() {
            return this.applicationId;
        }

        public String certificateIssuingTemplateId() {
            return this.certificateIssuingTemplateId;
        }

        public String existingCertificateId() {
            return this.existingCertificateId;
        }

        public ApiClientInformation apiClientInformation() {
            return this.apiClientInformation;
        }

        public CertificateRequestsPayload csr(String csr) {
            this.csr = csr;
            return this;
        }

        public CertificateRequestsPayload zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public CertificateRequestsPayload existingManagedCertificateId(String existingManagedCertificateId) {
            this.existingManagedCertificateId = existingManagedCertificateId;
            return this;
        }

        public CertificateRequestsPayload reuseCSR(boolean reuseCSR) {
            this.reuseCSR = reuseCSR;
            return this;
        }

        public CertificateRequestsPayload validityPeriod(String validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public CertificateRequestsPayload applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CertificateRequestsPayload certificateIssuingTemplateId(String certificateIssuingTemplateId) {
            this.certificateIssuingTemplateId = certificateIssuingTemplateId;
            return this;
        }

        public CertificateRequestsPayload existingCertificateId(String existingCertificateId) {
            this.existingCertificateId = existingCertificateId;
            return this;
        }

        public CertificateRequestsPayload apiClientInformation(ApiClientInformation apiClientInformation) {
            this.apiClientInformation = apiClientInformation;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsPayload)) {
                return false;
            }
            CertificateRequestsPayload other = (CertificateRequestsPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$csr = this.csr();
            String other$csr = other.csr();
            if (this$csr == null ? other$csr != null : !this$csr.equals(other$csr)) {
                return false;
            }
            String this$zoneId = this.zoneId();
            String other$zoneId = other.zoneId();
            if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
                return false;
            }
            String this$existingManagedCertificateId = this.existingManagedCertificateId();
            String other$existingManagedCertificateId = other.existingManagedCertificateId();
            if (this$existingManagedCertificateId == null ? other$existingManagedCertificateId != null : !this$existingManagedCertificateId.equals(other$existingManagedCertificateId)) {
                return false;
            }
            if (this.reuseCSR() != other.reuseCSR()) {
                return false;
            }
            String this$validityPeriod = this.validityPeriod();
            String other$validityPeriod = other.validityPeriod();
            if (this$validityPeriod == null ? other$validityPeriod != null : !this$validityPeriod.equals(other$validityPeriod)) {
                return false;
            }
            String this$applicationId = this.applicationId();
            String other$applicationId = other.applicationId();
            if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
                return false;
            }
            String this$certificateIssuingTemplateId = this.certificateIssuingTemplateId();
            String other$certificateIssuingTemplateId = other.certificateIssuingTemplateId();
            if (this$certificateIssuingTemplateId == null ? other$certificateIssuingTemplateId != null : !this$certificateIssuingTemplateId.equals(other$certificateIssuingTemplateId)) {
                return false;
            }
            String this$existingCertificateId = this.existingCertificateId();
            String other$existingCertificateId = other.existingCertificateId();
            if (this$existingCertificateId == null ? other$existingCertificateId != null : !this$existingCertificateId.equals(other$existingCertificateId)) {
                return false;
            }
            ApiClientInformation this$apiClientInformation = this.apiClientInformation();
            ApiClientInformation other$apiClientInformation = other.apiClientInformation();
            return !(this$apiClientInformation == null ? other$apiClientInformation != null : !((Object)this$apiClientInformation).equals(other$apiClientInformation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsPayload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $csr = this.csr();
            result = result * 59 + ($csr == null ? 43 : $csr.hashCode());
            String $zoneId = this.zoneId();
            result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
            String $existingManagedCertificateId = this.existingManagedCertificateId();
            result = result * 59 + ($existingManagedCertificateId == null ? 43 : $existingManagedCertificateId.hashCode());
            result = result * 59 + (this.reuseCSR() ? 79 : 97);
            String $validityPeriod = this.validityPeriod();
            result = result * 59 + ($validityPeriod == null ? 43 : $validityPeriod.hashCode());
            String $applicationId = this.applicationId();
            result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
            String $certificateIssuingTemplateId = this.certificateIssuingTemplateId();
            result = result * 59 + ($certificateIssuingTemplateId == null ? 43 : $certificateIssuingTemplateId.hashCode());
            String $existingCertificateId = this.existingCertificateId();
            result = result * 59 + ($existingCertificateId == null ? 43 : $existingCertificateId.hashCode());
            ApiClientInformation $apiClientInformation = this.apiClientInformation();
            result = result * 59 + ($apiClientInformation == null ? 43 : ((Object)$apiClientInformation).hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.CertificateRequestsPayload(csr=" + this.csr() + ", zoneId=" + this.zoneId() + ", existingManagedCertificateId=" + this.existingManagedCertificateId() + ", reuseCSR=" + this.reuseCSR() + ", validityPeriod=" + this.validityPeriod() + ", applicationId=" + this.applicationId() + ", certificateIssuingTemplateId=" + this.certificateIssuingTemplateId() + ", existingCertificateId=" + this.existingCertificateId() + ", apiClientInformation=" + this.apiClientInformation() + ")";
        }
    }
}

