/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.cloud;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.connectors.cloud.Cloud;
import com.venafi.vcert.sdk.connectors.cloud.domain.Application;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import com.venafi.vcert.sdk.connectors.cloud.domain.CloudZone;
import com.venafi.vcert.sdk.connectors.cloud.domain.UserDetails;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CAAccount;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CAAccountsList;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CITsList;
import com.venafi.vcert.sdk.policy.api.domain.CloudPolicy;
import feign.FeignException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CloudConnectorUtils {
    public static void setCit(String policyName, CertificateIssuingTemplate cit, CloudPolicy.CAInfo caInfo, String apiKey, Cloud cloud) throws VCertException {
        CertificateIssuingTemplate citFromServer;
        CloudZone cloudZone = new CloudZone(policyName);
        cit.name(cloudZone.citAlias());
        CAAccountInfo caAccountInfo = CloudConnectorUtils.getCAAccountInfo(caInfo, apiKey, cloud);
        String caProductOptionId = caAccountInfo.productId;
        if (caProductOptionId == null) {
            throw new VCertException("Specified CA doesn't exist");
        }
        cit.certificateAuthorityProductOptionId(caProductOptionId);
        if (caInfo.caType().equals("DIGICERT")) {
            if (caAccountInfo.organizationId != null) {
                cit.product().organizationId(caAccountInfo.organizationId);
            } else {
                throw new VCertException("It was not possible to determine the Organization Id from the DIGICERT Product.");
            }
        }
        if ((citFromServer = CloudConnectorUtils.getCIT(cit.name(), apiKey, cloud)) != null) {
            cloud.updateCIT(cit, citFromServer.id(), apiKey);
            cit.id(citFromServer.id());
        } else {
            cit.id(CloudConnectorUtils.createCIT(cit, apiKey, cloud));
        }
        CloudConnectorUtils.setCitToApp(policyName, cit, apiKey, cloud);
    }

    public static CAAccountInfo getCAAccountInfo(CloudPolicy.CAInfo caInfo, String apiKey, Cloud cloud) throws VCertException {
        String caProductOptionId = null;
        Integer organizationId = null;
        CAAccountsList caAccountsList = cloud.getCAAccounts(caInfo.caType(), apiKey);
        block0: for (CAAccount caAccount : caAccountsList.accounts()) {
            if (!caAccount.account().key().equals(caInfo.caAccountKey())) continue;
            for (CAAccount.ProductOption productOption : caAccount.productOptions()) {
                if (!productOption.productName().equals(caInfo.vendorProductName())) continue;
                caProductOptionId = productOption.id();
                if (!caInfo.caType().equals("DIGICERT") || productOption.productDetails() == null || productOption.productDetails().productTemplate() == null) continue block0;
                organizationId = productOption.productDetails().productTemplate().organizationId();
                continue block0;
            }
        }
        return new CAAccountInfo(caProductOptionId, organizationId);
    }

    public static CertificateIssuingTemplate getCIT(String citName, String apiKey, Cloud cloud) throws VCertException {
        CertificateIssuingTemplate cit = null;
        CITsList citsList = cloud.getCITs(apiKey);
        for (CertificateIssuingTemplate certificateIssuingTemplate : citsList.certificateIssuingTemplates()) {
            if (!certificateIssuingTemplate.name.equals(citName)) continue;
            cit = certificateIssuingTemplate;
            break;
        }
        return cit;
    }

    public static String createCIT(CertificateIssuingTemplate cit, String apiKey, Cloud cloud) throws VCertException {
        CITsList response = cloud.createCIT(cit, apiKey);
        return response.certificateIssuingTemplates().get(0).id();
    }

    public static void setCitToApp(String policyName, CertificateIssuingTemplate cit, String apiKey, Cloud cloud) throws VCertException {
        Application application;
        CloudZone zone;
        block4: {
            zone = new CloudZone(policyName);
            application = null;
            try {
                application = cloud.applicationByName(zone.appName(), apiKey);
            }
            catch (FeignException exception) {
                if (exception.status() == 404) break block4;
                throw exception;
            }
        }
        if (application == null) {
            CloudConnectorUtils.createAppForCit(cit, zone.appName(), apiKey, cloud);
        } else {
            CloudConnectorUtils.addCitToApp(cit, application, apiKey, cloud);
        }
    }

    private static void createAppForCit(CertificateIssuingTemplate cit, String appName, String apiKey, Cloud cloud) throws VCertException {
        UserDetails userDetails = cloud.authorize(apiKey);
        String userId = userDetails.user().id();
        Application application = new Application();
        Application.OwnerIdsAndType ownerIdsAndType = new Application.OwnerIdsAndType();
        ownerIdsAndType.ownerId(userId);
        ownerIdsAndType.ownerType("USER");
        ArrayList<Application.OwnerIdsAndType> ownerIdsAndTypes = new ArrayList<Application.OwnerIdsAndType>();
        ownerIdsAndTypes.add(ownerIdsAndType);
        HashMap<String, String> citAliasIdMap = new HashMap<String, String>();
        citAliasIdMap.put(cit.name(), cit.id());
        application.name(appName);
        application.ownerIdsAndTypes(ownerIdsAndTypes);
        application.certificateIssuingTemplateAliasIdMap(citAliasIdMap);
        cloud.createApplication(application, apiKey);
    }

    private static void addCitToApp(CertificateIssuingTemplate cit, Application application, String apiKey, Cloud cloud) throws VCertException {
        Map<String, String> citAliasIdMap = null;
        if (application.certificateIssuingTemplateAliasIdMap() != null) {
            citAliasIdMap = application.certificateIssuingTemplateAliasIdMap();
        } else {
            citAliasIdMap = new HashMap<String, String>();
            application.certificateIssuingTemplateAliasIdMap(citAliasIdMap);
        }
        if (!citAliasIdMap.containsKey(cit.name())) {
            citAliasIdMap.put(cit.name(), cit.id());
            String appId = application.id();
            application.id(null);
            application.companyId(null);
            application.fqDns(null);
            application.internalFqDns(null);
            cloud.updateApplication(application, appId, apiKey);
        }
    }

    public static CloudPolicy getCloudPolicy(String policyName, String apiKey, Cloud cloud) throws VCertException {
        CloudPolicy cloudPolicy = new CloudPolicy();
        CertificateIssuingTemplate cit = CloudConnectorUtils.getPolicy(policyName, apiKey, cloud);
        cloudPolicy.certificateIssuingTemplate(cit);
        cloudPolicy.caInfo(CloudConnectorUtils.getCAInfo(cit, apiKey, cloud));
        return cloudPolicy;
    }

    private static CertificateIssuingTemplate getPolicy(String policyName, String apiKey, Cloud cloud) throws VCertException {
        CloudZone zone = new CloudZone(policyName);
        return cloud.certificateIssuingTemplateByAppNameAndCitAlias(zone.appName(), zone.citAlias(), apiKey);
    }

    private static CloudPolicy.CAInfo getCAInfo(CertificateIssuingTemplate cit, String apiKey, Cloud cloud) throws VCertException {
        CAAccount caAccount = cloud.getCAAccount(cit.certificateAuthority, cit.certificateAuthorityAccountId(), apiKey);
        return new CloudPolicy.CAInfo(cit.certificateAuthority, caAccount.account().key(), CloudConnectorUtils.getProductName(caAccount, cit));
    }

    private static String getProductName(CAAccount caAccount, CertificateIssuingTemplate cit) {
        return caAccount.productOptions().stream().filter(p -> p.id().equals(cit.certificateAuthorityProductOptionId)).findFirst().get().productName();
    }

    public static class CAAccountInfo {
        private String productId;
        private Integer organizationId;

        public String productId() {
            return this.productId;
        }

        public Integer organizationId() {
            return this.organizationId;
        }

        public CAAccountInfo productId(String productId) {
            this.productId = productId;
            return this;
        }

        public CAAccountInfo organizationId(Integer organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CAAccountInfo)) {
                return false;
            }
            CAAccountInfo other = (CAAccountInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$productId = this.productId();
            String other$productId = other.productId();
            if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
                return false;
            }
            Integer this$organizationId = this.organizationId();
            Integer other$organizationId = other.organizationId();
            return !(this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CAAccountInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $productId = this.productId();
            result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
            Integer $organizationId = this.organizationId();
            result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnectorUtils.CAAccountInfo(productId=" + this.productId() + ", organizationId=" + this.organizationId() + ")";
        }

        public CAAccountInfo(String productId, Integer organizationId) {
            this.productId = productId;
            this.organizationId = organizationId;
        }
    }
}

