/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.google.gson.annotations.SerializedName;
import com.venafi.vcert.sdk.Config;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.connectors.tpp.AbstractTppConnector;
import com.venafi.vcert.sdk.connectors.tpp.AuthorizeResponse;
import com.venafi.vcert.sdk.connectors.tpp.AuthorizeTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.RefreshTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ClearPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeResponse;
import com.venafi.vcert.sdk.utils.FeignUtils;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.Response;
import java.util.List;
import java.util.Map;

public interface Tpp {
    @RequestLine(value="POST authorize/")
    @Headers(value={"Content-Type: application/json"})
    public AuthorizeResponse authorize(AbstractTppConnector.AuthorizeRequest var1);

    @RequestLine(value="POST certificates/checkpolicy")
    @Headers(value={"Content-Type: application/json", "x-venafi-api-key: {value}"})
    public AbstractTppConnector.ReadZoneConfigurationResponse readZoneConfiguration(AbstractTppConnector.ReadZoneConfigurationRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST certificates/request")
    @Headers(value={"Content-Type: application/json", "x-venafi-api-key: {value}"})
    public CertificateRequestResponse requestCertificate(AbstractTppConnector.CertificateRequestsPayload var1, @Param(value="value") String var2);

    @RequestLine(value="GET certificates/")
    @Headers(value={"x-venafi-api-key: {value}"})
    public CertificateSearchResponse searchCertificates(@QueryMap Map<String, String> var1, @Param(value="value") String var2);

    @RequestLine(value="POST certificates/retrieve")
    @Headers(value={"Content-Type: application/json", "x-venafi-api-key: {value}"})
    public CertificateRetrieveResponse certificateRetrieve(AbstractTppConnector.CertificateRetrieveRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST certificates/revoke")
    @Headers(value={"Content-Type: application/json", "x-venafi-api-key: {value}"})
    public CertificateRevokeResponse revokeCertificate(AbstractTppConnector.CertificateRevokeRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST certificates/renew")
    @Headers(value={"Content-Type: application/json", "x-venafi-api-key: {value}"})
    public CertificateRenewalResponse renewCertificate(AbstractTppConnector.CertificateRenewalRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST certificates/import")
    @Headers(value={"Content-Type: application/json", "x-venafi-api-key: {value}"})
    public ImportResponse importCertificate(ImportRequest var1, @Param(value="value") String var2);

    @RequestLine(value="GET /")
    @Headers(value={"x-venafi-api-key: {value}"})
    public Response ping(@Param(value="value") String var1);

    @RequestLine(value="POST Config/IsValid")
    @Headers(value={"Content-Type: application/json", "X-Venafi-Api-Key: {apiKey}"})
    public DNIsValidResponse dnIsValid(DNIsValidRequest var1, @Param(value="apiKey") String var2);

    @RequestLine(value="POST Config/Create")
    @Headers(value={"Content-Type: application/json", "X-Venafi-Api-Key: {apiKey}"})
    public CreateDNResponse createDN(CreateDNRequest var1, @Param(value="apiKey") String var2);

    @RequestLine(value="POST Config/WritePolicy")
    @Headers(value={"Content-Type: application/json", "X-Venafi-Api-Key: {apiKey}"})
    public SetPolicyAttributeResponse setPolicyAttribute(SetPolicyAttributeRequest var1, @Param(value="apiKey") String var2);

    @RequestLine(value="POST Config/ReadPolicy")
    @Headers(value={"Content-Type: application/json", "X-Venafi-Api-Key: {apiKey}"})
    public GetPolicyAttributeResponse getPolicyAttribute(GetPolicyAttributeRequest var1, @Param(value="apiKey") String var2);

    @RequestLine(value="POST Certificates/CheckPolicy")
    @Headers(value={"Content-Type: application/json", "X-Venafi-Api-Key: {apiKey}"})
    public GetPolicyResponse getPolicy(GetPolicyRequest var1, @Param(value="apiKey") String var2);

    @RequestLine(value="POST Config/ClearPolicyAttribute")
    @Headers(value={"Content-Type: application/json", "X-Venafi-Api-Key: {apiKey}"})
    public Response clearPolicyAttribute(ClearPolicyAttributeRequest var1, @Param(value="apiKey") String var2);

    @RequestLine(value="POST /vedauth/authorize/oauth")
    @Headers(value={"Content-Type: application/json"})
    public AuthorizeTokenResponse authorizeToken(AbstractTppConnector.AuthorizeTokenRequest var1);

    @RequestLine(value="POST /vedauth/authorize/token")
    @Headers(value={"Content-Type: application/json"})
    public RefreshTokenResponse refreshToken(AbstractTppConnector.RefreshTokenRequest var1);

    @RequestLine(value="GET /vedauth/revoke/token")
    @Headers(value={"Authorization: {token}"})
    public Response revokeToken(@Param(value="token") String var1);

    @RequestLine(value="POST /vedsdk/certificates/checkpolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {value}"})
    public AbstractTppConnector.ReadZoneConfigurationResponse readZoneConfigurationToken(AbstractTppConnector.ReadZoneConfigurationRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST /vedsdk/certificates/request")
    @Headers(value={"Content-Type: application/json", "Authorization: {value}"})
    public CertificateRequestResponse requestCertificateToken(AbstractTppConnector.CertificateRequestsPayload var1, @Param(value="value") String var2);

    @RequestLine(value="GET /vedsdk/certificates/")
    @Headers(value={"Authorization: {value}"})
    public CertificateSearchResponse searchCertificatesToken(@QueryMap Map<String, String> var1, @Param(value="value") String var2);

    @RequestLine(value="POST /vedsdk/certificates/retrieve")
    @Headers(value={"Content-Type: application/json", "Authorization: {value}"})
    public CertificateRetrieveResponse certificateRetrieveToken(AbstractTppConnector.CertificateRetrieveRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST /vedsdk/certificates/revoke")
    @Headers(value={"Content-Type: application/json", "Authorization: {value}"})
    public CertificateRevokeResponse revokeCertificateToken(AbstractTppConnector.CertificateRevokeRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST /vedsdk/certificates/renew")
    @Headers(value={"Content-Type: application/json", "Authorization: {value}"})
    public CertificateRenewalResponse renewCertificateToken(AbstractTppConnector.CertificateRenewalRequest var1, @Param(value="value") String var2);

    @RequestLine(value="POST /vedsdk/certificates/import")
    @Headers(value={"Content-Type: application/json", "Authorization: {value}"})
    public ImportResponse importCertificateToken(ImportRequest var1, @Param(value="value") String var2);

    @RequestLine(value="GET /vedsdk")
    @Headers(value={"Authorization: {value}"})
    public Response pingToken(@Param(value="value") String var1);

    @RequestLine(value="POST /vedsdk/Config/IsValid")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public DNIsValidResponse dnIsValidToken(DNIsValidRequest var1, @Param(value="token") String var2);

    @RequestLine(value="POST /vedsdk/Config/Create")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public CreateDNResponse createDNToken(CreateDNRequest var1, @Param(value="token") String var2);

    @RequestLine(value="POST /vedsdk/Config/WritePolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public SetPolicyAttributeResponse setPolicyAttributeToken(SetPolicyAttributeRequest var1, @Param(value="token") String var2);

    @RequestLine(value="POST /vedsdk/Config/ReadPolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public GetPolicyAttributeResponse getPolicyAttributeToken(GetPolicyAttributeRequest var1, @Param(value="token") String var2);

    @RequestLine(value="POST /vedsdk/Certificates/CheckPolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public GetPolicyResponse getPolicyToken(GetPolicyRequest var1, @Param(value="token") String var2);

    @RequestLine(value="POST /vedsdk/Config/ClearPolicyAttribute")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public Response clearPolicyAttributeToken(ClearPolicyAttributeRequest var1, @Param(value="token") String var2);

    public static Tpp connect(String baseUrl) {
        return FeignUtils.client(Tpp.class, Config.builder().baseUrl(baseUrl).build());
    }

    public static Tpp connect(Config config) {
        return FeignUtils.client(Tpp.class, config);
    }

    public static class CertificateRevokeResponse {
        private boolean requested;
        private boolean success;
        private String error;

        public boolean requested() {
            return this.requested;
        }

        public boolean success() {
            return this.success;
        }

        public String error() {
            return this.error;
        }

        public CertificateRevokeResponse requested(boolean requested) {
            this.requested = requested;
            return this;
        }

        public CertificateRevokeResponse success(boolean success) {
            this.success = success;
            return this;
        }

        public CertificateRevokeResponse error(String error) {
            this.error = error;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRevokeResponse)) {
                return false;
            }
            CertificateRevokeResponse other = (CertificateRevokeResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.requested() != other.requested()) {
                return false;
            }
            if (this.success() != other.success()) {
                return false;
            }
            String this$error = this.error();
            String other$error = other.error();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRevokeResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.requested() ? 79 : 97);
            result = result * 59 + (this.success() ? 79 : 97);
            String $error = this.error();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        public String toString() {
            return "Tpp.CertificateRevokeResponse(requested=" + this.requested() + ", success=" + this.success() + ", error=" + this.error() + ")";
        }
    }

    public static class CertificateRenewalResponse {
        private boolean success;
        private String error;

        public boolean success() {
            return this.success;
        }

        public String error() {
            return this.error;
        }

        public CertificateRenewalResponse success(boolean success) {
            this.success = success;
            return this;
        }

        public CertificateRenewalResponse error(String error) {
            this.error = error;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRenewalResponse)) {
                return false;
            }
            CertificateRenewalResponse other = (CertificateRenewalResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.success() != other.success()) {
                return false;
            }
            String this$error = this.error();
            String other$error = other.error();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRenewalResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.success() ? 79 : 97);
            String $error = this.error();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        public String toString() {
            return "Tpp.CertificateRenewalResponse(success=" + this.success() + ", error=" + this.error() + ")";
        }
    }

    public static class CertificateRetrieveResponse {
        private String certificateData;
        private String format;
        private String filename;
        private String status;
        private int stage;

        public String certificateData() {
            return this.certificateData;
        }

        public String format() {
            return this.format;
        }

        public String filename() {
            return this.filename;
        }

        public String status() {
            return this.status;
        }

        public int stage() {
            return this.stage;
        }

        public CertificateRetrieveResponse certificateData(String certificateData) {
            this.certificateData = certificateData;
            return this;
        }

        public CertificateRetrieveResponse format(String format) {
            this.format = format;
            return this;
        }

        public CertificateRetrieveResponse filename(String filename) {
            this.filename = filename;
            return this;
        }

        public CertificateRetrieveResponse status(String status) {
            this.status = status;
            return this;
        }

        public CertificateRetrieveResponse stage(int stage) {
            this.stage = stage;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRetrieveResponse)) {
                return false;
            }
            CertificateRetrieveResponse other = (CertificateRetrieveResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateData = this.certificateData();
            String other$certificateData = other.certificateData();
            if (this$certificateData == null ? other$certificateData != null : !this$certificateData.equals(other$certificateData)) {
                return false;
            }
            String this$format = this.format();
            String other$format = other.format();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            String this$filename = this.filename();
            String other$filename = other.filename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            String this$status = this.status();
            String other$status = other.status();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            return this.stage() == other.stage();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRetrieveResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateData = this.certificateData();
            result = result * 59 + ($certificateData == null ? 43 : $certificateData.hashCode());
            String $format = this.format();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            String $filename = this.filename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            String $status = this.status();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            result = result * 59 + this.stage();
            return result;
        }

        public String toString() {
            return "Tpp.CertificateRetrieveResponse(certificateData=" + this.certificateData() + ", format=" + this.format() + ", filename=" + this.filename() + ", status=" + this.status() + ", stage=" + this.stage() + ")";
        }
    }

    public static class CertificateRequestResponse {
        @SerializedName(value="CertificateDN")
        private String certificateDN;
        @SerializedName(value="Guid")
        private String guid;

        public String certificateDN() {
            return this.certificateDN;
        }

        public String guid() {
            return this.guid;
        }

        public CertificateRequestResponse certificateDN(String certificateDN) {
            this.certificateDN = certificateDN;
            return this;
        }

        public CertificateRequestResponse guid(String guid) {
            this.guid = guid;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestResponse)) {
                return false;
            }
            CertificateRequestResponse other = (CertificateRequestResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateDN = this.certificateDN();
            String other$certificateDN = other.certificateDN();
            if (this$certificateDN == null ? other$certificateDN != null : !this$certificateDN.equals(other$certificateDN)) {
                return false;
            }
            String this$guid = this.guid();
            String other$guid = other.guid();
            return !(this$guid == null ? other$guid != null : !this$guid.equals(other$guid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateDN = this.certificateDN();
            result = result * 59 + ($certificateDN == null ? 43 : $certificateDN.hashCode());
            String $guid = this.guid();
            result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
            return result;
        }

        public String toString() {
            return "Tpp.CertificateRequestResponse(certificateDN=" + this.certificateDN() + ", guid=" + this.guid() + ")";
        }
    }

    public static class Certificate {
        @SerializedName(value="DN")
        private String certificateRequestId;

        public String certificateRequestId() {
            return this.certificateRequestId;
        }

        public Certificate certificateRequestId(String certificateRequestId) {
            this.certificateRequestId = certificateRequestId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Certificate)) {
                return false;
            }
            Certificate other = (Certificate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateRequestId = this.certificateRequestId();
            String other$certificateRequestId = other.certificateRequestId();
            return !(this$certificateRequestId == null ? other$certificateRequestId != null : !this$certificateRequestId.equals(other$certificateRequestId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Certificate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateRequestId = this.certificateRequestId();
            result = result * 59 + ($certificateRequestId == null ? 43 : $certificateRequestId.hashCode());
            return result;
        }

        public String toString() {
            return "Tpp.Certificate(certificateRequestId=" + this.certificateRequestId() + ")";
        }
    }

    public static class CertificateSearchResponse {
        private Integer count;
        private List<Certificate> certificates;

        public Integer count() {
            return this.count;
        }

        public List<Certificate> certificates() {
            return this.certificates;
        }

        public CertificateSearchResponse count(Integer count) {
            this.count = count;
            return this;
        }

        public CertificateSearchResponse certificates(List<Certificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateSearchResponse)) {
                return false;
            }
            CertificateSearchResponse other = (CertificateSearchResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$count = this.count();
            Integer other$count = other.count();
            if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                return false;
            }
            List<Certificate> this$certificates = this.certificates();
            List<Certificate> other$certificates = other.certificates();
            return !(this$certificates == null ? other$certificates != null : !((Object)this$certificates).equals(other$certificates));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateSearchResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $count = this.count();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            List<Certificate> $certificates = this.certificates();
            result = result * 59 + ($certificates == null ? 43 : ((Object)$certificates).hashCode());
            return result;
        }

        public String toString() {
            return "Tpp.CertificateSearchResponse(count=" + this.count() + ", certificates=" + this.certificates() + ")";
        }
    }
}

