/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.google.common.annotations.VisibleForTesting;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.ChainOption;
import com.venafi.vcert.sdk.certificate.CsrOriginOption;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.certificate.KeyType;
import com.venafi.vcert.sdk.certificate.PEMCollection;
import com.venafi.vcert.sdk.certificate.PublicKeyAlgorithm;
import com.venafi.vcert.sdk.certificate.RenewalRequest;
import com.venafi.vcert.sdk.certificate.RevocationRequest;
import com.venafi.vcert.sdk.connectors.Connector;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.connectors.ServerPolicy;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.connectors.tpp.AbstractTppConnector;
import com.venafi.vcert.sdk.connectors.tpp.AuthorizeResponse;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.TppAPI;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ClearPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeResponse;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;
import com.venafi.vcert.sdk.policy.api.domain.TPPPolicy;
import com.venafi.vcert.sdk.policy.converter.TPPPolicySpecificationConverter;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.utils.Is;
import com.venafi.vcert.sdk.utils.VCertUtils;
import feign.Response;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Strings;

public class TppConnector
extends AbstractTppConnector
implements Connector {
    @VisibleForTesting
    OffsetDateTime bestBeforeEnd;
    private String apiKey;
    private TppAPI tppAPI;

    public TppConnector(Tpp tpp) {
        super(tpp);
    }

    @Override
    public ConnectorType getType() {
        return ConnectorType.TPP;
    }

    @Override
    public void setBaseUrl(String url) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setZone(String zone) {
        this.zone = zone;
    }

    @Override
    public void setVendorAndProductName(String vendorAndProductName) {
        this.vendorAndProductName = vendorAndProductName;
    }

    @Override
    public String getVendorAndProductName() {
        return this.vendorAndProductName;
    }

    @Override
    public void ping() throws VCertException {
        Response response = this.doPing();
        if (response.status() != 200) {
            throw new VCertException(String.format("ping failed with status %d and reason %s", response.status(), response.reason()));
        }
    }

    private Response doPing() {
        return this.tpp.ping(this.apiKey);
    }

    @Override
    public void authenticate(Authentication auth) throws VCertException {
        VCertException.throwIfNull(auth, "failed to authenticate: missing credentials");
        AuthorizeResponse response = this.tpp.authorize(new AbstractTppConnector.AuthorizeRequest(auth.user(), auth.password()));
        this.apiKey = response.apiKey();
        this.bestBeforeEnd = response.validUntil();
    }

    @Override
    public ZoneConfiguration readZoneConfiguration(String zone) throws VCertException {
        VCertException.throwIfNull(zone, "empty zone");
        AbstractTppConnector.ReadZoneConfigurationRequest request = new AbstractTppConnector.ReadZoneConfigurationRequest(this.getPolicyDN(zone));
        AbstractTppConnector.ReadZoneConfigurationResponse response = this.tpp.readZoneConfiguration(request, this.apiKey);
        ServerPolicy serverPolicy = response.policy();
        Policy policy = serverPolicy.toPolicy();
        ZoneConfiguration zoneConfig = serverPolicy.toZoneConfig();
        zoneConfig.policy(policy);
        zoneConfig.zoneId(zone);
        return zoneConfig;
    }

    @Override
    public CertificateRequest generateRequest(ZoneConfiguration config, CertificateRequest request) throws VCertException {
        String tppMgmtType;
        if (config == null) {
            config = this.readZoneConfiguration(this.zone);
        }
        if ("Monitoring".equals(tppMgmtType = config.customAttributeValues().get("Management Type")) || "Unassigned".equals(tppMgmtType)) {
            throw new VCertException("Unable to request certificate from TPP, current TPP configuration would not allow the request to be processed");
        }
        config.applyCertificateRequestDefaultSettingsIfNeeded(request);
        switch (request.csrOrigin()) {
            case LocalGeneratedCSR: {
                if ("0".equals(config.customAttributeValues().get("Manual Csr"))) {
                    throw new VCertException("Unable to request certificate by local generated CSR when zone configuration is 'Manual Csr' = 0");
                }
                request.generatePrivateKey();
                request.generateCSR();
                break;
            }
            case UserProvidedCSR: {
                if ("0".equals(config.customAttributeValues().get("Manual Csr"))) {
                    throw new VCertException("Unable to request certificate with user provided CSR when zone configuration is 'Manual Csr' = 0");
                }
                if (!Is.blank(request.csr())) break;
                throw new VCertException("CSR was supposed to be provided by user, but it's empty");
            }
            case ServiceGeneratedCSR: {
                request.csr(null);
            }
        }
        return request;
    }

    @Override
    public String requestCertificate(CertificateRequest request, String zone) throws VCertException {
        return this.requestCertificate(request, new ZoneConfiguration().zoneId(zone));
    }

    @Override
    public String requestCertificate(CertificateRequest request, ZoneConfiguration zoneConfiguration) throws VCertException {
        if (StringUtils.isBlank((CharSequence)zoneConfiguration.zoneId())) {
            zoneConfiguration.zoneId(this.zone);
        }
        AbstractTppConnector.CertificateRequestsPayload payload = this.prepareRequest(request, zoneConfiguration.zoneId());
        Tpp.CertificateRequestResponse response = this.tpp.requestCertificate(payload, this.apiKey);
        String requestId = response.certificateDN();
        request.pickupId(requestId);
        return requestId;
    }

    private AbstractTppConnector.CertificateRequestsPayload prepareRequest(CertificateRequest request, String zone) throws VCertException {
        AbstractTppConnector.CertificateRequestsPayload payload;
        ArrayList<AbstractTppConnector.NameValuePair<String, String>> caSpecificAttributes = new ArrayList<AbstractTppConnector.NameValuePair<String, String>>();
        if (!StringUtils.isBlank((CharSequence)this.vendorAndProductName)) {
            caSpecificAttributes.add(new AbstractTppConnector.NameValuePair<String, String>("Origin", this.vendorAndProductName));
        }
        switch (request.csrOrigin()) {
            case LocalGeneratedCSR: {
                payload = new AbstractTppConnector.CertificateRequestsPayload().policyDN(this.getPolicyDN(zone)).pkcs10(new String(request.csr())).objectName(request.friendlyName()).disableAutomaticRenewal(true).origin(this.vendorAndProductName).caSpecificAttributes(caSpecificAttributes);
                break;
            }
            case UserProvidedCSR: {
                payload = new AbstractTppConnector.CertificateRequestsPayload().policyDN(this.getPolicyDN(zone)).pkcs10(new String(request.csr())).objectName(request.friendlyName()).subjectAltNames(this.wrapAltNames(request)).disableAutomaticRenewal(true).origin(this.vendorAndProductName).caSpecificAttributes(caSpecificAttributes);
                break;
            }
            case ServiceGeneratedCSR: {
                payload = new AbstractTppConnector.CertificateRequestsPayload().policyDN(this.getPolicyDN(zone)).objectName(request.friendlyName()).subject(request.subject().commonName()).subjectAltNames(this.wrapAltNames(request)).disableAutomaticRenewal(true).origin(this.vendorAndProductName).caSpecificAttributes(caSpecificAttributes);
                break;
            }
            default: {
                throw new VCertException(MessageFormat.format("Unexpected option in PrivateKeyOrigin: {0}", new Object[]{request.csrOrigin()}));
            }
        }
        if (request.keyType() == null) {
            request.keyType(KeyType.defaultKeyType());
        }
        switch (request.keyType()) {
            case RSA: {
                payload.keyAlgorithm(PublicKeyAlgorithm.RSA.name());
                payload.keyBitSize(request.keyLength());
                break;
            }
            case ECDSA: {
                payload.keyAlgorithm("ECC");
                payload.ellipticCurve(request.keyCurve().value());
            }
        }
        VCertUtils.addExpirationDateAttribute(request, payload);
        VCertUtils.addCustomFieldsToRequest(request, payload);
        return payload;
    }

    private Collection<AbstractTppConnector.SANItem> wrapAltNames(CertificateRequest request) {
        ArrayList<AbstractTppConnector.SANItem> sanItems = new ArrayList<AbstractTppConnector.SANItem>();
        sanItems.addAll(this.toSanItems(request.emailAddresses(), 1));
        sanItems.addAll(this.toSanItems(request.dnsNames(), 2));
        sanItems.addAll(this.toSanItems(request.ipAddresses(), 7));
        return sanItems;
    }

    private List<AbstractTppConnector.SANItem> toSanItems(Collection<?> collection, int type) {
        return ((Collection)Optional.ofNullable(collection).orElse(Collections.emptyList())).stream().filter(Objects::nonNull).map(entry -> new AbstractTppConnector.SANItem().type(type).name(type == 7 ? ((InetAddress)entry).getHostAddress() : entry.toString())).collect(Collectors.toList());
    }

    @Override
    public PEMCollection retrieveCertificate(CertificateRequest request) throws VCertException {
        boolean rootFirstOrder;
        boolean includeChain = request.chainOption() != ChainOption.ChainOptionIgnore;
        boolean bl = rootFirstOrder = includeChain && request.chainOption() == ChainOption.ChainOptionRootFirst;
        if (StringUtils.isNotBlank((CharSequence)request.pickupId()) && StringUtils.isNotBlank((CharSequence)request.thumbprint())) {
            Tpp.CertificateSearchResponse searchResult = this.searchCertificatesByFingerprint(request.thumbprint());
            if (searchResult.certificates().size() == 0) {
                throw new VCertException(String.format("No certificate found using fingerprint %s", request.thumbprint()));
            }
            if (searchResult.certificates().size() > 1) {
                throw new VCertException(String.format("Error: more than one CertificateRequestId was found with the same thumbprint %s", request.thumbprint()));
            }
            request.pickupId(searchResult.certificates().get(0).certificateRequestId());
        }
        AbstractTppConnector.CertificateRetrieveRequest certReq = new AbstractTppConnector.CertificateRetrieveRequest().certificateDN(request.pickupId()).format("base64").rootFirstOrder(rootFirstOrder).includeChain(includeChain);
        if (request.csrOrigin() == CsrOriginOption.ServiceGeneratedCSR || request.fetchPrivateKey()) {
            certReq.includePrivateKey(true);
            certReq.password(request.keyPassword());
        }
        Instant startTime = Instant.now();
        while (true) {
            Tpp.CertificateRetrieveResponse retrieveResponse;
            if (StringUtils.isNotBlank((CharSequence)(retrieveResponse = this.retrieveCertificateOnce(certReq)).certificateData())) {
                PEMCollection pemCollection = PEMCollection.fromResponse(Strings.fromByteArray((byte[])Base64.getDecoder().decode(retrieveResponse.certificateData())), request.chainOption(), request.privateKey(), request.keyPassword());
                request.checkCertificate(pemCollection.certificate());
                return pemCollection;
            }
            if (Duration.ZERO.equals(request.timeout())) {
                throw new VCertException(String.format("Failed to retrieve certificate %s. Status %s", request.pickupId(), retrieveResponse.status()));
            }
            if (Instant.now().isAfter(startTime.plus(request.timeout()))) {
                throw new VCertException(String.format("Timeout trying to retrieve certificate %s", request.pickupId()));
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new VCertException("Error attempting to retry", e);
            }
        }
    }

    private Tpp.CertificateRetrieveResponse retrieveCertificateOnce(AbstractTppConnector.CertificateRetrieveRequest certificateRetrieveRequest) {
        return this.tpp.certificateRetrieve(certificateRetrieveRequest, this.apiKey);
    }

    private Tpp.CertificateSearchResponse searchCertificatesByFingerprint(String fingerprint) {
        HashMap<String, String> searchRequest = new HashMap<String, String>();
        searchRequest.put("Thumbprint", fingerprint);
        return this.searchCertificates(searchRequest);
    }

    private Tpp.CertificateSearchResponse searchCertificates(Map<String, String> searchRequest) {
        return this.tpp.searchCertificates(searchRequest, this.apiKey);
    }

    @Override
    public void revokeCertificate(RevocationRequest request) throws VCertException {
        Integer reason = (Integer)revocationReasons.get(request.reason());
        if (reason == null) {
            throw new VCertException(String.format("could not parse revocation reason `%s`", request.reason()));
        }
        AbstractTppConnector.CertificateRevokeRequest revokeRequest = new AbstractTppConnector.CertificateRevokeRequest().certificateDN(request.certificateDN()).thumbprint(request.thumbprint()).reason(reason).comments(request.comments()).disable(request.disable());
        Tpp.CertificateRevokeResponse revokeResponse = this.revokeCertificate(revokeRequest);
        if (!revokeResponse.success()) {
            throw new VCertException(String.format("Revocation error: %s", revokeResponse.error()));
        }
    }

    private Tpp.CertificateRevokeResponse revokeCertificate(AbstractTppConnector.CertificateRevokeRequest request) {
        return this.tpp.revokeCertificate(request, this.apiKey);
    }

    @Override
    public String renewCertificate(RenewalRequest request) throws VCertException {
        Tpp.CertificateRenewalResponse response;
        String certificateDN;
        if (StringUtils.isNotBlank((CharSequence)request.thumbprint()) && StringUtils.isBlank((CharSequence)request.certificateDN())) {
            Tpp.CertificateSearchResponse searchResult = this.searchCertificatesByFingerprint(request.thumbprint());
            if (searchResult.certificates().isEmpty()) {
                throw new VCertException(String.format("No certificate found using fingerprint %s", request.thumbprint()));
            }
            if (searchResult.certificates().size() > 1) {
                throw new VCertException(String.format("More than one certificate was found with the same thumbprint", new Object[0]));
            }
            certificateDN = searchResult.certificates().get(0).certificateRequestId();
        } else {
            certificateDN = request.certificateDN();
        }
        if (Objects.isNull(certificateDN)) {
            throw new VCertException("Failed to create renewal request: CertificateDN or Thumbprint required");
        }
        AbstractTppConnector.CertificateRenewalRequest renewalRequest = new AbstractTppConnector.CertificateRenewalRequest();
        renewalRequest.certificateDN(certificateDN);
        if (Objects.nonNull(request.request()) && request.request().csr().length > 0) {
            String pkcs10 = Strings.fromByteArray((byte[])request.request().csr());
            renewalRequest.PKCS10(pkcs10);
        }
        if (!(response = this.tpp.renewCertificate(renewalRequest, this.apiKey())).success()) {
            throw new VCertException(String.format("Certificate renewal error: %s", response.error()));
        }
        return certificateDN;
    }

    @Override
    public ImportResponse importCertificate(ImportRequest request) throws VCertException {
        if (StringUtils.isBlank((CharSequence)request.policyDN())) {
            request.policyDN(this.getPolicyDN(this.zone));
        }
        return this.doImportCertificate(request);
    }

    private ImportResponse doImportCertificate(ImportRequest request) {
        return this.tpp.importCertificate(request, this.apiKey);
    }

    @Override
    public Policy readPolicyConfiguration(String zone) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setPolicy(String policyName, PolicySpecification policySpecification) throws VCertException {
        try {
            TPPPolicy tppPolicy = (TPPPolicy)TPPPolicySpecificationConverter.INSTANCE.convertFromPolicySpecification(policySpecification);
            this.setPolicy(policyName, tppPolicy);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    @Override
    public PolicySpecification getPolicy(String policyName) throws VCertException {
        PolicySpecification policySpecification;
        try {
            TPPPolicy tppPolicy = this.getTPPPolicy(policyName);
            policySpecification = TPPPolicySpecificationConverter.INSTANCE.convertToPolicySpecification(tppPolicy);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        return policySpecification;
    }

    @Override
    protected TppAPI getTppAPI() {
        if (this.tppAPI == null) {
            this.tppAPI = new TppAPI(this.tpp){

                @Override
                String getAuthKey() throws VCertException {
                    if (TppConnector.this.apiKey() == null) {
                        throw new VCertException("API Key is null");
                    }
                    return TppConnector.this.apiKey();
                }

                @Override
                public DNIsValidResponse dnIsValid(DNIsValidRequest request) throws VCertException {
                    return this.tpp.dnIsValid(request, this.getAuthKey());
                }

                @Override
                CreateDNResponse createDN(CreateDNRequest request) throws VCertException {
                    return this.tpp.createDN(request, this.getAuthKey());
                }

                @Override
                SetPolicyAttributeResponse setPolicyAttribute(SetPolicyAttributeRequest request) throws VCertException {
                    return this.tpp.setPolicyAttribute(request, this.getAuthKey());
                }

                @Override
                GetPolicyAttributeResponse getPolicyAttribute(GetPolicyAttributeRequest request) throws VCertException {
                    return this.tpp.getPolicyAttribute(request, this.getAuthKey());
                }

                @Override
                GetPolicyResponse getPolicy(GetPolicyRequest request) throws VCertException {
                    return this.tpp.getPolicy(request, this.getAuthKey());
                }

                @Override
                Response clearPolicyAttribute(ClearPolicyAttributeRequest request) throws VCertException {
                    return this.tpp.clearPolicyAttribute(request, this.getAuthKey());
                }
            };
        }
        return this.tppAPI;
    }

    public String apiKey() {
        return this.apiKey;
    }
}

