/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.connectors.tpp.TppAPI;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ClearPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.KeyPairResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.PolicyResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SubjectResponse;
import com.venafi.vcert.sdk.policy.api.domain.TPPPolicy;
import com.venafi.vcert.sdk.policy.converter.tpp.AltName;
import feign.Response;
import java.util.ArrayList;

public class TppConnectorUtils {
    public static boolean dnExist(String dn, TppAPI tppAPI) throws VCertException {
        try {
            DNIsValidResponse dnIsValidResponse = tppAPI.dnIsValid(new DNIsValidRequest(dn));
            if (dnIsValidResponse.result() == 1 && dnIsValidResponse.objectDN().dn() != null) {
                return true;
            }
            if (dnIsValidResponse.error() != null && dnIsValidResponse.result() == 400) {
                return false;
            }
            throw new VCertException(dnIsValidResponse.error());
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    public static void createPolicy(String dn, TppAPI tppAPI) throws VCertException {
        try {
            CreateDNResponse createDNResponse = tppAPI.createDN(new CreateDNRequest(dn));
            if (createDNResponse.error() != null) {
                throw new VCertException(createDNResponse.error());
            }
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    public static void resetAttributes(String policyName, TppAPI tppAPI) throws VCertException {
        TppConnectorUtils.clearPolicyAttribute(policyName, "Contact", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Approver", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Domain Suffix Whitelist", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Prohibit Wildcard", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Certificate Authority", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Management Type", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Organization", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Organizational Unit", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "City", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "State", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Country", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Key Algorithm", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Key Bit Strength", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Elliptic Curve", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Manual Csr", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Prohibited SAN Types", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Allow Private Key Reuse", tppAPI);
        TppConnectorUtils.clearPolicyAttribute(policyName, "Want Renewal", tppAPI);
    }

    public static void setPolicyAttributes(TPPPolicy tppPolicy, TppAPI tppAPI) throws VCertException {
        if (tppPolicy.contact() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Contact", tppPolicy.contact(), true, tppAPI);
        }
        if (tppPolicy.approver() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Approver", tppPolicy.approver(), true, tppAPI);
        }
        if (tppPolicy.domainSuffixWhiteList() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Domain Suffix Whitelist", tppPolicy.domainSuffixWhiteList(), true, tppAPI);
        }
        if (tppPolicy.prohibitWildcard() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Prohibit Wildcard", new Integer[]{tppPolicy.prohibitWildcard()}, false, tppAPI);
        }
        if (tppPolicy.certificateAuthority() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Certificate Authority", new String[]{tppPolicy.certificateAuthority()}, false, tppAPI);
        }
        if (tppPolicy.managementType() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Management Type", tppPolicy.managementType().values(), tppPolicy.managementType().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Management Type", tppAPI);
        }
        if (tppPolicy.organization() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Organization", tppPolicy.organization().values(), tppPolicy.organization().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Organization", tppAPI);
        }
        if (tppPolicy.organizationalUnit() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Organizational Unit", tppPolicy.organizationalUnit().values(), tppPolicy.organizationalUnit().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Organizational Unit", tppAPI);
        }
        if (tppPolicy.city() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "City", tppPolicy.city().values(), tppPolicy.city().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "City", tppAPI);
        }
        if (tppPolicy.state() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "State", tppPolicy.state().values(), tppPolicy.state().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "State", tppAPI);
        }
        if (tppPolicy.country() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Country", tppPolicy.country().values(), tppPolicy.country().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Country", tppAPI);
        }
        if (tppPolicy.keyAlgorithm() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Key Algorithm", tppPolicy.keyAlgorithm().values(), tppPolicy.keyAlgorithm().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Key Algorithm", tppAPI);
        }
        if (tppPolicy.keyBitStrength() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Key Bit Strength", tppPolicy.keyBitStrength().values(), tppPolicy.keyBitStrength().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Key Bit Strength", tppAPI);
        }
        if (tppPolicy.ellipticCurve() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Elliptic Curve", tppPolicy.ellipticCurve().values(), tppPolicy.ellipticCurve().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Elliptic Curve", tppAPI);
        }
        if (tppPolicy.manualCsr() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Manual Csr", tppPolicy.manualCsr().values(), tppPolicy.manualCsr().lock(), tppAPI);
        } else {
            TppConnectorUtils.clearPolicyAttribute(tppPolicy.policyName(), "Manual Csr", tppAPI);
        }
        if (tppPolicy.prohibitedSANTypes() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Prohibited SAN Types", tppPolicy.prohibitedSANTypes(), false, tppAPI);
        }
        if (tppPolicy.allowPrivateKeyReuse() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Allow Private Key Reuse", tppPolicy.allowPrivateKeyReuse().values(), tppPolicy.allowPrivateKeyReuse().lock(), tppAPI);
        }
        if (tppPolicy.wantRenewal() != null) {
            TppConnectorUtils.setPolicyAttribute(tppPolicy.policyName(), "Want Renewal", tppPolicy.wantRenewal().values(), tppPolicy.wantRenewal().lock(), tppAPI);
        }
    }

    public static void setPolicyAttribute(String dn, String attributeName, Object[] values, boolean locked, TppAPI tppAPI) throws VCertException {
        try {
            SetPolicyAttributeResponse setPolicyAttributeResponse = tppAPI.setPolicyAttribute(new SetPolicyAttributeRequest(dn, attributeName, values, locked));
            if (setPolicyAttributeResponse.result() != 1) {
                throw new VCertException(setPolicyAttributeResponse.error());
            }
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    public static void clearPolicyAttribute(String dn, String attributeName, TppAPI tppAPI) throws VCertException {
        try {
            Response clearPolicyAttributeResponse = tppAPI.clearPolicyAttribute(new ClearPolicyAttributeRequest(dn, attributeName));
            if (clearPolicyAttributeResponse.status() != 200) {
                throw new VCertException("It was no possible to reset the attribute " + attributeName);
            }
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    public static TPPPolicy populatePolicy(TPPPolicy tppPolicy, TppAPI tppAPI) throws VCertException {
        GetPolicyResponse getPolicyResponse;
        try {
            getPolicyResponse = tppAPI.getPolicy(new GetPolicyRequest(tppPolicy.policyName()));
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        if (getPolicyResponse != null && getPolicyResponse.error() != null) {
            throw new VCertException(getPolicyResponse.error());
        }
        PolicyResponse policyResponse = getPolicyResponse.policy();
        if (policyResponse != null) {
            KeyPairResponse keyPairResponse;
            SubjectResponse subjectResponse;
            tppPolicy.domainSuffixWhiteList(policyResponse.whitelistedDomains());
            tppPolicy.prohibitWildcard(policyResponse.wildcardsAllowed() != false ? 0 : 1);
            tppPolicy.certificateAuthority(policyResponse.certificateAuthority() != null ? policyResponse.certificateAuthority().value() : null);
            if (policyResponse.managementType() != null) {
                tppPolicy.managementType(policyResponse.managementType().value(), policyResponse.managementType().locked());
            }
            if ((subjectResponse = policyResponse.subject()) != null) {
                if (subjectResponse.organization() != null) {
                    tppPolicy.organization(subjectResponse.organization().value(), subjectResponse.organization().locked());
                }
                if (subjectResponse.organizationalUnit() != null) {
                    tppPolicy.organizationalUnit(subjectResponse.organizationalUnit().values(), subjectResponse.organizationalUnit().locked());
                }
                if (subjectResponse.city() != null) {
                    tppPolicy.city(subjectResponse.city().value(), subjectResponse.city().locked());
                }
                if (subjectResponse.state() != null) {
                    tppPolicy.state(subjectResponse.state().value(), subjectResponse.state().locked());
                }
                if (subjectResponse.country() != null) {
                    tppPolicy.country(subjectResponse.country().value(), subjectResponse.country().locked());
                }
            }
            if ((keyPairResponse = policyResponse.keyPair()) != null) {
                if (keyPairResponse.keyAlgorithm() != null) {
                    tppPolicy.keyAlgorithm(keyPairResponse.keyAlgorithm().value(), keyPairResponse.keyAlgorithm().locked());
                }
                if (keyPairResponse.keySize() != null) {
                    tppPolicy.keyBitStrength(keyPairResponse.keySize().value().toString(), keyPairResponse.keySize().locked());
                }
                if (keyPairResponse.ellipticCurve() != null) {
                    tppPolicy.ellipticCurve(keyPairResponse.ellipticCurve().value(), keyPairResponse.ellipticCurve().locked());
                }
            }
            if (policyResponse.csrGeneration() != null) {
                if (policyResponse.csrGeneration().value().equals("ServiceGenerated")) {
                    tppPolicy.manualCsr("0", policyResponse.csrGeneration().locked());
                } else if (policyResponse.csrGeneration().value().equals("UserProvided")) {
                    tppPolicy.manualCsr("1", policyResponse.csrGeneration().locked());
                }
            }
            tppPolicy.allowPrivateKeyReuse(policyResponse.privateKeyReuseAllowed() != false ? "1" : "0", true);
            tppPolicy.wantRenewal(policyResponse.privateKeyReuseAllowed() != false ? "1" : "0", true);
            TppConnectorUtils.setProhibitedSANTypes(tppPolicy, policyResponse);
        }
        return tppPolicy;
    }

    public static void setProhibitedSANTypes(TPPPolicy tppPolicy, PolicyResponse policyResponse) {
        ArrayList<String> prohibitedSANTypes = new ArrayList<String>();
        if (policyResponse.subjAltNameDnsAllowed().booleanValue()) {
            prohibitedSANTypes.add(AltName.DNS.value);
        }
        if (policyResponse.subjAltNameIpAllowed().booleanValue()) {
            prohibitedSANTypes.add(AltName.IP.value);
        }
        if (policyResponse.subjAltNameEmailAllowed().booleanValue()) {
            prohibitedSANTypes.add(AltName.EMAIL.value);
        }
        if (policyResponse.subjAltNameUriAllowed().booleanValue()) {
            prohibitedSANTypes.add(AltName.URI.value);
        }
        if (policyResponse.subjAltNameUpnAllowed().booleanValue()) {
            prohibitedSANTypes.add(AltName.UPN.value);
        }
        if (prohibitedSANTypes.size() > 0) {
            tppPolicy.prohibitedSANTypes(prohibitedSANTypes.toArray(new String[0]));
        }
    }
}

