/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.domain;

import java.util.Arrays;

public class KeyPair {
    private String[] keyTypes;
    private Integer[] rsaKeySizes;
    private String[] ellipticCurves;
    private Boolean serviceGenerated;
    private Boolean reuseAllowed;

    public static KeyPairBuilder builder() {
        return new KeyPairBuilder();
    }

    public String[] keyTypes() {
        return this.keyTypes;
    }

    public Integer[] rsaKeySizes() {
        return this.rsaKeySizes;
    }

    public String[] ellipticCurves() {
        return this.ellipticCurves;
    }

    public Boolean serviceGenerated() {
        return this.serviceGenerated;
    }

    public Boolean reuseAllowed() {
        return this.reuseAllowed;
    }

    public KeyPair keyTypes(String[] keyTypes) {
        this.keyTypes = keyTypes;
        return this;
    }

    public KeyPair rsaKeySizes(Integer[] rsaKeySizes) {
        this.rsaKeySizes = rsaKeySizes;
        return this;
    }

    public KeyPair ellipticCurves(String[] ellipticCurves) {
        this.ellipticCurves = ellipticCurves;
        return this;
    }

    public KeyPair serviceGenerated(Boolean serviceGenerated) {
        this.serviceGenerated = serviceGenerated;
        return this;
    }

    public KeyPair reuseAllowed(Boolean reuseAllowed) {
        this.reuseAllowed = reuseAllowed;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.keyTypes(), other.keyTypes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.rsaKeySizes(), other.rsaKeySizes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.ellipticCurves(), other.ellipticCurves())) {
            return false;
        }
        Boolean this$serviceGenerated = this.serviceGenerated();
        Boolean other$serviceGenerated = other.serviceGenerated();
        if (this$serviceGenerated == null ? other$serviceGenerated != null : !((Object)this$serviceGenerated).equals(other$serviceGenerated)) {
            return false;
        }
        Boolean this$reuseAllowed = this.reuseAllowed();
        Boolean other$reuseAllowed = other.reuseAllowed();
        return !(this$reuseAllowed == null ? other$reuseAllowed != null : !((Object)this$reuseAllowed).equals(other$reuseAllowed));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyPair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.keyTypes());
        result = result * 59 + Arrays.deepHashCode(this.rsaKeySizes());
        result = result * 59 + Arrays.deepHashCode(this.ellipticCurves());
        Boolean $serviceGenerated = this.serviceGenerated();
        result = result * 59 + ($serviceGenerated == null ? 43 : ((Object)$serviceGenerated).hashCode());
        Boolean $reuseAllowed = this.reuseAllowed();
        result = result * 59 + ($reuseAllowed == null ? 43 : ((Object)$reuseAllowed).hashCode());
        return result;
    }

    public String toString() {
        return "KeyPair(keyTypes=" + Arrays.deepToString(this.keyTypes()) + ", rsaKeySizes=" + Arrays.deepToString(this.rsaKeySizes()) + ", ellipticCurves=" + Arrays.deepToString(this.ellipticCurves()) + ", serviceGenerated=" + this.serviceGenerated() + ", reuseAllowed=" + this.reuseAllowed() + ")";
    }

    public KeyPair(String[] keyTypes, Integer[] rsaKeySizes, String[] ellipticCurves, Boolean serviceGenerated, Boolean reuseAllowed) {
        this.keyTypes = keyTypes;
        this.rsaKeySizes = rsaKeySizes;
        this.ellipticCurves = ellipticCurves;
        this.serviceGenerated = serviceGenerated;
        this.reuseAllowed = reuseAllowed;
    }

    public KeyPair() {
    }

    public static class KeyPairBuilder {
        private String[] keyTypes;
        private Integer[] rsaKeySizes;
        private String[] ellipticCurves;
        private Boolean serviceGenerated;
        private Boolean reuseAllowed;

        KeyPairBuilder() {
        }

        public KeyPairBuilder keyTypes(String[] keyTypes) {
            this.keyTypes = keyTypes;
            return this;
        }

        public KeyPairBuilder rsaKeySizes(Integer[] rsaKeySizes) {
            this.rsaKeySizes = rsaKeySizes;
            return this;
        }

        public KeyPairBuilder ellipticCurves(String[] ellipticCurves) {
            this.ellipticCurves = ellipticCurves;
            return this;
        }

        public KeyPairBuilder serviceGenerated(Boolean serviceGenerated) {
            this.serviceGenerated = serviceGenerated;
            return this;
        }

        public KeyPairBuilder reuseAllowed(Boolean reuseAllowed) {
            this.reuseAllowed = reuseAllowed;
            return this;
        }

        public KeyPair build() {
            return new KeyPair(this.keyTypes, this.rsaKeySizes, this.ellipticCurves, this.serviceGenerated, this.reuseAllowed);
        }

        public String toString() {
            return "KeyPair.KeyPairBuilder(keyTypes=" + Arrays.deepToString(this.keyTypes) + ", rsaKeySizes=" + Arrays.deepToString(this.rsaKeySizes) + ", ellipticCurves=" + Arrays.deepToString(this.ellipticCurves) + ", serviceGenerated=" + this.serviceGenerated + ", reuseAllowed=" + this.reuseAllowed + ")";
        }
    }
}

