/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.certificate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum EllipticCurve {
    EllipticCurveP224("P224", "P-224"),
    EllipticCurveP256("P256", "P-256"),
    EllipticCurveP384("P384", "P-384"),
    EllipticCurveP521("P521", "P-521");

    private final String value;
    private final String bcName;
    private static Map<String, EllipticCurve> LOOKUP;

    private EllipticCurve(String value, String bcName) {
        this.value = value;
        this.bcName = bcName;
    }

    public static EllipticCurve from(String value) {
        if (LOOKUP.containsKey(value.toLowerCase())) {
            return LOOKUP.get(value.toLowerCase());
        }
        return EllipticCurve.ellipticCurveDefault();
    }

    public static EllipticCurve ellipticCurveDefault() {
        return EllipticCurveP521;
    }

    public static List<EllipticCurve> allSupportedCures() {
        return Arrays.asList(EllipticCurve.values());
    }

    public String value() {
        return this.value;
    }

    public String bcName() {
        return this.bcName;
    }

    static {
        LOOKUP = new HashMap<String, EllipticCurve>(EllipticCurve.values().length);
        for (EllipticCurve curve : EllipticCurve.values()) {
            LOOKUP.put(curve.value().toLowerCase(), curve);
        }
    }
}

