/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.cloud;

import com.venafi.vcert.sdk.Config;
import com.venafi.vcert.sdk.certificate.CertificateStatus;
import com.venafi.vcert.sdk.connectors.cloud.CloudConnector;
import com.venafi.vcert.sdk.connectors.cloud.domain.Application;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateDetails;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import com.venafi.vcert.sdk.connectors.cloud.domain.UserDetails;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.ApplicationsList;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CAAccount;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CAAccountsList;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CITsList;
import com.venafi.vcert.sdk.utils.FeignUtils;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public interface Cloud {
    @Headers(value={"tppl-api-key: {apiKey}"})
    @RequestLine(value="GET v1/useraccounts")
    public UserDetails authorize(@Param(value="apiKey") String var1);

    @Headers(value={"tppl-api-key: {apiKey}"})
    @RequestLine(value="GET /outagedetection/v1/applications/{appName}/certificateissuingtemplates/{citAlias}")
    public CertificateIssuingTemplate certificateIssuingTemplateByAppNameAndCitAlias(@Param(value="appName") String var1, @Param(value="citAlias") String var2, @Param(value="apiKey") String var3);

    @Headers(value={"tppl-api-key: {apiKey}"})
    @RequestLine(value="GET /outagedetection/v1/applications/name/{appName}")
    public Application applicationByName(@Param(value="appName") String var1, @Param(value="apiKey") String var2);

    @Headers(value={"tppl-api-key: {apiKey}", "Content-Type: application/json", "Accept: application/json"})
    @RequestLine(value="POST /outagedetection/v1/certificatesearch")
    public CertificateSearchResponse searchCertificates(@Param(value="apiKey") String var1, SearchRequest var2);

    @Headers(value={"tppl-api-key: {apiKey}", "Content-Type: application/json"})
    @RequestLine(value="POST  /outagedetection/v1/certificaterequests")
    public CloudConnector.CertificateRequestsResponse certificateRequest(@Param(value="apiKey") String var1, CloudConnector.CertificateRequestsPayload var2);

    @Headers(value={"tppl-api-key: {apiKey}"})
    @RequestLine(value="GET  /outagedetection/v1/certificaterequests/{id}")
    public CertificateStatus certificateStatus(@Param(value="id") String var1, @Param(value="apiKey") String var2);

    @Headers(value={"tppl-api-key: {apiKey}"})
    @RequestLine(value="GET /outagedetection/v1/certificates/{id}/contents?chainOrder={chainOrder}&format=PEM")
    public Response certificateViaCSR(@Param(value="id") String var1, @Param(value="apiKey") String var2, @Param(value="chainOrder") String var3);

    @Headers(value={"tppl-api-key: {apiKey}"})
    @RequestLine(value="GET /outagedetection/v1/certificates/{id}/contents")
    public Response certificateAsPem(@Param(value="id") String var1, @Param(value="apiKey") String var2);

    @Headers(value={"tppl-api-key: {apiKey}"})
    @RequestLine(value="GET /outagedetection/v1/certificates/{id}")
    public CertificateDetails certificateDetails(@Param(value="id") String var1, @Param(value="apiKey") String var2);

    @RequestLine(value="GET ping")
    @Headers(value={"x-venafi-api-key: {apiKey}"})
    public Response ping(@Param(value="apiKey") String var1);

    @RequestLine(value="GET /v1/certificateauthorities/{CA}/accounts")
    @Headers(value={"tppl-api-key: {apiKey}"})
    public CAAccountsList getCAAccounts(@Param(value="CA") String var1, @Param(value="apiKey") String var2);

    @RequestLine(value="GET /v1/certificateauthorities/{CA}/accounts/{id}")
    @Headers(value={"tppl-api-key: {apiKey}"})
    public CAAccount getCAAccount(@Param(value="CA") String var1, @Param(value="id") String var2, @Param(value="apiKey") String var3);

    @RequestLine(value="GET /v1/certificateissuingtemplates")
    @Headers(value={"tppl-api-key: {apiKey}"})
    public CITsList getCITs(@Param(value="apiKey") String var1);

    @RequestLine(value="POST /v1/certificateissuingtemplates")
    @Headers(value={"tppl-api-key: {apiKey}", "Content-Type: application/json"})
    public CITsList createCIT(CertificateIssuingTemplate var1, @Param(value="apiKey") String var2);

    @RequestLine(value="PUT /v1/certificateissuingtemplates/{id}")
    @Headers(value={"tppl-api-key: {apiKey}", "Content-Type: application/json"})
    public CertificateIssuingTemplate updateCIT(CertificateIssuingTemplate var1, @Param(value="id") String var2, @Param(value="apiKey") String var3);

    @Headers(value={"tppl-api-key: {apiKey}", "Content-Type: application/json"})
    @RequestLine(value="POST /outagedetection/v1/applications")
    public ApplicationsList createApplication(Application var1, @Param(value="apiKey") String var2);

    @Headers(value={"tppl-api-key: {apiKey}", "Content-Type: application/json"})
    @RequestLine(value="PUT /outagedetection/v1/applications/{id}")
    public Application updateApplication(Application var1, @Param(value="id") String var2, @Param(value="apiKey") String var3);

    public static Cloud connect(String baseUrl) {
        return FeignUtils.client(Cloud.class, Config.builder().baseUrl(Cloud.normalizeUrl(StringUtils.isNotBlank((CharSequence)baseUrl) ? baseUrl : "https://api.venafi.cloud")).build());
    }

    public static Cloud connect(Config config) {
        config.baseUrl(Cloud.normalizeUrl(StringUtils.isNotBlank((CharSequence)config.baseUrl()) ? config.baseUrl() : "https://api.venafi.cloud"));
        return FeignUtils.client(Cloud.class, config);
    }

    public static String normalizeUrl(String url) {
        url = url.toLowerCase();
        Pattern patternProtocol = Pattern.compile("^http(|s)://");
        Matcher matcherProtocol = patternProtocol.matcher(url);
        if (!matcherProtocol.find()) {
            url = "https://" + url;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static class Certificate {
        private String id;
        private String managedCertificateId;
        private String certificateRequestId;
        private List<String> subjectCN;

        public String id() {
            return this.id;
        }

        public String managedCertificateId() {
            return this.managedCertificateId;
        }

        public String certificateRequestId() {
            return this.certificateRequestId;
        }

        public List<String> subjectCN() {
            return this.subjectCN;
        }

        public Certificate id(String id) {
            this.id = id;
            return this;
        }

        public Certificate managedCertificateId(String managedCertificateId) {
            this.managedCertificateId = managedCertificateId;
            return this;
        }

        public Certificate certificateRequestId(String certificateRequestId) {
            this.certificateRequestId = certificateRequestId;
            return this;
        }

        public Certificate subjectCN(List<String> subjectCN) {
            this.subjectCN = subjectCN;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Certificate)) {
                return false;
            }
            Certificate other = (Certificate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$managedCertificateId = this.managedCertificateId();
            String other$managedCertificateId = other.managedCertificateId();
            if (this$managedCertificateId == null ? other$managedCertificateId != null : !this$managedCertificateId.equals(other$managedCertificateId)) {
                return false;
            }
            String this$certificateRequestId = this.certificateRequestId();
            String other$certificateRequestId = other.certificateRequestId();
            if (this$certificateRequestId == null ? other$certificateRequestId != null : !this$certificateRequestId.equals(other$certificateRequestId)) {
                return false;
            }
            List<String> this$subjectCN = this.subjectCN();
            List<String> other$subjectCN = other.subjectCN();
            return !(this$subjectCN == null ? other$subjectCN != null : !((Object)this$subjectCN).equals(other$subjectCN));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Certificate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $managedCertificateId = this.managedCertificateId();
            result = result * 59 + ($managedCertificateId == null ? 43 : $managedCertificateId.hashCode());
            String $certificateRequestId = this.certificateRequestId();
            result = result * 59 + ($certificateRequestId == null ? 43 : $certificateRequestId.hashCode());
            List<String> $subjectCN = this.subjectCN();
            result = result * 59 + ($subjectCN == null ? 43 : ((Object)$subjectCN).hashCode());
            return result;
        }

        public String toString() {
            return "Cloud.Certificate(id=" + this.id() + ", managedCertificateId=" + this.managedCertificateId() + ", certificateRequestId=" + this.certificateRequestId() + ", subjectCN=" + this.subjectCN() + ")";
        }
    }

    public static class CertificateSearchResponse {
        private Integer count;
        private List<Certificate> certificates;

        public Integer count() {
            return this.count;
        }

        public List<Certificate> certificates() {
            return this.certificates;
        }

        public CertificateSearchResponse count(Integer count) {
            this.count = count;
            return this;
        }

        public CertificateSearchResponse certificates(List<Certificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateSearchResponse)) {
                return false;
            }
            CertificateSearchResponse other = (CertificateSearchResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$count = this.count();
            Integer other$count = other.count();
            if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                return false;
            }
            List<Certificate> this$certificates = this.certificates();
            List<Certificate> other$certificates = other.certificates();
            return !(this$certificates == null ? other$certificates != null : !((Object)this$certificates).equals(other$certificates));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateSearchResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $count = this.count();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            List<Certificate> $certificates = this.certificates();
            result = result * 59 + ($certificates == null ? 43 : ((Object)$certificates).hashCode());
            return result;
        }

        public String toString() {
            return "Cloud.CertificateSearchResponse(count=" + this.count() + ", certificates=" + this.certificates() + ")";
        }
    }

    public static class Paging {
        private Integer pageNumber;
        private Integer pageSize;

        public Integer pageNumber() {
            return this.pageNumber;
        }

        public Integer pageSize() {
            return this.pageSize;
        }

        public Paging pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public Paging pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paging)) {
                return false;
            }
            Paging other = (Paging)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$pageNumber = this.pageNumber();
            Integer other$pageNumber = other.pageNumber();
            if (this$pageNumber == null ? other$pageNumber != null : !((Object)this$pageNumber).equals(other$pageNumber)) {
                return false;
            }
            Integer this$pageSize = this.pageSize();
            Integer other$pageSize = other.pageSize();
            return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Paging;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $pageNumber = this.pageNumber();
            result = result * 59 + ($pageNumber == null ? 43 : ((Object)$pageNumber).hashCode());
            Integer $pageSize = this.pageSize();
            result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
            return result;
        }

        public String toString() {
            return "Cloud.Paging(pageNumber=" + this.pageNumber() + ", pageSize=" + this.pageSize() + ")";
        }
    }

    public static class Operand {
        private String field;
        private String operator;
        private Object value;

        public String field() {
            return this.field;
        }

        public String operator() {
            return this.operator;
        }

        public Object value() {
            return this.value;
        }

        public Operand field(String field) {
            this.field = field;
            return this;
        }

        public Operand operator(String operator) {
            this.operator = operator;
            return this;
        }

        public Operand value(Object value) {
            this.value = value;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Operand)) {
                return false;
            }
            Operand other = (Operand)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field = this.field();
            String other$field = other.field();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$operator = this.operator();
            String other$operator = other.operator();
            if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                return false;
            }
            Object this$value = this.value();
            Object other$value = other.value();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Operand;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field = this.field();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $operator = this.operator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            Object $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Cloud.Operand(field=" + this.field() + ", operator=" + this.operator() + ", value=" + this.value() + ")";
        }

        public Operand() {
        }

        public Operand(String field, String operator, Object value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }
    }

    public static class Expression {
        private List<Operand> operands;

        public List<Operand> operands() {
            return this.operands;
        }

        public Expression operands(List<Operand> operands) {
            this.operands = operands;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Expression)) {
                return false;
            }
            Expression other = (Expression)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Operand> this$operands = this.operands();
            List<Operand> other$operands = other.operands();
            return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Expression;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Operand> $operands = this.operands();
            result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
            return result;
        }

        public String toString() {
            return "Cloud.Expression(operands=" + this.operands() + ")";
        }

        public Expression(List<Operand> operands) {
            this.operands = operands;
        }
    }

    public static class SearchRequest {
        private Expression expression;
        private Object ordering;
        private Paging paging;

        SearchRequest(Expression expression) {
            this.expression = expression;
        }

        static SearchRequest findByFingerPrint(String fingerprint) {
            return new SearchRequest(new Expression(Collections.singletonList(new Operand("fingerprint", "MATCH", fingerprint))));
        }

        public Expression expression() {
            return this.expression;
        }

        public Object ordering() {
            return this.ordering;
        }

        public Paging paging() {
            return this.paging;
        }

        public SearchRequest expression(Expression expression) {
            this.expression = expression;
            return this;
        }

        public SearchRequest ordering(Object ordering) {
            this.ordering = ordering;
            return this;
        }

        public SearchRequest paging(Paging paging) {
            this.paging = paging;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchRequest)) {
                return false;
            }
            SearchRequest other = (SearchRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expression this$expression = this.expression();
            Expression other$expression = other.expression();
            if (this$expression == null ? other$expression != null : !((Object)this$expression).equals(other$expression)) {
                return false;
            }
            Object this$ordering = this.ordering();
            Object other$ordering = other.ordering();
            if (this$ordering == null ? other$ordering != null : !this$ordering.equals(other$ordering)) {
                return false;
            }
            Paging this$paging = this.paging();
            Paging other$paging = other.paging();
            return !(this$paging == null ? other$paging != null : !((Object)this$paging).equals(other$paging));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $expression = this.expression();
            result = result * 59 + ($expression == null ? 43 : ((Object)$expression).hashCode());
            Object $ordering = this.ordering();
            result = result * 59 + ($ordering == null ? 43 : $ordering.hashCode());
            Paging $paging = this.paging();
            result = result * 59 + ($paging == null ? 43 : ((Object)$paging).hashCode());
            return result;
        }

        public String toString() {
            return "Cloud.SearchRequest(expression=" + this.expression() + ", ordering=" + this.ordering() + ", paging=" + this.paging() + ")";
        }

        public SearchRequest() {
        }
    }
}

