/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.annotations.SerializedName;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.SshCaTemplateRequest;
import com.venafi.vcert.sdk.certificate.SshCertRetrieveDetails;
import com.venafi.vcert.sdk.certificate.SshCertificateRequest;
import com.venafi.vcert.sdk.certificate.SshConfig;
import com.venafi.vcert.sdk.connectors.ConnectorException;
import com.venafi.vcert.sdk.connectors.ServerPolicy;
import com.venafi.vcert.sdk.connectors.tpp.CustomFieldRequest;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.TppAPI;
import com.venafi.vcert.sdk.connectors.tpp.TppConnectorUtils;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequestResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveResponse;
import com.venafi.vcert.sdk.policy.api.domain.TPPPolicy;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTppConnector {
    protected static final String HEADER_VALUE_AUTHORIZATION = "Bearer %s";
    protected static final String FAILED_TO_AUTHENTICATE_MESSAGE = "failed to authenticate: ";
    protected static final String MISSING_CREDENTIALS_MESSAGE = "failed to authenticate: missing credentials";
    protected static final String MISSING_REFRESH_TOKEN_MESSAGE = "failed to authenticate: missing refresh token";
    protected static final String MISSING_ACCESS_TOKEN_MESSAGE = "failed to authenticate: missing access token";
    protected static final String TPP_ATTRIBUTE_MANAGEMENT_TYPE = "Management Type";
    protected static final String TPP_ATTRIBUTE_MANUAL_CSR = "Manual Csr";
    protected static final Map<String, Integer> revocationReasons = new HashMap<String, Integer>(){
        {
            this.put("", 0);
            this.put("none", 0);
            this.put("key-compromise", 1);
            this.put("ca-compromise", 2);
            this.put("affiliation-changed", 3);
            this.put("superseded", 4);
            this.put("cessation-of-operation", 5);
        }
    };
    protected final Tpp tpp;
    protected String zone;
    protected String vendorAndProductName;
    protected TppAPI tppAPI;

    public AbstractTppConnector(Tpp tpp) {
        this.tpp = tpp;
        this.tppAPI = this.getTppAPI();
    }

    protected abstract TppAPI getTppAPI();

    @VisibleForTesting
    String getPolicyDN(String zone) {
        String result = zone;
        result = result.startsWith("\\") ? result : "\\" + result;
        result = result.startsWith("\\VED\\Policy") ? result : "\\VED\\Policy" + result;
        return result;
    }

    public void setPolicy(String policyName, TPPPolicy tppPolicy) throws VCertException {
        if (!policyName.startsWith("\\VED\\Policy\\")) {
            policyName = "\\VED\\Policy\\" + policyName;
        }
        tppPolicy.policyName(policyName);
        if (!TppConnectorUtils.dnExist(policyName, this.tppAPI)) {
            String parentName = tppPolicy.getParentName();
            if (!parentName.equals("\\VED\\Policy\\") && !TppConnectorUtils.dnExist(parentName, this.tppAPI)) {
                throw new VCertException(String.format("The policy's parent %s doesn't exist", parentName));
            }
            TppConnectorUtils.createPolicy(policyName, this.tppAPI);
        } else {
            TppConnectorUtils.resetAttributes(policyName, this.tppAPI);
        }
        TppConnectorUtils.setPolicyAttributes(tppPolicy, this.tppAPI);
    }

    public TPPPolicy getTPPPolicy(String policyName) throws VCertException {
        TPPPolicy tppPolicy = new TPPPolicy();
        if (!policyName.startsWith("\\VED\\Policy\\")) {
            policyName = "\\VED\\Policy\\" + policyName;
        }
        tppPolicy.policyName(policyName);
        TppConnectorUtils.populatePolicy(tppPolicy, this.tppAPI);
        return tppPolicy;
    }

    protected TppSshCertRequestResponse requestTppSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        TppSshCertRequestResponse requestResponse;
        TppSshCertRequest tppSshCertRequest = TppConnectorUtils.convertToTppSshCertReq(sshCertificateRequest);
        try {
            requestResponse = this.tppAPI.requestSshCertificate(tppSshCertRequest);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        if (!requestResponse.response().success()) {
            throw new ConnectorException.RequestCertificateException(requestResponse.response().errorCode(), requestResponse.response().errorMessage());
        }
        return requestResponse;
    }

    protected SshCertRetrieveDetails retrieveTppSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        TppSshCertRetrieveResponse tppSshCertRetrieveResponse = null;
        TppSshCertRetrieveRequest tppSshCertRetrieveRequest = TppConnectorUtils.convertToTppSshCertRetReq(sshCertificateRequest);
        Instant startTime = Instant.now();
        while (!StringUtils.isNotBlank((CharSequence)(tppSshCertRetrieveResponse = this.tppAPI.retrieveSshCertificate(tppSshCertRetrieveRequest)).certificateData())) {
            if (tppSshCertRetrieveResponse.response().success() && tppSshCertRetrieveResponse.processingDetails().status().equals("Rejected")) {
                throw new ConnectorException.CertificateRejectedException(sshCertificateRequest.pickupID(), tppSshCertRetrieveResponse.processingDetails().statusDescription());
            }
            if (Duration.ZERO.equals(sshCertificateRequest.timeout())) {
                throw new ConnectorException.CertificatePendingException(sshCertificateRequest.pickupID(), tppSshCertRetrieveResponse.processingDetails().statusDescription());
            }
            if (Instant.now().isAfter(startTime.plus(sshCertificateRequest.timeout()))) {
                throw new ConnectorException.RetrieveCertificateTimeoutException(sshCertificateRequest.pickupID());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new ConnectorException.AttemptToRetryException(e);
            }
        }
        return TppConnectorUtils.convertToSshCertRetrieveDetails(tppSshCertRetrieveResponse);
    }

    protected SshConfig retrieveTppSshConfig(SshCaTemplateRequest sshCaTemplateRequest) throws VCertException {
        SshConfig sshConfig = new SshConfig();
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.template())) {
            params.put("DN", TppConnectorUtils.getSshCADN(sshCaTemplateRequest.template()));
        } else if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.guid())) {
            params.put("Guid", sshCaTemplateRequest.guid());
        } else {
            throw new ConnectorException.CAOrGUIDNotProvidedException();
        }
        sshConfig.caPublicKey(this.tppAPI.retrieveSshCAPublicKeyData(params));
        sshConfig.principals(this.retrieveTppSshPrincipals(sshCaTemplateRequest));
        return sshConfig;
    }

    private String[] retrieveTppSshPrincipals(SshCaTemplateRequest sshCaTemplateRequest) throws VCertException {
        try {
            this.tppAPI.getAuthKey();
        }
        catch (VCertException e) {
            return null;
        }
        TppSshCaTemplateRequest request = new TppSshCaTemplateRequest();
        if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.template())) {
            request.dn(TppConnectorUtils.getSshCADN(sshCaTemplateRequest.template()));
        } else if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.guid())) {
            request.guid(sshCaTemplateRequest.guid());
        } else {
            throw new ConnectorException.CAOrGUIDNotProvidedException();
        }
        return this.tppAPI.retrieveSshCATemplate(request).accessControl().defaultPrincipals();
    }

    public String zone() {
        return this.zone;
    }

    public class CertificateRenewalRequest {
        private String certificateDN;
        private String PKCS10;

        public String certificateDN() {
            return this.certificateDN;
        }

        public String PKCS10() {
            return this.PKCS10;
        }

        public CertificateRenewalRequest certificateDN(String certificateDN) {
            this.certificateDN = certificateDN;
            return this;
        }

        public CertificateRenewalRequest PKCS10(String PKCS10) {
            this.PKCS10 = PKCS10;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRenewalRequest)) {
                return false;
            }
            CertificateRenewalRequest other = (CertificateRenewalRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateDN = this.certificateDN();
            String other$certificateDN = other.certificateDN();
            if (this$certificateDN == null ? other$certificateDN != null : !this$certificateDN.equals(other$certificateDN)) {
                return false;
            }
            String this$PKCS10 = this.PKCS10();
            String other$PKCS10 = other.PKCS10();
            return !(this$PKCS10 == null ? other$PKCS10 != null : !this$PKCS10.equals(other$PKCS10));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRenewalRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateDN = this.certificateDN();
            result = result * 59 + ($certificateDN == null ? 43 : $certificateDN.hashCode());
            String $PKCS10 = this.PKCS10();
            result = result * 59 + ($PKCS10 == null ? 43 : $PKCS10.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.CertificateRenewalRequest(certificateDN=" + this.certificateDN() + ", PKCS10=" + this.PKCS10() + ")";
        }
    }

    public class CertificateRevokeRequest {
        private String certificateDN;
        private String thumbprint;
        private Integer reason;
        private String comments;
        private boolean disable;

        public String certificateDN() {
            return this.certificateDN;
        }

        public String thumbprint() {
            return this.thumbprint;
        }

        public Integer reason() {
            return this.reason;
        }

        public String comments() {
            return this.comments;
        }

        public boolean disable() {
            return this.disable;
        }

        public CertificateRevokeRequest certificateDN(String certificateDN) {
            this.certificateDN = certificateDN;
            return this;
        }

        public CertificateRevokeRequest thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public CertificateRevokeRequest reason(Integer reason) {
            this.reason = reason;
            return this;
        }

        public CertificateRevokeRequest comments(String comments) {
            this.comments = comments;
            return this;
        }

        public CertificateRevokeRequest disable(boolean disable) {
            this.disable = disable;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRevokeRequest)) {
                return false;
            }
            CertificateRevokeRequest other = (CertificateRevokeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateDN = this.certificateDN();
            String other$certificateDN = other.certificateDN();
            if (this$certificateDN == null ? other$certificateDN != null : !this$certificateDN.equals(other$certificateDN)) {
                return false;
            }
            String this$thumbprint = this.thumbprint();
            String other$thumbprint = other.thumbprint();
            if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
                return false;
            }
            Integer this$reason = this.reason();
            Integer other$reason = other.reason();
            if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
                return false;
            }
            String this$comments = this.comments();
            String other$comments = other.comments();
            if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
                return false;
            }
            return this.disable() == other.disable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRevokeRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateDN = this.certificateDN();
            result = result * 59 + ($certificateDN == null ? 43 : $certificateDN.hashCode());
            String $thumbprint = this.thumbprint();
            result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
            Integer $reason = this.reason();
            result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
            String $comments = this.comments();
            result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
            result = result * 59 + (this.disable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.CertificateRevokeRequest(certificateDN=" + this.certificateDN() + ", thumbprint=" + this.thumbprint() + ", reason=" + this.reason() + ", comments=" + this.comments() + ", disable=" + this.disable() + ")";
        }
    }

    public class CertificateRetrieveRequest {
        private String certificateDN;
        private String format;
        private String password;
        private boolean includePrivateKey;
        private boolean includeChain;
        private String friendlyName;
        private boolean rootFirstOrder;

        public String certificateDN() {
            return this.certificateDN;
        }

        public String format() {
            return this.format;
        }

        public String password() {
            return this.password;
        }

        public boolean includePrivateKey() {
            return this.includePrivateKey;
        }

        public boolean includeChain() {
            return this.includeChain;
        }

        public String friendlyName() {
            return this.friendlyName;
        }

        public boolean rootFirstOrder() {
            return this.rootFirstOrder;
        }

        public CertificateRetrieveRequest certificateDN(String certificateDN) {
            this.certificateDN = certificateDN;
            return this;
        }

        public CertificateRetrieveRequest format(String format) {
            this.format = format;
            return this;
        }

        public CertificateRetrieveRequest password(String password) {
            this.password = password;
            return this;
        }

        public CertificateRetrieveRequest includePrivateKey(boolean includePrivateKey) {
            this.includePrivateKey = includePrivateKey;
            return this;
        }

        public CertificateRetrieveRequest includeChain(boolean includeChain) {
            this.includeChain = includeChain;
            return this;
        }

        public CertificateRetrieveRequest friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public CertificateRetrieveRequest rootFirstOrder(boolean rootFirstOrder) {
            this.rootFirstOrder = rootFirstOrder;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRetrieveRequest)) {
                return false;
            }
            CertificateRetrieveRequest other = (CertificateRetrieveRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateDN = this.certificateDN();
            String other$certificateDN = other.certificateDN();
            if (this$certificateDN == null ? other$certificateDN != null : !this$certificateDN.equals(other$certificateDN)) {
                return false;
            }
            String this$format = this.format();
            String other$format = other.format();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            if (this.includePrivateKey() != other.includePrivateKey()) {
                return false;
            }
            if (this.includeChain() != other.includeChain()) {
                return false;
            }
            String this$friendlyName = this.friendlyName();
            String other$friendlyName = other.friendlyName();
            if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
                return false;
            }
            return this.rootFirstOrder() == other.rootFirstOrder();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRetrieveRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateDN = this.certificateDN();
            result = result * 59 + ($certificateDN == null ? 43 : $certificateDN.hashCode());
            String $format = this.format();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            result = result * 59 + (this.includePrivateKey() ? 79 : 97);
            result = result * 59 + (this.includeChain() ? 79 : 97);
            String $friendlyName = this.friendlyName();
            result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
            result = result * 59 + (this.rootFirstOrder() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.CertificateRetrieveRequest(certificateDN=" + this.certificateDN() + ", format=" + this.format() + ", password=" + this.password() + ", includePrivateKey=" + this.includePrivateKey() + ", includeChain=" + this.includeChain() + ", friendlyName=" + this.friendlyName() + ", rootFirstOrder=" + this.rootFirstOrder() + ")";
        }
    }

    public static class NameValuePair<K, V> {
        private K name;
        private V value;

        public K name() {
            return this.name;
        }

        public V value() {
            return this.value;
        }

        public NameValuePair<K, V> name(K name) {
            this.name = name;
            return this;
        }

        public NameValuePair<K, V> value(V value) {
            this.value = value;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameValuePair)) {
                return false;
            }
            NameValuePair other = (NameValuePair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$name = this.name();
            K other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            V this$value = this.value();
            V other$value = other.value();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NameValuePair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            V $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.NameValuePair(name=" + this.name() + ", value=" + this.value() + ")";
        }

        public NameValuePair(K name, V value) {
            this.name = name;
            this.value = value;
        }
    }

    protected static class SANItem {
        private int type;
        private String name;

        public int type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public SANItem type(int type) {
            this.type = type;
            return this;
        }

        public SANItem name(String name) {
            this.name = name;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SANItem)) {
                return false;
            }
            SANItem other = (SANItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.type() != other.type()) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SANItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.type();
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.SANItem(type=" + this.type() + ", name=" + this.name() + ")";
        }
    }

    public static class CertificateRequestsPayload {
        @SerializedName(value="PolicyDN")
        private String policyDN;
        @SerializedName(value="CADN")
        private String cadn;
        private String objectName;
        private String subject;
        private String organizationalUnit;
        private String organization;
        private String city;
        private String state;
        private String country;
        @SerializedName(value="SubjectAltNames")
        private Collection<SANItem> subjectAltNames;
        private String contact;
        @SerializedName(value="CASpecificAttributes")
        private Collection<NameValuePair<String, String>> caSpecificAttributes;
        @SerializedName(value="PKCS10")
        private String pkcs10;
        private String keyAlgorithm;
        private int keyBitSize;
        private String ellipticCurve;
        private boolean disableAutomaticRenewal;
        private String origin;
        @SerializedName(value="CustomFields")
        private ArrayList<CustomFieldRequest> customFields;

        public String policyDN() {
            return this.policyDN;
        }

        public String cadn() {
            return this.cadn;
        }

        public String objectName() {
            return this.objectName;
        }

        public String subject() {
            return this.subject;
        }

        public String organizationalUnit() {
            return this.organizationalUnit;
        }

        public String organization() {
            return this.organization;
        }

        public String city() {
            return this.city;
        }

        public String state() {
            return this.state;
        }

        public String country() {
            return this.country;
        }

        public Collection<SANItem> subjectAltNames() {
            return this.subjectAltNames;
        }

        public String contact() {
            return this.contact;
        }

        public Collection<NameValuePair<String, String>> caSpecificAttributes() {
            return this.caSpecificAttributes;
        }

        public String pkcs10() {
            return this.pkcs10;
        }

        public String keyAlgorithm() {
            return this.keyAlgorithm;
        }

        public int keyBitSize() {
            return this.keyBitSize;
        }

        public String ellipticCurve() {
            return this.ellipticCurve;
        }

        public boolean disableAutomaticRenewal() {
            return this.disableAutomaticRenewal;
        }

        public String origin() {
            return this.origin;
        }

        public ArrayList<CustomFieldRequest> customFields() {
            return this.customFields;
        }

        public CertificateRequestsPayload policyDN(String policyDN) {
            this.policyDN = policyDN;
            return this;
        }

        public CertificateRequestsPayload cadn(String cadn) {
            this.cadn = cadn;
            return this;
        }

        public CertificateRequestsPayload objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public CertificateRequestsPayload subject(String subject) {
            this.subject = subject;
            return this;
        }

        public CertificateRequestsPayload organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public CertificateRequestsPayload organization(String organization) {
            this.organization = organization;
            return this;
        }

        public CertificateRequestsPayload city(String city) {
            this.city = city;
            return this;
        }

        public CertificateRequestsPayload state(String state) {
            this.state = state;
            return this;
        }

        public CertificateRequestsPayload country(String country) {
            this.country = country;
            return this;
        }

        public CertificateRequestsPayload subjectAltNames(Collection<SANItem> subjectAltNames) {
            this.subjectAltNames = subjectAltNames;
            return this;
        }

        public CertificateRequestsPayload contact(String contact) {
            this.contact = contact;
            return this;
        }

        public CertificateRequestsPayload caSpecificAttributes(Collection<NameValuePair<String, String>> caSpecificAttributes) {
            this.caSpecificAttributes = caSpecificAttributes;
            return this;
        }

        public CertificateRequestsPayload pkcs10(String pkcs10) {
            this.pkcs10 = pkcs10;
            return this;
        }

        public CertificateRequestsPayload keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public CertificateRequestsPayload keyBitSize(int keyBitSize) {
            this.keyBitSize = keyBitSize;
            return this;
        }

        public CertificateRequestsPayload ellipticCurve(String ellipticCurve) {
            this.ellipticCurve = ellipticCurve;
            return this;
        }

        public CertificateRequestsPayload disableAutomaticRenewal(boolean disableAutomaticRenewal) {
            this.disableAutomaticRenewal = disableAutomaticRenewal;
            return this;
        }

        public CertificateRequestsPayload origin(String origin) {
            this.origin = origin;
            return this;
        }

        public CertificateRequestsPayload customFields(ArrayList<CustomFieldRequest> customFields) {
            this.customFields = customFields;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsPayload)) {
                return false;
            }
            CertificateRequestsPayload other = (CertificateRequestsPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$policyDN = this.policyDN();
            String other$policyDN = other.policyDN();
            if (this$policyDN == null ? other$policyDN != null : !this$policyDN.equals(other$policyDN)) {
                return false;
            }
            String this$cadn = this.cadn();
            String other$cadn = other.cadn();
            if (this$cadn == null ? other$cadn != null : !this$cadn.equals(other$cadn)) {
                return false;
            }
            String this$objectName = this.objectName();
            String other$objectName = other.objectName();
            if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
                return false;
            }
            String this$subject = this.subject();
            String other$subject = other.subject();
            if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
                return false;
            }
            String this$organizationalUnit = this.organizationalUnit();
            String other$organizationalUnit = other.organizationalUnit();
            if (this$organizationalUnit == null ? other$organizationalUnit != null : !this$organizationalUnit.equals(other$organizationalUnit)) {
                return false;
            }
            String this$organization = this.organization();
            String other$organization = other.organization();
            if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
                return false;
            }
            String this$city = this.city();
            String other$city = other.city();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$state = this.state();
            String other$state = other.state();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$country = this.country();
            String other$country = other.country();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            Collection<SANItem> this$subjectAltNames = this.subjectAltNames();
            Collection<SANItem> other$subjectAltNames = other.subjectAltNames();
            if (this$subjectAltNames == null ? other$subjectAltNames != null : !((Object)this$subjectAltNames).equals(other$subjectAltNames)) {
                return false;
            }
            String this$contact = this.contact();
            String other$contact = other.contact();
            if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
                return false;
            }
            Collection<NameValuePair<String, String>> this$caSpecificAttributes = this.caSpecificAttributes();
            Collection<NameValuePair<String, String>> other$caSpecificAttributes = other.caSpecificAttributes();
            if (this$caSpecificAttributes == null ? other$caSpecificAttributes != null : !((Object)this$caSpecificAttributes).equals(other$caSpecificAttributes)) {
                return false;
            }
            String this$pkcs10 = this.pkcs10();
            String other$pkcs10 = other.pkcs10();
            if (this$pkcs10 == null ? other$pkcs10 != null : !this$pkcs10.equals(other$pkcs10)) {
                return false;
            }
            String this$keyAlgorithm = this.keyAlgorithm();
            String other$keyAlgorithm = other.keyAlgorithm();
            if (this$keyAlgorithm == null ? other$keyAlgorithm != null : !this$keyAlgorithm.equals(other$keyAlgorithm)) {
                return false;
            }
            if (this.keyBitSize() != other.keyBitSize()) {
                return false;
            }
            String this$ellipticCurve = this.ellipticCurve();
            String other$ellipticCurve = other.ellipticCurve();
            if (this$ellipticCurve == null ? other$ellipticCurve != null : !this$ellipticCurve.equals(other$ellipticCurve)) {
                return false;
            }
            if (this.disableAutomaticRenewal() != other.disableAutomaticRenewal()) {
                return false;
            }
            String this$origin = this.origin();
            String other$origin = other.origin();
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            ArrayList<CustomFieldRequest> this$customFields = this.customFields();
            ArrayList<CustomFieldRequest> other$customFields = other.customFields();
            return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsPayload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $policyDN = this.policyDN();
            result = result * 59 + ($policyDN == null ? 43 : $policyDN.hashCode());
            String $cadn = this.cadn();
            result = result * 59 + ($cadn == null ? 43 : $cadn.hashCode());
            String $objectName = this.objectName();
            result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
            String $subject = this.subject();
            result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
            String $organizationalUnit = this.organizationalUnit();
            result = result * 59 + ($organizationalUnit == null ? 43 : $organizationalUnit.hashCode());
            String $organization = this.organization();
            result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
            String $city = this.city();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $state = this.state();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $country = this.country();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            Collection<SANItem> $subjectAltNames = this.subjectAltNames();
            result = result * 59 + ($subjectAltNames == null ? 43 : ((Object)$subjectAltNames).hashCode());
            String $contact = this.contact();
            result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
            Collection<NameValuePair<String, String>> $caSpecificAttributes = this.caSpecificAttributes();
            result = result * 59 + ($caSpecificAttributes == null ? 43 : ((Object)$caSpecificAttributes).hashCode());
            String $pkcs10 = this.pkcs10();
            result = result * 59 + ($pkcs10 == null ? 43 : $pkcs10.hashCode());
            String $keyAlgorithm = this.keyAlgorithm();
            result = result * 59 + ($keyAlgorithm == null ? 43 : $keyAlgorithm.hashCode());
            result = result * 59 + this.keyBitSize();
            String $ellipticCurve = this.ellipticCurve();
            result = result * 59 + ($ellipticCurve == null ? 43 : $ellipticCurve.hashCode());
            result = result * 59 + (this.disableAutomaticRenewal() ? 79 : 97);
            String $origin = this.origin();
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            ArrayList<CustomFieldRequest> $customFields = this.customFields();
            result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.CertificateRequestsPayload(policyDN=" + this.policyDN() + ", cadn=" + this.cadn() + ", objectName=" + this.objectName() + ", subject=" + this.subject() + ", organizationalUnit=" + this.organizationalUnit() + ", organization=" + this.organization() + ", city=" + this.city() + ", state=" + this.state() + ", country=" + this.country() + ", subjectAltNames=" + this.subjectAltNames() + ", contact=" + this.contact() + ", caSpecificAttributes=" + this.caSpecificAttributes() + ", pkcs10=" + this.pkcs10() + ", keyAlgorithm=" + this.keyAlgorithm() + ", keyBitSize=" + this.keyBitSize() + ", ellipticCurve=" + this.ellipticCurve() + ", disableAutomaticRenewal=" + this.disableAutomaticRenewal() + ", origin=" + this.origin() + ", customFields=" + this.customFields() + ")";
        }
    }

    public static class ReadZoneConfigurationResponse {
        Object error;
        ServerPolicy policy;

        public Object error() {
            return this.error;
        }

        public ServerPolicy policy() {
            return this.policy;
        }

        public ReadZoneConfigurationResponse error(Object error) {
            this.error = error;
            return this;
        }

        public ReadZoneConfigurationResponse policy(ServerPolicy policy) {
            this.policy = policy;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadZoneConfigurationResponse)) {
                return false;
            }
            ReadZoneConfigurationResponse other = (ReadZoneConfigurationResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$error = this.error();
            Object other$error = other.error();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            ServerPolicy this$policy = this.policy();
            ServerPolicy other$policy = other.policy();
            return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReadZoneConfigurationResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $error = this.error();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            ServerPolicy $policy = this.policy();
            result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.ReadZoneConfigurationResponse(error=" + this.error() + ", policy=" + this.policy() + ")";
        }
    }

    public static class ReadZoneConfigurationRequest {
        String policyDN;

        public String policyDN() {
            return this.policyDN;
        }

        public ReadZoneConfigurationRequest policyDN(String policyDN) {
            this.policyDN = policyDN;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadZoneConfigurationRequest)) {
                return false;
            }
            ReadZoneConfigurationRequest other = (ReadZoneConfigurationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$policyDN = this.policyDN();
            String other$policyDN = other.policyDN();
            return !(this$policyDN == null ? other$policyDN != null : !this$policyDN.equals(other$policyDN));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReadZoneConfigurationRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $policyDN = this.policyDN();
            result = result * 59 + ($policyDN == null ? 43 : $policyDN.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.ReadZoneConfigurationRequest(policyDN=" + this.policyDN() + ")";
        }

        public ReadZoneConfigurationRequest(String policyDN) {
            this.policyDN = policyDN;
        }
    }

    static class RefreshTokenRequest {
        @SerializedName(value="refresh_token")
        private String refreshToken;
        @SerializedName(value="client_id")
        private String clientId;

        public String refreshToken() {
            return this.refreshToken;
        }

        public String clientId() {
            return this.clientId;
        }

        public RefreshTokenRequest refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public RefreshTokenRequest clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshTokenRequest)) {
                return false;
            }
            RefreshTokenRequest other = (RefreshTokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$refreshToken = this.refreshToken();
            String other$refreshToken = other.refreshToken();
            if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
                return false;
            }
            String this$clientId = this.clientId();
            String other$clientId = other.clientId();
            return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefreshTokenRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $refreshToken = this.refreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            String $clientId = this.clientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.RefreshTokenRequest(refreshToken=" + this.refreshToken() + ", clientId=" + this.clientId() + ")";
        }

        public RefreshTokenRequest(String refreshToken, String clientId) {
            this.refreshToken = refreshToken;
            this.clientId = clientId;
        }
    }

    static class AuthorizeTokenRequest {
        @SerializedName(value="username")
        private String username;
        @SerializedName(value="password")
        private String password;
        @SerializedName(value="client_id")
        private String clientId;
        @SerializedName(value="scope")
        private String scope;
        @SerializedName(value="state")
        private String state;
        @SerializedName(value="redirect_uri")
        private String redirectUri;

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public String clientId() {
            return this.clientId;
        }

        public String scope() {
            return this.scope;
        }

        public String state() {
            return this.state;
        }

        public String redirectUri() {
            return this.redirectUri;
        }

        public AuthorizeTokenRequest username(String username) {
            this.username = username;
            return this;
        }

        public AuthorizeTokenRequest password(String password) {
            this.password = password;
            return this;
        }

        public AuthorizeTokenRequest clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AuthorizeTokenRequest scope(String scope) {
            this.scope = scope;
            return this;
        }

        public AuthorizeTokenRequest state(String state) {
            this.state = state;
            return this;
        }

        public AuthorizeTokenRequest redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthorizeTokenRequest)) {
                return false;
            }
            AuthorizeTokenRequest other = (AuthorizeTokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.username();
            String other$username = other.username();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$clientId = this.clientId();
            String other$clientId = other.clientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$scope = this.scope();
            String other$scope = other.scope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$state = this.state();
            String other$state = other.state();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$redirectUri = this.redirectUri();
            String other$redirectUri = other.redirectUri();
            return !(this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthorizeTokenRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.username();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $clientId = this.clientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $scope = this.scope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $state = this.state();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $redirectUri = this.redirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.AuthorizeTokenRequest(username=" + this.username() + ", password=" + this.password() + ", clientId=" + this.clientId() + ", scope=" + this.scope() + ", state=" + this.state() + ", redirectUri=" + this.redirectUri() + ")";
        }

        public AuthorizeTokenRequest(String username, String password, String clientId, String scope, String state, String redirectUri) {
            this.username = username;
            this.password = password;
            this.clientId = clientId;
            this.scope = scope;
            this.state = state;
            this.redirectUri = redirectUri;
        }
    }

    public static class AuthorizeRequest {
        private String username;
        private String password;

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public AuthorizeRequest username(String username) {
            this.username = username;
            return this;
        }

        public AuthorizeRequest password(String password) {
            this.password = password;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthorizeRequest)) {
                return false;
            }
            AuthorizeRequest other = (AuthorizeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.username();
            String other$username = other.username();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthorizeRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.username();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTppConnector.AuthorizeRequest(username=" + this.username() + ", password=" + this.password() + ")";
        }

        public AuthorizeRequest(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

