/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.ChainOption;
import com.venafi.vcert.sdk.certificate.CsrOriginOption;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.certificate.KeyType;
import com.venafi.vcert.sdk.certificate.PEMCollection;
import com.venafi.vcert.sdk.certificate.PublicKeyAlgorithm;
import com.venafi.vcert.sdk.certificate.RenewalRequest;
import com.venafi.vcert.sdk.certificate.RevocationRequest;
import com.venafi.vcert.sdk.certificate.SshCaTemplateRequest;
import com.venafi.vcert.sdk.certificate.SshCertRetrieveDetails;
import com.venafi.vcert.sdk.certificate.SshCertificateRequest;
import com.venafi.vcert.sdk.certificate.SshConfig;
import com.venafi.vcert.sdk.connectors.ConnectorException;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.connectors.ServerPolicy;
import com.venafi.vcert.sdk.connectors.TokenConnector;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.connectors.tpp.AbstractTppConnector;
import com.venafi.vcert.sdk.connectors.tpp.AuthorizeTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.RefreshTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.TokenInfo;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.TppAPI;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ClearPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequestResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveResponse;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;
import com.venafi.vcert.sdk.policy.api.domain.TPPPolicy;
import com.venafi.vcert.sdk.policy.converter.TPPPolicySpecificationConverter;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.utils.Is;
import com.venafi.vcert.sdk.utils.VCertUtils;
import feign.FeignException;
import feign.Response;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Strings;

public class TppTokenConnector
extends AbstractTppConnector
implements TokenConnector {
    @VisibleForTesting
    private Authentication credentials;
    private TppAPI tppAPI;

    public TppTokenConnector(Tpp tpp) {
        super(tpp);
    }

    @Override
    public ConnectorType getType() {
        return ConnectorType.TPP_TOKEN;
    }

    @Override
    public void setBaseUrl(String url) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setZone(String zone) {
        this.zone = zone;
    }

    @Override
    public void setVendorAndProductName(String vendorAndProductName) {
        this.vendorAndProductName = vendorAndProductName;
    }

    @Override
    public String getVendorAndProductName() {
        return this.vendorAndProductName;
    }

    private String getAuthHeaderValue() throws VCertException {
        if (this.isEmptyToken()) {
            throw new ConnectorException.MissingAccessTokenException();
        }
        return String.format("Bearer %s", this.credentials.accessToken());
    }

    @Override
    public void ping() throws VCertException {
        Response response = this.doPing();
        if (response.status() != 200) {
            throw new ConnectorException.TppPingException(response.status(), response.reason());
        }
    }

    private Response doPing() throws VCertException {
        return this.tpp.pingToken(this.getAuthHeaderValue());
    }

    @Override
    public TokenInfo getAccessToken(Authentication auth) throws VCertException {
        TokenInfo accessTokenInfo;
        if (this.isEmptyCredentials(auth)) {
            throw new ConnectorException.MissingCredentialsException();
        }
        try {
            AbstractTppConnector.AuthorizeTokenRequest authRequest = new AbstractTppConnector.AuthorizeTokenRequest(auth.user(), auth.password(), auth.clientId(), auth.scope(), auth.state(), auth.redirectUri());
            AuthorizeTokenResponse response = this.tpp.authorizeToken(authRequest);
            accessTokenInfo = new TokenInfo(response.accessToken(), response.refreshToken(), response.expire(), response.tokenType(), response.scope(), response.identity(), response.refreshUntil(), true, null);
            this.credentials = auth;
            this.credentials.accessToken(accessTokenInfo.accessToken());
            this.credentials.refreshToken(accessTokenInfo.refreshToken());
        }
        catch (FeignException.BadRequest | FeignException.Unauthorized e) {
            accessTokenInfo = new TokenInfo(null, null, -1L, null, null, null, -1L, false, e.getMessage() + " " + new String(e.content()));
        }
        return accessTokenInfo;
    }

    @Override
    public TokenInfo getAccessToken() throws VCertException {
        return this.getAccessToken(this.credentials);
    }

    @Override
    public TokenInfo refreshAccessToken(String clientId) throws VCertException {
        if (StringUtils.isBlank((CharSequence)this.credentials.refreshToken())) {
            throw new ConnectorException.MissingRefreshTokenException();
        }
        try {
            AbstractTppConnector.RefreshTokenRequest request = new AbstractTppConnector.RefreshTokenRequest(this.credentials.refreshToken(), clientId);
            RefreshTokenResponse response = this.tpp.refreshToken(request);
            TokenInfo tokenInfo = new TokenInfo(response.accessToken(), response.refreshToken(), response.expire(), response.tokenType(), response.scope(), "", response.refreshUntil(), true, null);
            this.credentials.accessToken(tokenInfo.accessToken());
            this.credentials.refreshToken(tokenInfo.refreshToken());
            return tokenInfo;
        }
        catch (FeignException.BadRequest e) {
            TokenInfo tokenInfo = new TokenInfo(null, null, -1L, null, null, null, -1L, false, e.getMessage() + " " + new String(e.content()));
            return tokenInfo;
        }
    }

    @Override
    public int revokeAccessToken() throws VCertException {
        String requestHeader = this.getAuthHeaderValue();
        Response response = this.tpp.revokeToken(requestHeader);
        if (response.status() == 200) {
            return response.status();
        }
        throw new ConnectorException.FailedToRevokeTokenException(response.reason());
    }

    @Override
    public ZoneConfiguration readZoneConfiguration(String zone) throws VCertException {
        VCertException.throwIfNull(zone, "empty zone");
        AbstractTppConnector.ReadZoneConfigurationRequest request = new AbstractTppConnector.ReadZoneConfigurationRequest(this.getPolicyDN(zone));
        AbstractTppConnector.ReadZoneConfigurationResponse response = this.tpp.readZoneConfigurationToken(request, this.getAuthHeaderValue());
        ServerPolicy serverPolicy = response.policy();
        Policy policy = serverPolicy.toPolicy();
        ZoneConfiguration zoneConfig = serverPolicy.toZoneConfig();
        zoneConfig.policy(policy);
        zoneConfig.zoneId(zone);
        return zoneConfig;
    }

    @Override
    public CertificateRequest generateRequest(ZoneConfiguration config, CertificateRequest request) throws VCertException {
        String tppMgmtType;
        if (config == null) {
            config = this.readZoneConfiguration(this.zone);
        }
        if ("Monitoring".equals(tppMgmtType = config.customAttributeValues().get("Management Type")) || "Unassigned".equals(tppMgmtType)) {
            throw new ConnectorException.TppRequestCertificateNotAllowedException();
        }
        config.applyCertificateRequestDefaultSettingsIfNeeded(request);
        switch (request.csrOrigin()) {
            case LocalGeneratedCSR: {
                if ("0".equals(config.customAttributeValues().get("Manual Csr"))) {
                    throw new ConnectorException.TppManualCSRNotEnabledException(request.csrOrigin());
                }
                request.generatePrivateKey();
                request.generateCSR();
                break;
            }
            case UserProvidedCSR: {
                if ("0".equals(config.customAttributeValues().get("Manual Csr"))) {
                    throw new ConnectorException.TppManualCSRNotEnabledException(request.csrOrigin());
                }
                if (!Is.blank(request.csr())) break;
                throw new ConnectorException.CSRNotProvidedByUserException();
            }
            case ServiceGeneratedCSR: {
                request.csr(null);
            }
        }
        return request;
    }

    @Override
    public String requestCertificate(CertificateRequest request, String zone) throws VCertException {
        return this.requestCertificate(request, new ZoneConfiguration().zoneId(zone));
    }

    @Override
    public String requestCertificate(CertificateRequest request, ZoneConfiguration zoneConfiguration) throws VCertException {
        if (StringUtils.isBlank((CharSequence)zoneConfiguration.zoneId())) {
            zoneConfiguration.zoneId(this.zone);
        }
        AbstractTppConnector.CertificateRequestsPayload payload = this.prepareRequest(request, zoneConfiguration.zoneId());
        Tpp.CertificateRequestResponse response = this.tpp.requestCertificateToken(payload, this.getAuthHeaderValue());
        String requestId = response.certificateDN();
        request.pickupId(requestId);
        return requestId;
    }

    private AbstractTppConnector.CertificateRequestsPayload prepareRequest(CertificateRequest request, String zone) throws VCertException {
        AbstractTppConnector.CertificateRequestsPayload payload;
        ArrayList<AbstractTppConnector.NameValuePair<String, String>> caSpecificAttributes = new ArrayList<AbstractTppConnector.NameValuePair<String, String>>();
        if (!StringUtils.isBlank((CharSequence)this.vendorAndProductName)) {
            caSpecificAttributes.add(new AbstractTppConnector.NameValuePair<String, String>("Origin", this.vendorAndProductName));
        }
        switch (request.csrOrigin()) {
            case LocalGeneratedCSR: {
                payload = new AbstractTppConnector.CertificateRequestsPayload().policyDN(this.getPolicyDN(zone)).pkcs10(new String(request.csr())).objectName(request.friendlyName()).disableAutomaticRenewal(true).origin(this.vendorAndProductName).caSpecificAttributes(caSpecificAttributes);
                break;
            }
            case UserProvidedCSR: {
                payload = new AbstractTppConnector.CertificateRequestsPayload().policyDN(this.getPolicyDN(zone)).pkcs10(new String(request.csr())).objectName(request.friendlyName()).subjectAltNames(this.wrapAltNames(request)).disableAutomaticRenewal(true).origin(this.vendorAndProductName).caSpecificAttributes(caSpecificAttributes);
                break;
            }
            case ServiceGeneratedCSR: {
                payload = new AbstractTppConnector.CertificateRequestsPayload().policyDN(this.getPolicyDN(zone)).objectName(request.friendlyName()).subject(request.subject().commonName()).subjectAltNames(this.wrapAltNames(request)).disableAutomaticRenewal(true).origin(this.vendorAndProductName).caSpecificAttributes(caSpecificAttributes);
                break;
            }
            default: {
                throw new VCertException(MessageFormat.format("Unexpected option in PrivateKeyOrigin: {0}", new Object[]{request.csrOrigin()}));
            }
        }
        if (request.keyType() == null) {
            request.keyType(KeyType.defaultKeyType());
        }
        switch (request.keyType()) {
            case RSA: {
                payload.keyAlgorithm(PublicKeyAlgorithm.RSA.name());
                payload.keyBitSize(request.keyLength());
                break;
            }
            case ECDSA: {
                payload.keyAlgorithm("ECC");
                payload.ellipticCurve(request.keyCurve().value());
            }
        }
        VCertUtils.addExpirationDateAttribute(request, payload);
        VCertUtils.addCustomFieldsToRequest(request, payload);
        return payload;
    }

    private Collection<AbstractTppConnector.SANItem> wrapAltNames(CertificateRequest request) {
        ArrayList<AbstractTppConnector.SANItem> sanItems = new ArrayList<AbstractTppConnector.SANItem>();
        sanItems.addAll(this.toSanItems(request.emailAddresses(), 1));
        sanItems.addAll(this.toSanItems(request.dnsNames(), 2));
        sanItems.addAll(this.toSanItems(request.ipAddresses(), 7));
        return sanItems;
    }

    private List<AbstractTppConnector.SANItem> toSanItems(Collection<?> collection, int type) {
        return ((Collection)Optional.ofNullable(collection).orElse(Collections.emptyList())).stream().filter(Objects::nonNull).map(entry -> new AbstractTppConnector.SANItem().type(type).name(type == 7 ? ((InetAddress)entry).getHostAddress() : entry.toString())).collect(Collectors.toList());
    }

    @Override
    public PEMCollection retrieveCertificate(CertificateRequest request) throws VCertException {
        boolean rootFirstOrder;
        boolean includeChain = request.chainOption() != ChainOption.ChainOptionIgnore;
        boolean bl = rootFirstOrder = includeChain && request.chainOption() == ChainOption.ChainOptionRootFirst;
        if (StringUtils.isNotBlank((CharSequence)request.pickupId()) && StringUtils.isNotBlank((CharSequence)request.thumbprint())) {
            Tpp.CertificateSearchResponse searchResult = this.searchCertificatesByFingerprint(request.thumbprint());
            if (searchResult.certificates().size() == 0) {
                throw new ConnectorException.CertificateNotFoundByThumbprintException(request.thumbprint());
            }
            if (searchResult.certificates().size() > 1) {
                throw new ConnectorException.MoreThanOneCertificateWithSameThumbprintException(request.thumbprint());
            }
            request.pickupId(searchResult.certificates().get(0).certificateRequestId());
        }
        AbstractTppConnector.CertificateRetrieveRequest certReq = new AbstractTppConnector.CertificateRetrieveRequest().certificateDN(request.pickupId()).format("base64").rootFirstOrder(rootFirstOrder).includeChain(includeChain);
        if (request.csrOrigin() == CsrOriginOption.ServiceGeneratedCSR || request.fetchPrivateKey()) {
            certReq.includePrivateKey(true);
            certReq.password(request.keyPassword());
        }
        Instant startTime = Instant.now();
        while (true) {
            Tpp.CertificateRetrieveResponse retrieveResponse;
            if (StringUtils.isNotBlank((CharSequence)(retrieveResponse = this.retrieveCertificateOnce(certReq)).certificateData())) {
                PEMCollection pemCollection = PEMCollection.fromResponse(Strings.fromByteArray((byte[])Base64.getDecoder().decode(retrieveResponse.certificateData())), request.chainOption(), request.privateKey(), request.keyPassword());
                request.checkCertificate(pemCollection.certificate());
                return pemCollection;
            }
            if (Duration.ZERO.equals(request.timeout())) {
                throw new ConnectorException.CertificatePendingException(request.pickupId());
            }
            if (Instant.now().isAfter(startTime.plus(request.timeout()))) {
                throw new ConnectorException.RetrieveCertificateTimeoutException(request.pickupId());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new ConnectorException.AttemptToRetryException(e);
            }
        }
    }

    private Tpp.CertificateRetrieveResponse retrieveCertificateOnce(AbstractTppConnector.CertificateRetrieveRequest certificateRetrieveRequest) throws VCertException {
        return this.tpp.certificateRetrieveToken(certificateRetrieveRequest, this.getAuthHeaderValue());
    }

    private Tpp.CertificateSearchResponse searchCertificatesByFingerprint(String fingerprint) throws VCertException {
        HashMap<String, String> searchRequest = new HashMap<String, String>();
        searchRequest.put("Thumbprint", fingerprint);
        return this.searchCertificates(searchRequest);
    }

    private Tpp.CertificateSearchResponse searchCertificates(Map<String, String> searchRequest) throws VCertException {
        return this.tpp.searchCertificatesToken(searchRequest, this.getAuthHeaderValue());
    }

    @Override
    public void revokeCertificate(RevocationRequest request) throws VCertException {
        Integer reason = (Integer)revocationReasons.get(request.reason());
        if (reason == null) {
            throw new ConnectorException.CouldNotParseRevokeReasonException(request.reason());
        }
        AbstractTppConnector.CertificateRevokeRequest revokeRequest = new AbstractTppConnector.CertificateRevokeRequest().certificateDN(request.certificateDN()).thumbprint(request.thumbprint()).reason(reason).comments(request.comments()).disable(request.disable());
        Tpp.CertificateRevokeResponse revokeResponse = this.revokeCertificate(revokeRequest);
        if (!revokeResponse.success()) {
            throw new ConnectorException.RevokeFailureException(revokeResponse.error());
        }
    }

    private Tpp.CertificateRevokeResponse revokeCertificate(AbstractTppConnector.CertificateRevokeRequest request) throws VCertException {
        return this.tpp.revokeCertificateToken(request, this.getAuthHeaderValue());
    }

    @Override
    public String renewCertificate(RenewalRequest request) throws VCertException {
        Tpp.CertificateRenewalResponse response;
        String certificateDN;
        if (StringUtils.isNotBlank((CharSequence)request.thumbprint()) && StringUtils.isBlank((CharSequence)request.certificateDN())) {
            Tpp.CertificateSearchResponse searchResult = this.searchCertificatesByFingerprint(request.thumbprint());
            if (searchResult.certificates().isEmpty()) {
                throw new ConnectorException.CertificateNotFoundByThumbprintException(request.thumbprint());
            }
            if (searchResult.certificates().size() > 1) {
                throw new ConnectorException.MoreThanOneCertificateWithSameThumbprintException(request.thumbprint());
            }
            certificateDN = searchResult.certificates().get(0).certificateRequestId();
        } else {
            certificateDN = request.certificateDN();
        }
        if (Objects.isNull(certificateDN)) {
            throw new ConnectorException.CertificateDNOrThumbprintWasNotProvidedException();
        }
        AbstractTppConnector.CertificateRenewalRequest renewalRequest = new AbstractTppConnector.CertificateRenewalRequest();
        renewalRequest.certificateDN(certificateDN);
        if (Objects.nonNull(request.request()) && Objects.nonNull(request.request().csr()) && request.request().csr().length > 0) {
            String pkcs10 = Strings.fromByteArray((byte[])request.request().csr());
            renewalRequest.PKCS10(pkcs10);
        }
        if (!(response = this.tpp.renewCertificateToken(renewalRequest, this.getAuthHeaderValue())).success()) {
            throw new ConnectorException.RenewFailureException(response.error());
        }
        return certificateDN;
    }

    @Override
    public ImportResponse importCertificate(ImportRequest request) throws VCertException {
        if (StringUtils.isBlank((CharSequence)request.policyDN())) {
            request.policyDN(this.getPolicyDN(this.zone));
        }
        return this.doImportCertificate(request);
    }

    private ImportResponse doImportCertificate(ImportRequest request) throws VCertException {
        return this.tpp.importCertificateToken(request, this.getAuthHeaderValue());
    }

    @Override
    public Policy readPolicyConfiguration(String zone) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setPolicy(String policyName, PolicySpecification policySpecification) throws VCertException {
        try {
            TPPPolicy tppPolicy = (TPPPolicy)TPPPolicySpecificationConverter.INSTANCE.convertFromPolicySpecification(policySpecification);
            this.setPolicy(policyName, tppPolicy);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    @Override
    public PolicySpecification getPolicy(String policyName) throws VCertException {
        PolicySpecification policySpecification;
        try {
            TPPPolicy tppPolicy = this.getTPPPolicy(policyName);
            policySpecification = TPPPolicySpecificationConverter.INSTANCE.convertToPolicySpecification(tppPolicy);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        return policySpecification;
    }

    @Override
    public String requestSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        TppSshCertRequestResponse tppSshCertRequestResponse = super.requestTppSshCertificate(sshCertificateRequest);
        return tppSshCertRequestResponse.dn();
    }

    @Override
    public SshCertRetrieveDetails retrieveSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        return super.retrieveTppSshCertificate(sshCertificateRequest);
    }

    @Override
    public SshConfig retrieveSshConfig(SshCaTemplateRequest sshCaTemplateRequest) throws VCertException {
        return super.retrieveTppSshConfig(sshCaTemplateRequest);
    }

    private boolean isEmptyCredentials(Authentication credentials) {
        if (credentials == null) {
            return true;
        }
        if (credentials.user() == null || credentials.user().isEmpty()) {
            return true;
        }
        return credentials.password() == null || credentials.password().isEmpty();
    }

    private boolean isEmptyToken() {
        return this.credentials == null || StringUtils.isBlank((CharSequence)this.credentials.accessToken());
    }

    @Override
    protected TppAPI getTppAPI() {
        if (this.tppAPI == null) {
            this.tppAPI = new TppAPI(this.tpp){

                @Override
                public String getAuthKey() throws VCertException {
                    return TppTokenConnector.this.getAuthHeaderValue();
                }

                @Override
                public DNIsValidResponse dnIsValid(DNIsValidRequest request) throws VCertException {
                    return this.tpp.dnIsValidToken(request, this.getAuthKey());
                }

                @Override
                CreateDNResponse createDN(CreateDNRequest request) throws VCertException {
                    return this.tpp.createDNToken(request, this.getAuthKey());
                }

                @Override
                SetPolicyAttributeResponse setPolicyAttribute(SetPolicyAttributeRequest request) throws VCertException {
                    return this.tpp.setPolicyAttributeToken(request, this.getAuthKey());
                }

                @Override
                GetPolicyAttributeResponse getPolicyAttribute(GetPolicyAttributeRequest request) throws VCertException {
                    return this.tpp.getPolicyAttributeToken(request, this.getAuthKey());
                }

                @Override
                GetPolicyResponse getPolicy(GetPolicyRequest request) throws VCertException {
                    return this.tpp.getPolicyToken(request, this.getAuthKey());
                }

                @Override
                Response clearPolicyAttribute(ClearPolicyAttributeRequest request) throws VCertException {
                    return this.tpp.clearPolicyAttributeToken(request, this.getAuthKey());
                }

                @Override
                TppSshCertRequestResponse requestSshCertificate(TppSshCertRequest request) throws VCertException {
                    return this.tpp.requestSshCertificateToken(request, this.getAuthKey());
                }

                @Override
                TppSshCertRetrieveResponse retrieveSshCertificate(TppSshCertRetrieveRequest request) throws VCertException {
                    return this.tpp.retrieveSshCertificateToken(request, this.getAuthKey());
                }

                @Override
                String retrieveSshCAPublicKeyData(Map<String, String> params) throws VCertException {
                    String publicKeyData = null;
                    try {
                        publicKeyData = CharStreams.toString((Readable)this.tpp.retrieveSshCAPublicKeyData(params).body().asReader());
                    }
                    catch (Exception e) {
                        throw new VCertException(e);
                    }
                    return publicKeyData;
                }

                @Override
                TppSshCaTemplateResponse retrieveSshCATemplate(TppSshCaTemplateRequest request) throws VCertException {
                    return this.tpp.retrieveSshCATemplateToken(request, this.getAuthKey());
                }
            };
        }
        return this.tppAPI;
    }

    public TppTokenConnector credentials(Authentication credentials) {
        this.credentials = credentials;
        return this;
    }
}

