/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import feign.FeignException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class VCertException
extends Exception {
    private static final long serialVersionUID = 1L;

    public VCertException() {
    }

    public VCertException(String message) {
        super(message);
    }

    public VCertException(Exception cause) {
        super(cause);
    }

    public VCertException(String message, Exception cause) {
        super(message, cause);
    }

    public static void throwIfNull(Object testee, String message) throws VCertException {
        if (testee != null) {
            return;
        }
        if (message != null) {
            throw new VCertException(message);
        }
        throw new VCertException();
    }

    public static VCertException fromFeignException(FeignException feignException) {
        Gson gson = new GsonBuilder().create();
        VenafiTppErrorResponse tppResponse = (VenafiTppErrorResponse)gson.fromJson(feignException.contentUTF8(), VenafiTppErrorResponse.class);
        if (Objects.nonNull(tppResponse) && tppResponse.error() != null) {
            return new VCertException(feignException.getMessage() + ": " + tppResponse.error(), (Exception)((Object)feignException));
        }
        VenafiCloudErrorResponse response = (VenafiCloudErrorResponse)gson.fromJson(feignException.contentUTF8(), VenafiCloudErrorResponse.class);
        if (Objects.nonNull(response) && response.errors() != null && !response.errors().isEmpty()) {
            return new VCertException(feignException.getMessage() + ": " + response.errors().stream().map(VenafiServerError::message).collect(Collectors.joining(System.lineSeparator())), (Exception)((Object)feignException));
        }
        return new VCertException((Exception)((Object)feignException));
    }

    private static class VenafiServerError {
        private int code;
        private String message;
        private Collection<Object> args;

        public int code() {
            return this.code;
        }

        public String message() {
            return this.message;
        }

        public Collection<Object> args() {
            return this.args;
        }

        public VenafiServerError code(int code) {
            this.code = code;
            return this;
        }

        public VenafiServerError message(String message) {
            this.message = message;
            return this;
        }

        public VenafiServerError args(Collection<Object> args) {
            this.args = args;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VenafiServerError)) {
                return false;
            }
            VenafiServerError other = (VenafiServerError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.code() != other.code()) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Collection<Object> this$args = this.args();
            Collection<Object> other$args = other.args();
            return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VenafiServerError;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.code();
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Collection<Object> $args = this.args();
            result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
            return result;
        }

        public String toString() {
            return "VCertException.VenafiServerError(code=" + this.code() + ", message=" + this.message() + ", args=" + this.args() + ")";
        }
    }

    private static class VenafiTppErrorResponse {
        @SerializedName(value="Error")
        private String error;

        public String error() {
            return this.error;
        }

        public VenafiTppErrorResponse error(String error) {
            this.error = error;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VenafiTppErrorResponse)) {
                return false;
            }
            VenafiTppErrorResponse other = (VenafiTppErrorResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$error = this.error();
            String other$error = other.error();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VenafiTppErrorResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $error = this.error();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        public String toString() {
            return "VCertException.VenafiTppErrorResponse(error=" + this.error() + ")";
        }
    }

    private static class VenafiCloudErrorResponse {
        private Collection<VenafiServerError> errors;

        public Collection<VenafiServerError> errors() {
            return this.errors;
        }

        public VenafiCloudErrorResponse errors(Collection<VenafiServerError> errors) {
            this.errors = errors;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VenafiCloudErrorResponse)) {
                return false;
            }
            VenafiCloudErrorResponse other = (VenafiCloudErrorResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<VenafiServerError> this$errors = this.errors();
            Collection<VenafiServerError> other$errors = other.errors();
            return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VenafiCloudErrorResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<VenafiServerError> $errors = this.errors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            return result;
        }

        public String toString() {
            return "VCertException.VenafiCloudErrorResponse(errors=" + this.errors() + ")";
        }
    }
}

