/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors;

import com.venafi.vcert.sdk.SignatureAlgorithm;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.EllipticCurve;
import com.venafi.vcert.sdk.certificate.KeyType;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.endpoint.AllowedKeyConfiguration;
import com.venafi.vcert.sdk.utils.Is;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ZoneConfiguration {
    private String organization;
    private List<String> organizationalUnit;
    private String country;
    private String province;
    private String locality;
    private Policy policy = new Policy();
    private SignatureAlgorithm hashAlgorithm = SignatureAlgorithm.UnknownSignatureAlgorithm;
    private Map<String, String> customAttributeValues = new HashMap<String, String>();
    private String zoneId;
    private AllowedKeyConfiguration keyConfig;
    private String applicationId;
    private String certificateIssuingTemplateId;

    public void applyCertificateRequestDefaultSettingsIfNeeded(CertificateRequest request) {
        CertificateRequest.PKIXName subject = request.subject();
        subject.organization(Entity.of(subject.organization(), this.organization).resolve());
        if (Is.blank(subject.organizationalUnit()) && !Is.blank(this.organizationalUnit)) {
            subject.organizationalUnit(this.organizationalUnit);
        }
        subject.country(Entity.of(subject.country(), this.country).resolve());
        subject.province(Entity.of(subject.province(), this.province).resolve());
        subject.locality(Entity.of(subject.locality(), this.locality).resolve());
        if (request.keyType() == null) {
            request.keyType(this.keyConfig != null && this.keyConfig.keyType() != null ? this.keyConfig.keyType() : KeyType.defaultKeyType());
        }
        switch (request.keyType()) {
            case ECDSA: {
                if (request.keyCurve() == null) {
                    request.keyCurve(EllipticCurve.ellipticCurveDefault());
                }
                if (request.signatureAlgorithm() != SignatureAlgorithm.UnknownSignatureAlgorithm) break;
                request.signatureAlgorithm(SignatureAlgorithm.ECDSAWithSHA256);
                break;
            }
            default: {
                if (request.keyLength() < KeyType.defaultRsaLength()) {
                    request.keyLength(this.keyConfig != null && !Is.blank(this.keyConfig.keySizes()) && this.keyConfig.keySizes().get(0) >= KeyType.defaultRsaLength() ? this.keyConfig.keySizes().get(0).intValue() : KeyType.defaultRsaLength().intValue());
                }
                if (request.signatureAlgorithm() != SignatureAlgorithm.UnknownSignatureAlgorithm) break;
                request.signatureAlgorithm(SignatureAlgorithm.SHA256WithRSA);
            }
        }
        if (!Is.blank(this.policy.allowedKeyConfigurations())) {
            for (AllowedKeyConfiguration keyConf : this.policy.allowedKeyConfigurations()) {
                if (keyConf.keyType() != request.keyType()) continue;
                switch (request.keyType()) {
                    case ECDSA: {
                        if (Is.blank(keyConf.keyCurves()) || keyConf.keyCurves().contains((Object)request.keyCurve())) break;
                        request.keyCurve(keyConf.keyCurves().get(0));
                        break;
                    }
                    case RSA: {
                        if (Is.blank(keyConf.keySizes())) break;
                        boolean sizeOK = false;
                        for (Integer size : keyConf.keySizes()) {
                            if (!size.equals(request.keyLength())) continue;
                            sizeOK = true;
                        }
                        if (sizeOK) break;
                        request.keyLength(keyConf.keySizes().get(0));
                    }
                }
            }
        }
    }

    public boolean validateCertificateRequest(CertificateRequest request) throws VCertException {
        if (!this.isComponentValid(this.policy.subjectCNRegexes(), Collections.singletonList(request.subject().commonName()), false)) {
            throw new VCertException("The requested CN does not match any of the allowed CN regular expressions");
        }
        if (!this.isComponentValid(this.policy.subjectORegexes(), request.subject().organization(), false)) {
            throw new VCertException("The requested Organization does not match any of the allowed Organization regular expressions");
        }
        if (!this.isComponentValid(this.policy.subjectOURegexes(), request.subject().organizationalUnit(), false)) {
            throw new VCertException("The requested Organizational Unit does not match any of the allowed Organization Unit regular expressions");
        }
        if (!this.isComponentValid(this.policy.subjectSTRegexes(), request.subject().province(), false)) {
            throw new VCertException("The requested State/Province does not match any of the allowed State/Province regular expressions");
        }
        if (!this.isComponentValid(this.policy.subjectLRegexes(), request.subject().locality(), false)) {
            throw new VCertException("The requested Locality does not match any of the allowed Locality regular expressions");
        }
        if (!this.isComponentValid(this.policy.subjectCRegexes(), request.subject().country(), false)) {
            throw new VCertException("The requested Country does not match any of the allowed Country regular expressions");
        }
        if (!this.isComponentValid(this.policy.dnsSanRegExs(), request.dnsNames(), true)) {
            throw new VCertException("The requested Subject Alternative Name does not match any of the allowed Country regular expressions");
        }
        List<AllowedKeyConfiguration> allowedKeyConfigurations = this.policy.allowedKeyConfigurations();
        if (allowedKeyConfigurations != null && allowedKeyConfigurations.size() > 0) {
            for (AllowedKeyConfiguration keyConfiguration : allowedKeyConfigurations) {
                if (keyConfiguration.keyType() != request.keyType()) continue;
                if (request.keyLength() > 0) {
                    for (Integer size : keyConfiguration.keySizes()) {
                        if (!size.equals(request.keyLength())) continue;
                        return true;
                    }
                }
                return true;
            }
            throw new VCertException("The requested Key Type and Size do not match any of the allowed Key Types and Sizes");
        }
        return true;
    }

    private boolean isComponentValid(Collection<String> regexes, Collection<String> components, boolean optional) {
        if (regexes.isEmpty() || optional && Is.blank(components)) {
            return true;
        }
        if (components != null) {
            for (String regex : regexes) {
                Pattern pattern;
                try {
                    pattern = Pattern.compile(regex);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
                for (String component : components) {
                    Matcher m = pattern.matcher(component);
                    if (!m.matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String organization() {
        return this.organization;
    }

    public List<String> organizationalUnit() {
        return this.organizationalUnit;
    }

    public String country() {
        return this.country;
    }

    public String province() {
        return this.province;
    }

    public String locality() {
        return this.locality;
    }

    public Policy policy() {
        return this.policy;
    }

    public SignatureAlgorithm hashAlgorithm() {
        return this.hashAlgorithm;
    }

    public Map<String, String> customAttributeValues() {
        return this.customAttributeValues;
    }

    public String zoneId() {
        return this.zoneId;
    }

    public AllowedKeyConfiguration keyConfig() {
        return this.keyConfig;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String certificateIssuingTemplateId() {
        return this.certificateIssuingTemplateId;
    }

    public ZoneConfiguration organization(String organization) {
        this.organization = organization;
        return this;
    }

    public ZoneConfiguration organizationalUnit(List<String> organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
        return this;
    }

    public ZoneConfiguration country(String country) {
        this.country = country;
        return this;
    }

    public ZoneConfiguration province(String province) {
        this.province = province;
        return this;
    }

    public ZoneConfiguration locality(String locality) {
        this.locality = locality;
        return this;
    }

    public ZoneConfiguration policy(Policy policy) {
        this.policy = policy;
        return this;
    }

    public ZoneConfiguration hashAlgorithm(SignatureAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    public ZoneConfiguration customAttributeValues(Map<String, String> customAttributeValues) {
        this.customAttributeValues = customAttributeValues;
        return this;
    }

    public ZoneConfiguration zoneId(String zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public ZoneConfiguration keyConfig(AllowedKeyConfiguration keyConfig) {
        this.keyConfig = keyConfig;
        return this;
    }

    public ZoneConfiguration applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public ZoneConfiguration certificateIssuingTemplateId(String certificateIssuingTemplateId) {
        this.certificateIssuingTemplateId = certificateIssuingTemplateId;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZoneConfiguration)) {
            return false;
        }
        ZoneConfiguration other = (ZoneConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$organization = this.organization();
        String other$organization = other.organization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        List<String> this$organizationalUnit = this.organizationalUnit();
        List<String> other$organizationalUnit = other.organizationalUnit();
        if (this$organizationalUnit == null ? other$organizationalUnit != null : !((Object)this$organizationalUnit).equals(other$organizationalUnit)) {
            return false;
        }
        String this$country = this.country();
        String other$country = other.country();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$province = this.province();
        String other$province = other.province();
        if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
            return false;
        }
        String this$locality = this.locality();
        String other$locality = other.locality();
        if (this$locality == null ? other$locality != null : !this$locality.equals(other$locality)) {
            return false;
        }
        Policy this$policy = this.policy();
        Policy other$policy = other.policy();
        if (this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy)) {
            return false;
        }
        SignatureAlgorithm this$hashAlgorithm = this.hashAlgorithm();
        SignatureAlgorithm other$hashAlgorithm = other.hashAlgorithm();
        if (this$hashAlgorithm == null ? other$hashAlgorithm != null : !((Object)((Object)this$hashAlgorithm)).equals((Object)other$hashAlgorithm)) {
            return false;
        }
        Map<String, String> this$customAttributeValues = this.customAttributeValues();
        Map<String, String> other$customAttributeValues = other.customAttributeValues();
        if (this$customAttributeValues == null ? other$customAttributeValues != null : !((Object)this$customAttributeValues).equals(other$customAttributeValues)) {
            return false;
        }
        String this$zoneId = this.zoneId();
        String other$zoneId = other.zoneId();
        if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
            return false;
        }
        AllowedKeyConfiguration this$keyConfig = this.keyConfig();
        AllowedKeyConfiguration other$keyConfig = other.keyConfig();
        if (this$keyConfig == null ? other$keyConfig != null : !((Object)this$keyConfig).equals(other$keyConfig)) {
            return false;
        }
        String this$applicationId = this.applicationId();
        String other$applicationId = other.applicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$certificateIssuingTemplateId = this.certificateIssuingTemplateId();
        String other$certificateIssuingTemplateId = other.certificateIssuingTemplateId();
        return !(this$certificateIssuingTemplateId == null ? other$certificateIssuingTemplateId != null : !this$certificateIssuingTemplateId.equals(other$certificateIssuingTemplateId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZoneConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organization = this.organization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        List<String> $organizationalUnit = this.organizationalUnit();
        result = result * 59 + ($organizationalUnit == null ? 43 : ((Object)$organizationalUnit).hashCode());
        String $country = this.country();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $province = this.province();
        result = result * 59 + ($province == null ? 43 : $province.hashCode());
        String $locality = this.locality();
        result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
        Policy $policy = this.policy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        SignatureAlgorithm $hashAlgorithm = this.hashAlgorithm();
        result = result * 59 + ($hashAlgorithm == null ? 43 : ((Object)((Object)$hashAlgorithm)).hashCode());
        Map<String, String> $customAttributeValues = this.customAttributeValues();
        result = result * 59 + ($customAttributeValues == null ? 43 : ((Object)$customAttributeValues).hashCode());
        String $zoneId = this.zoneId();
        result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
        AllowedKeyConfiguration $keyConfig = this.keyConfig();
        result = result * 59 + ($keyConfig == null ? 43 : ((Object)$keyConfig).hashCode());
        String $applicationId = this.applicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $certificateIssuingTemplateId = this.certificateIssuingTemplateId();
        result = result * 59 + ($certificateIssuingTemplateId == null ? 43 : $certificateIssuingTemplateId.hashCode());
        return result;
    }

    public String toString() {
        return "ZoneConfiguration(organization=" + this.organization() + ", organizationalUnit=" + this.organizationalUnit() + ", country=" + this.country() + ", province=" + this.province() + ", locality=" + this.locality() + ", policy=" + this.policy() + ", hashAlgorithm=" + (Object)((Object)this.hashAlgorithm()) + ", customAttributeValues=" + this.customAttributeValues() + ", zoneId=" + this.zoneId() + ", keyConfig=" + this.keyConfig() + ", applicationId=" + this.applicationId() + ", certificateIssuingTemplateId=" + this.certificateIssuingTemplateId() + ")";
    }

    private static class Entity {
        private List<String> target;
        private String source;

        private Entity() {
        }

        static Entity of(List<String> target, String source) {
            Entity entity = new Entity();
            entity.target = target;
            entity.source = source != null ? source : "";
            return entity;
        }

        List<String> resolve() {
            return Is.blank(this.target) ? Collections.singletonList(this.source) : this.target;
        }
    }
}

