/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.cloud.domain;

import com.google.gson.annotations.SerializedName;
import com.venafi.vcert.sdk.certificate.KeyType;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.endpoint.AllowedKeyConfiguration;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class CertificateIssuingTemplate {
    public String id;
    public String companyId;
    public String certificateAuthority;
    public String name;
    public String certificateAuthorityAccountId;
    public String certificateAuthorityProductOptionId;
    public Product product;
    public TrackingData trackingData;
    public Integer priority;
    public Boolean systemGenerated;
    public Date creationDate;
    public Date modificationDate;
    public String reason;
    public List<String> subjectCNRegexes;
    public List<String> subjectORegexes;
    public List<String> subjectOURegexes;
    public List<String> subjectSTRegexes;
    public List<String> subjectLRegexes;
    public List<String> subjectCValues;
    @SerializedName(value="sanRegexes")
    public List<String> sanDnsNameRegexes;
    public List<AllowedKeyType> keyTypes;
    public Boolean keyReuse;
    public RecommendedSettings recommendedSettings;
    private String validityPeriod;

    public Policy toPolicy() {
        List<AllowedKeyConfiguration> allowedKeyConfigurations = this.keyTypes.stream().map(kt -> new AllowedKeyConfiguration(KeyType.from(((AllowedKeyType)kt).keyType), ((AllowedKeyType)kt).keyLengths, null)).collect(Collectors.toList());
        Policy policy = Policy.builder().subjectCNRegexes(this.subjectCNRegexes).subjectCRegexes(this.subjectCValues).subjectLRegexes(this.subjectLRegexes).subjectORegexes(this.subjectORegexes).subjectOURegexes(this.subjectOURegexes).subjectSTRegexes(this.subjectSTRegexes).dnsSanRegExs(this.sanDnsNameRegexes).allowedKeyConfigurations(allowedKeyConfigurations).allowKeyReuse(this.keyReuse).build();
        return policy;
    }

    public ZoneConfiguration toZoneConfig() {
        ZoneConfiguration zoneConfig = new ZoneConfiguration().customAttributeValues(new HashMap<String, String>());
        if (this.recommendedSettings != null) {
            zoneConfig.country(this.recommendedSettings.subjectCValue).organization(this.recommendedSettings.subjectOValue).organizationalUnit(Collections.singletonList(this.recommendedSettings.subjectOUValue)).province(this.recommendedSettings.subjectSTValue).locality(this.recommendedSettings.subjectLValue);
            if (this.recommendedSettings.key() != null) {
                String type = this.recommendedSettings.key().type != null ? this.recommendedSettings.key().type : KeyType.defaultKeyType().name();
                Integer length = this.recommendedSettings.key().length != null ? this.recommendedSettings.key().length : KeyType.defaultRsaLength();
                zoneConfig.keyConfig(new AllowedKeyConfiguration(KeyType.from(type), Collections.singletonList(length), null));
            }
        }
        return zoneConfig;
    }

    public String id() {
        return this.id;
    }

    public String companyId() {
        return this.companyId;
    }

    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public String name() {
        return this.name;
    }

    public String certificateAuthorityAccountId() {
        return this.certificateAuthorityAccountId;
    }

    public String certificateAuthorityProductOptionId() {
        return this.certificateAuthorityProductOptionId;
    }

    public Product product() {
        return this.product;
    }

    public TrackingData trackingData() {
        return this.trackingData;
    }

    public Integer priority() {
        return this.priority;
    }

    public Boolean systemGenerated() {
        return this.systemGenerated;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public Date modificationDate() {
        return this.modificationDate;
    }

    public String reason() {
        return this.reason;
    }

    public List<String> subjectCNRegexes() {
        return this.subjectCNRegexes;
    }

    public List<String> subjectORegexes() {
        return this.subjectORegexes;
    }

    public List<String> subjectOURegexes() {
        return this.subjectOURegexes;
    }

    public List<String> subjectSTRegexes() {
        return this.subjectSTRegexes;
    }

    public List<String> subjectLRegexes() {
        return this.subjectLRegexes;
    }

    public List<String> subjectCValues() {
        return this.subjectCValues;
    }

    public List<String> sanDnsNameRegexes() {
        return this.sanDnsNameRegexes;
    }

    public List<AllowedKeyType> keyTypes() {
        return this.keyTypes;
    }

    public Boolean keyReuse() {
        return this.keyReuse;
    }

    public RecommendedSettings recommendedSettings() {
        return this.recommendedSettings;
    }

    public String validityPeriod() {
        return this.validityPeriod;
    }

    public CertificateIssuingTemplate id(String id) {
        this.id = id;
        return this;
    }

    public CertificateIssuingTemplate companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    public CertificateIssuingTemplate certificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    public CertificateIssuingTemplate name(String name) {
        this.name = name;
        return this;
    }

    public CertificateIssuingTemplate certificateAuthorityAccountId(String certificateAuthorityAccountId) {
        this.certificateAuthorityAccountId = certificateAuthorityAccountId;
        return this;
    }

    public CertificateIssuingTemplate certificateAuthorityProductOptionId(String certificateAuthorityProductOptionId) {
        this.certificateAuthorityProductOptionId = certificateAuthorityProductOptionId;
        return this;
    }

    public CertificateIssuingTemplate product(Product product) {
        this.product = product;
        return this;
    }

    public CertificateIssuingTemplate trackingData(TrackingData trackingData) {
        this.trackingData = trackingData;
        return this;
    }

    public CertificateIssuingTemplate priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public CertificateIssuingTemplate systemGenerated(Boolean systemGenerated) {
        this.systemGenerated = systemGenerated;
        return this;
    }

    public CertificateIssuingTemplate creationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public CertificateIssuingTemplate modificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
        return this;
    }

    public CertificateIssuingTemplate reason(String reason) {
        this.reason = reason;
        return this;
    }

    public CertificateIssuingTemplate subjectCNRegexes(List<String> subjectCNRegexes) {
        this.subjectCNRegexes = subjectCNRegexes;
        return this;
    }

    public CertificateIssuingTemplate subjectORegexes(List<String> subjectORegexes) {
        this.subjectORegexes = subjectORegexes;
        return this;
    }

    public CertificateIssuingTemplate subjectOURegexes(List<String> subjectOURegexes) {
        this.subjectOURegexes = subjectOURegexes;
        return this;
    }

    public CertificateIssuingTemplate subjectSTRegexes(List<String> subjectSTRegexes) {
        this.subjectSTRegexes = subjectSTRegexes;
        return this;
    }

    public CertificateIssuingTemplate subjectLRegexes(List<String> subjectLRegexes) {
        this.subjectLRegexes = subjectLRegexes;
        return this;
    }

    public CertificateIssuingTemplate subjectCValues(List<String> subjectCValues) {
        this.subjectCValues = subjectCValues;
        return this;
    }

    public CertificateIssuingTemplate sanDnsNameRegexes(List<String> sanDnsNameRegexes) {
        this.sanDnsNameRegexes = sanDnsNameRegexes;
        return this;
    }

    public CertificateIssuingTemplate keyTypes(List<AllowedKeyType> keyTypes) {
        this.keyTypes = keyTypes;
        return this;
    }

    public CertificateIssuingTemplate keyReuse(Boolean keyReuse) {
        this.keyReuse = keyReuse;
        return this;
    }

    public CertificateIssuingTemplate recommendedSettings(RecommendedSettings recommendedSettings) {
        this.recommendedSettings = recommendedSettings;
        return this;
    }

    public CertificateIssuingTemplate validityPeriod(String validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertificateIssuingTemplate)) {
            return false;
        }
        CertificateIssuingTemplate other = (CertificateIssuingTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$companyId = this.companyId();
        String other$companyId = other.companyId();
        if (this$companyId == null ? other$companyId != null : !this$companyId.equals(other$companyId)) {
            return false;
        }
        String this$certificateAuthority = this.certificateAuthority();
        String other$certificateAuthority = other.certificateAuthority();
        if (this$certificateAuthority == null ? other$certificateAuthority != null : !this$certificateAuthority.equals(other$certificateAuthority)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$certificateAuthorityAccountId = this.certificateAuthorityAccountId();
        String other$certificateAuthorityAccountId = other.certificateAuthorityAccountId();
        if (this$certificateAuthorityAccountId == null ? other$certificateAuthorityAccountId != null : !this$certificateAuthorityAccountId.equals(other$certificateAuthorityAccountId)) {
            return false;
        }
        String this$certificateAuthorityProductOptionId = this.certificateAuthorityProductOptionId();
        String other$certificateAuthorityProductOptionId = other.certificateAuthorityProductOptionId();
        if (this$certificateAuthorityProductOptionId == null ? other$certificateAuthorityProductOptionId != null : !this$certificateAuthorityProductOptionId.equals(other$certificateAuthorityProductOptionId)) {
            return false;
        }
        Product this$product = this.product();
        Product other$product = other.product();
        if (this$product == null ? other$product != null : !((Object)this$product).equals(other$product)) {
            return false;
        }
        TrackingData this$trackingData = this.trackingData();
        TrackingData other$trackingData = other.trackingData();
        if (this$trackingData == null ? other$trackingData != null : !((Object)this$trackingData).equals(other$trackingData)) {
            return false;
        }
        Integer this$priority = this.priority();
        Integer other$priority = other.priority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Boolean this$systemGenerated = this.systemGenerated();
        Boolean other$systemGenerated = other.systemGenerated();
        if (this$systemGenerated == null ? other$systemGenerated != null : !((Object)this$systemGenerated).equals(other$systemGenerated)) {
            return false;
        }
        Date this$creationDate = this.creationDate();
        Date other$creationDate = other.creationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        Date this$modificationDate = this.modificationDate();
        Date other$modificationDate = other.modificationDate();
        if (this$modificationDate == null ? other$modificationDate != null : !((Object)this$modificationDate).equals(other$modificationDate)) {
            return false;
        }
        String this$reason = this.reason();
        String other$reason = other.reason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        List<String> this$subjectCNRegexes = this.subjectCNRegexes();
        List<String> other$subjectCNRegexes = other.subjectCNRegexes();
        if (this$subjectCNRegexes == null ? other$subjectCNRegexes != null : !((Object)this$subjectCNRegexes).equals(other$subjectCNRegexes)) {
            return false;
        }
        List<String> this$subjectORegexes = this.subjectORegexes();
        List<String> other$subjectORegexes = other.subjectORegexes();
        if (this$subjectORegexes == null ? other$subjectORegexes != null : !((Object)this$subjectORegexes).equals(other$subjectORegexes)) {
            return false;
        }
        List<String> this$subjectOURegexes = this.subjectOURegexes();
        List<String> other$subjectOURegexes = other.subjectOURegexes();
        if (this$subjectOURegexes == null ? other$subjectOURegexes != null : !((Object)this$subjectOURegexes).equals(other$subjectOURegexes)) {
            return false;
        }
        List<String> this$subjectSTRegexes = this.subjectSTRegexes();
        List<String> other$subjectSTRegexes = other.subjectSTRegexes();
        if (this$subjectSTRegexes == null ? other$subjectSTRegexes != null : !((Object)this$subjectSTRegexes).equals(other$subjectSTRegexes)) {
            return false;
        }
        List<String> this$subjectLRegexes = this.subjectLRegexes();
        List<String> other$subjectLRegexes = other.subjectLRegexes();
        if (this$subjectLRegexes == null ? other$subjectLRegexes != null : !((Object)this$subjectLRegexes).equals(other$subjectLRegexes)) {
            return false;
        }
        List<String> this$subjectCValues = this.subjectCValues();
        List<String> other$subjectCValues = other.subjectCValues();
        if (this$subjectCValues == null ? other$subjectCValues != null : !((Object)this$subjectCValues).equals(other$subjectCValues)) {
            return false;
        }
        List<String> this$sanDnsNameRegexes = this.sanDnsNameRegexes();
        List<String> other$sanDnsNameRegexes = other.sanDnsNameRegexes();
        if (this$sanDnsNameRegexes == null ? other$sanDnsNameRegexes != null : !((Object)this$sanDnsNameRegexes).equals(other$sanDnsNameRegexes)) {
            return false;
        }
        List<AllowedKeyType> this$keyTypes = this.keyTypes();
        List<AllowedKeyType> other$keyTypes = other.keyTypes();
        if (this$keyTypes == null ? other$keyTypes != null : !((Object)this$keyTypes).equals(other$keyTypes)) {
            return false;
        }
        Boolean this$keyReuse = this.keyReuse();
        Boolean other$keyReuse = other.keyReuse();
        if (this$keyReuse == null ? other$keyReuse != null : !((Object)this$keyReuse).equals(other$keyReuse)) {
            return false;
        }
        RecommendedSettings this$recommendedSettings = this.recommendedSettings();
        RecommendedSettings other$recommendedSettings = other.recommendedSettings();
        if (this$recommendedSettings == null ? other$recommendedSettings != null : !((Object)this$recommendedSettings).equals(other$recommendedSettings)) {
            return false;
        }
        String this$validityPeriod = this.validityPeriod();
        String other$validityPeriod = other.validityPeriod();
        return !(this$validityPeriod == null ? other$validityPeriod != null : !this$validityPeriod.equals(other$validityPeriod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CertificateIssuingTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $companyId = this.companyId();
        result = result * 59 + ($companyId == null ? 43 : $companyId.hashCode());
        String $certificateAuthority = this.certificateAuthority();
        result = result * 59 + ($certificateAuthority == null ? 43 : $certificateAuthority.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $certificateAuthorityAccountId = this.certificateAuthorityAccountId();
        result = result * 59 + ($certificateAuthorityAccountId == null ? 43 : $certificateAuthorityAccountId.hashCode());
        String $certificateAuthorityProductOptionId = this.certificateAuthorityProductOptionId();
        result = result * 59 + ($certificateAuthorityProductOptionId == null ? 43 : $certificateAuthorityProductOptionId.hashCode());
        Product $product = this.product();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        TrackingData $trackingData = this.trackingData();
        result = result * 59 + ($trackingData == null ? 43 : ((Object)$trackingData).hashCode());
        Integer $priority = this.priority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Boolean $systemGenerated = this.systemGenerated();
        result = result * 59 + ($systemGenerated == null ? 43 : ((Object)$systemGenerated).hashCode());
        Date $creationDate = this.creationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        Date $modificationDate = this.modificationDate();
        result = result * 59 + ($modificationDate == null ? 43 : ((Object)$modificationDate).hashCode());
        String $reason = this.reason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        List<String> $subjectCNRegexes = this.subjectCNRegexes();
        result = result * 59 + ($subjectCNRegexes == null ? 43 : ((Object)$subjectCNRegexes).hashCode());
        List<String> $subjectORegexes = this.subjectORegexes();
        result = result * 59 + ($subjectORegexes == null ? 43 : ((Object)$subjectORegexes).hashCode());
        List<String> $subjectOURegexes = this.subjectOURegexes();
        result = result * 59 + ($subjectOURegexes == null ? 43 : ((Object)$subjectOURegexes).hashCode());
        List<String> $subjectSTRegexes = this.subjectSTRegexes();
        result = result * 59 + ($subjectSTRegexes == null ? 43 : ((Object)$subjectSTRegexes).hashCode());
        List<String> $subjectLRegexes = this.subjectLRegexes();
        result = result * 59 + ($subjectLRegexes == null ? 43 : ((Object)$subjectLRegexes).hashCode());
        List<String> $subjectCValues = this.subjectCValues();
        result = result * 59 + ($subjectCValues == null ? 43 : ((Object)$subjectCValues).hashCode());
        List<String> $sanDnsNameRegexes = this.sanDnsNameRegexes();
        result = result * 59 + ($sanDnsNameRegexes == null ? 43 : ((Object)$sanDnsNameRegexes).hashCode());
        List<AllowedKeyType> $keyTypes = this.keyTypes();
        result = result * 59 + ($keyTypes == null ? 43 : ((Object)$keyTypes).hashCode());
        Boolean $keyReuse = this.keyReuse();
        result = result * 59 + ($keyReuse == null ? 43 : ((Object)$keyReuse).hashCode());
        RecommendedSettings $recommendedSettings = this.recommendedSettings();
        result = result * 59 + ($recommendedSettings == null ? 43 : ((Object)$recommendedSettings).hashCode());
        String $validityPeriod = this.validityPeriod();
        result = result * 59 + ($validityPeriod == null ? 43 : $validityPeriod.hashCode());
        return result;
    }

    public String toString() {
        return "CertificateIssuingTemplate(id=" + this.id() + ", companyId=" + this.companyId() + ", certificateAuthority=" + this.certificateAuthority() + ", name=" + this.name() + ", certificateAuthorityAccountId=" + this.certificateAuthorityAccountId() + ", certificateAuthorityProductOptionId=" + this.certificateAuthorityProductOptionId() + ", product=" + this.product() + ", trackingData=" + this.trackingData() + ", priority=" + this.priority() + ", systemGenerated=" + this.systemGenerated() + ", creationDate=" + this.creationDate() + ", modificationDate=" + this.modificationDate() + ", reason=" + this.reason() + ", subjectCNRegexes=" + this.subjectCNRegexes() + ", subjectORegexes=" + this.subjectORegexes() + ", subjectOURegexes=" + this.subjectOURegexes() + ", subjectSTRegexes=" + this.subjectSTRegexes() + ", subjectLRegexes=" + this.subjectLRegexes() + ", subjectCValues=" + this.subjectCValues() + ", sanDnsNameRegexes=" + this.sanDnsNameRegexes() + ", keyTypes=" + this.keyTypes() + ", keyReuse=" + this.keyReuse() + ", recommendedSettings=" + this.recommendedSettings() + ", validityPeriod=" + this.validityPeriod() + ")";
    }

    public static class RecommendedSettingsKey {
        private String type;
        private Integer length;

        public String type() {
            return this.type;
        }

        public Integer length() {
            return this.length;
        }

        public RecommendedSettingsKey type(String type) {
            this.type = type;
            return this;
        }

        public RecommendedSettingsKey length(Integer length) {
            this.length = length;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecommendedSettingsKey)) {
                return false;
            }
            RecommendedSettingsKey other = (RecommendedSettingsKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.type();
            String other$type = other.type();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Integer this$length = this.length();
            Integer other$length = other.length();
            return !(this$length == null ? other$length != null : !((Object)this$length).equals(other$length));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RecommendedSettingsKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.type();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Integer $length = this.length();
            result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
            return result;
        }

        public String toString() {
            return "CertificateIssuingTemplate.RecommendedSettingsKey(type=" + this.type() + ", length=" + this.length() + ")";
        }

        public RecommendedSettingsKey(String type, Integer length) {
            this.type = type;
            this.length = length;
        }

        public RecommendedSettingsKey() {
        }
    }

    public static class RecommendedSettings {
        private String subjectOValue;
        private String subjectOUValue;
        private String subjectSTValue;
        private String subjectLValue;
        private String subjectCValue;
        private RecommendedSettingsKey key;
        private Boolean keyReuse;

        public String subjectOValue() {
            return this.subjectOValue;
        }

        public String subjectOUValue() {
            return this.subjectOUValue;
        }

        public String subjectSTValue() {
            return this.subjectSTValue;
        }

        public String subjectLValue() {
            return this.subjectLValue;
        }

        public String subjectCValue() {
            return this.subjectCValue;
        }

        public RecommendedSettingsKey key() {
            return this.key;
        }

        public Boolean keyReuse() {
            return this.keyReuse;
        }

        public RecommendedSettings subjectOValue(String subjectOValue) {
            this.subjectOValue = subjectOValue;
            return this;
        }

        public RecommendedSettings subjectOUValue(String subjectOUValue) {
            this.subjectOUValue = subjectOUValue;
            return this;
        }

        public RecommendedSettings subjectSTValue(String subjectSTValue) {
            this.subjectSTValue = subjectSTValue;
            return this;
        }

        public RecommendedSettings subjectLValue(String subjectLValue) {
            this.subjectLValue = subjectLValue;
            return this;
        }

        public RecommendedSettings subjectCValue(String subjectCValue) {
            this.subjectCValue = subjectCValue;
            return this;
        }

        public RecommendedSettings key(RecommendedSettingsKey key) {
            this.key = key;
            return this;
        }

        public RecommendedSettings keyReuse(Boolean keyReuse) {
            this.keyReuse = keyReuse;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecommendedSettings)) {
                return false;
            }
            RecommendedSettings other = (RecommendedSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$subjectOValue = this.subjectOValue();
            String other$subjectOValue = other.subjectOValue();
            if (this$subjectOValue == null ? other$subjectOValue != null : !this$subjectOValue.equals(other$subjectOValue)) {
                return false;
            }
            String this$subjectOUValue = this.subjectOUValue();
            String other$subjectOUValue = other.subjectOUValue();
            if (this$subjectOUValue == null ? other$subjectOUValue != null : !this$subjectOUValue.equals(other$subjectOUValue)) {
                return false;
            }
            String this$subjectSTValue = this.subjectSTValue();
            String other$subjectSTValue = other.subjectSTValue();
            if (this$subjectSTValue == null ? other$subjectSTValue != null : !this$subjectSTValue.equals(other$subjectSTValue)) {
                return false;
            }
            String this$subjectLValue = this.subjectLValue();
            String other$subjectLValue = other.subjectLValue();
            if (this$subjectLValue == null ? other$subjectLValue != null : !this$subjectLValue.equals(other$subjectLValue)) {
                return false;
            }
            String this$subjectCValue = this.subjectCValue();
            String other$subjectCValue = other.subjectCValue();
            if (this$subjectCValue == null ? other$subjectCValue != null : !this$subjectCValue.equals(other$subjectCValue)) {
                return false;
            }
            RecommendedSettingsKey this$key = this.key();
            RecommendedSettingsKey other$key = other.key();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            Boolean this$keyReuse = this.keyReuse();
            Boolean other$keyReuse = other.keyReuse();
            return !(this$keyReuse == null ? other$keyReuse != null : !((Object)this$keyReuse).equals(other$keyReuse));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RecommendedSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $subjectOValue = this.subjectOValue();
            result = result * 59 + ($subjectOValue == null ? 43 : $subjectOValue.hashCode());
            String $subjectOUValue = this.subjectOUValue();
            result = result * 59 + ($subjectOUValue == null ? 43 : $subjectOUValue.hashCode());
            String $subjectSTValue = this.subjectSTValue();
            result = result * 59 + ($subjectSTValue == null ? 43 : $subjectSTValue.hashCode());
            String $subjectLValue = this.subjectLValue();
            result = result * 59 + ($subjectLValue == null ? 43 : $subjectLValue.hashCode());
            String $subjectCValue = this.subjectCValue();
            result = result * 59 + ($subjectCValue == null ? 43 : $subjectCValue.hashCode());
            RecommendedSettingsKey $key = this.key();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            Boolean $keyReuse = this.keyReuse();
            result = result * 59 + ($keyReuse == null ? 43 : ((Object)$keyReuse).hashCode());
            return result;
        }

        public String toString() {
            return "CertificateIssuingTemplate.RecommendedSettings(subjectOValue=" + this.subjectOValue() + ", subjectOUValue=" + this.subjectOUValue() + ", subjectSTValue=" + this.subjectSTValue() + ", subjectLValue=" + this.subjectLValue() + ", subjectCValue=" + this.subjectCValue() + ", key=" + this.key() + ", keyReuse=" + this.keyReuse() + ")";
        }

        public RecommendedSettings(String subjectOValue, String subjectOUValue, String subjectSTValue, String subjectLValue, String subjectCValue, RecommendedSettingsKey key, Boolean keyReuse) {
            this.subjectOValue = subjectOValue;
            this.subjectOUValue = subjectOUValue;
            this.subjectSTValue = subjectSTValue;
            this.subjectLValue = subjectLValue;
            this.subjectCValue = subjectCValue;
            this.key = key;
            this.keyReuse = keyReuse;
        }

        public RecommendedSettings() {
        }
    }

    public static class AllowedKeyType {
        private String keyType;
        private List<Integer> keyLengths;

        public String keyType() {
            return this.keyType;
        }

        public List<Integer> keyLengths() {
            return this.keyLengths;
        }

        public AllowedKeyType keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        public AllowedKeyType keyLengths(List<Integer> keyLengths) {
            this.keyLengths = keyLengths;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AllowedKeyType)) {
                return false;
            }
            AllowedKeyType other = (AllowedKeyType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$keyType = this.keyType();
            String other$keyType = other.keyType();
            if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
                return false;
            }
            List<Integer> this$keyLengths = this.keyLengths();
            List<Integer> other$keyLengths = other.keyLengths();
            return !(this$keyLengths == null ? other$keyLengths != null : !((Object)this$keyLengths).equals(other$keyLengths));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AllowedKeyType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $keyType = this.keyType();
            result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
            List<Integer> $keyLengths = this.keyLengths();
            result = result * 59 + ($keyLengths == null ? 43 : ((Object)$keyLengths).hashCode());
            return result;
        }

        public String toString() {
            return "CertificateIssuingTemplate.AllowedKeyType(keyType=" + this.keyType() + ", keyLengths=" + this.keyLengths() + ")";
        }

        public AllowedKeyType(String keyType, List<Integer> keyLengths) {
            this.keyType = keyType;
            this.keyLengths = keyLengths;
        }
    }

    public static class TrackingData {
        private String certificateAuthority;
        private String requesterName;
        private String requesterEmail;
        private String requesterPhone;

        public String certificateAuthority() {
            return this.certificateAuthority;
        }

        public String requesterName() {
            return this.requesterName;
        }

        public String requesterEmail() {
            return this.requesterEmail;
        }

        public String requesterPhone() {
            return this.requesterPhone;
        }

        public TrackingData certificateAuthority(String certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public TrackingData requesterName(String requesterName) {
            this.requesterName = requesterName;
            return this;
        }

        public TrackingData requesterEmail(String requesterEmail) {
            this.requesterEmail = requesterEmail;
            return this;
        }

        public TrackingData requesterPhone(String requesterPhone) {
            this.requesterPhone = requesterPhone;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrackingData)) {
                return false;
            }
            TrackingData other = (TrackingData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateAuthority = this.certificateAuthority();
            String other$certificateAuthority = other.certificateAuthority();
            if (this$certificateAuthority == null ? other$certificateAuthority != null : !this$certificateAuthority.equals(other$certificateAuthority)) {
                return false;
            }
            String this$requesterName = this.requesterName();
            String other$requesterName = other.requesterName();
            if (this$requesterName == null ? other$requesterName != null : !this$requesterName.equals(other$requesterName)) {
                return false;
            }
            String this$requesterEmail = this.requesterEmail();
            String other$requesterEmail = other.requesterEmail();
            if (this$requesterEmail == null ? other$requesterEmail != null : !this$requesterEmail.equals(other$requesterEmail)) {
                return false;
            }
            String this$requesterPhone = this.requesterPhone();
            String other$requesterPhone = other.requesterPhone();
            return !(this$requesterPhone == null ? other$requesterPhone != null : !this$requesterPhone.equals(other$requesterPhone));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TrackingData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateAuthority = this.certificateAuthority();
            result = result * 59 + ($certificateAuthority == null ? 43 : $certificateAuthority.hashCode());
            String $requesterName = this.requesterName();
            result = result * 59 + ($requesterName == null ? 43 : $requesterName.hashCode());
            String $requesterEmail = this.requesterEmail();
            result = result * 59 + ($requesterEmail == null ? 43 : $requesterEmail.hashCode());
            String $requesterPhone = this.requesterPhone();
            result = result * 59 + ($requesterPhone == null ? 43 : $requesterPhone.hashCode());
            return result;
        }

        public String toString() {
            return "CertificateIssuingTemplate.TrackingData(certificateAuthority=" + this.certificateAuthority() + ", requesterName=" + this.requesterName() + ", requesterEmail=" + this.requesterEmail() + ", requesterPhone=" + this.requesterPhone() + ")";
        }

        public TrackingData(String certificateAuthority, String requesterName, String requesterEmail, String requesterPhone) {
            this.certificateAuthority = certificateAuthority;
            this.requesterName = requesterName;
            this.requesterEmail = requesterEmail;
            this.requesterPhone = requesterPhone;
        }

        public TrackingData() {
        }
    }

    public static class Product {
        private String certificateAuthority;
        private String productName;
        private String validityPeriod;
        private String hashAlgorithm;
        private Boolean autoRenew;
        private Integer organizationId;

        public String certificateAuthority() {
            return this.certificateAuthority;
        }

        public String productName() {
            return this.productName;
        }

        public String validityPeriod() {
            return this.validityPeriod;
        }

        public String hashAlgorithm() {
            return this.hashAlgorithm;
        }

        public Boolean autoRenew() {
            return this.autoRenew;
        }

        public Integer organizationId() {
            return this.organizationId;
        }

        public Product certificateAuthority(String certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public Product productName(String productName) {
            this.productName = productName;
            return this;
        }

        public Product validityPeriod(String validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public Product hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public Product autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public Product organizationId(Integer organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Product)) {
                return false;
            }
            Product other = (Product)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateAuthority = this.certificateAuthority();
            String other$certificateAuthority = other.certificateAuthority();
            if (this$certificateAuthority == null ? other$certificateAuthority != null : !this$certificateAuthority.equals(other$certificateAuthority)) {
                return false;
            }
            String this$productName = this.productName();
            String other$productName = other.productName();
            if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
                return false;
            }
            String this$validityPeriod = this.validityPeriod();
            String other$validityPeriod = other.validityPeriod();
            if (this$validityPeriod == null ? other$validityPeriod != null : !this$validityPeriod.equals(other$validityPeriod)) {
                return false;
            }
            String this$hashAlgorithm = this.hashAlgorithm();
            String other$hashAlgorithm = other.hashAlgorithm();
            if (this$hashAlgorithm == null ? other$hashAlgorithm != null : !this$hashAlgorithm.equals(other$hashAlgorithm)) {
                return false;
            }
            Boolean this$autoRenew = this.autoRenew();
            Boolean other$autoRenew = other.autoRenew();
            if (this$autoRenew == null ? other$autoRenew != null : !((Object)this$autoRenew).equals(other$autoRenew)) {
                return false;
            }
            Integer this$organizationId = this.organizationId();
            Integer other$organizationId = other.organizationId();
            return !(this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Product;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateAuthority = this.certificateAuthority();
            result = result * 59 + ($certificateAuthority == null ? 43 : $certificateAuthority.hashCode());
            String $productName = this.productName();
            result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
            String $validityPeriod = this.validityPeriod();
            result = result * 59 + ($validityPeriod == null ? 43 : $validityPeriod.hashCode());
            String $hashAlgorithm = this.hashAlgorithm();
            result = result * 59 + ($hashAlgorithm == null ? 43 : $hashAlgorithm.hashCode());
            Boolean $autoRenew = this.autoRenew();
            result = result * 59 + ($autoRenew == null ? 43 : ((Object)$autoRenew).hashCode());
            Integer $organizationId = this.organizationId();
            result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
            return result;
        }

        public String toString() {
            return "CertificateIssuingTemplate.Product(certificateAuthority=" + this.certificateAuthority() + ", productName=" + this.productName() + ", validityPeriod=" + this.validityPeriod() + ", hashAlgorithm=" + this.hashAlgorithm() + ", autoRenew=" + this.autoRenew() + ", organizationId=" + this.organizationId() + ")";
        }

        public Product(String certificateAuthority, String productName, String validityPeriod, String hashAlgorithm, Boolean autoRenew, Integer organizationId) {
            this.certificateAuthority = certificateAuthority;
            this.productName = productName;
            this.validityPeriod = validityPeriod;
            this.hashAlgorithm = hashAlgorithm;
            this.autoRenew = autoRenew;
            this.organizationId = organizationId;
        }
    }
}

