/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.converter;

import com.venafi.vcert.sdk.policy.api.domain.AttributeLockable;
import com.venafi.vcert.sdk.policy.converter.ToPolicyConverter;
import com.venafi.vcert.sdk.policy.domain.Defaults;
import com.venafi.vcert.sdk.policy.domain.DefaultsKeyPair;
import com.venafi.vcert.sdk.policy.domain.DefaultsSubject;
import com.venafi.vcert.sdk.policy.domain.KeyPair;
import com.venafi.vcert.sdk.policy.domain.Policy;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.policy.domain.Subject;
import com.venafi.vcert.sdk.policy.domain.SubjectAltNames;
import java.util.function.BiConsumer;
import java.util.function.Function;

public abstract class ToPolicyConverterAbstract<T>
implements ToPolicyConverter<T> {
    @Override
    public abstract PolicySpecification convertToPolicy(T var1) throws Exception;

    protected <S> TypePSAToCreate shouldCreateAttribute(S source, Function<S, AttributeLockable> sourceGetter) {
        AttributeLockable attributeLockable = sourceGetter.apply(source);
        if (attributeLockable != null && ((String[])attributeLockable.values()).length > 0) {
            if (attributeLockable.lock()) {
                return TypePSAToCreate.NORMAL;
            }
            return TypePSAToCreate.DEFAULT;
        }
        return TypePSAToCreate.NONE;
    }

    protected <N, P> N getNestedObject(P parent, Function<P, N> getter, BiConsumer<P, N> setter, Class<N> clazz) throws Exception {
        N nested = getter.apply(parent);
        if (nested == null) {
            nested = clazz.newInstance();
            setter.accept(parent, nested);
        }
        return nested;
    }

    protected Policy getPolicyFromPolicySpecification(PolicySpecification policySpecification) throws Exception {
        return this.getNestedObject(policySpecification, PolicySpecification::policy, PolicySpecification::policy, Policy.class);
    }

    protected Subject getSubjectFromPolicy(Policy policy) throws Exception {
        return this.getNestedObject(policy, Policy::subject, Policy::subject, Subject.class);
    }

    protected Subject getSubjectFromPolicySpecification(PolicySpecification policySpecification) throws Exception {
        return this.getSubjectFromPolicy(this.getPolicyFromPolicySpecification(policySpecification));
    }

    protected KeyPair getKeyPairFromPolicy(Policy policy) throws Exception {
        return this.getNestedObject(policy, Policy::keyPair, Policy::keyPair, KeyPair.class);
    }

    protected KeyPair getKeyPairFromPolicySpecification(PolicySpecification policySpecification) throws Exception {
        return this.getKeyPairFromPolicy(this.getPolicyFromPolicySpecification(policySpecification));
    }

    protected SubjectAltNames getSubjectAltNamesFromPolicy(Policy policy) throws Exception {
        return this.getNestedObject(policy, Policy::subjectAltNames, Policy::subjectAltNames, SubjectAltNames.class);
    }

    protected SubjectAltNames getSubjectAltNamesFromPolicySpecification(PolicySpecification policySpecification) throws Exception {
        return this.getSubjectAltNamesFromPolicy(this.getPolicyFromPolicySpecification(policySpecification));
    }

    protected Defaults getDefaultsFromPolicySpecification(PolicySpecification policySpecification) throws Exception {
        return this.getNestedObject(policySpecification, PolicySpecification::defaults, PolicySpecification::defaults, Defaults.class);
    }

    protected DefaultsSubject getSubjectFromDefaults(Defaults defaults) throws Exception {
        return this.getNestedObject(defaults, Defaults::subject, Defaults::subject, DefaultsSubject.class);
    }

    protected DefaultsSubject getDefaultsSubjectFromPolicySpecification(PolicySpecification policySpecification) throws Exception {
        return this.getSubjectFromDefaults(this.getDefaultsFromPolicySpecification(policySpecification));
    }

    protected DefaultsKeyPair getKeyPairFromDefaults(Defaults defaults) throws Exception {
        return this.getNestedObject(defaults, Defaults::keyPair, Defaults::keyPair, DefaultsKeyPair.class);
    }

    protected DefaultsKeyPair getDefaultsKeyPairFromPolicySpecification(PolicySpecification policySpecification) throws Exception {
        return this.getKeyPairFromDefaults(this.getDefaultsFromPolicySpecification(policySpecification));
    }

    public static enum TypePSAToCreate {
        NORMAL,
        DEFAULT,
        NONE;

    }
}

