/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.converter.cloud;

import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import com.venafi.vcert.sdk.policy.api.domain.CloudPolicy;
import com.venafi.vcert.sdk.policy.converter.ToPolicyConverterAbstract;
import com.venafi.vcert.sdk.policy.domain.Policy;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import java.util.ArrayList;
import java.util.List;

public class CloudPolicyToPolicyConverter
extends ToPolicyConverterAbstract<CloudPolicy> {
    private static final String REGEX = "[a-z]{1}[a-z0-9.-]*\\.";
    private static final String REGEX_WITH_WILCARD = "[*a-z]{1}[a-z0-9.-]*\\.";
    public static CloudPolicyToPolicyConverter INSTANCE = new CloudPolicyToPolicyConverter();

    private CloudPolicyToPolicyConverter() {
    }

    @Override
    public PolicySpecification convertToPolicy(CloudPolicy cloudPolicy) throws Exception {
        PolicySpecification policySpecification = new PolicySpecification();
        CertificateIssuingTemplate cit = cloudPolicy.certificateIssuingTemplate();
        policySpecification.name(cit.name());
        this.processPolicy(policySpecification, cloudPolicy);
        this.processDefaults(policySpecification, cloudPolicy);
        return policySpecification;
    }

    private void processPolicy(PolicySpecification policySpecification, CloudPolicy cloudPolicy) throws Exception {
        CertificateIssuingTemplate cit = cloudPolicy.certificateIssuingTemplate();
        this.processDomainsAndWildcard(policySpecification, cit);
        this.processMaxValidDays(policySpecification, cit);
        this.processCertificateAuthority(policySpecification, cloudPolicy.caInfo());
        this.processSubject(policySpecification, cloudPolicy);
        this.processKeyPair(policySpecification, cloudPolicy);
        this.processSubjectAltNames(policySpecification, cloudPolicy);
    }

    private void processDomainsAndWildcard(PolicySpecification policySpecification, CertificateIssuingTemplate cit) throws Exception {
        List<String> subjectCNRegexes = cit.subjectCNRegexes;
        if (subjectCNRegexes != null && subjectCNRegexes.size() > 0 && !subjectCNRegexes.get(0).equals(".*")) {
            Policy policy = this.getPolicyFromPolicySpecification(policySpecification);
            this.processDomains(policy, subjectCNRegexes);
            this.processWildcard(policy, subjectCNRegexes);
        }
    }

    private void processDomains(Policy policy, List<String> subjectCNRegexes) {
        ArrayList<String> domains = new ArrayList<String>();
        for (String domain : subjectCNRegexes) {
            if (domain.startsWith(REGEX_WITH_WILCARD)) {
                domain = domain.substring(REGEX_WITH_WILCARD.length());
            } else if (domain.startsWith(REGEX)) {
                domain = domain.substring(REGEX.length());
            }
            domain = domain.replace("\\.", ".");
            domains.add(domain);
        }
        policy.domains(domains.toArray(new String[0]));
    }

    private void processWildcard(Policy policy, List<String> subjectCNRegexes) {
        boolean wildcardFound = false;
        boolean wildcardNotFound = false;
        for (String subjectCNRegex : subjectCNRegexes) {
            if (subjectCNRegex.startsWith("[*")) {
                wildcardFound = true;
                continue;
            }
            wildcardNotFound = true;
        }
        if (wildcardFound && !wildcardNotFound) {
            policy.wildcardAllowed(true);
        } else if (!wildcardFound && wildcardNotFound) {
            policy.wildcardAllowed(false);
        }
    }

    private void processMaxValidDays(PolicySpecification policySpecification, CertificateIssuingTemplate cit) throws Exception {
        String validityPeriod;
        if (cit.validityPeriod() != null && (validityPeriod = cit.validityPeriod()).matches("P[0-9]*D")) {
            this.getPolicyFromPolicySpecification(policySpecification).maxValidDays(Integer.valueOf(validityPeriod.substring(1, validityPeriod.length() - 1)));
        }
    }

    private void processCertificateAuthority(PolicySpecification policySpecification, CloudPolicy.CAInfo caInfo) throws Exception {
        if (caInfo != null) {
            this.getPolicyFromPolicySpecification(policySpecification).certificateAuthority(caInfo.certificateAuthorityString());
        }
    }

    private void processSubject(PolicySpecification policySpecification, CloudPolicy cloudPolicy) throws Exception {
        CertificateIssuingTemplate cit = cloudPolicy.certificateIssuingTemplate();
        if (cit.subjectORegexes() != null) {
            this.getSubjectFromPolicySpecification(policySpecification).orgs(cit.subjectORegexes.toArray(new String[0]));
        }
        if (cit.subjectOURegexes() != null) {
            this.getSubjectFromPolicySpecification(policySpecification).orgUnits(cit.subjectOURegexes.toArray(new String[0]));
        }
        if (cit.subjectLRegexes() != null) {
            this.getSubjectFromPolicySpecification(policySpecification).localities(cit.subjectLRegexes.toArray(new String[0]));
        }
        if (cit.subjectSTRegexes() != null) {
            this.getSubjectFromPolicySpecification(policySpecification).states(cit.subjectSTRegexes.toArray(new String[0]));
        }
        if (cit.subjectCValues() != null) {
            this.getSubjectFromPolicySpecification(policySpecification).countries(cit.subjectCValues.toArray(new String[0]));
        }
    }

    private void processKeyPair(PolicySpecification policySpecification, CloudPolicy cloudPolicy) throws Exception {
        CertificateIssuingTemplate cit = cloudPolicy.certificateIssuingTemplate();
        if (cit.keyReuse() != null) {
            this.getKeyPairFromPolicySpecification(policySpecification).reuseAllowed(cit.keyReuse());
        }
        if (cit.keyTypes() != null && cit.keyTypes().size() > 0) {
            this.processKeyTypes(policySpecification, cit.keyTypes().get(0));
        }
    }

    private void processKeyTypes(PolicySpecification policySpecification, CertificateIssuingTemplate.AllowedKeyType keyType) throws Exception {
        if (keyType.keyType() != null) {
            String[] keyTypes = new String[]{keyType.keyType()};
            this.getKeyPairFromPolicySpecification(policySpecification).keyTypes(keyTypes);
        }
        if (keyType.keyLengths() != null && keyType.keyLengths().size() > 0) {
            this.getKeyPairFromPolicySpecification(policySpecification).rsaKeySizes(keyType.keyLengths().toArray(new Integer[0]));
        }
    }

    private void processSubjectAltNames(PolicySpecification policySpecification, CloudPolicy cloudPolicy) throws Exception {
        this.processSubjectAltNames(policySpecification, cloudPolicy.certificateIssuingTemplate());
    }

    private void processSubjectAltNames(PolicySpecification policySpecification, CertificateIssuingTemplate cit) throws Exception {
        List<String> subjectCNRegexes = cit.sanDnsNameRegexes();
        if (subjectCNRegexes != null && subjectCNRegexes.size() > 0 && !subjectCNRegexes.get(0).equals(".*")) {
            this.getSubjectAltNamesFromPolicySpecification(policySpecification).dnsAllowed(true);
        }
    }

    private void processDefaults(PolicySpecification policySpecification, CloudPolicy cloudPolicy) throws Exception {
        if (cloudPolicy.certificateIssuingTemplate().recommendedSettings() != null) {
            CertificateIssuingTemplate.RecommendedSettings recommendedSettings = cloudPolicy.certificateIssuingTemplate().recommendedSettings();
            this.processDefaultsSubject(policySpecification, recommendedSettings);
            this.processDefaultsKeyPair(policySpecification, recommendedSettings);
        }
    }

    private void processDefaultsSubject(PolicySpecification policySpecification, CertificateIssuingTemplate.RecommendedSettings recommendedSettings) throws Exception {
        if (recommendedSettings.subjectOValue() != null) {
            this.getDefaultsSubjectFromPolicySpecification(policySpecification).org(recommendedSettings.subjectOValue());
        }
        if (recommendedSettings.subjectOUValue() != null) {
            String[] subjectOUValues = new String[]{recommendedSettings.subjectOUValue()};
            this.getDefaultsSubjectFromPolicySpecification(policySpecification).orgUnits(subjectOUValues);
        }
        if (recommendedSettings.subjectLValue() != null) {
            this.getDefaultsSubjectFromPolicySpecification(policySpecification).locality(recommendedSettings.subjectLValue());
        }
        if (recommendedSettings.subjectSTValue() != null) {
            this.getDefaultsSubjectFromPolicySpecification(policySpecification).state(recommendedSettings.subjectSTValue());
        }
        if (recommendedSettings.subjectCValue() != null) {
            this.getDefaultsSubjectFromPolicySpecification(policySpecification).country(recommendedSettings.subjectCValue());
        }
    }

    private void processDefaultsKeyPair(PolicySpecification policySpecification, CertificateIssuingTemplate.RecommendedSettings recommendedSettings) throws Exception {
        this.processDefaultsKeyType(policySpecification, recommendedSettings);
    }

    private void processDefaultsKeyType(PolicySpecification policySpecification, CertificateIssuingTemplate.RecommendedSettings recommendedSettings) throws Exception {
        if (recommendedSettings.key() != null) {
            if (recommendedSettings.key().type() != null) {
                this.getDefaultsKeyPairFromPolicySpecification(policySpecification).keyType(recommendedSettings.key().type());
            }
            if (recommendedSettings.key().length() != null) {
                this.getDefaultsKeyPairFromPolicySpecification(policySpecification).rsaKeySize(recommendedSettings.key().length());
            }
        }
    }
}

