/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.certificate;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.ChainOption;
import com.venafi.vcert.sdk.certificate.KeyType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class PEMCollection {
    public static final String BOUNCY_CASTLE_ENCRYPTION_ALGORITHM = "AES-128-CBC";
    public static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    public static final String SECRET_KEY_FACTORY_ALGORITHM = "PBKDF-OpenSSL";
    public static final String SECRET_KEY_ALGORITHM = "AES";
    public static final int SECRET_KEY_LENGTH_BITS = 128;
    private X509Certificate certificate;
    private PrivateKey privateKey;
    private String privateKeyPassword;
    private List<X509Certificate> chain = new ArrayList<X509Certificate>();

    public static PEMCollection fromResponse(String body, ChainOption chainOption, PrivateKey privateKey, String privateKeyPassword) throws VCertException {
        PEMCollection pemCollection;
        block16: {
            block15: {
                ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
                PEMParser pemParser = new PEMParser((Reader)new StringReader(body));
                JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
                JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter();
                try {
                    Object object = pemParser.readObject();
                    while (object != null) {
                        if (object instanceof X509CertificateHolder) {
                            X509Certificate certificate = certificateConverter.getCertificate((X509CertificateHolder)object);
                            chain.add(certificate);
                        } else if (object instanceof PEMKeyPair) {
                            privateKey = keyConverter.getPrivateKey(((PEMKeyPair)object).getPrivateKeyInfo());
                        } else if (object instanceof PEMEncryptedKeyPair) {
                            PEMKeyPair keyPair = ((PEMEncryptedKeyPair)object).decryptKeyPair((PEMDecryptorProvider)new BcPEMDecryptorProvider(privateKeyPassword.toCharArray()));
                            privateKey = keyConverter.getPrivateKey(keyPair.getPrivateKeyInfo());
                        }
                        object = pemParser.readObject();
                    }
                }
                catch (IOException | CertificateException e) {
                    throw new VCertException("Unable to parse certificate from response", e);
                }
                if (chain.size() <= 0) break block15;
                switch (chainOption) {
                    case ChainOptionRootFirst: {
                        pemCollection = new PEMCollection();
                        pemCollection.certificate((X509Certificate)chain.get(chain.size() - 1));
                        if (chain.size() > 1 && chainOption != ChainOption.ChainOptionIgnore) {
                            for (int i = 0; i < chain.size() - 1; ++i) {
                                pemCollection.chain().add((X509Certificate)chain.get(i));
                            }
                        }
                        break block16;
                    }
                    default: {
                        pemCollection = new PEMCollection();
                        pemCollection.certificate((X509Certificate)chain.get(0));
                        if (chain.size() > 1 && chainOption != ChainOption.ChainOptionIgnore) {
                            for (int i = 1; i < chain.size(); ++i) {
                                pemCollection.chain().add((X509Certificate)chain.get(i));
                            }
                        }
                        break block16;
                    }
                }
            }
            pemCollection = new PEMCollection();
        }
        pemCollection.privateKey(privateKey);
        pemCollection.privateKeyPassword(privateKeyPassword);
        return pemCollection;
    }

    public String pemCertificate() {
        String pem = null;
        if (!Objects.isNull(this.certificate)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(outputStream));){
                pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", this.certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            pem = new String(outputStream.toByteArray());
        }
        return pem;
    }

    public String pemPrivateKey() {
        if (Objects.isNull(this.privateKey)) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(outputStream));){
            PEMEncryptor encryptor = null;
            if (this.privateKeyPassword != null) {
                encryptor = new JcePEMEncryptorBuilder(BOUNCY_CASTLE_ENCRYPTION_ALGORITHM).build(this.privateKeyPassword.toCharArray());
            }
            JcaMiscPEMGenerator gen = new JcaMiscPEMGenerator((Object)this.privateKey, encryptor);
            pemWriter.writeObject((PemObjectGenerator)gen.generate());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(outputStream.toByteArray());
    }

    public String pemCertificateChain() {
        StringBuilder pem = new StringBuilder();
        if (!Objects.isNull(this.chain)) {
            for (Certificate certificate : this.chain) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(outputStream));){
                    pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificate.getEncoded()));
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                pem.append(new String(outputStream.toByteArray()));
            }
        }
        return pem.toString();
    }

    public byte[] derCertificate() {
        if (Objects.isNull(this.certificate)) {
            return null;
        }
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public RawPrivateKey derPrivateKey() {
        if (Objects.isNull(this.privateKey)) {
            return null;
        }
        try {
            RawPrivateKey result = new RawPrivateKey();
            if (KeyType.from(this.privateKey.getAlgorithm()) == KeyType.RSA) {
                PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)this.privateKey.getEncoded());
                ASN1Primitive privateKeyPKCS1ASN1 = pkInfo.parsePrivateKey().toASN1Primitive();
                result.data = privateKeyPKCS1ASN1.getEncoded();
            } else {
                result.data = this.privateKey.getEncoded();
            }
            if (this.privateKeyPassword == null) {
                return result;
            }
            result.iv = new byte[16];
            new SecureRandom().nextBytes(result.iv);
            SecretKeySpec secretKey = PEMCollection.passwordToCipherSecretKey(this.privateKeyPassword.toCharArray(), result.iv);
            Cipher c = Cipher.getInstance(CIPHER_TRANSFORMATION);
            c.init(1, (Key)secretKey, new IvParameterSpec(result.iv));
            result.data = c.doFinal(result.data);
            return result;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public List<byte[]> derCertificateChain() {
        if (Objects.isNull(this.chain)) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        result.ensureCapacity(this.chain.size());
        for (Certificate certificate : this.chain) {
            try {
                result.add(certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public byte[] toPkcs12(String password) throws PKCSException {
        try {
            SubjectKeyIdentifier pubKeyId = new JcaX509ExtensionUtils().createSubjectKeyIdentifier(this.certificate.getPublicKey());
            OutputEncryptor encOut = new JcePKCSPBEOutputEncryptorBuilder(NISTObjectIdentifiers.id_aes128_CBC).setProvider("BC").build(password.toCharArray());
            ArrayList<PKCS12SafeBag> safeBags = new ArrayList<PKCS12SafeBag>();
            safeBags.ensureCapacity(this.chain.size() + 2);
            safeBags.add(new JcaPKCS12SafeBagBuilder(this.certificate).addBagAttribute(PKCS12SafeBag.localKeyIdAttribute, (ASN1Encodable)pubKeyId).build());
            for (Certificate certificate : this.chain) {
                safeBags.add(new JcaPKCS12SafeBagBuilder((X509Certificate)certificate).build());
            }
            safeBags.add(new JcaPKCS12SafeBagBuilder(this.privateKey, encOut).addBagAttribute(PKCS12SafeBag.localKeyIdAttribute, (ASN1Encodable)pubKeyId).build());
            PKCS12PfxPduBuilder builder = new PKCS12PfxPduBuilder();
            builder.addEncryptedData(new JcePKCSPBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC).setProvider("BC").build(password.toCharArray()), safeBags.toArray(new PKCS12SafeBag[0]));
            PKCS12PfxPdu pKCS12PfxPdu = builder.build((PKCS12MacCalculatorBuilder)new JcePKCS12MacCalculatorBuilder(NISTObjectIdentifiers.id_sha256), password.toCharArray());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(pKCS12PfxPdu.getEncoded("DL"));
            out.close();
            return out.toByteArray();
        }
        catch (IOException | NoSuchAlgorithmException | OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toJks(String password) throws KeyStoreException, CertificateException {
        KeyStore store;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(null, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.add(this.certificate);
        chain.addAll(this.chain);
        store.setKeyEntry("private-key", this.privateKey, password.toCharArray(), chain.toArray(new X509Certificate[0]));
        try {
            store.store(output, password.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return output.toByteArray();
    }

    public static SecretKeySpec passwordToCipherSecretKey(char[] password, byte[] iv) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, iv, 1, 128);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM);
        byte[] key = keyFactory.generateSecret(spec).getEncoded();
        return new SecretKeySpec(key, SECRET_KEY_ALGORITHM);
    }

    public static PrivateKey decryptPKCS8PrivateKey(PEMParser pemParser, String keyPassword) throws IOException, OperatorCreationException, PKCSException {
        PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemParser.readObject();
        InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(keyPassword.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PrivateKeyInfo decryptedPrivateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
        return converter.getPrivateKey(decryptedPrivateKeyInfo);
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public String privateKeyPassword() {
        return this.privateKeyPassword;
    }

    public List<X509Certificate> chain() {
        return this.chain;
    }

    public PEMCollection certificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public PEMCollection privateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public PEMCollection privateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public PEMCollection chain(List<X509Certificate> chain) {
        this.chain = chain;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PEMCollection)) {
            return false;
        }
        PEMCollection other = (PEMCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        X509Certificate this$certificate = this.certificate();
        X509Certificate other$certificate = other.certificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        PrivateKey this$privateKey = this.privateKey();
        PrivateKey other$privateKey = other.privateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$privateKeyPassword = this.privateKeyPassword();
        String other$privateKeyPassword = other.privateKeyPassword();
        if (this$privateKeyPassword == null ? other$privateKeyPassword != null : !this$privateKeyPassword.equals(other$privateKeyPassword)) {
            return false;
        }
        List<X509Certificate> this$chain = this.chain();
        List<X509Certificate> other$chain = other.chain();
        return !(this$chain == null ? other$chain != null : !((Object)this$chain).equals(other$chain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PEMCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        X509Certificate $certificate = this.certificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        PrivateKey $privateKey = this.privateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $privateKeyPassword = this.privateKeyPassword();
        result = result * 59 + ($privateKeyPassword == null ? 43 : $privateKeyPassword.hashCode());
        List<X509Certificate> $chain = this.chain();
        result = result * 59 + ($chain == null ? 43 : ((Object)$chain).hashCode());
        return result;
    }

    public String toString() {
        return "PEMCollection(certificate=" + this.certificate() + ", privateKey=" + this.privateKey() + ", privateKeyPassword=" + this.privateKeyPassword() + ", chain=" + this.chain() + ")";
    }

    public static class RawPrivateKey {
        private byte[] iv;
        private byte[] data;

        public boolean isEncrypted() {
            return this.iv != null;
        }

        public byte[] iv() {
            return this.iv;
        }

        public byte[] data() {
            return this.data;
        }

        public RawPrivateKey iv(byte[] iv) {
            this.iv = iv;
            return this;
        }

        public RawPrivateKey data(byte[] data) {
            this.data = data;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RawPrivateKey)) {
                return false;
            }
            RawPrivateKey other = (RawPrivateKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.iv(), other.iv())) {
                return false;
            }
            return Arrays.equals(this.data(), other.data());
        }

        protected boolean canEqual(Object other) {
            return other instanceof RawPrivateKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.iv());
            result = result * 59 + Arrays.hashCode(this.data());
            return result;
        }

        public String toString() {
            return "PEMCollection.RawPrivateKey(iv=" + Arrays.toString(this.iv()) + ", data=" + Arrays.toString(this.data()) + ")";
        }
    }
}

