/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors;

import com.google.common.annotations.VisibleForTesting;
import com.venafi.vcert.sdk.SignatureAlgorithm;
import com.venafi.vcert.sdk.certificate.EllipticCurve;
import com.venafi.vcert.sdk.certificate.KeyType;
import com.venafi.vcert.sdk.connectors.LockableValue;
import com.venafi.vcert.sdk.connectors.LockableValues;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.endpoint.AllowedKeyConfiguration;
import com.venafi.vcert.sdk.utils.Is;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ServerPolicy {
    private static final transient String allAllowedRegex = ".*";
    public static final transient Function<String, String> addStartEnd = s -> {
        if (!((String)s).startsWith("^")) {
            s = "^" + (String)s;
        }
        if (!((String)s).endsWith("$")) {
            s = (String)s + "$";
        }
        return s;
    };
    private LockableValue<String> certificateAuthority;
    private LockableValue<String> csrGeneration;
    private LockableValue<String> keyGeneration;
    private KeyPair keyPair;
    private LockableValue<String> managementType;
    private boolean privateKeyReuseAllowed;
    private boolean subjAltNameDnsAllowed;
    private boolean subjAltNameEmailAllowed;
    private boolean subjAltNameIpAllowed;
    private boolean subjAltNameUpnAllowed;
    private boolean subjAltNameUriAllowed;
    private Subject subject;
    private boolean uniqueSubjectEnforced;
    private Collection<String> whitelistedDomains;
    private boolean wildcardsAllowed;

    public Policy toPolicy() {
        Function<String, String> escapeOne = s -> addStartEnd.apply(Pattern.quote(s));
        Function<Collection, Collection> escapeCollection = in -> in.stream().map(escapeOne).collect(Collectors.toList());
        Function<LockableValue, Collection> selectValue = in -> {
            if (null == in) {
                return Collections.singleton(allAllowedRegex);
            }
            return in.locked() ? Collections.singleton((String)escapeOne.apply((String)in.value())) : Collections.singleton(allAllowedRegex);
        };
        Function<Boolean, Collection> allOrNothing = bool -> bool != false ? Collections.singleton(allAllowedRegex) : Collections.emptyList();
        Policy policy = new Policy().allowedKeyConfigurations(new ArrayList<AllowedKeyConfiguration>());
        if (Is.blank(this.whitelistedDomains)) {
            policy.subjectCNRegexes(Collections.singleton(allAllowedRegex));
        } else {
            ArrayList<String> subjectCNRegexes = new ArrayList<String>(this.whitelistedDomains.size());
            for (String string : this.whitelistedDomains()) {
                if (this.wildcardsAllowed()) {
                    subjectCNRegexes.add(addStartEnd.apply(allAllowedRegex + Pattern.quote("." + string)));
                    continue;
                }
                subjectCNRegexes.add(escapeOne.apply(string));
            }
            policy.subjectCNRegexes(subjectCNRegexes);
        }
        if (this.subject.organizationalUnit().locked()) {
            policy.subjectOURegexes(escapeCollection.apply(this.subject.organizationalUnit().values()));
        } else {
            policy.subjectOURegexes(Collections.singleton(allAllowedRegex));
        }
        policy.subjectORegexes(selectValue.apply(this.subject.organization()));
        policy.subjectLRegexes(selectValue.apply(this.subject.city()));
        policy.subjectSTRegexes(selectValue.apply(this.subject.state()));
        policy.subjectCRegexes(selectValue.apply(this.subject.country()));
        if (this.subjAltNameDnsAllowed) {
            if (Is.blank(this.whitelistedDomains)) {
                policy.dnsSanRegExs(Collections.singleton(allAllowedRegex));
            } else {
                ArrayList<String> regExs = new ArrayList<String>(this.whitelistedDomains.size());
                for (String string : this.whitelistedDomains) {
                    if (this.wildcardsAllowed) {
                        regExs.add(addStartEnd.apply(allAllowedRegex + Pattern.quote("." + string)));
                        continue;
                    }
                    regExs.add(escapeOne.apply(string));
                }
                policy.dnsSanRegExs(regExs);
            }
        } else {
            policy.dnsSanRegExs(Collections.emptyList());
        }
        policy.ipSanRegExs(allOrNothing.apply(this.subjAltNameIpAllowed));
        policy.emailSanRegExs(allOrNothing.apply(this.subjAltNameEmailAllowed));
        policy.uriSanRegExs(allOrNothing.apply(this.subjAltNameUriAllowed));
        policy.upnSanRegExs(allOrNothing.apply(this.subjAltNameUpnAllowed));
        if (this.keyPair.keyAlgorithm().locked()) {
            KeyType keyType = KeyType.from(this.keyPair.keyAlgorithm().value());
            AllowedKeyConfiguration key = new AllowedKeyConfiguration().keyType(keyType).keySizes(new ArrayList<Integer>());
            if (KeyType.RSA.equals((Object)keyType)) {
                if (this.keyPair.keySize().locked()) {
                    for (Integer keySize : KeyType.allSupportedKeySizes()) {
                        if (keySize < this.keyPair.keySize().value() && this.keyPair.keySize().value() != null) continue;
                        key.keySizes().add(keySize);
                    }
                } else {
                    key.keySizes(KeyType.allSupportedKeySizes());
                }
            } else if (this.keyPair.ellipticCurve().locked()) {
                EllipticCurve ellipticCurve = EllipticCurve.from(this.keyPair.ellipticCurve().value());
                key.keyCurves().add(ellipticCurve);
            } else {
                key.keyCurves(EllipticCurve.allSupportedCures());
            }
            policy.allowedKeyConfigurations().add(key);
        } else {
            policy.allowedKeyConfigurations().add(new AllowedKeyConfiguration().keyType(KeyType.RSA).keySizes(KeyType.allSupportedKeySizes()));
            policy.allowedKeyConfigurations().add(new AllowedKeyConfiguration().keyType(KeyType.ECDSA).keyCurves(EllipticCurve.allSupportedCures()));
        }
        policy.allowWildcards(this.wildcardsAllowed);
        policy.allowKeyReuse(this.privateKeyReuseAllowed);
        return policy;
    }

    public ZoneConfiguration toZoneConfig() {
        return new ZoneConfiguration().customAttributeValues(new HashMap<String, String>()).hashAlgorithm(SignatureAlgorithm.SHA256WithRSA).country(this.subject.country().value()).organization(this.subject.organization().value()).organizationalUnit(this.subject.organizationalUnit().values()).province(this.subject.state().value()).locality(this.subject.city().value());
    }

    public LockableValue<String> certificateAuthority() {
        return this.certificateAuthority;
    }

    public LockableValue<String> csrGeneration() {
        return this.csrGeneration;
    }

    public LockableValue<String> keyGeneration() {
        return this.keyGeneration;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public LockableValue<String> managementType() {
        return this.managementType;
    }

    public boolean privateKeyReuseAllowed() {
        return this.privateKeyReuseAllowed;
    }

    public boolean subjAltNameDnsAllowed() {
        return this.subjAltNameDnsAllowed;
    }

    public boolean subjAltNameEmailAllowed() {
        return this.subjAltNameEmailAllowed;
    }

    public boolean subjAltNameIpAllowed() {
        return this.subjAltNameIpAllowed;
    }

    public boolean subjAltNameUpnAllowed() {
        return this.subjAltNameUpnAllowed;
    }

    public boolean subjAltNameUriAllowed() {
        return this.subjAltNameUriAllowed;
    }

    public Subject subject() {
        return this.subject;
    }

    public boolean uniqueSubjectEnforced() {
        return this.uniqueSubjectEnforced;
    }

    public Collection<String> whitelistedDomains() {
        return this.whitelistedDomains;
    }

    public boolean wildcardsAllowed() {
        return this.wildcardsAllowed;
    }

    public ServerPolicy certificateAuthority(LockableValue<String> certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    public ServerPolicy csrGeneration(LockableValue<String> csrGeneration) {
        this.csrGeneration = csrGeneration;
        return this;
    }

    public ServerPolicy keyGeneration(LockableValue<String> keyGeneration) {
        this.keyGeneration = keyGeneration;
        return this;
    }

    public ServerPolicy keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public ServerPolicy managementType(LockableValue<String> managementType) {
        this.managementType = managementType;
        return this;
    }

    public ServerPolicy privateKeyReuseAllowed(boolean privateKeyReuseAllowed) {
        this.privateKeyReuseAllowed = privateKeyReuseAllowed;
        return this;
    }

    public ServerPolicy subjAltNameDnsAllowed(boolean subjAltNameDnsAllowed) {
        this.subjAltNameDnsAllowed = subjAltNameDnsAllowed;
        return this;
    }

    public ServerPolicy subjAltNameEmailAllowed(boolean subjAltNameEmailAllowed) {
        this.subjAltNameEmailAllowed = subjAltNameEmailAllowed;
        return this;
    }

    public ServerPolicy subjAltNameIpAllowed(boolean subjAltNameIpAllowed) {
        this.subjAltNameIpAllowed = subjAltNameIpAllowed;
        return this;
    }

    public ServerPolicy subjAltNameUpnAllowed(boolean subjAltNameUpnAllowed) {
        this.subjAltNameUpnAllowed = subjAltNameUpnAllowed;
        return this;
    }

    public ServerPolicy subjAltNameUriAllowed(boolean subjAltNameUriAllowed) {
        this.subjAltNameUriAllowed = subjAltNameUriAllowed;
        return this;
    }

    public ServerPolicy subject(Subject subject) {
        this.subject = subject;
        return this;
    }

    public ServerPolicy uniqueSubjectEnforced(boolean uniqueSubjectEnforced) {
        this.uniqueSubjectEnforced = uniqueSubjectEnforced;
        return this;
    }

    public ServerPolicy whitelistedDomains(Collection<String> whitelistedDomains) {
        this.whitelistedDomains = whitelistedDomains;
        return this;
    }

    public ServerPolicy wildcardsAllowed(boolean wildcardsAllowed) {
        this.wildcardsAllowed = wildcardsAllowed;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPolicy)) {
            return false;
        }
        ServerPolicy other = (ServerPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.privateKeyReuseAllowed() != other.privateKeyReuseAllowed()) {
            return false;
        }
        if (this.subjAltNameDnsAllowed() != other.subjAltNameDnsAllowed()) {
            return false;
        }
        if (this.subjAltNameEmailAllowed() != other.subjAltNameEmailAllowed()) {
            return false;
        }
        if (this.subjAltNameIpAllowed() != other.subjAltNameIpAllowed()) {
            return false;
        }
        if (this.subjAltNameUpnAllowed() != other.subjAltNameUpnAllowed()) {
            return false;
        }
        if (this.subjAltNameUriAllowed() != other.subjAltNameUriAllowed()) {
            return false;
        }
        if (this.uniqueSubjectEnforced() != other.uniqueSubjectEnforced()) {
            return false;
        }
        if (this.wildcardsAllowed() != other.wildcardsAllowed()) {
            return false;
        }
        LockableValue<String> this$certificateAuthority = this.certificateAuthority();
        LockableValue<String> other$certificateAuthority = other.certificateAuthority();
        if (this$certificateAuthority == null ? other$certificateAuthority != null : !((Object)this$certificateAuthority).equals(other$certificateAuthority)) {
            return false;
        }
        LockableValue<String> this$csrGeneration = this.csrGeneration();
        LockableValue<String> other$csrGeneration = other.csrGeneration();
        if (this$csrGeneration == null ? other$csrGeneration != null : !((Object)this$csrGeneration).equals(other$csrGeneration)) {
            return false;
        }
        LockableValue<String> this$keyGeneration = this.keyGeneration();
        LockableValue<String> other$keyGeneration = other.keyGeneration();
        if (this$keyGeneration == null ? other$keyGeneration != null : !((Object)this$keyGeneration).equals(other$keyGeneration)) {
            return false;
        }
        KeyPair this$keyPair = this.keyPair();
        KeyPair other$keyPair = other.keyPair();
        if (this$keyPair == null ? other$keyPair != null : !((Object)this$keyPair).equals(other$keyPair)) {
            return false;
        }
        LockableValue<String> this$managementType = this.managementType();
        LockableValue<String> other$managementType = other.managementType();
        if (this$managementType == null ? other$managementType != null : !((Object)this$managementType).equals(other$managementType)) {
            return false;
        }
        Subject this$subject = this.subject();
        Subject other$subject = other.subject();
        if (this$subject == null ? other$subject != null : !((Object)this$subject).equals(other$subject)) {
            return false;
        }
        Collection<String> this$whitelistedDomains = this.whitelistedDomains();
        Collection<String> other$whitelistedDomains = other.whitelistedDomains();
        return !(this$whitelistedDomains == null ? other$whitelistedDomains != null : !((Object)this$whitelistedDomains).equals(other$whitelistedDomains));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.privateKeyReuseAllowed() ? 79 : 97);
        result = result * 59 + (this.subjAltNameDnsAllowed() ? 79 : 97);
        result = result * 59 + (this.subjAltNameEmailAllowed() ? 79 : 97);
        result = result * 59 + (this.subjAltNameIpAllowed() ? 79 : 97);
        result = result * 59 + (this.subjAltNameUpnAllowed() ? 79 : 97);
        result = result * 59 + (this.subjAltNameUriAllowed() ? 79 : 97);
        result = result * 59 + (this.uniqueSubjectEnforced() ? 79 : 97);
        result = result * 59 + (this.wildcardsAllowed() ? 79 : 97);
        LockableValue<String> $certificateAuthority = this.certificateAuthority();
        result = result * 59 + ($certificateAuthority == null ? 43 : ((Object)$certificateAuthority).hashCode());
        LockableValue<String> $csrGeneration = this.csrGeneration();
        result = result * 59 + ($csrGeneration == null ? 43 : ((Object)$csrGeneration).hashCode());
        LockableValue<String> $keyGeneration = this.keyGeneration();
        result = result * 59 + ($keyGeneration == null ? 43 : ((Object)$keyGeneration).hashCode());
        KeyPair $keyPair = this.keyPair();
        result = result * 59 + ($keyPair == null ? 43 : ((Object)$keyPair).hashCode());
        LockableValue<String> $managementType = this.managementType();
        result = result * 59 + ($managementType == null ? 43 : ((Object)$managementType).hashCode());
        Subject $subject = this.subject();
        result = result * 59 + ($subject == null ? 43 : ((Object)$subject).hashCode());
        Collection<String> $whitelistedDomains = this.whitelistedDomains();
        result = result * 59 + ($whitelistedDomains == null ? 43 : ((Object)$whitelistedDomains).hashCode());
        return result;
    }

    public String toString() {
        return "ServerPolicy(certificateAuthority=" + this.certificateAuthority() + ", csrGeneration=" + this.csrGeneration() + ", keyGeneration=" + this.keyGeneration() + ", keyPair=" + this.keyPair() + ", managementType=" + this.managementType() + ", privateKeyReuseAllowed=" + this.privateKeyReuseAllowed() + ", subjAltNameDnsAllowed=" + this.subjAltNameDnsAllowed() + ", subjAltNameEmailAllowed=" + this.subjAltNameEmailAllowed() + ", subjAltNameIpAllowed=" + this.subjAltNameIpAllowed() + ", subjAltNameUpnAllowed=" + this.subjAltNameUpnAllowed() + ", subjAltNameUriAllowed=" + this.subjAltNameUriAllowed() + ", subject=" + this.subject() + ", uniqueSubjectEnforced=" + this.uniqueSubjectEnforced() + ", whitelistedDomains=" + this.whitelistedDomains() + ", wildcardsAllowed=" + this.wildcardsAllowed() + ")";
    }

    public ServerPolicy() {
    }

    public ServerPolicy(LockableValue<String> certificateAuthority, LockableValue<String> csrGeneration, LockableValue<String> keyGeneration, KeyPair keyPair, LockableValue<String> managementType, boolean privateKeyReuseAllowed, boolean subjAltNameDnsAllowed, boolean subjAltNameEmailAllowed, boolean subjAltNameIpAllowed, boolean subjAltNameUpnAllowed, boolean subjAltNameUriAllowed, Subject subject, boolean uniqueSubjectEnforced, Collection<String> whitelistedDomains, boolean wildcardsAllowed) {
        this.certificateAuthority = certificateAuthority;
        this.csrGeneration = csrGeneration;
        this.keyGeneration = keyGeneration;
        this.keyPair = keyPair;
        this.managementType = managementType;
        this.privateKeyReuseAllowed = privateKeyReuseAllowed;
        this.subjAltNameDnsAllowed = subjAltNameDnsAllowed;
        this.subjAltNameEmailAllowed = subjAltNameEmailAllowed;
        this.subjAltNameIpAllowed = subjAltNameIpAllowed;
        this.subjAltNameUpnAllowed = subjAltNameUpnAllowed;
        this.subjAltNameUriAllowed = subjAltNameUriAllowed;
        this.subject = subject;
        this.uniqueSubjectEnforced = uniqueSubjectEnforced;
        this.whitelistedDomains = whitelistedDomains;
        this.wildcardsAllowed = wildcardsAllowed;
    }

    @VisibleForTesting
    public static class Subject {
        private LockableValue<String> city;
        private LockableValue<String> country;
        private LockableValue<String> organization;
        private LockableValues<String> organizationalUnit;
        private LockableValue<String> state;

        public LockableValue<String> city() {
            return this.city;
        }

        public LockableValue<String> country() {
            return this.country;
        }

        public LockableValue<String> organization() {
            return this.organization;
        }

        public LockableValues<String> organizationalUnit() {
            return this.organizationalUnit;
        }

        public LockableValue<String> state() {
            return this.state;
        }

        public Subject city(LockableValue<String> city) {
            this.city = city;
            return this;
        }

        public Subject country(LockableValue<String> country) {
            this.country = country;
            return this;
        }

        public Subject organization(LockableValue<String> organization) {
            this.organization = organization;
            return this;
        }

        public Subject organizationalUnit(LockableValues<String> organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public Subject state(LockableValue<String> state) {
            this.state = state;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subject)) {
                return false;
            }
            Subject other = (Subject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LockableValue<String> this$city = this.city();
            LockableValue<String> other$city = other.city();
            if (this$city == null ? other$city != null : !((Object)this$city).equals(other$city)) {
                return false;
            }
            LockableValue<String> this$country = this.country();
            LockableValue<String> other$country = other.country();
            if (this$country == null ? other$country != null : !((Object)this$country).equals(other$country)) {
                return false;
            }
            LockableValue<String> this$organization = this.organization();
            LockableValue<String> other$organization = other.organization();
            if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
                return false;
            }
            LockableValues<String> this$organizationalUnit = this.organizationalUnit();
            LockableValues<String> other$organizationalUnit = other.organizationalUnit();
            if (this$organizationalUnit == null ? other$organizationalUnit != null : !((Object)this$organizationalUnit).equals(other$organizationalUnit)) {
                return false;
            }
            LockableValue<String> this$state = this.state();
            LockableValue<String> other$state = other.state();
            return !(this$state == null ? other$state != null : !((Object)this$state).equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Subject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LockableValue<String> $city = this.city();
            result = result * 59 + ($city == null ? 43 : ((Object)$city).hashCode());
            LockableValue<String> $country = this.country();
            result = result * 59 + ($country == null ? 43 : ((Object)$country).hashCode());
            LockableValue<String> $organization = this.organization();
            result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
            LockableValues<String> $organizationalUnit = this.organizationalUnit();
            result = result * 59 + ($organizationalUnit == null ? 43 : ((Object)$organizationalUnit).hashCode());
            LockableValue<String> $state = this.state();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            return result;
        }

        public String toString() {
            return "ServerPolicy.Subject(city=" + this.city() + ", country=" + this.country() + ", organization=" + this.organization() + ", organizationalUnit=" + this.organizationalUnit() + ", state=" + this.state() + ")";
        }

        public Subject() {
        }

        public Subject(LockableValue<String> city, LockableValue<String> country, LockableValue<String> organization, LockableValues<String> organizationalUnit, LockableValue<String> state) {
            this.city = city;
            this.country = country;
            this.organization = organization;
            this.organizationalUnit = organizationalUnit;
            this.state = state;
        }
    }

    @VisibleForTesting
    public static class KeyPair {
        private LockableValue<String> keyAlgorithm;
        private LockableValue<Integer> keySize;
        private LockableValue<String> ellipticCurve;

        public LockableValue<String> keyAlgorithm() {
            return this.keyAlgorithm;
        }

        public LockableValue<Integer> keySize() {
            return this.keySize;
        }

        public LockableValue<String> ellipticCurve() {
            return this.ellipticCurve;
        }

        public KeyPair keyAlgorithm(LockableValue<String> keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public KeyPair keySize(LockableValue<Integer> keySize) {
            this.keySize = keySize;
            return this;
        }

        public KeyPair ellipticCurve(LockableValue<String> ellipticCurve) {
            this.ellipticCurve = ellipticCurve;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyPair)) {
                return false;
            }
            KeyPair other = (KeyPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LockableValue<String> this$keyAlgorithm = this.keyAlgorithm();
            LockableValue<String> other$keyAlgorithm = other.keyAlgorithm();
            if (this$keyAlgorithm == null ? other$keyAlgorithm != null : !((Object)this$keyAlgorithm).equals(other$keyAlgorithm)) {
                return false;
            }
            LockableValue<Integer> this$keySize = this.keySize();
            LockableValue<Integer> other$keySize = other.keySize();
            if (this$keySize == null ? other$keySize != null : !((Object)this$keySize).equals(other$keySize)) {
                return false;
            }
            LockableValue<String> this$ellipticCurve = this.ellipticCurve();
            LockableValue<String> other$ellipticCurve = other.ellipticCurve();
            return !(this$ellipticCurve == null ? other$ellipticCurve != null : !((Object)this$ellipticCurve).equals(other$ellipticCurve));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeyPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LockableValue<String> $keyAlgorithm = this.keyAlgorithm();
            result = result * 59 + ($keyAlgorithm == null ? 43 : ((Object)$keyAlgorithm).hashCode());
            LockableValue<Integer> $keySize = this.keySize();
            result = result * 59 + ($keySize == null ? 43 : ((Object)$keySize).hashCode());
            LockableValue<String> $ellipticCurve = this.ellipticCurve();
            result = result * 59 + ($ellipticCurve == null ? 43 : ((Object)$ellipticCurve).hashCode());
            return result;
        }

        public String toString() {
            return "ServerPolicy.KeyPair(keyAlgorithm=" + this.keyAlgorithm() + ", keySize=" + this.keySize() + ", ellipticCurve=" + this.ellipticCurve() + ")";
        }

        public KeyPair(LockableValue<String> keyAlgorithm, LockableValue<Integer> keySize, LockableValue<String> ellipticCurve) {
            this.keyAlgorithm = keyAlgorithm;
            this.keySize = keySize;
            this.ellipticCurve = ellipticCurve;
        }
    }
}

