/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.cloud;

import com.google.common.io.CharStreams;
import com.google.gson.annotations.SerializedName;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.CertificateStatus;
import com.venafi.vcert.sdk.certificate.CsrOriginOption;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.certificate.PEMCollection;
import com.venafi.vcert.sdk.certificate.RenewalRequest;
import com.venafi.vcert.sdk.certificate.RevocationRequest;
import com.venafi.vcert.sdk.certificate.SshCaTemplateRequest;
import com.venafi.vcert.sdk.certificate.SshCertRetrieveDetails;
import com.venafi.vcert.sdk.certificate.SshCertificateRequest;
import com.venafi.vcert.sdk.certificate.SshConfig;
import com.venafi.vcert.sdk.connectors.Connector;
import com.venafi.vcert.sdk.connectors.ConnectorException;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.connectors.cloud.Cloud;
import com.venafi.vcert.sdk.connectors.cloud.CloudConnectorUtils;
import com.venafi.vcert.sdk.connectors.cloud.SealedBoxUtility;
import com.venafi.vcert.sdk.connectors.cloud.domain.Application;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateDetails;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import com.venafi.vcert.sdk.connectors.cloud.domain.EdgeEncryptionKey;
import com.venafi.vcert.sdk.connectors.cloud.domain.UserDetails;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.KeystoreRequest;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;
import com.venafi.vcert.sdk.policy.api.domain.CloudPolicy;
import com.venafi.vcert.sdk.policy.converter.CloudPolicySpecificationConverter;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.utils.VCertUtils;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Strings;

public class CloudConnector
implements Connector {
    private static String APPLICATION_SERVER_TYPE_ID = "784938d1-ef0d-11eb-9461-7bb533ba575b";
    private Cloud cloud;
    private UserDetails user;
    private Authentication auth;
    private String zone;
    private String vendorAndProductName;

    public CloudConnector(Cloud cloud) {
        this.cloud = cloud;
    }

    @Override
    public ConnectorType getType() {
        return ConnectorType.CLOUD;
    }

    @Override
    public void setBaseUrl(String url) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setZone(String zone) {
        this.zone = zone;
    }

    @Override
    public void setVendorAndProductName(String vendorAndProductName) {
        this.vendorAndProductName = vendorAndProductName;
    }

    @Override
    public String getVendorAndProductName() {
        return this.vendorAndProductName;
    }

    @Override
    public void ping() throws VCertException {
        Response response = this.doPing();
        if (response.status() != 200) {
            throw new ConnectorException.CloudPingException(response.status(), response.reason());
        }
    }

    private Response doPing() {
        return this.cloud.ping(this.auth.apiKey());
    }

    @Override
    public void authenticate(Authentication auth) throws VCertException {
        VCertException.throwIfNull(auth, "Failed to authenticate: missing credentials");
        this.auth = auth;
        this.user = this.cloud.authorize(auth.apiKey());
    }

    @Override
    public ZoneConfiguration readZoneConfiguration(String zone) throws VCertException {
        String[] valies = StringUtils.split((String)zone, (String)"\\");
        String appName = valies[0];
        String citAlias = valies[1];
        CertificateIssuingTemplate cit = null;
        Object zoneId = null;
        if (appName == null || appName == "" || citAlias == null || citAlias == "") {
            throw new ConnectorException.ZoneFormatException("The parameters: appName, citAlias or both are empty");
        }
        cit = this.cloud.certificateIssuingTemplateByAppNameAndCitAlias(appName, citAlias, this.auth.apiKey());
        Application app = this.cloud.applicationByName(appName, this.auth.apiKey());
        String appId = app.id();
        ZoneConfiguration zoneConfig = cit.toZoneConfig();
        zoneConfig.policy(cit.toPolicy());
        zoneConfig.zoneId(zone);
        zoneConfig.applicationId(appId);
        zoneConfig.certificateIssuingTemplateId(cit.id());
        return zoneConfig;
    }

    @Override
    public CertificateRequest generateRequest(ZoneConfiguration zoneConfig, CertificateRequest request) throws VCertException {
        switch (request.csrOrigin()) {
            case LocalGeneratedCSR: {
                if (zoneConfig == null) {
                    zoneConfig = this.readZoneConfiguration(this.zone);
                }
                zoneConfig.applyCertificateRequestDefaultSettingsIfNeeded(request);
                zoneConfig.validateCertificateRequest(request);
                request.generatePrivateKey();
                request.generateCSR();
                break;
            }
            case UserProvidedCSR: {
                if (request.csr().length != 0) break;
                throw new ConnectorException.CSRNotProvidedByUserException();
            }
            case ServiceGeneratedCSR: {
                request.csr(null);
                break;
            }
            default: {
                throw new ConnectorException.UnreconigzedCSROriginException(request.csrOrigin());
            }
        }
        return request;
    }

    @Override
    public String requestCertificate(CertificateRequest request, String zone) throws VCertException {
        return this.requestCertificate(request, new ZoneConfiguration().zoneId(zone));
    }

    @Override
    public String requestCertificate(CertificateRequest request, ZoneConfiguration zoneConfiguration) throws VCertException {
        if (StringUtils.isBlank((CharSequence)zoneConfiguration.zoneId())) {
            zoneConfiguration.zoneId(this.zone);
        }
        if (this.user == null || this.user.company() == null) {
            throw new ConnectorException.UserNotAuthenticatedException("Must be authenticated to request a certificate");
        }
        CertificateRequestsPayload payload = this.buildRequestCertificatePayload(request, zoneConfiguration);
        CertificateRequestsResponse response = this.cloud.certificateRequest(this.auth.apiKey(), payload);
        String requestId = response.certificateRequests().get(0).id();
        request.pickupId(requestId);
        return requestId;
    }

    private CertificateRequestsPayload buildRequestCertificatePayload(CertificateRequest request, ZoneConfiguration zoneConfiguration) throws VCertException {
        CertificateRequestsPayload payload = new CertificateRequestsPayload();
        if (CsrOriginOption.ServiceGeneratedCSR == request.csrOrigin()) {
            payload.isVaaSGenerated(true);
            payload.applicationServerTypeId(APPLICATION_SERVER_TYPE_ID);
            PolicySpecification policySpecification = this.getPolicy(zoneConfiguration.zoneId(), false);
            payload.csrAttributes(CloudConnectorUtils.buildCsrAttributes(request, policySpecification));
        } else {
            payload.csr(new String(request.csr()));
        }
        if (request.validityHours() > 0) {
            String validityHours = "PT" + request.validityHours() + "H";
            payload.validityPeriod(validityHours);
        }
        payload.applicationId(zoneConfiguration.applicationId());
        payload.certificateIssuingTemplateId(zoneConfiguration.certificateIssuingTemplateId());
        VCertUtils.addApiClientInformation(payload);
        return payload;
    }

    @Override
    public PEMCollection retrieveCertificate(CertificateRequest request) throws VCertException {
        if (StringUtils.isBlank((CharSequence)request.certId())) {
            this.setCertId(request);
        }
        return this.getCertificateAsPEMCollection(request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setCertId(CertificateRequest request) throws VCertException {
        if (StringUtils.isBlank((CharSequence)request.pickupId())) {
            if (!StringUtils.isNotBlank((CharSequence)request.thumbprint())) throw new ConnectorException.PickupIdOrThumbprintNotSetToGetCertIdException();
            this.setIdentifiersUsingThumbprint(request);
            if (StringUtils.isBlank((CharSequence)request.certId()) && StringUtils.isBlank((CharSequence)request.pickupId())) {
                throw new ConnectorException.UndeterminedCertIdException();
            }
            if (!StringUtils.isBlank((CharSequence)request.certId()) || !StringUtils.isNotBlank((CharSequence)request.pickupId())) return;
            request.certId(this.getCertificateIdFromPickupId(request));
            return;
        } else {
            request.certId(this.getCertificateIdFromPickupId(request));
        }
    }

    private void setIdentifiersUsingThumbprint(CertificateRequest request) throws VCertException {
        String pickupId = null;
        String certId = null;
        Cloud.CertificateSearchResponse certificateSearchResponse = this.searchCertificatesByFingerprint(request.thumbprint());
        if (certificateSearchResponse.certificates().size() == 0) {
            throw new ConnectorException.CertificateNotFoundByThumbprintException(request.thumbprint());
        }
        ArrayList<String> reqIds = new ArrayList<String>();
        boolean isOnlyOneCertificateRequestId = true;
        for (Cloud.Certificate certificate : certificateSearchResponse.certificates()) {
            reqIds.add(certificate.certificateRequestId());
            if (StringUtils.isNotBlank(pickupId) && !pickupId.equals(certificate.certificateRequestId())) {
                isOnlyOneCertificateRequestId = false;
                break;
            }
            if (StringUtils.isNotBlank((CharSequence)certificate.certificateRequestId())) {
                pickupId = certificate.certificateRequestId();
            }
            if (!StringUtils.isNotBlank((CharSequence)certificate.id())) continue;
            certId = certificate.id();
        }
        if (!isOnlyOneCertificateRequestId) {
            throw new ConnectorException.MoreThanOneCertificateRequestIdException(reqIds);
        }
        request.pickupId(pickupId);
        request.certId(certId);
    }

    private String getCertificateIdFromPickupId(CertificateRequest request) throws VCertException {
        CertificateStatus certificateStatus = null;
        Instant startTime = Instant.now();
        while (!"ISSUED".equals((certificateStatus = this.getCertificateStatus(request.pickupId())).status())) {
            if ("FAILED".equals(certificateStatus.status())) {
                throw new ConnectorException.CertificateStatusFailedException(certificateStatus.toString());
            }
            if (Duration.ZERO.equals(request.timeout())) {
                throw new ConnectorException.CertificatePendingException(request.pickupId());
            }
            if (Instant.now().isAfter(startTime.plus(request.timeout()))) {
                throw new ConnectorException.RetrieveCertificateTimeoutException(request.pickupId());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new ConnectorException.AttemptToRetryException(e);
            }
        }
        if (this.user == null || this.user.company() == null) {
            throw new ConnectorException.UserNotAuthenticatedException("Must be authenticated to retieve certificate");
        }
        if (certificateStatus == null) {
            throw new ConnectorException.FailedToRetrieveCertificateStatusException(request.pickupId());
        }
        return certificateStatus.certificateIds().get(0);
    }

    private PEMCollection getCertificateAsPEMCollection(CertificateRequest request) throws VCertException {
        String vaasChainOption = CloudConnectorUtils.getVaaSChainOption(request.chainOption());
        PEMCollection pemCollection = this.getCertificateAsPEMCollection(request, vaasChainOption);
        request.checkCertificate(pemCollection.certificate());
        return pemCollection;
    }

    private PEMCollection getCertificateAsPEMCollection(CertificateRequest request, String vaasChainOption) throws VCertException {
        CertificateDetails certificateDetails = this.cloud.certificateDetails(request.certId(), this.auth.apiKey());
        EdgeEncryptionKey edgeEncryptionKey = this.cloud.retrieveEdgeEncryptionKey(certificateDetails.dekHash(), this.auth.apiKey());
        if (StringUtils.isNotBlank((CharSequence)edgeEncryptionKey.key())) {
            byte[] serverPublicKey = Base64.getDecoder().decode(edgeEncryptionKey.key());
            return this.retrieveCertificateAsPemCollectionFromCSRServiceGenerated(request, serverPublicKey, vaasChainOption);
        }
        return this.retrieveCertificateAsPemCollectionFromCSRProvided(request, vaasChainOption);
    }

    private PEMCollection retrieveCertificateAsPemCollectionFromCSRProvided(CertificateRequest request, String chainOrder) throws VCertException {
        String certificateAsPemString = "";
        Instant startTime = Instant.now();
        while (true) {
            Response response;
            if ((response = this.cloud.retrieveCertificate(request.certId(), this.auth.apiKey(), chainOrder)).status() == 200) {
                try {
                    certificateAsPemString = CharStreams.toString((Readable)response.body().asReader());
                    break;
                }
                catch (IOException e) {
                    throw new ConnectorException.UnableToReadPEMCertificateException(request.certId());
                }
            }
            if (Duration.ZERO.equals(request.timeout())) {
                throw new ConnectorException.CertificatePendingException(request.pickupId());
            }
            if (Instant.now().isAfter(startTime.plus(request.timeout()))) {
                throw new ConnectorException.RetrieveCertificateTimeoutException(request.pickupId());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new ConnectorException.AttemptToRetryException(e);
            }
        }
        return PEMCollection.fromResponse(certificateAsPemString, request.chainOption(), request.privateKey(), request.keyPassword());
    }

    private PEMCollection retrieveCertificateAsPemCollectionFromCSRServiceGenerated(CertificateRequest request, byte[] serverPublicKey, String chainOption) throws VCertException {
        String encodedMessage = null;
        try {
            byte[] cipherText = SealedBoxUtility.cryptoBoxSeal(serverPublicKey, request.keyPassword().getBytes());
            encodedMessage = Base64.getEncoder().encodeToString(cipherText);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        KeystoreRequest keystoreRequest = new KeystoreRequest().exportFormat("PEM").encryptedPrivateKeyPassphrase(encodedMessage).encryptedKeystorePassphrase("").certificateLabel("");
        InputStream keyStoreAsStream = null;
        try {
            Response response = this.cloud.retrieveKeystore(request.certId(), keystoreRequest, this.auth.apiKey());
            keyStoreAsStream = response.body().asInputStream();
        }
        catch (IOException e) {
            throw new VCertException(e);
        }
        return CloudConnectorUtils.getPEMCollectionFromKeyStoreAsStream(keyStoreAsStream, request.chainOption(), request.keyPassword());
    }

    public String certificateAsPem(String requestId) throws VCertException {
        Response response = this.cloud.certificateAsPem(requestId, this.auth.apiKey());
        if (response.status() != 200) {
            throw new VCertException(String.format("Invalid response fetching the certificate via CSR: %s", response.reason()));
        }
        try {
            return CharStreams.toString((Readable)response.body().asReader());
        }
        catch (IOException e) {
            throw new VCertException("Unable to read the PEM certificate");
        }
    }

    private CertificateStatus getCertificateStatus(String requestId) {
        return this.cloud.certificateStatus(requestId, this.auth.apiKey());
    }

    @Override
    public void revokeCertificate(RevocationRequest request) throws VCertException {
        throw new UnsupportedOperationException("not supported by endpoint");
    }

    @Override
    public String renewCertificate(RenewalRequest request) throws VCertException {
        String certificateRequestId = null;
        if (StringUtils.isNotBlank((CharSequence)request.thumbprint())) {
            Cloud.CertificateSearchResponse result = this.searchCertificatesByFingerprint(request.thumbprint());
            Set requestIds = result.certificates().stream().map(c -> c.certificateRequestId()).collect(Collectors.toSet());
            if (requestIds.size() > 1) {
                throw new ConnectorException.MoreThanOneCertificateRequestIdException(request.thumbprint());
            }
            if (requestIds.size() == 0) {
                throw new ConnectorException.CertificateNotFoundByThumbprintException(request.thumbprint());
            }
            certificateRequestId = (String)requestIds.iterator().next();
        } else if (StringUtils.isNotBlank((CharSequence)request.certificateDN())) {
            certificateRequestId = request.certificateDN();
        } else {
            throw new ConnectorException.CertificateDNOrThumbprintWasNotProvidedException();
        }
        CertificateStatus status = this.cloud.certificateStatus(certificateRequestId, this.auth.apiKey());
        String certificateId = status.certificateIds().get(0);
        CertificateDetails certDetails = this.cloud.certificateDetails(certificateId, this.auth.apiKey());
        if (!certDetails.certificateRequestId().equals(certificateRequestId)) {
            StringBuilder errorStr = new StringBuilder();
            errorStr.append("Certificate under requestId %s ");
            errorStr.append(StringUtils.isNotBlank((CharSequence)request.thumbprint()) ? String.format("with thumbprint %s ", request.thumbprint()) : "");
            errorStr.append("is not the latest under ManagedCertificateId %s. The latest request is %s. ");
            errorStr.append("This error may happen when revoked certificate is requested to be renewed.");
            throw new VCertException(String.format(errorStr.toString(), certificateRequestId, certDetails.id(), certDetails.certificateRequestId()));
        }
        CertificateRequestsPayload certificateRequest = new CertificateRequestsPayload();
        certificateRequest.existingCertificateId(certDetails.id());
        certificateRequest.applicationId(status.applicationId());
        certificateRequest.certificateIssuingTemplateId(status.certificateIssuingTemplateId());
        VCertUtils.addApiClientInformation(certificateRequest);
        certificateRequest.reuseCSR(!Objects.nonNull(request.request()) || request.request().csr().length <= 0);
        if (certificateRequest.reuseCSR) {
            throw new ConnectorException.CSRNotProvidedException();
        }
        certificateRequest.csr(Strings.fromByteArray((byte[])request.request().csr()));
        CertificateRequestsResponse response = this.cloud.certificateRequest(this.auth.apiKey(), certificateRequest);
        return response.certificateRequests().get(0).id();
    }

    @Override
    public ImportResponse importCertificate(ImportRequest request) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public Policy readPolicyConfiguration(String zone) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public void setPolicy(String policyName, PolicySpecification policySpecification) throws VCertException {
        try {
            CloudPolicy cloudPolicy = (CloudPolicy)CloudPolicySpecificationConverter.INSTANCE.convertFromPolicySpecification(policySpecification);
            CloudConnectorUtils.setCit(policyName, cloudPolicy.certificateIssuingTemplate(), cloudPolicy.caInfo(), this.auth.apiKey(), this.cloud);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
    }

    @Override
    public PolicySpecification getPolicy(String policyName) throws VCertException {
        return this.getPolicy(policyName, true);
    }

    private PolicySpecification getPolicy(String policyName, boolean removeRegexFromSubjectCN) throws VCertException {
        PolicySpecification policySpecification;
        try {
            CloudPolicy cloudPolicy = CloudConnectorUtils.getCloudPolicy(policyName, this.auth.apiKey(), this.cloud);
            cloudPolicy.removeRegexesFromSubjectCN(removeRegexFromSubjectCN);
            policySpecification = CloudPolicySpecificationConverter.INSTANCE.convertToPolicySpecification(cloudPolicy);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        return policySpecification;
    }

    @Override
    public String requestSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public SshCertRetrieveDetails retrieveSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @Override
    public SshConfig retrieveSshConfig(SshCaTemplateRequest sshCaTemplateRequest) throws VCertException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    private Cloud.CertificateSearchResponse searchCertificates(Cloud.SearchRequest searchRequest) {
        return this.cloud.searchCertificates(this.auth.apiKey(), searchRequest);
    }

    private Cloud.CertificateSearchResponse searchCertificatesByFingerprint(String fingerprint) {
        String cleanFingerprint = fingerprint.replaceAll(":", "").replaceAll("/.", "");
        return this.searchCertificates(Cloud.SearchRequest.findByFingerPrint(cleanFingerprint));
    }

    private String[] parseZoneIdentifiers(String zone) throws VCertException {
        try {
            UUID.fromString(zone);
            return new String[]{zone, null, null};
        }
        catch (IllegalArgumentException iae) {
            String[] zoneParsed = zone.split(Pattern.quote("\\"));
            if (zoneParsed.length != 2) {
                throw new VCertException(String.format("Invalid zone ID or path. We expect UUID or 'ProjectName\\ZoneName', but we got '%s'.", zone));
            }
            if (StringUtils.isBlank((CharSequence)zoneParsed[0])) {
                throw new VCertException(String.format("Unable to get Project Name from '%s'", zone));
            }
            if (StringUtils.isBlank((CharSequence)zoneParsed[1])) {
                throw new VCertException(String.format("Unable to get Zone Name from '%s'", zone));
            }
            return new String[]{null, zoneParsed[0], zoneParsed[1]};
        }
    }

    public UserDetails user() {
        return this.user;
    }

    public String vendorAndProductName() {
        return this.vendorAndProductName;
    }

    public static class SubjectAlternativeNamesByType {
        private String[] dnsNames;

        public String[] dnsNames() {
            return this.dnsNames;
        }

        public SubjectAlternativeNamesByType dnsNames(String[] dnsNames) {
            this.dnsNames = dnsNames;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubjectAlternativeNamesByType)) {
                return false;
            }
            SubjectAlternativeNamesByType other = (SubjectAlternativeNamesByType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.dnsNames(), other.dnsNames());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubjectAlternativeNamesByType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.dnsNames());
            return result;
        }

        public String toString() {
            return "CloudConnector.SubjectAlternativeNamesByType(dnsNames=" + Arrays.deepToString(this.dnsNames()) + ")";
        }
    }

    public static class CsrAttributes {
        private String commonName;
        private String organization;
        private String[] organizationalUnits;
        private String locality;
        private String state;
        private String country;
        private SubjectAlternativeNamesByType subjectAlternativeNamesByType;

        public String commonName() {
            return this.commonName;
        }

        public String organization() {
            return this.organization;
        }

        public String[] organizationalUnits() {
            return this.organizationalUnits;
        }

        public String locality() {
            return this.locality;
        }

        public String state() {
            return this.state;
        }

        public String country() {
            return this.country;
        }

        public SubjectAlternativeNamesByType subjectAlternativeNamesByType() {
            return this.subjectAlternativeNamesByType;
        }

        public CsrAttributes commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public CsrAttributes organization(String organization) {
            this.organization = organization;
            return this;
        }

        public CsrAttributes organizationalUnits(String[] organizationalUnits) {
            this.organizationalUnits = organizationalUnits;
            return this;
        }

        public CsrAttributes locality(String locality) {
            this.locality = locality;
            return this;
        }

        public CsrAttributes state(String state) {
            this.state = state;
            return this;
        }

        public CsrAttributes country(String country) {
            this.country = country;
            return this;
        }

        public CsrAttributes subjectAlternativeNamesByType(SubjectAlternativeNamesByType subjectAlternativeNamesByType) {
            this.subjectAlternativeNamesByType = subjectAlternativeNamesByType;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CsrAttributes)) {
                return false;
            }
            CsrAttributes other = (CsrAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$commonName = this.commonName();
            String other$commonName = other.commonName();
            if (this$commonName == null ? other$commonName != null : !this$commonName.equals(other$commonName)) {
                return false;
            }
            String this$organization = this.organization();
            String other$organization = other.organization();
            if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
                return false;
            }
            if (!Arrays.deepEquals(this.organizationalUnits(), other.organizationalUnits())) {
                return false;
            }
            String this$locality = this.locality();
            String other$locality = other.locality();
            if (this$locality == null ? other$locality != null : !this$locality.equals(other$locality)) {
                return false;
            }
            String this$state = this.state();
            String other$state = other.state();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$country = this.country();
            String other$country = other.country();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            SubjectAlternativeNamesByType this$subjectAlternativeNamesByType = this.subjectAlternativeNamesByType();
            SubjectAlternativeNamesByType other$subjectAlternativeNamesByType = other.subjectAlternativeNamesByType();
            return !(this$subjectAlternativeNamesByType == null ? other$subjectAlternativeNamesByType != null : !((Object)this$subjectAlternativeNamesByType).equals(other$subjectAlternativeNamesByType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CsrAttributes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $commonName = this.commonName();
            result = result * 59 + ($commonName == null ? 43 : $commonName.hashCode());
            String $organization = this.organization();
            result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.organizationalUnits());
            String $locality = this.locality();
            result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
            String $state = this.state();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $country = this.country();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            SubjectAlternativeNamesByType $subjectAlternativeNamesByType = this.subjectAlternativeNamesByType();
            result = result * 59 + ($subjectAlternativeNamesByType == null ? 43 : ((Object)$subjectAlternativeNamesByType).hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.CsrAttributes(commonName=" + this.commonName() + ", organization=" + this.organization() + ", organizationalUnits=" + Arrays.deepToString(this.organizationalUnits()) + ", locality=" + this.locality() + ", state=" + this.state() + ", country=" + this.country() + ", subjectAlternativeNamesByType=" + this.subjectAlternativeNamesByType() + ")";
        }
    }

    public static class ApiClientInformation {
        String type;
        String identifier;

        public String type() {
            return this.type;
        }

        public String identifier() {
            return this.identifier;
        }

        public ApiClientInformation type(String type) {
            this.type = type;
            return this;
        }

        public ApiClientInformation identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiClientInformation)) {
                return false;
            }
            ApiClientInformation other = (ApiClientInformation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.type();
            String other$type = other.type();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$identifier = this.identifier();
            String other$identifier = other.identifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiClientInformation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.type();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $identifier = this.identifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.ApiClientInformation(type=" + this.type() + ", identifier=" + this.identifier() + ")";
        }
    }

    static class CertificateRequestsResponseData {
        private String id;
        private String zoneId;
        private String status;
        private String subjectDN;
        private boolean generatedKey;
        private boolean defaultKeyPassword;
        private Collection<String> certificateInstanceIds;
        private OffsetDateTime creationDate;
        private String pem;
        private String der;

        public String id() {
            return this.id;
        }

        public String zoneId() {
            return this.zoneId;
        }

        public String status() {
            return this.status;
        }

        public String subjectDN() {
            return this.subjectDN;
        }

        public boolean generatedKey() {
            return this.generatedKey;
        }

        public boolean defaultKeyPassword() {
            return this.defaultKeyPassword;
        }

        public Collection<String> certificateInstanceIds() {
            return this.certificateInstanceIds;
        }

        public OffsetDateTime creationDate() {
            return this.creationDate;
        }

        public String pem() {
            return this.pem;
        }

        public String der() {
            return this.der;
        }

        public CertificateRequestsResponseData id(String id) {
            this.id = id;
            return this;
        }

        public CertificateRequestsResponseData zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public CertificateRequestsResponseData status(String status) {
            this.status = status;
            return this;
        }

        public CertificateRequestsResponseData subjectDN(String subjectDN) {
            this.subjectDN = subjectDN;
            return this;
        }

        public CertificateRequestsResponseData generatedKey(boolean generatedKey) {
            this.generatedKey = generatedKey;
            return this;
        }

        public CertificateRequestsResponseData defaultKeyPassword(boolean defaultKeyPassword) {
            this.defaultKeyPassword = defaultKeyPassword;
            return this;
        }

        public CertificateRequestsResponseData certificateInstanceIds(Collection<String> certificateInstanceIds) {
            this.certificateInstanceIds = certificateInstanceIds;
            return this;
        }

        public CertificateRequestsResponseData creationDate(OffsetDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public CertificateRequestsResponseData pem(String pem) {
            this.pem = pem;
            return this;
        }

        public CertificateRequestsResponseData der(String der) {
            this.der = der;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsResponseData)) {
                return false;
            }
            CertificateRequestsResponseData other = (CertificateRequestsResponseData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.generatedKey() != other.generatedKey()) {
                return false;
            }
            if (this.defaultKeyPassword() != other.defaultKeyPassword()) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$zoneId = this.zoneId();
            String other$zoneId = other.zoneId();
            if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
                return false;
            }
            String this$status = this.status();
            String other$status = other.status();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$subjectDN = this.subjectDN();
            String other$subjectDN = other.subjectDN();
            if (this$subjectDN == null ? other$subjectDN != null : !this$subjectDN.equals(other$subjectDN)) {
                return false;
            }
            Collection<String> this$certificateInstanceIds = this.certificateInstanceIds();
            Collection<String> other$certificateInstanceIds = other.certificateInstanceIds();
            if (this$certificateInstanceIds == null ? other$certificateInstanceIds != null : !((Object)this$certificateInstanceIds).equals(other$certificateInstanceIds)) {
                return false;
            }
            OffsetDateTime this$creationDate = this.creationDate();
            OffsetDateTime other$creationDate = other.creationDate();
            if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
                return false;
            }
            String this$pem = this.pem();
            String other$pem = other.pem();
            if (this$pem == null ? other$pem != null : !this$pem.equals(other$pem)) {
                return false;
            }
            String this$der = this.der();
            String other$der = other.der();
            return !(this$der == null ? other$der != null : !this$der.equals(other$der));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsResponseData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.generatedKey() ? 79 : 97);
            result = result * 59 + (this.defaultKeyPassword() ? 79 : 97);
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $zoneId = this.zoneId();
            result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
            String $status = this.status();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $subjectDN = this.subjectDN();
            result = result * 59 + ($subjectDN == null ? 43 : $subjectDN.hashCode());
            Collection<String> $certificateInstanceIds = this.certificateInstanceIds();
            result = result * 59 + ($certificateInstanceIds == null ? 43 : ((Object)$certificateInstanceIds).hashCode());
            OffsetDateTime $creationDate = this.creationDate();
            result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
            String $pem = this.pem();
            result = result * 59 + ($pem == null ? 43 : $pem.hashCode());
            String $der = this.der();
            result = result * 59 + ($der == null ? 43 : $der.hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.CertificateRequestsResponseData(id=" + this.id() + ", zoneId=" + this.zoneId() + ", status=" + this.status() + ", subjectDN=" + this.subjectDN() + ", generatedKey=" + this.generatedKey() + ", defaultKeyPassword=" + this.defaultKeyPassword() + ", certificateInstanceIds=" + this.certificateInstanceIds() + ", creationDate=" + this.creationDate() + ", pem=" + this.pem() + ", der=" + this.der() + ")";
        }
    }

    public static class CertificateRequestsResponse {
        private List<CertificateRequestsResponseData> certificateRequests;

        public List<CertificateRequestsResponseData> certificateRequests() {
            return this.certificateRequests;
        }

        public CertificateRequestsResponse certificateRequests(List<CertificateRequestsResponseData> certificateRequests) {
            this.certificateRequests = certificateRequests;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsResponse)) {
                return false;
            }
            CertificateRequestsResponse other = (CertificateRequestsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CertificateRequestsResponseData> this$certificateRequests = this.certificateRequests();
            List<CertificateRequestsResponseData> other$certificateRequests = other.certificateRequests();
            return !(this$certificateRequests == null ? other$certificateRequests != null : !((Object)this$certificateRequests).equals(other$certificateRequests));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CertificateRequestsResponseData> $certificateRequests = this.certificateRequests();
            result = result * 59 + ($certificateRequests == null ? 43 : ((Object)$certificateRequests).hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.CertificateRequestsResponse(certificateRequests=" + this.certificateRequests() + ")";
        }
    }

    public static class CertificateRequestsPayload {
        @SerializedName(value="certificateSigningRequest")
        private String csr;
        private String zoneId;
        private String existingManagedCertificateId;
        private boolean reuseCSR;
        private String validityPeriod;
        private String applicationId;
        private String certificateIssuingTemplateId;
        private String existingCertificateId;
        private ApiClientInformation apiClientInformation;
        private boolean isVaaSGenerated;
        private CsrAttributes csrAttributes;
        private String applicationServerTypeId;

        public String csr() {
            return this.csr;
        }

        public String zoneId() {
            return this.zoneId;
        }

        public String existingManagedCertificateId() {
            return this.existingManagedCertificateId;
        }

        public boolean reuseCSR() {
            return this.reuseCSR;
        }

        public String validityPeriod() {
            return this.validityPeriod;
        }

        public String applicationId() {
            return this.applicationId;
        }

        public String certificateIssuingTemplateId() {
            return this.certificateIssuingTemplateId;
        }

        public String existingCertificateId() {
            return this.existingCertificateId;
        }

        public ApiClientInformation apiClientInformation() {
            return this.apiClientInformation;
        }

        public boolean isVaaSGenerated() {
            return this.isVaaSGenerated;
        }

        public CsrAttributes csrAttributes() {
            return this.csrAttributes;
        }

        public String applicationServerTypeId() {
            return this.applicationServerTypeId;
        }

        public CertificateRequestsPayload csr(String csr) {
            this.csr = csr;
            return this;
        }

        public CertificateRequestsPayload zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public CertificateRequestsPayload existingManagedCertificateId(String existingManagedCertificateId) {
            this.existingManagedCertificateId = existingManagedCertificateId;
            return this;
        }

        public CertificateRequestsPayload reuseCSR(boolean reuseCSR) {
            this.reuseCSR = reuseCSR;
            return this;
        }

        public CertificateRequestsPayload validityPeriod(String validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public CertificateRequestsPayload applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CertificateRequestsPayload certificateIssuingTemplateId(String certificateIssuingTemplateId) {
            this.certificateIssuingTemplateId = certificateIssuingTemplateId;
            return this;
        }

        public CertificateRequestsPayload existingCertificateId(String existingCertificateId) {
            this.existingCertificateId = existingCertificateId;
            return this;
        }

        public CertificateRequestsPayload apiClientInformation(ApiClientInformation apiClientInformation) {
            this.apiClientInformation = apiClientInformation;
            return this;
        }

        public CertificateRequestsPayload isVaaSGenerated(boolean isVaaSGenerated) {
            this.isVaaSGenerated = isVaaSGenerated;
            return this;
        }

        public CertificateRequestsPayload csrAttributes(CsrAttributes csrAttributes) {
            this.csrAttributes = csrAttributes;
            return this;
        }

        public CertificateRequestsPayload applicationServerTypeId(String applicationServerTypeId) {
            this.applicationServerTypeId = applicationServerTypeId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsPayload)) {
                return false;
            }
            CertificateRequestsPayload other = (CertificateRequestsPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.reuseCSR() != other.reuseCSR()) {
                return false;
            }
            if (this.isVaaSGenerated() != other.isVaaSGenerated()) {
                return false;
            }
            String this$csr = this.csr();
            String other$csr = other.csr();
            if (this$csr == null ? other$csr != null : !this$csr.equals(other$csr)) {
                return false;
            }
            String this$zoneId = this.zoneId();
            String other$zoneId = other.zoneId();
            if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
                return false;
            }
            String this$existingManagedCertificateId = this.existingManagedCertificateId();
            String other$existingManagedCertificateId = other.existingManagedCertificateId();
            if (this$existingManagedCertificateId == null ? other$existingManagedCertificateId != null : !this$existingManagedCertificateId.equals(other$existingManagedCertificateId)) {
                return false;
            }
            String this$validityPeriod = this.validityPeriod();
            String other$validityPeriod = other.validityPeriod();
            if (this$validityPeriod == null ? other$validityPeriod != null : !this$validityPeriod.equals(other$validityPeriod)) {
                return false;
            }
            String this$applicationId = this.applicationId();
            String other$applicationId = other.applicationId();
            if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
                return false;
            }
            String this$certificateIssuingTemplateId = this.certificateIssuingTemplateId();
            String other$certificateIssuingTemplateId = other.certificateIssuingTemplateId();
            if (this$certificateIssuingTemplateId == null ? other$certificateIssuingTemplateId != null : !this$certificateIssuingTemplateId.equals(other$certificateIssuingTemplateId)) {
                return false;
            }
            String this$existingCertificateId = this.existingCertificateId();
            String other$existingCertificateId = other.existingCertificateId();
            if (this$existingCertificateId == null ? other$existingCertificateId != null : !this$existingCertificateId.equals(other$existingCertificateId)) {
                return false;
            }
            ApiClientInformation this$apiClientInformation = this.apiClientInformation();
            ApiClientInformation other$apiClientInformation = other.apiClientInformation();
            if (this$apiClientInformation == null ? other$apiClientInformation != null : !((Object)this$apiClientInformation).equals(other$apiClientInformation)) {
                return false;
            }
            CsrAttributes this$csrAttributes = this.csrAttributes();
            CsrAttributes other$csrAttributes = other.csrAttributes();
            if (this$csrAttributes == null ? other$csrAttributes != null : !((Object)this$csrAttributes).equals(other$csrAttributes)) {
                return false;
            }
            String this$applicationServerTypeId = this.applicationServerTypeId();
            String other$applicationServerTypeId = other.applicationServerTypeId();
            return !(this$applicationServerTypeId == null ? other$applicationServerTypeId != null : !this$applicationServerTypeId.equals(other$applicationServerTypeId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsPayload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.reuseCSR() ? 79 : 97);
            result = result * 59 + (this.isVaaSGenerated() ? 79 : 97);
            String $csr = this.csr();
            result = result * 59 + ($csr == null ? 43 : $csr.hashCode());
            String $zoneId = this.zoneId();
            result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
            String $existingManagedCertificateId = this.existingManagedCertificateId();
            result = result * 59 + ($existingManagedCertificateId == null ? 43 : $existingManagedCertificateId.hashCode());
            String $validityPeriod = this.validityPeriod();
            result = result * 59 + ($validityPeriod == null ? 43 : $validityPeriod.hashCode());
            String $applicationId = this.applicationId();
            result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
            String $certificateIssuingTemplateId = this.certificateIssuingTemplateId();
            result = result * 59 + ($certificateIssuingTemplateId == null ? 43 : $certificateIssuingTemplateId.hashCode());
            String $existingCertificateId = this.existingCertificateId();
            result = result * 59 + ($existingCertificateId == null ? 43 : $existingCertificateId.hashCode());
            ApiClientInformation $apiClientInformation = this.apiClientInformation();
            result = result * 59 + ($apiClientInformation == null ? 43 : ((Object)$apiClientInformation).hashCode());
            CsrAttributes $csrAttributes = this.csrAttributes();
            result = result * 59 + ($csrAttributes == null ? 43 : ((Object)$csrAttributes).hashCode());
            String $applicationServerTypeId = this.applicationServerTypeId();
            result = result * 59 + ($applicationServerTypeId == null ? 43 : $applicationServerTypeId.hashCode());
            return result;
        }

        public String toString() {
            return "CloudConnector.CertificateRequestsPayload(csr=" + this.csr() + ", zoneId=" + this.zoneId() + ", existingManagedCertificateId=" + this.existingManagedCertificateId() + ", reuseCSR=" + this.reuseCSR() + ", validityPeriod=" + this.validityPeriod() + ", applicationId=" + this.applicationId() + ", certificateIssuingTemplateId=" + this.certificateIssuingTemplateId() + ", existingCertificateId=" + this.existingCertificateId() + ", apiClientInformation=" + this.apiClientInformation() + ", isVaaSGenerated=" + this.isVaaSGenerated() + ", csrAttributes=" + this.csrAttributes() + ", applicationServerTypeId=" + this.applicationServerTypeId() + ")";
        }
    }
}

