/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.cloud;

import com.iwebpp.crypto.TweetNaclFast;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.bouncycastle.crypto.digests.Blake2bDigest;

public class SealedBoxUtility {
    public static final int CRYPTO_BOX_NONCEBYTES = 24;

    public static byte[] cryptoBoxSeal(byte[] receiverPubKey, byte[] clearText) throws GeneralSecurityException {
        TweetNaclFast.Box.KeyPair ephkeypair = TweetNaclFast.Box.keyPair();
        byte[] nonce = SealedBoxUtility.cryptoBoxSealNonce(ephkeypair.getPublicKey(), receiverPubKey);
        TweetNaclFast.Box box = new TweetNaclFast.Box(receiverPubKey, ephkeypair.getSecretKey());
        byte[] ciphertext = box.box(clearText, nonce);
        if (ciphertext == null) {
            throw new GeneralSecurityException("Could not create the crypto box");
        }
        byte[] sealedbox = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byteArrayOutputStream.write(ephkeypair.getPublicKey());
            byteArrayOutputStream.write(ciphertext);
            sealedbox = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Could not create the sealed crypto box", e);
        }
        return sealedbox;
    }

    public static byte[] cryptoBoxSealNonce(byte[] senderpk, byte[] mypk) {
        Blake2bDigest blake2b = new Blake2bDigest(192);
        blake2b.update(senderpk, 0, senderpk.length);
        blake2b.update(mypk, 0, mypk.length);
        byte[] nonce = new byte[24];
        blake2b.doFinal(nonce, 0);
        if (nonce == null || nonce.length != 24) {
            throw new IllegalArgumentException("Blake2b hashing failed");
        }
        return nonce;
    }
}

