/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.certificate;

import com.google.common.annotations.VisibleForTesting;
import com.venafi.vcert.sdk.SignatureAlgorithm;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.ChainOption;
import com.venafi.vcert.sdk.certificate.CsrOriginOption;
import com.venafi.vcert.sdk.certificate.CustomField;
import com.venafi.vcert.sdk.certificate.EllipticCurve;
import com.venafi.vcert.sdk.certificate.KeyType;
import com.venafi.vcert.sdk.certificate.PublicKeyAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemReader;

public class CertificateRequest {
    private PKIXName subject;
    private Collection<String> dnsNames;
    private Collection<String> emailAddresses;
    private Collection<InetAddress> ipAddresses;
    private Collection<AttributeTypeAndValueSET> attributes;
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.UnknownSignatureAlgorithm;
    private String friendlyName;
    private KeyType keyType;
    private int keyLength;
    private EllipticCurve keyCurve;
    private byte[] csr;
    private KeyPair keyPair;
    private CsrOriginOption csrOrigin = CsrOriginOption.defaultCsrOrigin();
    private String pickupId;
    private String certId;
    private ChainOption chainOption;
    private String keyPassword;
    private boolean fetchPrivateKey;
    private String thumbprint;
    private Duration timeout;
    private int validityHours;
    private String issuerHint;
    private Collection<CustomField> customFields;

    public CertificateRequest() {
        this.dnsNames = Collections.emptyList();
        this.emailAddresses = Collections.emptyList();
        this.ipAddresses = Collections.emptyList();
        this.attributes = Collections.emptyList();
    }

    public Duration timeout() {
        return !Objects.isNull(this.timeout) ? this.timeout : Duration.of(5L, ChronoUnit.MINUTES);
    }

    public ChainOption chainOption() {
        return !Objects.isNull((Object)this.chainOption) ? this.chainOption : ChainOption.ChainOptionRootFirst;
    }

    public PrivateKey privateKey() {
        return !Objects.isNull(this.keyPair) ? this.keyPair.getPrivate() : null;
    }

    public void generatePrivateKey() throws VCertException {
        if (this.keyPair != null) {
            return;
        }
        switch (this.keyType) {
            case ECDSA: {
                this.keyPair = this.generateECDSAKeyPair(this.keyCurve);
                break;
            }
            case RSA: {
                if (this.keyLength == 0) {
                    this.keyLength = KeyType.defaultRsaLength();
                }
                this.keyPair = this.generateRSAKeyPair(this.keyLength);
                break;
            }
            default: {
                throw new VCertException(String.format("Unable to generate certificate request, key type %s is not supported", this.keyType.name()));
            }
        }
    }

    public void generateCSR() throws VCertException {
        try {
            ArrayList<GeneralName> sans = new ArrayList<GeneralName>();
            JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(this.subject.toX500Principal(), this.keyPair.getPublic());
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.signatureAlgorithm.standardName());
            ContentSigner signer = signerBuilder.build(this.keyPair.getPrivate());
            for (String string : this.dnsNames) {
                sans.add(new GeneralName(2, string));
            }
            for (InetAddress inetAddress : this.ipAddresses) {
                sans.add(new GeneralName(7, (ASN1Encodable)new DEROctetString(inetAddress.getAddress())));
            }
            for (String string : this.emailAddresses) {
                sans.add(new GeneralName(1, string));
            }
            if (!sans.isEmpty()) {
                GeneralNames names = new GeneralNames(sans.toArray(new GeneralName[0]));
                ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
                extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)names);
                requestBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
            }
            PKCS10CertificationRequest certificationRequest = requestBuilder.build(signer);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write("-----BEGIN CERTIFICATE REQUEST-----".getBytes());
            byteArrayOutputStream.write(System.lineSeparator().getBytes());
            byteArrayOutputStream.write(Base64.getMimeEncoder().encode(certificationRequest.getEncoded()));
            byteArrayOutputStream.write(System.lineSeparator().getBytes());
            byteArrayOutputStream.write("-----END CERTIFICATE REQUEST-----".getBytes());
            this.csr = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new VCertException("Unable to generate CSR", e);
        }
    }

    @VisibleForTesting
    KeyPair generateECDSAKeyPair(EllipticCurve keyCurve) throws VCertException {
        try {
            KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
            ECGenParameterSpec spec = new ECGenParameterSpec(keyCurve.bcName());
            g.initialize(spec);
            return g.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new VCertException("No security provider found for KeyFactory.EC", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new VCertException(String.format("No algorithmn provider for curve %s", keyCurve.bcName()), e);
        }
    }

    @VisibleForTesting
    KeyPair generateRSAKeyPair(Integer keyLength) throws VCertException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(keyLength);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new VCertException("No security provider found for KeyFactory.RSA", e);
        }
        catch (NoSuchProviderException e) {
            throw new VCertException(String.format("No algorithm provider for RSA with key length %s", Integer.toString(keyLength)), e);
        }
    }

    public boolean checkCertificate(Certificate certificate) throws VCertException {
        block16: {
            PublicKeyAlgorithm publicKeyAlgorithm;
            block15: {
                publicKeyAlgorithm = KeyType.from(certificate.getPublicKey().getAlgorithm()).X509Type();
                if (this.keyPair == null || this.keyPair.getPublic() == null || this.keyPair.getPrivate() == null) break block15;
                KeyType keyType = this.keyType = this.keyType == null ? KeyType.defaultKeyType() : this.keyType;
                if (this.keyType.X509Type() != publicKeyAlgorithm) {
                    throw new VCertException(String.format("unmatched key type: %s, %s", new Object[]{this.keyType.X509Type(), publicKeyAlgorithm.name()}));
                }
                switch (publicKeyAlgorithm) {
                    case RSA: {
                        RSAPublicKey certPublicKey = (RSAPublicKey)certificate.getPublicKey();
                        RSAPublicKey reqPublicKey = (RSAPublicKey)this.keyPair.getPublic();
                        if (certPublicKey.getModulus().compareTo(reqPublicKey.getModulus()) != 0) {
                            throw new VCertException("unmatched key modules");
                        }
                        break block16;
                    }
                    case ECDSA: {
                        ECPublicKey certEcPublicKey = (ECPublicKey)certificate.getPublicKey();
                        ECPublicKey reqEcPublicKey = (ECPublicKey)this.keyPair.getPublic();
                        ECParameterSpec certSpec = certEcPublicKey.getParams();
                        ECParameterSpec csrSpec = reqEcPublicKey.getParams();
                        java.security.spec.EllipticCurve certCurve = certSpec.getCurve();
                        java.security.spec.EllipticCurve csrCurve = csrSpec.getCurve();
                        ECField certField = certCurve.getField();
                        ECField csrField = csrCurve.getField();
                        if (!(certSpec == csrSpec || certSpec.getCofactor() == csrSpec.getCofactor() && certSpec.getOrder().equals(csrSpec.getOrder()) && certSpec.getGenerator().equals(csrSpec.getGenerator()) && (certCurve == csrCurve || certCurve.getA().equals(csrCurve.getA()) && certCurve.getB().equals(csrCurve.getB()) && certField.getFieldSize() == csrField.getFieldSize()))) {
                            throw new VCertException("unmatched parameters for elliptic keys");
                        }
                        break block16;
                    }
                    default: {
                        throw new VCertException(String.format("unknown key algorithm %s", publicKeyAlgorithm.name()));
                    }
                }
            }
            if (Objects.nonNull(this.csr) && this.csr.length != 0) {
                try {
                    PemReader pemReader = new PemReader((Reader)new StringReader(new String(this.csr)));
                    PKCS10CertificationRequest csr = new PKCS10CertificationRequest(pemReader.readPemObject().getContent());
                    pemReader.close();
                    DefaultAlgorithmNameFinder nameFinder = new DefaultAlgorithmNameFinder();
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                    PublicKeyAlgorithm csrPublicKeyAlgorithm = PublicKeyAlgorithm.valueOf(String.valueOf(nameFinder.getAlgorithmName(csr.getSubjectPublicKeyInfo().getAlgorithm())));
                    if (publicKeyAlgorithm != csrPublicKeyAlgorithm) {
                        throw new VCertException(String.format("unmatched key type: %s, %s", new Object[]{publicKeyAlgorithm, csrPublicKeyAlgorithm}));
                    }
                    switch (csrPublicKeyAlgorithm) {
                        case RSA: {
                            RSAPublicKey certPublicKey = (RSAPublicKey)certificate.getPublicKey();
                            RSAPublicKey reqPublicKey = (RSAPublicKey)converter.getPublicKey(csr.getSubjectPublicKeyInfo());
                            if (certPublicKey.getModulus().compareTo(reqPublicKey.getModulus()) == 0) break;
                            throw new VCertException("unmatched key modules");
                        }
                        case ECDSA: {
                            ECPublicKey certEcPublicKey = (ECPublicKey)certificate.getPublicKey();
                            ECPublicKey reqEcPublicKey = (ECPublicKey)converter.getPublicKey(csr.getSubjectPublicKeyInfo());
                            ECParameterSpec certSpec = certEcPublicKey.getParams();
                            ECParameterSpec csrSpec = reqEcPublicKey.getParams();
                            java.security.spec.EllipticCurve certCurve = certSpec.getCurve();
                            java.security.spec.EllipticCurve csrCurve = csrSpec.getCurve();
                            ECField certField = certCurve.getField();
                            ECField csrField = csrCurve.getField();
                            if (certSpec == csrSpec || certSpec.getCofactor() == csrSpec.getCofactor() && certSpec.getOrder().equals(csrSpec.getOrder()) && certSpec.getGenerator().equals(csrSpec.getGenerator()) && (certCurve == csrCurve || certCurve.getA().equals(csrCurve.getA()) && certCurve.getB().equals(csrCurve.getB()) && certField.getFieldSize() == csrField.getFieldSize())) break;
                            throw new VCertException("unmatched parameters for elliptic keys");
                        }
                    }
                }
                catch (IOException e) {
                    throw new VCertException(String.format("bad csr: %s", e.getMessage()), e);
                }
            }
        }
        return true;
    }

    public PKIXName subject() {
        return this.subject;
    }

    public Collection<String> dnsNames() {
        return this.dnsNames;
    }

    public Collection<String> emailAddresses() {
        return this.emailAddresses;
    }

    public Collection<InetAddress> ipAddresses() {
        return this.ipAddresses;
    }

    public Collection<AttributeTypeAndValueSET> attributes() {
        return this.attributes;
    }

    public SignatureAlgorithm signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public KeyType keyType() {
        return this.keyType;
    }

    public int keyLength() {
        return this.keyLength;
    }

    public EllipticCurve keyCurve() {
        return this.keyCurve;
    }

    public byte[] csr() {
        return this.csr;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public CsrOriginOption csrOrigin() {
        return this.csrOrigin;
    }

    public String pickupId() {
        return this.pickupId;
    }

    public String certId() {
        return this.certId;
    }

    public String keyPassword() {
        return this.keyPassword;
    }

    public boolean fetchPrivateKey() {
        return this.fetchPrivateKey;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public int validityHours() {
        return this.validityHours;
    }

    public String issuerHint() {
        return this.issuerHint;
    }

    public Collection<CustomField> customFields() {
        return this.customFields;
    }

    public CertificateRequest subject(PKIXName subject) {
        this.subject = subject;
        return this;
    }

    public CertificateRequest dnsNames(Collection<String> dnsNames) {
        this.dnsNames = dnsNames;
        return this;
    }

    public CertificateRequest emailAddresses(Collection<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public CertificateRequest ipAddresses(Collection<InetAddress> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public CertificateRequest attributes(Collection<AttributeTypeAndValueSET> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CertificateRequest signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public CertificateRequest friendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public CertificateRequest keyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public CertificateRequest keyLength(int keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    public CertificateRequest keyCurve(EllipticCurve keyCurve) {
        this.keyCurve = keyCurve;
        return this;
    }

    public CertificateRequest csr(byte[] csr) {
        this.csr = csr;
        return this;
    }

    public CertificateRequest keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public CertificateRequest csrOrigin(CsrOriginOption csrOrigin) {
        this.csrOrigin = csrOrigin;
        return this;
    }

    public CertificateRequest pickupId(String pickupId) {
        this.pickupId = pickupId;
        return this;
    }

    public CertificateRequest certId(String certId) {
        this.certId = certId;
        return this;
    }

    public CertificateRequest chainOption(ChainOption chainOption) {
        this.chainOption = chainOption;
        return this;
    }

    public CertificateRequest keyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public CertificateRequest fetchPrivateKey(boolean fetchPrivateKey) {
        this.fetchPrivateKey = fetchPrivateKey;
        return this;
    }

    public CertificateRequest thumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public CertificateRequest timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public CertificateRequest validityHours(int validityHours) {
        this.validityHours = validityHours;
        return this;
    }

    public CertificateRequest issuerHint(String issuerHint) {
        this.issuerHint = issuerHint;
        return this;
    }

    public CertificateRequest customFields(Collection<CustomField> customFields) {
        this.customFields = customFields;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertificateRequest)) {
            return false;
        }
        CertificateRequest other = (CertificateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.keyLength() != other.keyLength()) {
            return false;
        }
        if (this.fetchPrivateKey() != other.fetchPrivateKey()) {
            return false;
        }
        if (this.validityHours() != other.validityHours()) {
            return false;
        }
        PKIXName this$subject = this.subject();
        PKIXName other$subject = other.subject();
        if (this$subject == null ? other$subject != null : !((Object)this$subject).equals(other$subject)) {
            return false;
        }
        Collection<String> this$dnsNames = this.dnsNames();
        Collection<String> other$dnsNames = other.dnsNames();
        if (this$dnsNames == null ? other$dnsNames != null : !((Object)this$dnsNames).equals(other$dnsNames)) {
            return false;
        }
        Collection<String> this$emailAddresses = this.emailAddresses();
        Collection<String> other$emailAddresses = other.emailAddresses();
        if (this$emailAddresses == null ? other$emailAddresses != null : !((Object)this$emailAddresses).equals(other$emailAddresses)) {
            return false;
        }
        Collection<InetAddress> this$ipAddresses = this.ipAddresses();
        Collection<InetAddress> other$ipAddresses = other.ipAddresses();
        if (this$ipAddresses == null ? other$ipAddresses != null : !((Object)this$ipAddresses).equals(other$ipAddresses)) {
            return false;
        }
        Collection<AttributeTypeAndValueSET> this$attributes = this.attributes();
        Collection<AttributeTypeAndValueSET> other$attributes = other.attributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        SignatureAlgorithm this$signatureAlgorithm = this.signatureAlgorithm();
        SignatureAlgorithm other$signatureAlgorithm = other.signatureAlgorithm();
        if (this$signatureAlgorithm == null ? other$signatureAlgorithm != null : !((Object)((Object)this$signatureAlgorithm)).equals((Object)other$signatureAlgorithm)) {
            return false;
        }
        String this$friendlyName = this.friendlyName();
        String other$friendlyName = other.friendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        KeyType this$keyType = this.keyType();
        KeyType other$keyType = other.keyType();
        if (this$keyType == null ? other$keyType != null : !((Object)((Object)this$keyType)).equals((Object)other$keyType)) {
            return false;
        }
        EllipticCurve this$keyCurve = this.keyCurve();
        EllipticCurve other$keyCurve = other.keyCurve();
        if (this$keyCurve == null ? other$keyCurve != null : !((Object)((Object)this$keyCurve)).equals((Object)other$keyCurve)) {
            return false;
        }
        if (!Arrays.equals(this.csr(), other.csr())) {
            return false;
        }
        KeyPair this$keyPair = this.keyPair();
        KeyPair other$keyPair = other.keyPair();
        if (this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair)) {
            return false;
        }
        CsrOriginOption this$csrOrigin = this.csrOrigin();
        CsrOriginOption other$csrOrigin = other.csrOrigin();
        if (this$csrOrigin == null ? other$csrOrigin != null : !((Object)((Object)this$csrOrigin)).equals((Object)other$csrOrigin)) {
            return false;
        }
        String this$pickupId = this.pickupId();
        String other$pickupId = other.pickupId();
        if (this$pickupId == null ? other$pickupId != null : !this$pickupId.equals(other$pickupId)) {
            return false;
        }
        String this$certId = this.certId();
        String other$certId = other.certId();
        if (this$certId == null ? other$certId != null : !this$certId.equals(other$certId)) {
            return false;
        }
        ChainOption this$chainOption = this.chainOption();
        ChainOption other$chainOption = other.chainOption();
        if (this$chainOption == null ? other$chainOption != null : !((Object)((Object)this$chainOption)).equals((Object)other$chainOption)) {
            return false;
        }
        String this$keyPassword = this.keyPassword();
        String other$keyPassword = other.keyPassword();
        if (this$keyPassword == null ? other$keyPassword != null : !this$keyPassword.equals(other$keyPassword)) {
            return false;
        }
        String this$thumbprint = this.thumbprint();
        String other$thumbprint = other.thumbprint();
        if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
            return false;
        }
        Duration this$timeout = this.timeout();
        Duration other$timeout = other.timeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$issuerHint = this.issuerHint();
        String other$issuerHint = other.issuerHint();
        if (this$issuerHint == null ? other$issuerHint != null : !this$issuerHint.equals(other$issuerHint)) {
            return false;
        }
        Collection<CustomField> this$customFields = this.customFields();
        Collection<CustomField> other$customFields = other.customFields();
        return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CertificateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.keyLength();
        result = result * 59 + (this.fetchPrivateKey() ? 79 : 97);
        result = result * 59 + this.validityHours();
        PKIXName $subject = this.subject();
        result = result * 59 + ($subject == null ? 43 : ((Object)$subject).hashCode());
        Collection<String> $dnsNames = this.dnsNames();
        result = result * 59 + ($dnsNames == null ? 43 : ((Object)$dnsNames).hashCode());
        Collection<String> $emailAddresses = this.emailAddresses();
        result = result * 59 + ($emailAddresses == null ? 43 : ((Object)$emailAddresses).hashCode());
        Collection<InetAddress> $ipAddresses = this.ipAddresses();
        result = result * 59 + ($ipAddresses == null ? 43 : ((Object)$ipAddresses).hashCode());
        Collection<AttributeTypeAndValueSET> $attributes = this.attributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        SignatureAlgorithm $signatureAlgorithm = this.signatureAlgorithm();
        result = result * 59 + ($signatureAlgorithm == null ? 43 : ((Object)((Object)$signatureAlgorithm)).hashCode());
        String $friendlyName = this.friendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        KeyType $keyType = this.keyType();
        result = result * 59 + ($keyType == null ? 43 : ((Object)((Object)$keyType)).hashCode());
        EllipticCurve $keyCurve = this.keyCurve();
        result = result * 59 + ($keyCurve == null ? 43 : ((Object)((Object)$keyCurve)).hashCode());
        result = result * 59 + Arrays.hashCode(this.csr());
        KeyPair $keyPair = this.keyPair();
        result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
        CsrOriginOption $csrOrigin = this.csrOrigin();
        result = result * 59 + ($csrOrigin == null ? 43 : ((Object)((Object)$csrOrigin)).hashCode());
        String $pickupId = this.pickupId();
        result = result * 59 + ($pickupId == null ? 43 : $pickupId.hashCode());
        String $certId = this.certId();
        result = result * 59 + ($certId == null ? 43 : $certId.hashCode());
        ChainOption $chainOption = this.chainOption();
        result = result * 59 + ($chainOption == null ? 43 : ((Object)((Object)$chainOption)).hashCode());
        String $keyPassword = this.keyPassword();
        result = result * 59 + ($keyPassword == null ? 43 : $keyPassword.hashCode());
        String $thumbprint = this.thumbprint();
        result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
        Duration $timeout = this.timeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $issuerHint = this.issuerHint();
        result = result * 59 + ($issuerHint == null ? 43 : $issuerHint.hashCode());
        Collection<CustomField> $customFields = this.customFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        return result;
    }

    public String toString() {
        return "CertificateRequest(subject=" + this.subject() + ", dnsNames=" + this.dnsNames() + ", emailAddresses=" + this.emailAddresses() + ", ipAddresses=" + this.ipAddresses() + ", attributes=" + this.attributes() + ", signatureAlgorithm=" + this.signatureAlgorithm() + ", friendlyName=" + this.friendlyName() + ", keyType=" + this.keyType() + ", keyLength=" + this.keyLength() + ", keyCurve=" + this.keyCurve() + ", csr=" + Arrays.toString(this.csr()) + ", keyPair=" + this.keyPair() + ", csrOrigin=" + this.csrOrigin() + ", pickupId=" + this.pickupId() + ", certId=" + this.certId() + ", chainOption=" + this.chainOption() + ", keyPassword=" + this.keyPassword() + ", fetchPrivateKey=" + this.fetchPrivateKey() + ", thumbprint=" + this.thumbprint() + ", timeout=" + this.timeout() + ", validityHours=" + this.validityHours() + ", issuerHint=" + this.issuerHint() + ", customFields=" + this.customFields() + ")";
    }

    public static class AttributeTypeAndValueSET {
        private Collection<Integer> type;
        private Collection<Collection<AttributeTypeAndValue>> value;

        public Collection<Integer> type() {
            return this.type;
        }

        public Collection<Collection<AttributeTypeAndValue>> value() {
            return this.value;
        }

        public AttributeTypeAndValueSET type(Collection<Integer> type) {
            this.type = type;
            return this;
        }

        public AttributeTypeAndValueSET value(Collection<Collection<AttributeTypeAndValue>> value) {
            this.value = value;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeTypeAndValueSET)) {
                return false;
            }
            AttributeTypeAndValueSET other = (AttributeTypeAndValueSET)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<Integer> this$type = this.type();
            Collection<Integer> other$type = other.type();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            Collection<Collection<AttributeTypeAndValue>> this$value = this.value();
            Collection<Collection<AttributeTypeAndValue>> other$value = other.value();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AttributeTypeAndValueSET;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<Integer> $type = this.type();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            Collection<Collection<AttributeTypeAndValue>> $value = this.value();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public String toString() {
            return "CertificateRequest.AttributeTypeAndValueSET(type=" + this.type() + ", value=" + this.value() + ")";
        }
    }

    public static class AttributeTypeAndValue {
        private Collection<Integer> type;
        private Object value;

        public Collection<Integer> type() {
            return this.type;
        }

        public Object value() {
            return this.value;
        }

        public AttributeTypeAndValue type(Collection<Integer> type) {
            this.type = type;
            return this;
        }

        public AttributeTypeAndValue value(Object value) {
            this.value = value;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeTypeAndValue)) {
                return false;
            }
            AttributeTypeAndValue other = (AttributeTypeAndValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<Integer> this$type = this.type();
            Collection<Integer> other$type = other.type();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            Object this$value = this.value();
            Object other$value = other.value();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AttributeTypeAndValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<Integer> $type = this.type();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            Object $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "CertificateRequest.AttributeTypeAndValue(type=" + this.type() + ", value=" + this.value() + ")";
        }
    }

    public static class PKIXName {
        private String commonName;
        private String serialNumber;
        private List<String> country;
        private List<String> organization;
        private List<String> organizationalUnit;
        private List<String> locality;
        private List<String> province;
        private List<String> streetAddress;
        private List<String> postalCode;
        private Collection<AttributeTypeAndValue> names;
        private Collection<AttributeTypeAndValue> extraNames;

        private static void addAll(X500NameBuilder builder, ASN1ObjectIdentifier identifier, Collection<String> values) {
            if (values != null) {
                values.stream().filter(Objects::nonNull).forEach(value -> builder.addRDN(identifier, value));
            }
        }

        public X500Principal toX500Principal() throws VCertException {
            if (StringUtils.isBlank((CharSequence)this.commonName)) {
                throw new VCertException("common name must not be null or emtpy");
            }
            X500NameBuilder x500NameBuilder = new X500NameBuilder();
            x500NameBuilder.addRDN(BCStyle.CN, this.commonName);
            PKIXName.addAll(x500NameBuilder, BCStyle.C, this.country);
            PKIXName.addAll(x500NameBuilder, BCStyle.O, this.organization);
            PKIXName.addAll(x500NameBuilder, BCStyle.OU, this.organizationalUnit);
            PKIXName.addAll(x500NameBuilder, BCStyle.L, this.locality);
            PKIXName.addAll(x500NameBuilder, BCStyle.ST, this.province);
            PKIXName.addAll(x500NameBuilder, BCStyle.STREET, this.streetAddress);
            PKIXName.addAll(x500NameBuilder, BCStyle.POSTAL_CODE, this.postalCode);
            return new X500Principal(x500NameBuilder.build().toString());
        }

        public String commonName() {
            return this.commonName;
        }

        public String serialNumber() {
            return this.serialNumber;
        }

        public List<String> country() {
            return this.country;
        }

        public List<String> organization() {
            return this.organization;
        }

        public List<String> organizationalUnit() {
            return this.organizationalUnit;
        }

        public List<String> locality() {
            return this.locality;
        }

        public List<String> province() {
            return this.province;
        }

        public List<String> streetAddress() {
            return this.streetAddress;
        }

        public List<String> postalCode() {
            return this.postalCode;
        }

        public Collection<AttributeTypeAndValue> names() {
            return this.names;
        }

        public Collection<AttributeTypeAndValue> extraNames() {
            return this.extraNames;
        }

        public PKIXName commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public PKIXName serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public PKIXName country(List<String> country) {
            this.country = country;
            return this;
        }

        public PKIXName organization(List<String> organization) {
            this.organization = organization;
            return this;
        }

        public PKIXName organizationalUnit(List<String> organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public PKIXName locality(List<String> locality) {
            this.locality = locality;
            return this;
        }

        public PKIXName province(List<String> province) {
            this.province = province;
            return this;
        }

        public PKIXName streetAddress(List<String> streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        public PKIXName postalCode(List<String> postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public PKIXName names(Collection<AttributeTypeAndValue> names) {
            this.names = names;
            return this;
        }

        public PKIXName extraNames(Collection<AttributeTypeAndValue> extraNames) {
            this.extraNames = extraNames;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PKIXName)) {
                return false;
            }
            PKIXName other = (PKIXName)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$commonName = this.commonName();
            String other$commonName = other.commonName();
            if (this$commonName == null ? other$commonName != null : !this$commonName.equals(other$commonName)) {
                return false;
            }
            String this$serialNumber = this.serialNumber();
            String other$serialNumber = other.serialNumber();
            if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
                return false;
            }
            List<String> this$country = this.country();
            List<String> other$country = other.country();
            if (this$country == null ? other$country != null : !((Object)this$country).equals(other$country)) {
                return false;
            }
            List<String> this$organization = this.organization();
            List<String> other$organization = other.organization();
            if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
                return false;
            }
            List<String> this$organizationalUnit = this.organizationalUnit();
            List<String> other$organizationalUnit = other.organizationalUnit();
            if (this$organizationalUnit == null ? other$organizationalUnit != null : !((Object)this$organizationalUnit).equals(other$organizationalUnit)) {
                return false;
            }
            List<String> this$locality = this.locality();
            List<String> other$locality = other.locality();
            if (this$locality == null ? other$locality != null : !((Object)this$locality).equals(other$locality)) {
                return false;
            }
            List<String> this$province = this.province();
            List<String> other$province = other.province();
            if (this$province == null ? other$province != null : !((Object)this$province).equals(other$province)) {
                return false;
            }
            List<String> this$streetAddress = this.streetAddress();
            List<String> other$streetAddress = other.streetAddress();
            if (this$streetAddress == null ? other$streetAddress != null : !((Object)this$streetAddress).equals(other$streetAddress)) {
                return false;
            }
            List<String> this$postalCode = this.postalCode();
            List<String> other$postalCode = other.postalCode();
            if (this$postalCode == null ? other$postalCode != null : !((Object)this$postalCode).equals(other$postalCode)) {
                return false;
            }
            Collection<AttributeTypeAndValue> this$names = this.names();
            Collection<AttributeTypeAndValue> other$names = other.names();
            if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
                return false;
            }
            Collection<AttributeTypeAndValue> this$extraNames = this.extraNames();
            Collection<AttributeTypeAndValue> other$extraNames = other.extraNames();
            return !(this$extraNames == null ? other$extraNames != null : !((Object)this$extraNames).equals(other$extraNames));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PKIXName;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $commonName = this.commonName();
            result = result * 59 + ($commonName == null ? 43 : $commonName.hashCode());
            String $serialNumber = this.serialNumber();
            result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
            List<String> $country = this.country();
            result = result * 59 + ($country == null ? 43 : ((Object)$country).hashCode());
            List<String> $organization = this.organization();
            result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
            List<String> $organizationalUnit = this.organizationalUnit();
            result = result * 59 + ($organizationalUnit == null ? 43 : ((Object)$organizationalUnit).hashCode());
            List<String> $locality = this.locality();
            result = result * 59 + ($locality == null ? 43 : ((Object)$locality).hashCode());
            List<String> $province = this.province();
            result = result * 59 + ($province == null ? 43 : ((Object)$province).hashCode());
            List<String> $streetAddress = this.streetAddress();
            result = result * 59 + ($streetAddress == null ? 43 : ((Object)$streetAddress).hashCode());
            List<String> $postalCode = this.postalCode();
            result = result * 59 + ($postalCode == null ? 43 : ((Object)$postalCode).hashCode());
            Collection<AttributeTypeAndValue> $names = this.names();
            result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
            Collection<AttributeTypeAndValue> $extraNames = this.extraNames();
            result = result * 59 + ($extraNames == null ? 43 : ((Object)$extraNames).hashCode());
            return result;
        }

        public String toString() {
            return "CertificateRequest.PKIXName(commonName=" + this.commonName() + ", serialNumber=" + this.serialNumber() + ", country=" + this.country() + ", organization=" + this.organization() + ", organizationalUnit=" + this.organizationalUnit() + ", locality=" + this.locality() + ", province=" + this.province() + ", streetAddress=" + this.streetAddress() + ", postalCode=" + this.postalCode() + ", names=" + this.names() + ", extraNames=" + this.extraNames() + ")";
        }
    }
}

