/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.api.domain;

import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import org.apache.commons.lang3.StringUtils;

public class CloudPolicy {
    private CertificateIssuingTemplate certificateIssuingTemplate;
    private CAInfo caInfo;
    private boolean removeRegexesFromSubjectCN;

    public CertificateIssuingTemplate certificateIssuingTemplate() {
        return this.certificateIssuingTemplate;
    }

    public CAInfo caInfo() {
        return this.caInfo;
    }

    public boolean removeRegexesFromSubjectCN() {
        return this.removeRegexesFromSubjectCN;
    }

    public CloudPolicy certificateIssuingTemplate(CertificateIssuingTemplate certificateIssuingTemplate) {
        this.certificateIssuingTemplate = certificateIssuingTemplate;
        return this;
    }

    public CloudPolicy caInfo(CAInfo caInfo) {
        this.caInfo = caInfo;
        return this;
    }

    public CloudPolicy removeRegexesFromSubjectCN(boolean removeRegexesFromSubjectCN) {
        this.removeRegexesFromSubjectCN = removeRegexesFromSubjectCN;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudPolicy)) {
            return false;
        }
        CloudPolicy other = (CloudPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.removeRegexesFromSubjectCN() != other.removeRegexesFromSubjectCN()) {
            return false;
        }
        CertificateIssuingTemplate this$certificateIssuingTemplate = this.certificateIssuingTemplate();
        CertificateIssuingTemplate other$certificateIssuingTemplate = other.certificateIssuingTemplate();
        if (this$certificateIssuingTemplate == null ? other$certificateIssuingTemplate != null : !((Object)this$certificateIssuingTemplate).equals(other$certificateIssuingTemplate)) {
            return false;
        }
        CAInfo this$caInfo = this.caInfo();
        CAInfo other$caInfo = other.caInfo();
        return !(this$caInfo == null ? other$caInfo != null : !((Object)this$caInfo).equals(other$caInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloudPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.removeRegexesFromSubjectCN() ? 79 : 97);
        CertificateIssuingTemplate $certificateIssuingTemplate = this.certificateIssuingTemplate();
        result = result * 59 + ($certificateIssuingTemplate == null ? 43 : ((Object)$certificateIssuingTemplate).hashCode());
        CAInfo $caInfo = this.caInfo();
        result = result * 59 + ($caInfo == null ? 43 : ((Object)$caInfo).hashCode());
        return result;
    }

    public String toString() {
        return "CloudPolicy(certificateIssuingTemplate=" + this.certificateIssuingTemplate() + ", caInfo=" + this.caInfo() + ", removeRegexesFromSubjectCN=" + this.removeRegexesFromSubjectCN() + ")";
    }

    public static class CAInfo {
        private String certificateAuthorityString;
        private String caType;
        private String caAccountKey;
        private String vendorProductName;

        public CAInfo(String certificateAuthority) {
            this.certificateAuthorityString = certificateAuthority;
            String[] caInfoArray = StringUtils.split((String)this.certificateAuthorityString, (String)"\\");
            this.caType = caInfoArray[0];
            this.caAccountKey = caInfoArray[1];
            this.vendorProductName = caInfoArray[2];
        }

        public CAInfo(String caType, String caAccountKey, String vendorProductName) {
            this.caType = caType;
            this.caAccountKey = caAccountKey;
            this.vendorProductName = vendorProductName;
            this.certificateAuthorityString = caType + "\\" + caAccountKey + "\\" + vendorProductName;
        }

        public String certificateAuthorityString() {
            return this.certificateAuthorityString;
        }

        public String caType() {
            return this.caType;
        }

        public String caAccountKey() {
            return this.caAccountKey;
        }

        public String vendorProductName() {
            return this.vendorProductName;
        }

        public CAInfo certificateAuthorityString(String certificateAuthorityString) {
            this.certificateAuthorityString = certificateAuthorityString;
            return this;
        }

        public CAInfo caType(String caType) {
            this.caType = caType;
            return this;
        }

        public CAInfo caAccountKey(String caAccountKey) {
            this.caAccountKey = caAccountKey;
            return this;
        }

        public CAInfo vendorProductName(String vendorProductName) {
            this.vendorProductName = vendorProductName;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CAInfo)) {
                return false;
            }
            CAInfo other = (CAInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateAuthorityString = this.certificateAuthorityString();
            String other$certificateAuthorityString = other.certificateAuthorityString();
            if (this$certificateAuthorityString == null ? other$certificateAuthorityString != null : !this$certificateAuthorityString.equals(other$certificateAuthorityString)) {
                return false;
            }
            String this$caType = this.caType();
            String other$caType = other.caType();
            if (this$caType == null ? other$caType != null : !this$caType.equals(other$caType)) {
                return false;
            }
            String this$caAccountKey = this.caAccountKey();
            String other$caAccountKey = other.caAccountKey();
            if (this$caAccountKey == null ? other$caAccountKey != null : !this$caAccountKey.equals(other$caAccountKey)) {
                return false;
            }
            String this$vendorProductName = this.vendorProductName();
            String other$vendorProductName = other.vendorProductName();
            return !(this$vendorProductName == null ? other$vendorProductName != null : !this$vendorProductName.equals(other$vendorProductName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CAInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateAuthorityString = this.certificateAuthorityString();
            result = result * 59 + ($certificateAuthorityString == null ? 43 : $certificateAuthorityString.hashCode());
            String $caType = this.caType();
            result = result * 59 + ($caType == null ? 43 : $caType.hashCode());
            String $caAccountKey = this.caAccountKey();
            result = result * 59 + ($caAccountKey == null ? 43 : $caAccountKey.hashCode());
            String $vendorProductName = this.vendorProductName();
            result = result * 59 + ($vendorProductName == null ? 43 : $vendorProductName.hashCode());
            return result;
        }

        public String toString() {
            return "CloudPolicy.CAInfo(certificateAuthorityString=" + this.certificateAuthorityString() + ", caType=" + this.caType() + ", caAccountKey=" + this.caAccountKey() + ", vendorProductName=" + this.vendorProductName() + ")";
        }

        public CAInfo(String certificateAuthorityString, String caType, String caAccountKey, String vendorProductName) {
            this.certificateAuthorityString = certificateAuthorityString;
            this.caType = caType;
            this.caAccountKey = caAccountKey;
            this.vendorProductName = vendorProductName;
        }
    }
}

