/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.converter.cloud;

import com.venafi.vcert.sdk.certificate.KeySize;
import com.venafi.vcert.sdk.certificate.KeyType;
import com.venafi.vcert.sdk.connectors.cloud.CloudConstants;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import com.venafi.vcert.sdk.policy.api.domain.CloudPolicy;
import com.venafi.vcert.sdk.policy.converter.FromPolicyConverter;
import com.venafi.vcert.sdk.policy.domain.Defaults;
import com.venafi.vcert.sdk.policy.domain.DefaultsSubject;
import com.venafi.vcert.sdk.policy.domain.Policy;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.policy.domain.Subject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PolicyToCloudPolicyConverter
implements FromPolicyConverter<CloudPolicy> {
    public static PolicyToCloudPolicyConverter INSTANCE = new PolicyToCloudPolicyConverter();

    private PolicyToCloudPolicyConverter() {
    }

    @Override
    public CloudPolicy convertFromPolicy(PolicySpecification policySpecification) throws Exception {
        CloudPolicy cloudPolicy = new CloudPolicy();
        Policy policy = policySpecification.policy();
        CloudPolicy.CAInfo caInfo = this.getCertAuthorityInfo(policy);
        cloudPolicy.caInfo(caInfo);
        CertificateIssuingTemplate cit = new CertificateIssuingTemplate();
        cloudPolicy.certificateIssuingTemplate(cit);
        cit.certificateAuthority(caInfo.caType());
        cit.product(new CertificateIssuingTemplate.Product(caInfo.caType(), caInfo.vendorProductName(), this.getValidityPeriod(policy), null, null, null));
        switch (caInfo.caType().toUpperCase()) {
            case "ENTRUST": {
                cit.trackingData(CloudConstants.ENTRUST_DEFAULT_TRACKING_DATA);
                break;
            }
            case "DIGICERT": {
                CertificateIssuingTemplate.Product product = cit.product();
                product.hashAlgorithm("SHA256");
                product.autoRenew(false);
            }
        }
        List<String> domainsInRegex = this.convertDomainsToRegex(policy);
        cit.subjectCNRegexes(domainsInRegex);
        if (policy != null && policy.subjectAltNames() != null && policy.subjectAltNames().dnsAllowed() != null) {
            if (policy.subjectAltNames().dnsAllowed().booleanValue()) {
                cit.sanDnsNameRegexes(domainsInRegex);
            }
        } else {
            cit.sanDnsNameRegexes(domainsInRegex);
        }
        ArrayList<String> defaultRegexes = new ArrayList<String>();
        defaultRegexes.add(".*");
        if (policy != null && policy.subject() != null) {
            Subject policySubject = policy.subject();
            cit.subjectORegexes(policySubject.orgs() != null && policySubject.orgs().length > 0 ? Arrays.asList(policySubject.orgs()) : defaultRegexes);
            cit.subjectOURegexes(policySubject.orgUnits() != null && policySubject.orgUnits().length > 0 ? Arrays.asList(policySubject.orgUnits()) : defaultRegexes);
            cit.subjectLRegexes(policySubject.localities() != null && policySubject.localities().length > 0 ? Arrays.asList(policySubject.localities()) : defaultRegexes);
            cit.subjectSTRegexes(policySubject.states() != null && policySubject.states().length > 0 ? Arrays.asList(policySubject.states()) : defaultRegexes);
            cit.subjectCValues(policySubject.countries() != null && policySubject.countries().length > 0 ? Arrays.asList(policySubject.countries()) : defaultRegexes);
        } else {
            cit.subjectORegexes(defaultRegexes);
            cit.subjectOURegexes(defaultRegexes);
            cit.subjectLRegexes(defaultRegexes);
            cit.subjectSTRegexes(defaultRegexes);
            cit.subjectCValues(defaultRegexes);
        }
        cit.keyTypes(this.getKeyTypes(policy));
        cit.keyReuse(policy != null && policy.keyPair() != null && policy.keyPair().reuseAllowed() != null ? policy.keyPair().reuseAllowed() : false);
        Defaults defaults = policySpecification.defaults();
        if (defaults != null && defaults.subject() != null) {
            DefaultsSubject defaultsSubject = defaults.subject();
            if (defaultsSubject.org() != null) {
                this.getRecommendedSettings(cit).subjectOValue(defaultsSubject.org());
            }
            if (defaultsSubject.orgUnits() != null) {
                this.getRecommendedSettings(cit).subjectOUValue(defaultsSubject.orgUnits()[0]);
            }
            if (defaultsSubject.locality() != null) {
                this.getRecommendedSettings(cit).subjectLValue(defaultsSubject.locality());
            }
            if (defaultsSubject.state() != null) {
                this.getRecommendedSettings(cit).subjectSTValue(defaultsSubject.state());
            }
            if (defaultsSubject.country() != null) {
                this.getRecommendedSettings(cit).subjectCValue(defaultsSubject.country());
            }
        }
        if (defaults != null && defaults.keyPair() != null) {
            CertificateIssuingTemplate.AllowedKeyType recommendedKey = this.getDefaultKeyType(defaults);
            CertificateIssuingTemplate.RecommendedSettingsKey key = this.getRecommendedSettingsKey(cit);
            key.type(recommendedKey.keyType());
            key.length(recommendedKey.keyLengths().get(0));
        }
        return cloudPolicy;
    }

    private CloudPolicy.CAInfo getCertAuthorityInfo(Policy policy) {
        String certificateAuthorityString = policy != null && policy.certificateAuthority() != null ? policy.certificateAuthority() : "BUILTIN\\Built-In CA\\Default Product";
        return new CloudPolicy.CAInfo(certificateAuthorityString);
    }

    private String getValidityPeriod(Policy policy) {
        int defaultValidDays = 365;
        int maxValidDays = policy == null || policy.maxValidDays() == null || policy.maxValidDays() != null && policy.maxValidDays() == 0 ? defaultValidDays : policy.maxValidDays();
        return "P" + maxValidDays + "D";
    }

    private List<String> convertDomainsToRegex(Policy policy) {
        List<String> sanRegexList;
        if (policy != null && policy.domains() != null && policy.domains().length > 0) {
            sanRegexList = this.convertToRegex(policy.domains(), policy != null && policy.wildcardAllowed() != null ? policy.wildcardAllowed() : false);
        } else {
            sanRegexList = new ArrayList<String>();
            sanRegexList.add(".*");
        }
        return sanRegexList;
    }

    private List<String> convertToRegex(String[] values, boolean wildcardAllowed) {
        ArrayList<String> regexValues = new ArrayList<String>();
        for (String current : values) {
            String currentRegex = StringUtils.replace((String)current, (String)".", (String)"\\.");
            String wildCard = wildcardAllowed ? "*" : "";
            regexValues.add(String.format("[%sa-z]{1}[a-z0-9.-]*\\.", wildCard) + currentRegex);
        }
        return regexValues;
    }

    private List<CertificateIssuingTemplate.AllowedKeyType> getKeyTypes(Policy policy) {
        ArrayList<CertificateIssuingTemplate.AllowedKeyType> keyTypes = new ArrayList<CertificateIssuingTemplate.AllowedKeyType>();
        String keyType = this.getCloudDefaultKeyType();
        List<Integer> keySizes = this.getCloudDefaultKeySizes();
        if (policy != null && policy.keyPair() != null) {
            if (policy.keyPair().keyTypes()[0] != null) {
                keyType = policy.keyPair().keyTypes()[0].toUpperCase();
            }
            if (policy.keyPair().rsaKeySizes() != null) {
                keySizes = Arrays.asList(policy.keyPair().rsaKeySizes());
            }
        }
        keyTypes.add(new CertificateIssuingTemplate.AllowedKeyType(keyType, keySizes));
        return keyTypes;
    }

    private CertificateIssuingTemplate.AllowedKeyType getDefaultKeyType(Defaults defaults) {
        String keyType = this.getCloudDefaultKeyType();
        List<Integer> keySizes = this.getCloudDefaultKeySizes();
        if (defaults != null && defaults.keyPair() != null) {
            if (defaults.keyPair().keyType() != null) {
                keyType = defaults.keyPair().keyType().toUpperCase();
            }
            if (defaults.keyPair().rsaKeySize() != null) {
                keySizes = Arrays.asList(defaults.keyPair().rsaKeySize());
            }
        }
        return new CertificateIssuingTemplate.AllowedKeyType(keyType, keySizes);
    }

    private String getCloudDefaultKeyType() {
        return KeyType.RSA.value().toUpperCase();
    }

    private List<Integer> getCloudDefaultKeySizes() {
        ArrayList<Integer> keySizes = new ArrayList<Integer>();
        keySizes.add(KeySize.KS2048.value());
        return keySizes;
    }

    private CertificateIssuingTemplate.RecommendedSettings getRecommendedSettings(CertificateIssuingTemplate certificateIssuingTemplate) {
        if (certificateIssuingTemplate.recommendedSettings() == null) {
            certificateIssuingTemplate.recommendedSettings(new CertificateIssuingTemplate.RecommendedSettings());
        }
        return certificateIssuingTemplate.recommendedSettings();
    }

    private CertificateIssuingTemplate.RecommendedSettingsKey getRecommendedSettingsKey(CertificateIssuingTemplate certificateIssuingTemplate) {
        CertificateIssuingTemplate.RecommendedSettingsKey key = this.getRecommendedSettings(certificateIssuingTemplate).key();
        if (key == null) {
            key = new CertificateIssuingTemplate.RecommendedSettingsKey();
            this.getRecommendedSettings(certificateIssuingTemplate).key(key);
        }
        return key;
    }
}

