/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.converter.tpp;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.policy.converter.IPolicySpecificationValidator;
import com.venafi.vcert.sdk.policy.converter.tpp.TPPKeyPairEnums;
import com.venafi.vcert.sdk.policy.domain.Defaults;
import com.venafi.vcert.sdk.policy.domain.DefaultsKeyPair;
import com.venafi.vcert.sdk.policy.domain.DefaultsSubject;
import com.venafi.vcert.sdk.policy.domain.KeyPair;
import com.venafi.vcert.sdk.policy.domain.Policy;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.policy.domain.Subject;
import java.util.Arrays;

public class TPPPolicySpecificationValidator
implements IPolicySpecificationValidator {
    public static final String ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE = "The specified policy attribute %s has more than one value";
    public static final String ATTRIBUTE_HAS_NOT_A_TWO_CHAR_STRING_VALUE_EXCEPTION_MESSAGE = "The specified policy attribute %s has not a two-char string value.";
    public static final String ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE = "The specified value for policy attribute %s doesn't match with the supported ones";
    public static final String DEFAULT_ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE = "The specified value for default attribute %s doesn't match with the supported ones";
    public static final String DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE = "The specified value for default attribute %1$s doesn't match with the value of policy attribute %2$s";
    public static final TPPPolicySpecificationValidator INSTANCE = new TPPPolicySpecificationValidator();

    private TPPPolicySpecificationValidator() {
    }

    @Override
    public void validate(PolicySpecification policySpecification) throws Exception {
        Policy policy = policySpecification.policy();
        Defaults defaults = policySpecification.defaults();
        if (policy != null) {
            this.validatePolicySubject(policy.subject());
            this.validateKeyPair(policy.keyPair());
        }
        if (defaults != null) {
            this.validateDefaultSubject(defaults.subject(), policy != null ? policy.subject() : null);
            this.validateDefaultKeyPair(defaults.keyPair(), policy != null ? policy.keyPair() : null);
        }
    }

    private void validatePolicySubject(Subject subject) throws VCertException {
        if (subject != null) {
            if (subject.orgs() != null && subject.orgs().length > 1) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE, "orgs"));
            }
            if (subject.localities() != null && subject.localities().length > 1) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE, "localities"));
            }
            if (subject.states() != null && subject.states().length > 1) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE, "states"));
            }
            if (subject.countries() != null && subject.countries().length > 1) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE, "countries"));
            }
            if (subject.countries() != null && subject.countries().length == 1 && subject.countries()[0].length() != 2) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_NOT_A_TWO_CHAR_STRING_VALUE_EXCEPTION_MESSAGE, "countries"));
            }
        }
    }

    private void validateKeyPair(KeyPair keyPair) throws VCertException {
        if (keyPair != null) {
            if (keyPair.keyTypes() != null) {
                int keyTypesLength = keyPair.keyTypes().length;
                if (keyTypesLength > 1) {
                    throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE, "keyTypes"));
                }
                if (keyTypesLength == 1 && !TPPKeyPairEnums.containsKeyTypes(keyPair.keyTypes())) {
                    throw new VCertException(String.format(ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "keyTypes"));
                }
            }
            if (keyPair.rsaKeySizes() != null) {
                int rsaKeySizesLength = keyPair.rsaKeySizes().length;
                if (rsaKeySizesLength > 1) {
                    throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE, "rsaKeySizes"));
                }
                if (rsaKeySizesLength == 1 && !TPPKeyPairEnums.containsRsaKeySizes(keyPair.rsaKeySizes())) {
                    throw new VCertException(String.format(ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "rsaKeySizes"));
                }
            }
            if (keyPair.ellipticCurves() != null) {
                int ecLength = keyPair.ellipticCurves().length;
                if (ecLength > 1) {
                    throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE, "ellipticCurves"));
                }
                if (ecLength == 1 && !TPPKeyPairEnums.containsEllipticCurves(keyPair.ellipticCurves())) {
                    throw new VCertException(String.format(ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "ellipticCurves"));
                }
            }
        }
    }

    private void validateDefaultSubject(DefaultsSubject defaultsSubject, Subject policySubject) throws VCertException {
        if (defaultsSubject != null) {
            if (policySubject != null) {
                if (!(policySubject.orgs() == null || policySubject.orgs().length != 1 || policySubject.orgs()[0].equals("") || defaultsSubject.org() == null || defaultsSubject.org().equals("") || policySubject.orgs()[0].equals(defaultsSubject.org()))) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "org", "orgs"));
                }
                if (policySubject.orgUnits() != null && defaultsSubject.orgUnits() != null && !Arrays.asList(policySubject.orgUnits()).containsAll(Arrays.asList(defaultsSubject.orgUnits()))) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "orgUnits", "orgUnits"));
                }
                if (!(policySubject.localities() == null || policySubject.localities().length != 1 || policySubject.localities()[0].equals("") || defaultsSubject.locality() == null || defaultsSubject.locality().equals("") || policySubject.localities()[0].equals(defaultsSubject.locality()))) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "locality", "localities"));
                }
                if (!(policySubject.states() == null || policySubject.states().length != 1 || policySubject.states()[0].equals("") || defaultsSubject.state() == null || defaultsSubject.state().equals("") || policySubject.states()[0].equals(defaultsSubject.state()))) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "state", "states"));
                }
                if (!(policySubject.countries() == null || policySubject.countries().length != 1 || policySubject.countries()[0].equals("") || defaultsSubject.country() == null || defaultsSubject.country().equals("") || policySubject.countries()[0].equals(defaultsSubject.country()))) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "country", "countries"));
                }
            }
            if (defaultsSubject.country() != null && defaultsSubject.country().length() != 2) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_NOT_A_TWO_CHAR_STRING_VALUE_EXCEPTION_MESSAGE, "country"));
            }
        }
    }

    private void validateDefaultKeyPair(DefaultsKeyPair defaultsKeyPair, KeyPair policyKeyPair) throws VCertException {
        if (defaultsKeyPair != null) {
            String defaultEC;
            Integer defaultRsaKeySize;
            String defaultKeyType = defaultsKeyPair.keyType();
            if (defaultKeyType != null && !defaultKeyType.equals("")) {
                String[] policyKeyTypes;
                if (!TPPKeyPairEnums.containsKeyType(defaultKeyType)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "keyType"));
                }
                if (policyKeyPair != null && (policyKeyTypes = policyKeyPair.keyTypes()) != null && policyKeyTypes.length == 1 && !policyKeyTypes[0].equals("") && !policyKeyTypes[0].equals(defaultKeyType)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "keyType", "keyTypes"));
                }
            }
            if ((defaultRsaKeySize = defaultsKeyPair.rsaKeySize()) != null) {
                Integer[] policyRsaKeySizes;
                if (!TPPKeyPairEnums.containsRsaKeySize(defaultRsaKeySize)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "rsaKeySize"));
                }
                if (policyKeyPair != null && (policyRsaKeySizes = policyKeyPair.rsaKeySizes()) != null && policyRsaKeySizes.length == 1 && !policyRsaKeySizes[0].equals(defaultRsaKeySize)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "rsaKeySize", "rsaKeySizes"));
                }
            }
            if ((defaultEC = defaultsKeyPair.ellipticCurve()) != null && !defaultEC.equals("")) {
                String[] policyEC;
                if (!TPPKeyPairEnums.containsEllipticCurve(defaultEC)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "ellipticCurve"));
                }
                if (policyKeyPair != null && (policyEC = policyKeyPair.ellipticCurves()) != null && policyEC.length == 1 && !policyEC[0].equals("") && !policyEC[0].equals(defaultEC)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "ellipticCurve", "ellipticCurves"));
                }
            }
            if (policyKeyPair != null && policyKeyPair.serviceGenerated() != null && defaultsKeyPair.serviceGenerated() != null && !policyKeyPair.serviceGenerated().equals(defaultsKeyPair.serviceGenerated())) {
                throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "serviceGenerated", "serviceGenerated"));
            }
        }
    }
}

