/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.converter.tpp;

import com.venafi.vcert.sdk.policy.api.domain.TPPPolicy;
import com.venafi.vcert.sdk.policy.converter.ToPolicyConverterAbstract;
import com.venafi.vcert.sdk.policy.converter.tpp.AltName;
import com.venafi.vcert.sdk.policy.converter.tpp.ManagementTypes;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.policy.domain.SubjectAltNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;

public class TppPolicyToPolicyConverter
extends ToPolicyConverterAbstract<TPPPolicy> {
    public static TppPolicyToPolicyConverter INSTANCE = new TppPolicyToPolicyConverter();

    private TppPolicyToPolicyConverter() {
    }

    @Override
    public PolicySpecification convertToPolicy(TPPPolicy tppPolicy) throws Exception {
        PolicySpecification policySpecification = new PolicySpecification();
        policySpecification.name(tppPolicy.policyName());
        policySpecification.users(tppPolicy.contact() != null && tppPolicy.contact().length > 0 ? tppPolicy.contact() : null);
        policySpecification.approvers(tppPolicy.approver() != null && tppPolicy.approver().length > 0 ? tppPolicy.approver() : null);
        if (tppPolicy.domainSuffixWhiteList() != null && tppPolicy.domainSuffixWhiteList().length > 0) {
            this.getPolicyFromPolicySpecification(policySpecification).domains(tppPolicy.domainSuffixWhiteList());
        }
        if (tppPolicy.prohibitWildcard() != null) {
            this.getPolicyFromPolicySpecification(policySpecification).wildcardAllowed(tppPolicy.prohibitWildcard() != 1);
        }
        if (tppPolicy.certificateAuthority() != null && !tppPolicy.certificateAuthority().equals("")) {
            this.getPolicyFromPolicySpecification(policySpecification).certificateAuthority(tppPolicy.certificateAuthority());
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::managementType)) {
            case NORMAL: {
                this.getPolicyFromPolicySpecification(policySpecification).autoInstalled(ManagementTypes.from((String)tppPolicy.managementType().values()[0]).psValue);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::organization)) {
            case NORMAL: {
                this.getSubjectFromPolicySpecification(policySpecification).orgs(tppPolicy.organization().values());
                break;
            }
            case DEFAULT: {
                this.getDefaultsSubjectFromPolicySpecification(policySpecification).org(tppPolicy.organization().values()[0]);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::organizationalUnit)) {
            case NORMAL: {
                this.getSubjectFromPolicySpecification(policySpecification).orgUnits(tppPolicy.organizationalUnit().values());
                break;
            }
            case DEFAULT: {
                this.getDefaultsSubjectFromPolicySpecification(policySpecification).orgUnits(tppPolicy.organizationalUnit().values());
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::city)) {
            case NORMAL: {
                this.getSubjectFromPolicySpecification(policySpecification).localities(tppPolicy.city().values());
                break;
            }
            case DEFAULT: {
                this.getDefaultsSubjectFromPolicySpecification(policySpecification).locality(tppPolicy.city().values()[0]);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::state)) {
            case NORMAL: {
                this.getSubjectFromPolicySpecification(policySpecification).states(tppPolicy.state().values());
                break;
            }
            case DEFAULT: {
                this.getDefaultsSubjectFromPolicySpecification(policySpecification).state(tppPolicy.state().values()[0]);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::country)) {
            case NORMAL: {
                this.getSubjectFromPolicySpecification(policySpecification).countries(tppPolicy.country().values());
                break;
            }
            case DEFAULT: {
                this.getDefaultsSubjectFromPolicySpecification(policySpecification).country(tppPolicy.country().values()[0]);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::keyAlgorithm)) {
            case NORMAL: {
                this.getKeyPairFromPolicySpecification(policySpecification).keyTypes(tppPolicy.keyAlgorithm().values());
                break;
            }
            case DEFAULT: {
                this.getDefaultsKeyPairFromPolicySpecification(policySpecification).keyType(tppPolicy.keyAlgorithm().values()[0]);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::keyBitStrength)) {
            case NORMAL: {
                Integer[] keyBitStrength = (Integer[])Stream.of(tppPolicy.keyBitStrength().values()).mapToInt(Integer::parseInt).boxed().toArray(Integer[]::new);
                this.getKeyPairFromPolicySpecification(policySpecification).rsaKeySizes(keyBitStrength);
                break;
            }
            case DEFAULT: {
                Integer[] keyBitStrength = (Integer[])Stream.of(tppPolicy.keyBitStrength().values()).mapToInt(Integer::parseInt).boxed().toArray(Integer[]::new);
                this.getDefaultsKeyPairFromPolicySpecification(policySpecification).rsaKeySize(keyBitStrength[0]);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::ellipticCurve)) {
            case NORMAL: {
                this.getKeyPairFromPolicySpecification(policySpecification).ellipticCurves(tppPolicy.ellipticCurve().values());
                break;
            }
            case DEFAULT: {
                this.getDefaultsKeyPairFromPolicySpecification(policySpecification).ellipticCurve(tppPolicy.ellipticCurve().values()[0]);
            }
        }
        switch (this.shouldCreateAttribute(tppPolicy, TPPPolicy::manualCsr)) {
            case NORMAL: {
                this.getKeyPairFromPolicySpecification(policySpecification).serviceGenerated(tppPolicy.manualCsr().values()[0].equals("0"));
                break;
            }
            case DEFAULT: {
                this.getDefaultsKeyPairFromPolicySpecification(policySpecification).serviceGenerated(tppPolicy.manualCsr().values()[0].equals("0"));
            }
        }
        if (this.shouldCreateAttribute(tppPolicy, TPPPolicy::allowPrivateKeyReuse) == ToPolicyConverterAbstract.TypePSAToCreate.NORMAL) {
            this.getKeyPairFromPolicySpecification(policySpecification).reuseAllowed(tppPolicy.allowPrivateKeyReuse().values()[0].equals("1"));
        } else if (this.shouldCreateAttribute(tppPolicy, TPPPolicy::wantRenewal) == ToPolicyConverterAbstract.TypePSAToCreate.NORMAL) {
            this.getKeyPairFromPolicySpecification(policySpecification).reuseAllowed(tppPolicy.wantRenewal().values()[0].equals("1"));
        }
        this.resolveSubjectAltNames(tppPolicy, policySpecification);
        return policySpecification;
    }

    private void resolveSubjectAltNames(TPPPolicy tppPolicy, PolicySpecification policySpecification) throws Exception {
        if (tppPolicy.prohibitedSANTypes() != null && tppPolicy.prohibitedSANTypes().length > 0) {
            SubjectAltNames subjectAltNames = this.getSubjectAltNamesFromPolicySpecification(policySpecification);
            ArrayList<AltName> allowedAltNames = new ArrayList<AltName>(Arrays.asList(AltName.values()));
            Arrays.asList(tppPolicy.prohibitedSANTypes()).stream().forEach(s -> allowedAltNames.remove((Object)AltName.from(s)));
            for (AltName altName : allowedAltNames) {
                switch (altName) {
                    case DNS: {
                        subjectAltNames.dnsAllowed(false);
                        break;
                    }
                    case IP: {
                        subjectAltNames.ipAllowed(false);
                        break;
                    }
                    case EMAIL: {
                        subjectAltNames.emailAllowed(false);
                        break;
                    }
                    case URI: {
                        subjectAltNames.uriAllowed(false);
                        break;
                    }
                    case UPN: {
                        subjectAltNames.upnAllowed(false);
                    }
                }
            }
        }
    }
}

