/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.domain;

import com.venafi.vcert.sdk.policy.domain.Defaults;
import com.venafi.vcert.sdk.policy.domain.Policy;
import java.util.Arrays;

public class PolicySpecification {
    private String name;
    private String[] owners;
    private String[] users;
    private String userAccess;
    private String[] approvers;
    private Policy policy;
    private Defaults defaults;

    public static PolicySpecificationBuilder builder() {
        return new PolicySpecificationBuilder();
    }

    public String name() {
        return this.name;
    }

    public String[] owners() {
        return this.owners;
    }

    public String[] users() {
        return this.users;
    }

    public String userAccess() {
        return this.userAccess;
    }

    public String[] approvers() {
        return this.approvers;
    }

    public Policy policy() {
        return this.policy;
    }

    public Defaults defaults() {
        return this.defaults;
    }

    public PolicySpecification name(String name) {
        this.name = name;
        return this;
    }

    public PolicySpecification owners(String[] owners) {
        this.owners = owners;
        return this;
    }

    public PolicySpecification users(String[] users) {
        this.users = users;
        return this;
    }

    public PolicySpecification userAccess(String userAccess) {
        this.userAccess = userAccess;
        return this;
    }

    public PolicySpecification approvers(String[] approvers) {
        this.approvers = approvers;
        return this;
    }

    public PolicySpecification policy(Policy policy) {
        this.policy = policy;
        return this;
    }

    public PolicySpecification defaults(Defaults defaults) {
        this.defaults = defaults;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicySpecification)) {
            return false;
        }
        PolicySpecification other = (PolicySpecification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.owners(), other.owners())) {
            return false;
        }
        if (!Arrays.deepEquals(this.users(), other.users())) {
            return false;
        }
        String this$userAccess = this.userAccess();
        String other$userAccess = other.userAccess();
        if (this$userAccess == null ? other$userAccess != null : !this$userAccess.equals(other$userAccess)) {
            return false;
        }
        if (!Arrays.deepEquals(this.approvers(), other.approvers())) {
            return false;
        }
        Policy this$policy = this.policy();
        Policy other$policy = other.policy();
        if (this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy)) {
            return false;
        }
        Defaults this$defaults = this.defaults();
        Defaults other$defaults = other.defaults();
        return !(this$defaults == null ? other$defaults != null : !((Object)this$defaults).equals(other$defaults));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolicySpecification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.owners());
        result = result * 59 + Arrays.deepHashCode(this.users());
        String $userAccess = this.userAccess();
        result = result * 59 + ($userAccess == null ? 43 : $userAccess.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.approvers());
        Policy $policy = this.policy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        Defaults $defaults = this.defaults();
        result = result * 59 + ($defaults == null ? 43 : ((Object)$defaults).hashCode());
        return result;
    }

    public String toString() {
        return "PolicySpecification(name=" + this.name() + ", owners=" + Arrays.deepToString(this.owners()) + ", users=" + Arrays.deepToString(this.users()) + ", userAccess=" + this.userAccess() + ", approvers=" + Arrays.deepToString(this.approvers()) + ", policy=" + this.policy() + ", defaults=" + this.defaults() + ")";
    }

    public PolicySpecification(String name, String[] owners, String[] users, String userAccess, String[] approvers, Policy policy, Defaults defaults) {
        this.name = name;
        this.owners = owners;
        this.users = users;
        this.userAccess = userAccess;
        this.approvers = approvers;
        this.policy = policy;
        this.defaults = defaults;
    }

    public PolicySpecification() {
    }

    public static class PolicySpecificationBuilder {
        private String name;
        private String[] owners;
        private String[] users;
        private String userAccess;
        private String[] approvers;
        private Policy policy;
        private Defaults defaults;

        PolicySpecificationBuilder() {
        }

        public PolicySpecificationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PolicySpecificationBuilder owners(String[] owners) {
            this.owners = owners;
            return this;
        }

        public PolicySpecificationBuilder users(String[] users) {
            this.users = users;
            return this;
        }

        public PolicySpecificationBuilder userAccess(String userAccess) {
            this.userAccess = userAccess;
            return this;
        }

        public PolicySpecificationBuilder approvers(String[] approvers) {
            this.approvers = approvers;
            return this;
        }

        public PolicySpecificationBuilder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public PolicySpecificationBuilder defaults(Defaults defaults) {
            this.defaults = defaults;
            return this;
        }

        public PolicySpecification build() {
            return new PolicySpecification(this.name, this.owners, this.users, this.userAccess, this.approvers, this.policy, this.defaults);
        }

        public String toString() {
            return "PolicySpecification.PolicySpecificationBuilder(name=" + this.name + ", owners=" + Arrays.deepToString(this.owners) + ", users=" + Arrays.deepToString(this.users) + ", userAccess=" + this.userAccess + ", approvers=" + Arrays.deepToString(this.approvers) + ", policy=" + this.policy + ", defaults=" + this.defaults + ")";
        }
    }
}

