/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.venafi.vcert.sdk.Config;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.slf4j.Slf4jLogger;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class FeignUtils {
    static Supplier<GsonBuilder> gsonBuilderFactory = GsonBuilder::new;

    public static <T> T client(Class<T> clazz, Config config) {
        GsonBuilder builder = FeignUtils.gsonBuilderFor(clazz);
        Object client = config.client();
        if (client == null) {
            client = config.proxy() == null ? new Client.Default(FeignUtils.getSSLSocketFactory(), null) : (config.proxyUser() != null && config.proxyPassword() != null ? new Client.Proxied(null, null, config.proxy(), config.proxyUser(), config.proxyPassword()) : new Client.Proxied(null, null, config.proxy()));
        }
        return (T)Feign.builder().client(client).encoder((Encoder)FeignUtils.encoder(builder)).decoder((Decoder)FeignUtils.decoder(builder)).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).target(clazz, config.baseUrl());
    }

    private static <T> GsonBuilder gsonBuilderFor(Class<T> clazz) {
        GsonBuilder builder = gsonBuilderFactory.get();
        if (Tpp.class.equals(clazz)) {
            builder.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE);
        }
        return builder;
    }

    private static GsonDecoder decoder(GsonBuilder builder) {
        return new GsonDecoder(builder.registerTypeAdapter(OffsetDateTime.class, (Object)new MicrosoftJsonDateFormatDeserializer()).create());
    }

    private static GsonEncoder encoder(GsonBuilder builder) {
        return new GsonEncoder(builder.create());
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        try {
            if (FeignUtils.isDebugMode()) {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                return sslContext.getSocketFactory();
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isDebugMode() {
        boolean debug = false;
        String value = System.getenv("DEBUG");
        if (value != null && !value.isEmpty() & !value.equals("")) {
            debug = true;
        }
        return debug;
    }

    private static class MicrosoftJsonDateFormatDeserializer
    implements JsonDeserializer<OffsetDateTime> {
        static final Pattern msDate = Pattern.compile("^/Date\\((?<epoch>\\d+)(?<offset>(?:[+-]\\d+|Z))?\\)/$");
        static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

        private MicrosoftJsonDateFormatDeserializer() {
        }

        public OffsetDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull() || json.getAsString().isEmpty()) {
                throw new JsonParseException(String.format("Unable to parse ZonedDateTime from [ %s ].", json.toString()));
            }
            String dateString = json.getAsString();
            Matcher input = msDate.matcher(dateString);
            if (!input.matches()) {
                try {
                    return OffsetDateTime.parse(dateString, formatter);
                }
                catch (Exception e) {
                    return OffsetDateTime.parse(dateString, DateTimeFormatter.ISO_DATE_TIME);
                }
            }
            if (input.group("offset") != null) {
                return OffsetDateTime.from(Instant.ofEpochMilli(Long.parseLong(input.group("epoch")))).withOffsetSameInstant(ZoneOffset.of(input.group("offset")));
            }
            return OffsetDateTime.from(Instant.ofEpochMilli(Long.parseLong(input.group("epoch"))).atZone(ZoneOffset.UTC));
        }
    }
}

